#pragma once
#include <BWAPI.h>
#include "Utilities.h"

//2018-03-11: list for storing enemy information

struct EnemyList
{
public:
	EnemyList();

	std::vector<int> ids;
	std::vector<BWAPI::Position> positions;
	std::vector<BWAPI::Position> main_pos;
	int supply_work;
	int supply_air;
	int supply_small;
	int supply_army;
	int supply_cloak;

	void append_unit(BWAPI::Unit unit);
	void remove_unit(BWAPI::Unit unit);
	void change_unit(BWAPI::Unit unit);
	void correct();

	BWAPI::Race race = BWAPI::Races::Unknown;
	std::string name = "enemies";

private:
	bool need_race = false;
	void determine_race(BWAPI::Unit unit);
	void determine_main(BWAPI::Unit unit);
	bool can_cloak(BWAPI::UnitType t);

};