#include "EnemyList.h"

EnemyList::EnemyList() {
	if (BWAPI::Broodwar->enemies().size() == 1) {
		BWAPI::Race r = BWAPI::Broodwar->enemy()->getRace();
		if (r == BWAPI::Races::Terran ||
			r == BWAPI::Races::Protoss ||
			r == BWAPI::Races::Zerg)
			race = r;
		else
			need_race = true;
		name = BWAPI::Broodwar->enemy()->getName();
	}
}

void EnemyList::append_unit(BWAPI::Unit unit) {
	if (need_race)
		determine_race(unit);
	if (std::find(ids.begin(), ids.end(), unit->getID()) != ids.end())
		return;
	ids.push_back(unit->getID());
	BWAPI::UnitType t = unit->getType();
	int my_supply = t.supplyRequired();

	if (t.isBuilding())
		positions.push_back( unit->getPosition() );
	else if (t.isWorker())
		supply_work += my_supply;
	else if (t.isFlyer())
		supply_air += my_supply;
	else if (t == BWAPI::UnitTypes::Protoss_Zealot || t == BWAPI::UnitTypes::Zerg_Zergling)
		supply_small += my_supply;
	else
		supply_army += my_supply;
	if (can_cloak(t))
		supply_cloak += my_supply;

	if (t.isResourceDepot())
		determine_main(unit);
}

void EnemyList::remove_unit(BWAPI::Unit unit) {
	ids.erase(std::remove(ids.begin(), ids.end(), unit->getID()), ids.end());
	BWAPI::UnitType t = unit->getType();
	int my_supply = t.supplyRequired();

	if (t.isBuilding())
		positions.erase(std::remove(positions.begin(), positions.end(), unit->getPosition()), positions.end());
	else if (t.isWorker())
		safe_substract(supply_work, my_supply);
	else if (t.isFlyer())
		safe_substract(supply_air, my_supply);
	else if (t == BWAPI::UnitTypes::Protoss_Zealot || t == BWAPI::UnitTypes::Zerg_Zergling)
		safe_substract(supply_small, my_supply);
	else
		safe_substract(supply_army, my_supply);
	if (can_cloak(t))
		safe_substract(supply_cloak, my_supply);
}

void EnemyList::change_unit(BWAPI::Unit unit) {
	BWAPI::UnitType t = unit->getType();

	if (t.isBuilding() &&
		t != BWAPI::UnitTypes::Zerg_Lair &&
		t != BWAPI::UnitTypes::Zerg_Hive &&
		t != BWAPI::UnitTypes::Zerg_Sunken_Colony &&
		t != BWAPI::UnitTypes::Zerg_Spore_Colony &&
		t != BWAPI::UnitTypes::Zerg_Greater_Spire) {
		positions.push_back(unit->getPosition());
		supply_work -= 2;
		return;
	}
	if (t == BWAPI::UnitTypes::Terran_Siege_Tank_Siege_Mode ||
		t == BWAPI::UnitTypes::Terran_Siege_Tank_Tank_Mode ||
		t == BWAPI::UnitTypes::Zerg_Guardian ||
		t == BWAPI::UnitTypes::Zerg_Devourer ||
		t == BWAPI::UnitTypes::Zerg_Lurker_Egg) {
		return;
	}
	if (t == BWAPI::UnitTypes::Zerg_Lurker) {
		supply_army += 2;
		supply_cloak += 4;
		return;
	}
	int my_supply = t.supplyRequired();
	if (t.isWorker())
		supply_work += my_supply;
	else if (t.isFlyer())
		supply_air += my_supply;
	else if (t == BWAPI::UnitTypes::Zerg_Zergling)
		supply_small += my_supply;
	else
		supply_army += my_supply;
}

void EnemyList::determine_race(BWAPI::Unit unit) {
	BWAPI::Race r = unit->getType().getRace();
	if (r == BWAPI::Races::Terran ||
		r == BWAPI::Races::Protoss ||
		r == BWAPI::Races::Zerg) {
		race = r;
		need_race = false;
		BWAPI::Broodwar->sendText("so you are %s", r.c_str());
	}
}

void EnemyList::correct() {
	for (std::size_t i = 0; i < positions.size(); ++i) {
		BWAPI::TilePosition my_tile = BWAPI::TilePosition(positions[i]);
		if (BWAPI::Broodwar->isVisible(my_tile)) {
			bool found = false;
			for (BWAPI::Unit u : BWAPI::Broodwar->getUnitsOnTile(my_tile)) {
				if (u->getPlayer()->isEnemy(BWAPI::Broodwar->self())) {
					found = true;
				}
			}
			if (!found) {
				positions.erase(positions.begin() + i);
				BWAPI::Broodwar->sendText("removing vacant enemy position");
			}
		}
	}
}

void EnemyList::determine_main(BWAPI::Unit unit) {
	if (!main_pos.empty() &&
		std::find(main_pos.begin(), main_pos.end(), unit->getPosition()) != main_pos.end()) {
		BWAPI::Broodwar->printf("enemy main already listed");
		return;
	}
	for (BWAPI::TilePosition main_tile : BWAPI::Broodwar->getStartLocations()) {
		if (main_tile == unit->getTilePosition()) {
			main_pos.push_back(unit->getPosition());
			BWAPI::Broodwar->printf("found enemy main");
			return;
		}
	}
}

bool EnemyList::can_cloak(BWAPI::UnitType t) {
	if (t == BWAPI::UnitTypes::Protoss_Dark_Templar ||
		t == BWAPI::UnitTypes::Protoss_Arbiter ||
		t == BWAPI::UnitTypes::Terran_Ghost ||
		t == BWAPI::UnitTypes::Terran_Wraith ||
		t == BWAPI::UnitTypes::Zerg_Lurker)
		return true;
	return false;
}