#include "Detection.h"

void Detection::check() {
	BWAPI::Unit my_coms = get_comsat(50);
	BWAPI::Unit my_unit = check_invis_units();
	if (my_coms && my_unit) {
		if (!my_unit->isFlying() &&
			check_units_near_ground(my_unit)) {
			my_coms->useTech(BWAPI::TechTypes::Scanner_Sweep, my_unit->getPosition());
		}
		if (my_unit->isFlying() &&
			check_units_near_air(my_unit)) {
			my_coms->useTech(BWAPI::TechTypes::Scanner_Sweep, my_unit->getPosition());
		}
	}
}

BWAPI::Unit Detection::get_comsat(int e) {
	for (BWAPI::Unit &my_coms : willyt::comsatstations)
		if (my_coms->getEnergy() >= e)
			return my_coms;
	return NULL;
}

BWAPI::Unit Detection::check_invis_units() {
	for (BWAPI::Player p : BWAPI::Broodwar->enemies())
		for (BWAPI::Unit u : p->getUnits())
			if ((u->isCloaked() ||
				u->isBurrowed()) &&
				!u->isDetected())
				return u;
	return NULL;
}

bool Detection::check_units_near_ground(BWAPI::Unit my_unit) {
	unsigned i = 0;
	for (BWAPI::Unit u : BWAPI::Broodwar->self()->getUnits()) {
		if (u->getType().isBuilding() ||
			u->getType().isWorker()) {
			continue;
		}
		if (u->getType() == BWAPI::UnitTypes::Terran_Marine &&
			u->getDistance(my_unit) < 192) {
			++i;
		}
		else if (u->getType() == BWAPI::UnitTypes::Terran_Firebat &&
			u->getDistance(my_unit) < 192) {
			++i;
		}
		else if (u->getType() == BWAPI::UnitTypes::Terran_Goliath &&
			u->getDistance(my_unit) < 192) {
			++i;
		}
		else if (u->getType() == BWAPI::UnitTypes::Terran_Siege_Tank_Tank_Mode &&
			u->getDistance(my_unit) < 256) {
			++i;
		}
		else if (u->getType() == BWAPI::UnitTypes::Terran_Siege_Tank_Siege_Mode &&
			u->getDistance(my_unit) < 384) {
			++i;
		}
		if (i >= 3) { return true; }
	}
	return false;
}

bool Detection::check_units_near_air(BWAPI::Unit my_unit) {
	unsigned i = 0;
	for (BWAPI::Unit u : BWAPI::Broodwar->self()->getUnits()) {
		if (u->getType().isBuilding() ||
			u->getType().isWorker()) {
			continue;
		}
		if (u->getType() == BWAPI::UnitTypes::Terran_Marine &&
			u->getDistance(my_unit) < 192) {
			++i;
		}
		else if (u->getType() == BWAPI::UnitTypes::Terran_Goliath &&
			u->getDistance(my_unit) < 256) {
			++i;
		}
		if (i >= 3) { return true; }
	}
	return false;
}