#pragma once
#include <BWAPI.h>
#include "Namespace.h"
#include "UnitList.h"
#include "BuildGenerator.h"

//2018-03-08: building manager
//2018-09-28: can add 3 missile turrets in main base

struct BuildManager
{
public:
	//check for building:
	//--- check for building queue
	//--- check for building type
	//--- check for resources
	//--- check for building tile
	//--- choose scv and build
	void build_buildings();

	void init();
	void update_defense(BWAPI::Unit my_scout);
	void update_turrets(int &supply_air, int &supply_cloak);
	void draw_defense();

private:
	BuildGenerator buildgenerator;
	int building_queue = 0;

	BWAPI::TilePosition my_tile;
	BWAPI::UnitType my_type;
	BWAPI::UnitType check_order();
	BWAPI::UnitType check_depot();
	BWAPI::UnitType check_turrets();
	//BWAPI::UnitType check_barracks();
	//BWAPI::UnitType check_build();

	BWAPI::TilePosition def_tile;
	BWAPI::TilePosition turret_1;
	BWAPI::TilePosition turret_2;
	bool def_scouted;
	bool need_turrets;
	BWAPI::TilePosition turret_tile();
	int calc_turret_dist(BWAPI::TilePosition &my_tile);
};