#include "BuildManager.h"

void BuildManager::build_buildings() {
	building_queue--;
	if (building_queue > 0) { return; }

	my_tile = BWAPI::TilePositions::None;
	my_type = BWAPI::UnitTypes::None;

	my_type = check_turrets();
	my_type = check_depot();
	my_type = check_order();
	if (my_type == BWAPI::UnitTypes::None) { return; }

	if (BWAPI::Broodwar->self()->minerals() < my_type.mineralPrice() ||
		BWAPI::Broodwar->self()->gas() < my_type.gasPrice()) {
		return;
	}

	if (my_type == BWAPI::UnitTypes::Terran_Refinery) {
		my_tile = willyt::geysers.front()->getTilePosition();
	}
	else if (my_type == BWAPI::UnitTypes::Terran_Bunker) {
		my_tile = buildgenerator.generate_random_tile(my_type, def_tile, 1);
	}
	else if (my_type == BWAPI::UnitTypes::Terran_Missile_Turret) {
		my_tile = buildgenerator.generate_random_tile(my_type, turret_tile(), 0);
	}
	else { //any other building type
		my_tile = buildgenerator.generate_random_tile(my_type, BWAPI::Broodwar->self()->getStartLocation(), 1);
	}
	if (my_tile == BWAPI::TilePositions::None) {
		return;
	}

	//BWAPI::TilePosition my_tile = BWAPI::Broodwar->getBuildLocation(my_type, my_star, 32, false);
	//if (my_type == BWAPI::UnitTypes::Terran_Bunker && dt)
	//	my_tile = BWAPI::Broodwar->getBuildLocation(my_type, my_def, 6, false);

	choose_scv(my_tile)->set_build_mission(my_type, my_tile);
	building_queue = 32;
	//BWAPI::Broodwar->printf("build now");
}

BWAPI::UnitType BuildManager::check_order() {
	int s = BWAPI::Broodwar->self()->supplyUsed() / 2;
	using namespace willyt;
	using namespace BWAPI::UnitTypes;

	if (s >=  0 && commandcenters.size() < 1) return Terran_Command_Center;
	if (s >=  9 && depots.size() < 1)		return Terran_Supply_Depot;
	if (s >= 10 && barracks.size() < 2)		return Terran_Barracks;
	if (s >= 12 && bunkers.size() < 1)		return Terran_Bunker;
	if (s >= 16 && depots.size() < 2)		return Terran_Supply_Depot;
	if (s >= 18 && academies.size() < 1)	return Terran_Academy;
	if (s >= 20 && refineries.size() < 1)	return Terran_Refinery;
	if (s >= 22 && depots.size() < 3)		return Terran_Supply_Depot;
	if (s >= 28 && depots.size() < 4)		return Terran_Supply_Depot;

	if (s >= 36 && factories.size() < 1)	return Terran_Factory;
	if (s >= 48 && engybays.size() < 1)		return Terran_Engineering_Bay;
	if (s >= 60 && factories.size() < 2)	return Terran_Factory;
	if (s >= 60 && armories.size() < 1)		return Terran_Armory;

	if (BWAPI::Broodwar->self()->minerals() > 800 &&
		BWAPI::Broodwar->self()->gas() > 400 &&
		factories.size() < 4)				return Terran_Factory;
	if (BWAPI::Broodwar->self()->minerals() > 800 &&
		barracks.size() < 4)				return Terran_Barracks;

	return my_type;
}

BWAPI::UnitType BuildManager::check_depot() {
	int supply_full = 10 * willyt::commandcenters.size() + 8 * willyt::depots.size();
	int supply_pred = 4 + (BWAPI::Broodwar->self()->supplyUsed() * 11) / 20;

	if (supply_full < supply_pred &&
		willyt::depots.size() > 3 &&
		willyt::depots.size() < 20)
		return BWAPI::UnitTypes::Terran_Supply_Depot;

	return my_type;
}

BWAPI::UnitType BuildManager::check_turrets() {
	if (!need_turrets || willyt::scvs.size() < 8) return my_type;
	if (willyt::engybays.size() < 1) return BWAPI::UnitTypes::Terran_Engineering_Bay;
	if (willyt::turrets.size() < 3) return BWAPI::UnitTypes::Terran_Missile_Turret;
	return my_type;
}

//BWAPI::UnitType BuildManager::check_barracks() {
//	if (BWAPI::Broodwar->self()->minerals() > 1000 &&
//		willyt::barracks.size() < 5)
//		return BWAPI::UnitTypes::Terran_Barracks;
//
//	return my_type;
//}

void BuildManager::init() {
	int x0 = willyt::start_pos.x;
	int y0 = willyt::start_pos.y;
	int x1 = willyt::w * 16;
	int y1 = willyt::h * 16;
	double l = sqrt( pow (x1-x0, 2) + pow (y1-y0, 2) );
	int x2 = x0 + (int) (256 * (x1-x0) / l);
	int y2 = y0 + (int) (256 * (y1-y0) / l);
	def_tile = BWAPI::TilePosition(x2/32, y2/32);
	def_scouted = false;
	need_turrets = false;
	BWAPI::TilePosition s = BWAPI::Broodwar->self()->getStartLocation();
	turret_1 = BWAPI::TilePosition(s.x + 3, s.y - 1);
	turret_2 = BWAPI::TilePosition(s.x - 1, s.y + 2);
	//BWAPI::Broodwar->printf("initialize placement");
}

void BuildManager::update_defense(BWAPI::Unit my_scout) {
	if (def_scouted || !my_scout) { return; }
	if (my_scout->getDistance(willyt::start_pos) >= 256) {
		def_tile = my_scout->getTilePosition();
		def_scouted = true;
		BWAPI::Broodwar->sendText("determine bunker placement");
	}
}

void BuildManager::update_turrets(int &supply_air, int &supply_cloak) {
	if (need_turrets) { return; }
	if (supply_air > 0 || supply_cloak > 0) {
		need_turrets = true;
		BWAPI::Broodwar->sendText("air/cloaked units detected, need engybay and turrets");
	}
}

BWAPI::TilePosition BuildManager::turret_tile() {
	int d0 = calc_turret_dist(def_tile);
	int d1 = calc_turret_dist(turret_1);
	int d2 = calc_turret_dist(turret_2);
	if (d0 >= d1 && d0 >= d2) return def_tile;
	if (d1 >= d2 && d1 >= d0) return turret_1;
	if (d2 >= d0 && d2 >= d1) return turret_2;
	return BWAPI::Broodwar->self()->getStartLocation();
}

int BuildManager::calc_turret_dist(BWAPI::TilePosition &my_tile) {
	int i = 0;
	for (BWAPI::Unit &my_turret : willyt::turrets) {
		BWAPI::TilePosition t = my_turret->getTilePosition();
		i += t.getApproxDistance(my_tile);
	}
	return i;
}

void BuildManager::draw_defense() {
	draw_tile_box(def_tile, 2, 2, 19);
	draw_tile_box(turret_1, 2, 2, 19);
	draw_tile_box(turret_2, 2, 2, 19);
}

//BWAPI::UnitType BuildManager::check_build() {
//	int supply_full = 20 * willyt::commandcenters.size() + 16 * willyt::depots.size();
//	int supply_pred = 5 * BWAPI::Broodwar->self()->supplyUsed() / 4;
//	int my_minerals = BWAPI::Broodwar->self()->minerals();
//
//	if (supply_full < supply_pred && supply_full < 400 &&
//		willyt::barracks.size() >= 1 && my_minerals >= 100)
//		return BWAPI::UnitTypes::Terran_Supply_Depot;
//	if (willyt::academies.size() < 1 &&
//		willyt::barracks.size() >= 2 && my_minerals >= 150)
//		return BWAPI::UnitTypes::Terran_Academy;
//	if (willyt::refineries.size() < 1 &&
//		willyt::academies.size() >= 1 && my_minerals >= 100)
//		return BWAPI::UnitTypes::Terran_Refinery;
//	if (willyt::barracks.size() < 4 &&
//		willyt::commandcenters.size() >= 1 && my_minerals >= 200)
//		return BWAPI::UnitTypes::Terran_Barracks;
//
//	return BWAPI::UnitTypes::None;
//}