#include "BuildList.h"

void append_building(BWAPI::Unit unit) {
	if (!unit->getType().isBuilding())
		return;
	else if (unit->getType() == BWAPI::UnitTypes::Terran_Command_Center)
		willyt::commandcenters.push_back(unit);
	else if (unit->getType() == BWAPI::UnitTypes::Terran_Refinery)
		willyt::refineries.push_back(unit);
	else if (unit->getType() == BWAPI::UnitTypes::Terran_Supply_Depot)
		willyt::depots.push_back(unit);
	else if (unit->getType() == BWAPI::UnitTypes::Terran_Barracks)
		willyt::barracks.push_back(unit);
	else if (unit->getType() == BWAPI::UnitTypes::Terran_Engineering_Bay)
		willyt::engybays.push_back(unit);
	else if (unit->getType() == BWAPI::UnitTypes::Terran_Bunker)
		willyt::bunkers.push_back(unit);
	else if (unit->getType() == BWAPI::UnitTypes::Terran_Missile_Turret)
		willyt::turrets.push_back(unit);
	else if (unit->getType() == BWAPI::UnitTypes::Terran_Academy)
		willyt::academies.push_back(unit);
	else if (unit->getType() == BWAPI::UnitTypes::Terran_Armory)
		willyt::armories.push_back(unit);
	else if (unit->getType() == BWAPI::UnitTypes::Terran_Factory)
		willyt::factories.push_back(unit);
	else if (unit->getType() == BWAPI::UnitTypes::Terran_Comsat_Station)
		willyt::comsatstations.push_back(unit);
	else if (unit->getType() == BWAPI::UnitTypes::Terran_Machine_Shop)
		willyt::machineshops.push_back(unit);

	willyt::buildings.push_back(unit);
	set_map_area_unit(willyt::build_map, unit, false);
	if (unit->getType().canBuildAddon()) {
		BWAPI::TilePosition tp = unit->getTilePosition();
		set_map_area(willyt::build_map, tp.x, tp.y, 6, 3, false);
	}
}

void remove_building(BWAPI::Unit unit) {
	if (!unit->getType().isBuilding())
		return;
	else if (unit->getType() == BWAPI::UnitTypes::Terran_Command_Center)
		vector_remove_unit(willyt::commandcenters, unit);
	else if (unit->getType() == BWAPI::UnitTypes::Terran_Refinery)
		vector_remove_unit(willyt::refineries, unit);
	else if (unit->getType() == BWAPI::UnitTypes::Terran_Supply_Depot)
		vector_remove_unit(willyt::depots, unit);
	else if (unit->getType() == BWAPI::UnitTypes::Terran_Barracks)
		vector_remove_unit(willyt::barracks, unit);
	else if (unit->getType() == BWAPI::UnitTypes::Terran_Engineering_Bay)
		vector_remove_unit(willyt::engybays, unit);
	else if (unit->getType() == BWAPI::UnitTypes::Terran_Bunker)
		vector_remove_unit(willyt::bunkers, unit);
	else if (unit->getType() == BWAPI::UnitTypes::Terran_Missile_Turret)
		vector_remove_unit(willyt::turrets, unit);
	else if (unit->getType() == BWAPI::UnitTypes::Terran_Academy)
		vector_remove_unit(willyt::academies, unit);
	else if (unit->getType() == BWAPI::UnitTypes::Terran_Armory)
		vector_remove_unit(willyt::armories, unit);
	else if (unit->getType() == BWAPI::UnitTypes::Terran_Factory)
		vector_remove_unit(willyt::factories, unit);
	else if (unit->getType() == BWAPI::UnitTypes::Terran_Comsat_Station)
		vector_remove_unit(willyt::comsatstations, unit);
	else if (unit->getType() == BWAPI::UnitTypes::Terran_Machine_Shop)
		vector_remove_unit(willyt::machineshops, unit);

	vector_remove_unit(willyt::buildings, unit);
	if (!unit->isLifted() &&
		!unit->getType().isResourceDepot() &&
		!unit->getType().isRefinery() &&
		!unit->getType().isAddon())
		set_map_area_unit(willyt::build_map, unit, true);
}