#include "BuildGenerator.h"

BWAPI::TilePosition BuildGenerator::generate_random_tile(BWAPI::UnitType my_type, BWAPI::TilePosition my_start, int my_space) {
	n = (BWAPI::Broodwar->getFrameCount() / 8) % 4;
	t = BWAPI::TilePositions::None;
	r = 0;
	s = my_space;
	i = 1;

	int x0 = my_start.x + 2;
	int y0 = my_start.y + 1;
	w = s + my_type.tileWidth() + s;
	h = s + my_type.tileHeight() + s;
	if (my_type.canBuildAddon()) { w += 2; }

	while (r < 24) {
		if (n == 0) {
			t = check_line_top(x0, y0);
			t = check_line_rig(x0, y0);
			t = check_line_bot(x0, y0);
			t = check_line_lef(x0, y0);
		}
		else if (n == 1) {
			t = check_line_rig(x0, y0);
			t = check_line_bot(x0, y0);
			t = check_line_lef(x0, y0);
			t = check_line_top(x0, y0);
		}
		else if (n == 2) {
			t = check_line_bot(x0, y0);
			t = check_line_lef(x0, y0);
			t = check_line_top(x0, y0);
			t = check_line_rig(x0, y0);
		}
		else if (n == 3) {
			t = check_line_lef(x0, y0);
			t = check_line_top(x0, y0);
			t = check_line_rig(x0, y0);
			t = check_line_bot(x0, y0);
		}
		if (t != BWAPI::TilePositions::None) {
			//BWAPI::Broodwar->printf("Build generator cycles: %d", i);
			return t;
		}
		++r;
	}
	return t;
}

BWAPI::TilePosition BuildGenerator::check_line_top(int x0, int y0) {
	return check_line_hor(x0 - w / 2, y0 - r - (h - 1));
}
BWAPI::TilePosition BuildGenerator::check_line_bot(int x0, int y0) {
	return check_line_hor(x0 - w / 2, y0 + r);
}
BWAPI::TilePosition BuildGenerator::check_line_lef(int x0, int y0) {
	return check_line_ver(x0 - r - (w - 1), y0 - h / 2);
}
BWAPI::TilePosition BuildGenerator::check_line_rig(int x0, int y0) {
	return check_line_ver(x0 + r, y0 - h / 2);
}

BWAPI::TilePosition BuildGenerator::check_line_ver(int x0, int y0) {
	if (t == BWAPI::TilePositions::None) {
		int y1 = y0 - r - 2;
		int y2 = y0 + r + 2;
		for (int y = y1; y < y2; ++y) {
			if (check_build_area(x0, y, w, h)) {
				return BWAPI::TilePosition(x0+s, y+s);
			}
			++i;
		}
	}
	return t;
}

BWAPI::TilePosition BuildGenerator::check_line_hor(int x0, int y0) {
	if (t == BWAPI::TilePositions::None) {
		int x1 = x0 - r - 2;
		int x2 = x0 + r + 2;
		for (int x = x1; x < x2; ++x) {
			if (check_build_area(x, y0, w, h)) {
				return BWAPI::TilePosition(x+s, y0+s);
			}
			++i;
		}
	}
	return t;
}