#include "ArmyUtilities.h"

//---------------------------------------------------------

bool base_under_attack() {
	for (BWAPI::Unit u : BWAPI::Broodwar->self()->getUnits()) {
		if (u->isUnderAttack()) {
			BWAPI::TilePosition t = u->getTilePosition();
			if (willyt::def_map[t.y][t.x]) { return true; }
		}
	}
	return false;
}

int count_attackers() {
	int i = 0;
	for (BWAPI::Player p : BWAPI::Broodwar->enemies()) {
		for (BWAPI::Unit u : p->getUnits()) {
			if (u->exists()) {
				BWAPI::TilePosition t = u->getTilePosition();
				if (willyt::def_map[t.y][t.x]) {
					if (u->getType().isWorker()) { ++i; }
					else { i += u->getType().supplyRequired(); }
				}
			}
		}
	}
	return i * 3 / 2;
}



//---------------------------------------------------------

BWAPI::Unit choose_enemy_attacker() {
	for (BWAPI::Player p : BWAPI::Broodwar->enemies()) {
		for (BWAPI::Unit u : p->getUnits()) {
			if (u->exists()) {
				BWAPI::TilePosition t = u->getTilePosition();
				if (willyt::def_map[t.y][t.x]) { return u; }
			}
		}
	}
	return NULL;
}

BWAPI::Position choose_enemy_unit() {
	for (BWAPI::Player p : BWAPI::Broodwar->getPlayers())
		if (p->isEnemy(BWAPI::Broodwar->self()))
			for (BWAPI::Unit u : p->getUnits())
				if (u->exists())
					return u->getPosition();
	return BWAPI::Positions::None;
}

BWAPI::Position choose_enemy_building(std::vector<BWAPI::Position> &ep, std::vector<BWAPI::Position> &em) {
	BWAPI::Position max_pos = BWAPI::Positions::None;
	int max_sq_dist = -1;
	if (ep.empty()) { return max_pos; }

	for (std::vector<BWAPI::Position>::iterator itp = ep.begin(); itp != ep.end(); ++itp) {
		int my_sq_dist = 0;
		for (std::vector<BWAPI::Position>::iterator itm = em.begin(); itm != em.end(); ++itm) {
			my_sq_dist += (int)sqrt( pow(itp->x - itm->x, 2) + pow(itp->y - itm->y, 2) );
		}
		if (max_sq_dist < my_sq_dist) {
			max_sq_dist = my_sq_dist;
			max_pos = *itp;
		}
	}
	//if (max_sq_dist > -1) { BWAPI::Broodwar->printf("Max dist: %d", max_sq_dist); }
	return max_pos;
}



//---------------------------------------------------------

void call_militia(int n) {
	if (n > 12) { n = 12; }
	if (willyt::tcount_scv > 0) {
		BWAPI::Broodwar->printf("Call %d militia!", n);
	}
	for (SCV &scv : willyt::scvs) {
		if (n > 0 &&
			scv.unit->isCompleted() &&
			scv.unit->isGatheringMinerals()) {
			scv.is_militia = true;
			n--;
		}
	}
}

void stop_militia() {
	for (SCV &scv : willyt::scvs) {
		if (scv.is_militia) {
			scv.is_militia = false;
			scv.unit->stop();
		}
	}
}



//---------------------------------------------------------

BWAPI::Position calc_leading_pos(BWAPI::Position my_target) {
	BWAPI::Position min_pos = BWAPI::Positions::None;
	int min_dist = -15000;

	if (willyt::siegetanks.empty() ||
		BWAPI::Broodwar->elapsedTime() < 900) {
		for (Marine &marine : willyt::marines) {
			BWAPI::TilePosition t = (BWAPI::TilePosition) marine.unit->getPosition();
			int d1 = 8 * willyt::dist_map[t.y][t.x];
			int d2 = marine.unit->getPosition().getApproxDistance(my_target);
			if (min_dist < d1 - d2) {
				min_dist = d1 - d2;
				min_pos = marine.unit->getPosition();
			}
		}
	}
	else {
		for (SiegeTank &siegetank : willyt::siegetanks) {
			BWAPI::TilePosition t = (BWAPI::TilePosition) siegetank.unit->getPosition();
			int d1 = 8 * willyt::dist_map[t.y][t.x];
			int d2 = siegetank.unit->getPosition().getApproxDistance(my_target);
			if (min_dist < d1 - d2) {
				min_dist = d1 - d2;
				min_pos = siegetank.unit->getPosition();
			}
		}
	}
	BWAPI::TilePosition t1 = (BWAPI::TilePosition) min_pos;
	BWAPI::TilePosition t2 = (BWAPI::TilePosition) my_target;
	if (willyt::dist_map[t1.y][t1.x] > willyt::dist_map[t2.y][t2.x]) {
		return BWAPI::Positions::None;
	}
	//BWAPI::Broodwar->printf("leading distance: %d", my_dis);
	return min_pos;
}

int count_around(BWAPI::Position my_pos, int r) {
	int i = 0;
	for (BWAPI::Unit u : BWAPI::Broodwar->getUnitsInRadius(my_pos, r))
		if (u->getPlayer() == BWAPI::Broodwar->self()) { ++i; }
	return i;
}



//---------------------------------------------------------

void load_bunker(BWAPI::Unit b) {
	int i = 0;
	for (auto &marine : willyt::marines) {
		if (i < 4 &&
			marine.unit->exists() &&
			marine.unit->isCompleted() &&
			!marine.unit->isLoaded() &&
			marine.unit->getDistance(b) < 512) {
			marine.unit->load(b);
			marine.retreat_queue = 96;
			++i;
		}
	}
}

bool enemy_in_radius(BWAPI::Unit b, int r) {
	for (BWAPI::Unit u : b->getUnitsInRadius(r)) {
		if (u->getPlayer()->isEnemy(BWAPI::Broodwar->self())) { return true; };
	}
	return false;
}




//void Defender::update(ArmyManager &am) {
//	if (defense_queue == 0) {
//		if (base_under_attack()) {
//			int d = count_army() + count_militia() + 2 * willyt::bunkers.size();
//			int a = count_attackers();
//			if (d < 12 && d < a) { am.call_militia(a - d); }
//			am.attack(choose_defense());
//			am.is_defending = true;
//			defense_queue = 64;
//		}
//		else {
//			if (!am.is_attacking) {
//				am.stop_militia();
//				am.attack(choose_defense());
//			}
//			am.is_defending = false;
//			defense_queue = 32;
//		}
//		update_bunkers();
//	}
//}