#pragma once
#include <BWAPI.h>
#include "Namespace.h"
#include "ArmyUtilities.h"
#include "ArmyAttacker.h"
#include "UnitList.h"
#include "EnemyList.h"

//2018-03-10: army manager for attacking
//2018-09: rewrite to enable concurrent attacking and defending

struct ArmyManager
{
public:
	void update_positions();
	void update(EnemyList &el);

private:
	void check_defend(int d, int a, BWAPI::Unit enemy_attacker);
	void check_attack(int n, EnemyList &el);
	void check_militia(int m);
	void check_cohesion(int &n);
	void check_bunkers();
	void unload_bunkers();

	int army_queue = 0;

	bool is_defending = false;
	bool is_attacking = false;
	bool is_swarming = false;
	bool first_attack = false;
	bool under_attack = false;

	BWAPI::Position gather_pos = BWAPI::Positions::None;
	BWAPI::Position defend_pos = BWAPI::Positions::None;
	BWAPI::Position attack_pos = BWAPI::Positions::None;
	BWAPI::Position leader_pos = BWAPI::Positions::None;
	BWAPI::Position latest_pos = BWAPI::Positions::None;
};