#include "ArmyManager.h"

void ArmyManager::update_positions() {
	int x = 0;
	int y = 0;
	int i = 0;
	for (BWAPI::Unit &unit : willyt::commandcenters) {
		x += unit->getPosition().x;
		y += unit->getPosition().y;
		++i;
	}
	for (BWAPI::Unit &unit : willyt::bunkers) {
		x += unit->getPosition().x;
		y += unit->getPosition().y;
		++i;
	}
	if (i > 0) { gather_pos = BWAPI::Position{ x / i, y / i }; }
	else { gather_pos = willyt::start_pos; }
	//BWAPI::Broodwar->printf("Updating defense position.");
}

void ArmyManager::update(EnemyList &el) {
	safe_substract( army_queue, 1 );
	attack_pos = BWAPI::Positions::None;
	defend_pos = BWAPI::Positions::None;

	int n = count_army();
	int m = count_militia();
	int d = n + m + 2 * willyt::bunkers.size();
	int a = count_attackers();
	BWAPI::Unit enemy_attacker = NULL;

	if (army_queue == 0) {
		enemy_attacker = choose_enemy_attacker();
		check_defend(d, a, enemy_attacker);
		check_attack(n, el);
		check_militia(m);
		check_cohesion(n);
	}

	if (defend_pos && !attack_pos) {
		army_attack(defend_pos);
		check_bunkers();
	}
	if (!defend_pos && attack_pos) {
		army_attack(attack_pos);
		unload_bunkers();
		latest_pos = attack_pos;
	}
	if (defend_pos && attack_pos) {
		army_split(defend_pos, attack_pos, enemy_attacker, n, m, a);
		check_bunkers();
		latest_pos = attack_pos;
	}

	BWAPI::Broodwar->drawCircleMap(latest_pos, 4, 111, true);
}





void ArmyManager::check_defend(int d, int a, BWAPI::Unit enemy_attacker) {

	//defend if units in base
	if (enemy_attacker) {
		is_defending = true;
		defend_pos = enemy_attacker->getPosition();
		army_queue = 32;
	}
	else {
		is_defending = false;
	}

	//high alert when attack on base
	//call militia for help if needed
	under_attack = base_under_attack();
	if (under_attack) {
		if (d < 12 && d < a) { call_militia(a - d); }
		army_queue = 32;
	}
	army_queue = 16;
}

void ArmyManager::check_attack(int n, EnemyList &el) {

	//determine attack state based on army supply
	if (n >= willyt::attack_supply)
		is_attacking = true;
	else if (is_attacking && n+6 >= willyt::attack_supply)
		is_attacking = true;
	else
		is_attacking = false;

	//choose attack target
	//buildings, units, swarming
	if (is_attacking) {
		if (!attack_pos) {
			attack_pos = choose_enemy_building(el.positions, el.main_pos);
		}
		if (!attack_pos) {
			attack_pos = choose_enemy_unit();
		}
		if (!attack_pos) {
			army_swarm(!is_swarming);
			is_swarming = true;
		}
		else { is_swarming = false; }
		army_queue = 64;
	}
	
	//gather else
	if (!is_attacking && !is_defending) {
		attack_pos = gather_pos;
	}
}

void ArmyManager::check_militia(int m) {
	if (is_attacking &&
		!first_attack) {
		first_attack = true;
		call_militia(8);
		BWAPI::Broodwar->sendText("first attack");
	}
	if (m > 0 && !under_attack) {
		if (BWAPI::Broodwar->elapsedTime() > 900 ||
			!is_attacking) {
			stop_militia();
		}
	}
}

void ArmyManager::check_cohesion(int &n) {
	leader_pos = BWAPI::Positions::None;
	if (is_attacking &&
		!is_swarming &&
		!is_defending) {
		leader_pos = calc_leading_pos(attack_pos);
	}
	if (leader_pos) {
		int a = count_around(leader_pos, 320);
		if (a < 20 && 2 * a < n) {
			attack_pos = leader_pos;
			army_queue = 16;
			//Broodwar->printf("Get together!");
		}
	}
}

void ArmyManager::check_bunkers() {
	for (BWAPI::Unit &b : willyt::bunkers) {
		if (enemy_in_radius(b, 256)) {
			if (b->getSpaceRemaining() > 0) { load_bunker(b); }
		}
		else {
			if (b->getSpaceRemaining() < 4) { b->unloadAll(); }
		}
	}
}

void ArmyManager::unload_bunkers() {
	for (BWAPI::Unit &b : willyt::bunkers) { b->unloadAll(); }
}