#include "ArmyAttacker.h"

void army_attack(BWAPI::Position &my_pos) {

	for (std::vector<SCV>::iterator it = willyt::scvs.begin(); it != willyt::scvs.end(); ++it)
		if (it->is_militia)
			it->unit->attack(my_pos);
	for (std::vector<Marine>::iterator it = willyt::marines.begin(); it != willyt::marines.end(); ++it)
		it->unit->attack(my_pos);
	for (std::vector<Firebat>::iterator it = willyt::firebats.begin(); it != willyt::firebats.end(); ++it)
		it->unit->attack(my_pos);
	for (std::vector<Medic>::iterator it = willyt::medics.begin(); it != willyt::medics.end(); ++it)
		it->unit->attack(my_pos);
	for (std::vector<SiegeTank>::iterator it = willyt::siegetanks.begin(); it != willyt::siegetanks.end(); ++it)
		it->unit->attack(my_pos);
	for (std::vector<Goliath>::iterator it = willyt::goliaths.begin(); it != willyt::goliaths.end(); ++it)
		it->unit->attack(my_pos);

	//BWAPI::Broodwar->sendText("attack all");
}

void army_swarm(bool i) {

	for (std::vector<SCV>::iterator it = willyt::scvs.begin(); it != willyt::scvs.end(); ++it)
		if (it->is_militia)
			send_random(it->unit, i);
	for (std::vector<Marine>::iterator it = willyt::marines.begin(); it != willyt::marines.end(); ++it)
		send_random(it->unit, i);
	for (std::vector<Firebat>::iterator it = willyt::firebats.begin(); it != willyt::firebats.end(); ++it)
		send_random(it->unit, i);
	for (std::vector<Medic>::iterator it = willyt::medics.begin(); it != willyt::medics.end(); ++it)
		send_random(it->unit, i);
	for (std::vector<SiegeTank>::iterator it = willyt::siegetanks.begin(); it != willyt::siegetanks.end(); ++it)
		send_random(it->unit, i);
	for (std::vector<Goliath>::iterator it = willyt::goliaths.begin(); it != willyt::goliaths.end(); ++it)
		send_random(it->unit, i);

	BWAPI::Broodwar->sendText("swarm");
}

void send_random(BWAPI::Unit &unit, bool immediately) {
	if (immediately || unit->isIdle()) {
		int x = rand() % willyt::wp;
		int y = rand() % willyt::hp;
		unit->attack(BWAPI::Position{ x , y });
	}
}

void army_split(BWAPI::Position &dpos, BWAPI::Position &apos, BWAPI::Unit &eaunit, int n, int m, int a) {

	int d_militia = 0;
	int d_marine_ = 0;
	int d_firebat = 0;
	int d_medical = 0;
	int d_sietank = 0;
	int d_goliath = 0;

	if (eaunit->isFlying()) {
		int g = willyt::goliaths.size();
		float f = 0.0;
		if (g > 0) { f = 2 * n / (float)g; }
		d_goliath = 1 + (int)(f * a);
		d_marine_ = 1 + (int)((a - f * a) * 0.83);
		d_medical = 1 + (int)((a - f * a) * 0.17);
		d_militia = 0;
		d_firebat = 0;
		d_sietank = 0;
	}
	else {
		float q = 0.0;
		if (a > 0) { q = (n + m) / (float)a; }
		d_militia = 1 + (int)(q * m);
		d_marine_ = 1 + (int)(q * willyt::marines.size());
		d_firebat = 1 + (int)(q * willyt::firebats.size());
		d_medical = 1 + (int)(q * willyt::medics.size());
		d_sietank = 1 + (int)(q * willyt::siegetanks.size() / 2);
		d_goliath = 1 + (int)(q * willyt::goliaths.size() / 2);
	}

	for (std::vector<SCV>::reverse_iterator it = willyt::scvs.rbegin(); it != willyt::scvs.rend(); ++it)
		if (it->is_militia)
			send_split(it->unit, d_militia, dpos, apos);
	for (std::vector<Marine>::reverse_iterator it = willyt::marines.rbegin(); it != willyt::marines.rend(); ++it)
		send_split(it->unit, d_marine_, dpos, apos);
	for (std::vector<Firebat>::reverse_iterator it = willyt::firebats.rbegin(); it != willyt::firebats.rend(); ++it)
		send_split(it->unit, d_firebat, dpos, apos);
	for (std::vector<Medic>::reverse_iterator it = willyt::medics.rbegin(); it != willyt::medics.rend(); ++it)
		send_split(it->unit, d_medical, dpos, apos);
	for (std::vector<SiegeTank>::reverse_iterator it = willyt::siegetanks.rbegin(); it != willyt::siegetanks.rend(); ++it)
		send_split(it->unit, d_sietank, dpos, apos);
	for (std::vector<Goliath>::reverse_iterator it = willyt::goliaths.rbegin(); it != willyt::goliaths.rend(); ++it)
		send_split(it->unit, d_goliath, dpos, apos);

	BWAPI::Broodwar->sendText("split defense and attack");
}

void send_split(BWAPI::Unit &unit, int &count, BWAPI::Position &dpos, BWAPI::Position &apos) {
	if (count > 0)
		unit->attack(dpos);
	else
		unit->attack(apos);
	--count;
}