/*
* Tyr is an AI for StarCraft: Broodwar, 
* 
* Please visit https://github.com/SimonPrins/Tyr for further information.
* 
* Copyright 2015 Simon Prins
*
* This file is part of Tyr.
* Tyr is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 2 of the License, or
* (at your option) any later version.
* Tyr is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
* You should have received a copy of the GNU General Public License
* along with Tyr.  If not, see http://www.gnu.org/licenses/.
*/


package com.tyr.unitgroups;

import com.tyr.Tyr;
import com.tyr.agents.Agent;

import bwapi.Color;
import bwapi.Game;
import bwapi.Player;


/**
 * This unit group manages units that currently have no other unit group.
 * From here those units will be redistributed to their appropriate group.
 * @author Simon
 *
 */
public class OutOfJob extends UnitGroup
{
	/**
	 * This unit group manages units that currently have no other unit group.
	 * From here those units will be redistributed to their appropriate group. 
	 */
	public OutOfJob() 
	{
		super(null);
	}

	@Override
	public void onFrame(Game game, Player self, Tyr bot) 
	{
		for(Agent agent : units)
			agent.drawCircle(Color.Black);
	}

}
