package com.tyr.unitgroups;

import bwapi.Position;

import com.tyr.DebugMessages;
import com.tyr.Tyr;
import com.tyr.agents.Agent;
import com.tyr.agents.None;

public abstract class IAttackGroup extends UnitGroup
{
	/**
	 * The target where we want to attack.
	 */
	protected Position target;
	
	/**
	 * A unit group for sending units to attack a certain location.
	 * @param target The target where we want the units to attack.
	 */
	public IAttackGroup(Position target) 
	{
		super(Tyr.bot.hobos);
		
		this.target = target;
	}
	
	/**
	 * Setter for the target where we want the units to attack.
	 */
	public void setTarget(Position target)
	{
		if (target == null)
			DebugMessages.addMessage("AttackGroup.target is null!");
		this.target = target;
	}
	
	/**
	 * Adds an agent to the list of agents.
	 */
	@Override
	public void add(Agent agent)
	{
		super.add(agent);
		agent.order(new None(agent));
		agent.unit.stop();
	}

	/**
	 * Clears the list of units so that this unit group can be removed.
	 */
	public void clear() 
	{
		for(int i = units.size() - 1; i >= 0; i--)
		{
			units.get(i).order(new None(units.get(i)));
			this.rejects.add(units.get(i));
			units.remove(i);
		}
	}
}
