/*
* Tyr is an AI for StarCraft: Broodwar, 
* 
* Please visit https://github.com/SimonPrins/Tyr for further information.
* 
* Copyright 2015 Simon Prins
*
* This file is part of Tyr.
* Tyr is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 2 of the License, or
* (at your option) any later version.
* Tyr is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
* You should have received a copy of the GNU General Public License
* along with Tyr.  If not, see http://www.gnu.org/licenses/.
*/


package com.tyr.tasks;

import java.util.ArrayList;

import com.tyr.Tyr;

import bwapi.Game;
import bwapi.Player;


/**
 * This class represents a list of solutions.
 * @author Simon
 *
 */
public class SolutionList extends Solution
{
	/**
	 * The list of solutions that this class represents.
	 */
	public ArrayList<SolutionItem> solutions = new ArrayList<SolutionItem>();
	
	
	/**
	 * This class represents a list of solutions.
	 * @param task The task that started this solution.
	 */
	public SolutionList(Task task) 
	{
		super(task);
	}


	@Override
	public void onFrame(Game game, Player self, Tyr bot)
	{
		for(Solution sol : solutions)
			sol.onFrame(game, self, bot);
		
		// Remove the finished solutions.
		for(int i = solutions.size() - 1; i >= 0; i--)
			if (solutions.get(i).done())
			{
				System.out.println("Removing solution.");
				solutions.remove(i);
			}
	}
	
	/**
	 * Adds a solution to the list of solutions.
	 * @param sol A solution item to be added to the list of solutions.
	 */
	public void add(SolutionItem sol)
	{
		solutions.add(sol);
	}
	
	/**
	 * Returns the number of solutions in the list.
	 * @return Returns the number of solutions in the list.
	 */
	public int size()
	{
		return solutions.size();
	}
}
