/*
* Tyr is an AI for StarCraft: Broodwar, 
* 
* Please visit https://github.com/SimonPrins/Tyr for further information.
* 
* Copyright 2015 Simon Prins
*
* This file is part of Tyr.
* Tyr is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 2 of the License, or
* (at your option) any later version.
* Tyr is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
* You should have received a copy of the GNU General Public License
* along with Tyr.  If not, see http://www.gnu.org/licenses/.
*/


package com.tyr.tasks;

import com.tyr.Tyr;
import bwapi.Game;
import bwapi.Player;


/**
 * A task for scouting for enemy expansions.
 */
public class ScoutExpansionsTask extends Task
{
	/**
	 * The direction in which we will scout first, either -1 or 1.
	 */
	private int startDir = 1;
	
	/**
	 * Do we alternate the direction in which we scout?
	 */
	private boolean alternateDir = false;
	
	/**
	 * A task for scouting for enemy expansions.
	 */
	public ScoutExpansionsTask() { }
	
	/**
	 * A task for scouting for enemy expansions.
	 * Do we alternate the direction in which we scout?
	 */
	public ScoutExpansionsTask(boolean alternateDir) 
	{
		this.alternateDir = alternateDir;
	}
	
	/**
	 * A task for scouting for enemy expansions.
	 * The direction in which we will scout first, either -1 or 1.
	 */
	public ScoutExpansionsTask(int startDir) 
	{
		this.startDir = startDir;
	}
	
	@Override
	public boolean isRequired(Game game, Player self, Tyr bot) 
	{
		return true;
	}
	
	@Override
	public void solve(Game game, Player self, Tyr bot)
	{
		if (((ScoutExpansionsSolution)solution).count() == 0)
			((ScoutExpansionsSolution)solution).add(bot.workForce.pop());
		
		// We call the super class, which will send the units out to scout.
		super.solve(game, self, bot);
	}

	@Override
	public void findSolution(Game game, Player self, Tyr bot)
	{
		solution = new ScoutExpansionsSolution(this, startDir);
		if (alternateDir)
			startDir = -startDir;
	}
}
