/*
* Tyr is an AI for StarCraft: Broodwar, 
* 
* Please visit https://github.com/SimonPrins/Tyr for further information.
* 
* Copyright 2015 Simon Prins
*
* This file is part of Tyr.
* Tyr is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 2 of the License, or
* (at your option) any later version.
* Tyr is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
* You should have received a copy of the GNU General Public License
* along with Tyr.  If not, see http://www.gnu.org/licenses/.
*/


package com.tyr.tasks;

import com.tyr.DebugMessages;
import com.tyr.EnemyManager;
import com.tyr.Scanner;
import com.tyr.Tyr;
import com.tyr.agents.Agent;
import com.tyr.agents.None;
import com.tyr.unitgroups.OutOfJob;

import bwapi.Game;
import bwapi.Player;


/**
 * This solution finds the remaining enemy buildings after the main base has been destroyed.
 * @author Simon
 *
 */
public class ScanSolution extends Solution 
{
	/**
	 * Reference to the scanner used by Tyr.
	 * This scanner will try to find remaining enemy buildings after has main has been destroyed.
	 */
	Scanner scanner;
	
	/**
	 * This solution finds the remaining enemy buildings after the main base has been destroyed.
	 * @param task The task that created this solution.
	 */
	public ScanSolution(Task task) 
	{
		super(task);
		
		scanner = Tyr.bot.scanner;
	}

	@Override
	public void onFrame(Game game, Player self, Tyr bot)
	{
		DebugMessages.addMessage("Looking for enemy buildings.");
		
		 // Get all units able to help with the scanning.
		for (int i=bot.homeGroup.units.size()-1; i >= 0; i--)
		{
			Agent agent = bot.homeGroup.units.get(i);
			add(agent);
			agent.order(new None(agent));
			agent.unit.stop();
			bot.homeGroup.remove(i);
		}
	}
	
	/**
	 * Adds an agent to the scanner.
	 * @param agent The Agent that is to be added to the scanner.
	 */
	public void add(Agent agent)
	{
		agent.order(new None(agent));
		agent.unit.stop();
		
		if (agent.unit.getType().isFlyer())
			scanner.addAir(agent);
		else
			scanner.addGround(agent);
	}

	/**
	 * Have we found an enemy building yet?
	 * @return Returns true if we have found an enemy building, returns false otherwise.
	 */
	public boolean finishedScanning()
	{
		return EnemyManager.getManager().enemyBuildingMemory.size() > 0;
	}
	
	/**
	 * Clears all units from the scanner, releasing them to the rest of the program.
	 * @param rejects The rejects to which the units are to be released. 
	 */
	public void clear(OutOfJob rejects)
	{
		this.scanner.clear(rejects);
	}
}
