/*
 * Tyr is an AI for StarCraft: Broodwar, 
 * 
 * Please visit https://github.com/SimonPrins/Tyr for further information.
 * 
 * Copyright 2015 Simon Prins
 *
 * This file is part of Tyr.
 * Tyr is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 * Tyr is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with Tyr.  If not, see http://www.gnu.org/licenses/.
 */


package com.tyr.tasks;

import java.util.ArrayList;

import com.tyr.DebugMessages;
import com.tyr.EnemyManager;
import com.tyr.Tyr;
import com.tyr.UnitTracker;
import com.tyr.agents.Agent;

import bwapi.Game;
import bwapi.Player;
import bwapi.Position;
import bwapi.UnitType;

/**
 * Boomerang always comes back.
 */
public class BoomerangTask extends Task
{
	private int defendingVultures = 2;

	private int defendingTanks = 2;

	private int minimumVultures = 2;

	private int minimumTanks = 2;

	@Override
	public boolean isRequired(Game game, Player self, Tyr bot) 
	{
		if (solution != null)
		{
			if (((BoomerangSolution)solution).size() == 0)
				solution = null;
			else return true;
		}
			
		// We cannot start the harass if we cannot determine a target for the harass.
		if (EnemyManager.getManager().getOrderedExpands() == null)
			return false;
		
		if (UnitTracker.count(UnitType.Terran_Command_Center) < 2)
			return false;
		
		// Count how many vultures and tanks we can use.
		int vultureCount = 0;
		int tankCount = 0;
		
		for(Agent agent : bot.homeGroup.units)
		{
			if (agent.unit.getType() == UnitType.Terran_Vulture)
				vultureCount++;
			else if (agent.unit.getType() == UnitType.Terran_Siege_Tank_Siege_Mode || agent.unit.getType() == UnitType.Terran_Siege_Tank_Tank_Mode)
				tankCount++;
			if (vultureCount >= minimumVultures + defendingVultures && tankCount >= minimumTanks + defendingTanks)
				return true;
		}
		
		return false;
	}

	@Override
	public void solve(Game game, Player self, Tyr bot)
	{
		// We call the super class, which will send out the boomerang.
		super.solve(game, self, bot);
	}

	@Override
	public void findSolution(Game game, Player self, Tyr bot)
	{
		ArrayList<Position> orderedExpands = EnemyManager.getManager().getOrderedExpands();
		int pos = (EnemyManager.getManager().getSelfPos() + 2) % orderedExpands.size();
		if (orderedExpands == null || orderedExpands.size() == 0 || orderedExpands.get(pos) == null)
		{
			DebugMessages.addMessage("orderedExpands is null!");
			return;
		}
		solution = new BoomerangSolution(this, orderedExpands.get(pos));

		// The number of vultures and tanks we have added.
		int vultureCount = 0;
		int tankCount = 0;

		// Get the vultures needed for the harass.
		for (int i = bot.homeGroup.units.size() - 1; i >= 0; i--)
		{
			Agent agent = bot.homeGroup.units.get(i);
			if (agent.unit.getType() == UnitType.Terran_Vulture)
			{
				vultureCount++;
				if (vultureCount > defendingVultures)
				{
					((BoomerangSolution) solution).add(agent);
					bot.homeGroup.units.remove(i);
				}
			}
			else if (agent.unit.getType() == UnitType.Terran_Siege_Tank_Siege_Mode || agent.unit.getType() == UnitType.Terran_Siege_Tank_Tank_Mode)
			{
				tankCount++;
				if (tankCount > defendingTanks)
				{
					((BoomerangSolution) solution).add(agent);
					bot.homeGroup.units.remove(i);
				}
			}
		}
	}
}
