/*
* Tyr is an AI for StarCraft: Broodwar, 
* 
* Please visit https://github.com/SimonPrins/Tyr for further information.
* 
* Copyright 2015 Simon Prins
*
* This file is part of Tyr.
* Tyr is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 2 of the License, or
* (at your option) any later version.
* Tyr is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
* You should have received a copy of the GNU General Public License
* along with Tyr.  If not, see http://www.gnu.org/licenses/.
*/


package com.tyr.requirements;

import com.tyr.Tyr;

import bwapi.TechType;

/**
 * Has a certain type of tech been researched?
 * @author Simon
 *
 */
public class TechRequirement implements Requirement 
{
	/**
	 * The type of tech that is required.
	 */
	private TechType type;
	
	/**
	 * Does the research need to be finished, or is it enough for it to be researching?
	 */
	private boolean finished;
	
	/**
	 * Has a certain type of tech been researched?
	 * @param type The type of tech that is required.
	 * @param finished Does the research need to be finished, or is it enough for it to be researching?
	 */
	public TechRequirement(TechType type, boolean finished)
	{
		this.type = type;
		this.finished = finished;
	}

	/**
	 * Has a certain type of tech been researched?
	 * @param type The type of tech that is required.
	 */
	public TechRequirement(TechType type)
	{
		this(type, true);
	}
	
	@Override
	public boolean met()
	{
		if (Tyr.self.hasResearched(type))
			return true;
		return Tyr.self.isResearching(type) && !finished;
	}
}
