/*
* Tyr is an AI for StarCraft: Broodwar, 
* 
* Please visit https://github.com/SimonPrins/Tyr for further information.
* 
* Copyright 2015 Simon Prins
*
* This file is part of Tyr.
* Tyr is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 2 of the License, or
* (at your option) any later version.
* Tyr is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
* You should have received a copy of the GNU General Public License
* along with Tyr.  If not, see http://www.gnu.org/licenses/.
*/


package com.tyr.requirements;

import com.tyr.Tyr;

/**
 * Do we have a certain amount of resources?
 * Normally the GenericPartFactory.setCost method should be used to define a cost.
 * However, this requirement can be useful in combination with the DisjRequirement and ConjRequirement.
 * @author Simon
 *
 */
public class CostRequirement implements Requirement 
{
	/**
	 * The minerals needed before we build the building.
	 */
	private int minerals;
	
	/**
	 * The gas needed before we build the building.
	 */
	private int gas;
	
	/**
	 * Do we have a certain amount of resources?
	 * Normally the GenericPartFactory.setCost method should be used to define a cost.
	 * However, this requirement can be useful in combination with the DisjRequirement and ConjRequirement.
	 */
	public CostRequirement(int minerals, int gas)
	{
		this.minerals = minerals;
		this.gas = gas;
	}
	
	@Override
	public boolean met()
	{
		return Tyr.bot.getAvailableGas() >= gas && Tyr.bot.getAvailableMinerals() >= minerals;
	}
}
