/*
* Tyr is an AI for StarCraft: Broodwar, 
* 
* Please visit https://github.com/SimonPrins/Tyr for further information.
* 
* Copyright 2015 Simon Prins
*
* This file is part of Tyr.
* Tyr is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 2 of the License, or
* (at your option) any later version.
* Tyr is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
* You should have received a copy of the GNU General Public License
* along with Tyr.  If not, see http://www.gnu.org/licenses/.
*/


package com.tyr.builds;

import com.tyr.DebugMessages;
import com.tyr.Tyr;

import bwapi.Game;
import bwapi.Player;


/**
 * This BuildOrder sends a worker to scout at the start of a game.
 * This is meant to be used as a part of a larger build using the CompositeBuildOrder class.
 */
public class WorkerScoutPart extends BuildOrder
{
	/**
	 * How many worker scouts have we requested so far?
	 */
	private int scoutsRequested = 0;
	
	/**
	 * Determines the frame at which we send out the worker scout.
	 */
	private int atFrame;
	
	/**
	 * Do we send a second worker to be certain of finding the opponents base in time.
	 */
	private boolean doubleScout = false;
	
	/**
	 * This part sends out a single worker scout.
	 * @param atFrame The frame at which the worker should be sent out.
	 */
	public WorkerScoutPart(int atFrame)
	{
		this.atFrame = atFrame;
	}
	
	@Override
	public void initialize(Game game, Player self, Tyr bot)
	{ }
	
	@Override
	public void onFrame(Game game, Player self, Tyr bot)
	{
		// If we haven't sent the scout yet and the frame at which we should send the scout has passed...
		if(game.getFrameCount() >= atFrame && scoutsRequested == 0)
		{
			// Then we send the scout.
			bot.scout.requestWorkerScoutOnce();
			scoutsRequested++;
			
			if (bot.suspectedEnemy.size() < 3)
			{
				DebugMessages.log("No need to double scout.");
				doubleScout = false;
			}
		}
		
		if (doubleScout
				&& scoutsRequested == 1
				&& bot.suspectedEnemy.size() == 2)
		{
			DebugMessages.log("Activating double scout.");
			// Then we send the scout.
			bot.scout.requestWorkerScout();
			scoutsRequested++;
		}
	}
	
	public WorkerScoutPart doubleScout()
	{
		doubleScout = true;
		return this;
	}
}
