/*
* Tyr is an AI for StarCraft: Broodwar, 
* 
* Please visit https://github.com/SimonPrins/Tyr for further information.
* 
* Copyright 2015 Simon Prins
*
* This file is part of Tyr.
* Tyr is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 2 of the License, or
* (at your option) any later version.
* Tyr is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
* You should have received a copy of the GNU General Public License
* along with Tyr.  If not, see http://www.gnu.org/licenses/.
*/


package com.tyr.builds;

import com.tyr.Settings;
import com.tyr.Tyr;
import com.tyr.UnitTracker;

import bwapi.Game;
import bwapi.Player;
import bwapi.UnitType;


public class MarinePush extends CompositeBuildOrder
{
	@Override
	public void initialize(Game game, Player self, Tyr bot)
	{
		Settings.setRequiredSize(20);
		Settings.setMaximumSize(60);
		
		this.add(new SupplyDepotPart());
		this.add(new WorkerScoutPart(1600));
		
		super.initialize(game, self, bot);
	}

	@Override
	public void onFrame(Game game, Player self, Tyr bot) 
	{
		super.onFrame(game, self, bot);
		
		//if we've the resources to build a barracks ...
		if (bot.getAvailableMinerals()>= 150 && (UnitTracker.count(UnitType.Terran_Barracks) < Math.min(UnitTracker.getCcCount() * 2, 10) + 1)) 
		{
			bot.spaceManager.build(UnitType.Terran_Barracks);
		}
		
		if (bot.getAvailableMinerals() >= 400)
		{
			bot.spaceManager.build(UnitType.Terran_Command_Center);
		}
	}
}
