/*
* Tyr is an AI for StarCraft: Broodwar, 
* 
* Please visit https://github.com/SimonPrins/Tyr for further information.
* 
* Copyright 2015 Simon Prins
*
* This file is part of Tyr.
* Tyr is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 2 of the License, or
* (at your option) any later version.
* Tyr is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
* You should have received a copy of the GNU General Public License
* along with Tyr.  If not, see http://www.gnu.org/licenses/.
*/


package com.tyr.agents;

import com.tyr.EnemyManager;
import com.tyr.EnemyPosition;
import com.tyr.Tyr;

import bwapi.Game;
import bwapi.Player;
import bwapi.Position;
import bwapi.UnitType;


/**
 * A command for a-moving to the enemy.
 * Siege tanks will siege to attack cannons.
 * @author Simon
 *
 */
public class AntiCannonPush extends Command
{
	/**
	 * The position where the unit will attack.
	 */
	private Position target;
	
	/**
	 * A command for a-moving to the enemy.
	 * Siege tanks will siege to attack cannons.
	 * @param agent The agent who will carry out the attack.
	 * @param target The position where we will attack.
	 */
	public AntiCannonPush(Agent agent, Position target) 
	{
		super(agent);
		this.target = target;
	}

	@Override
	public void execute(Game game, Player self, Tyr bot) 
	{
		// Attack the enemy.
		if(agent.unit.isIdle() || game.getFrameCount() % 200 == 0)
			agent.unit.attack(target);
		
		// Siege tanks should siege in range of cannons.
		if(agent.unit.getType() == UnitType.Terran_Siege_Tank_Tank_Mode)
		{
			for(EnemyPosition enemy : EnemyManager.getManager().enemyBuildingMemory)
			{
				if(enemy.type == UnitType.Protoss_Photon_Cannon
						&& agent.distanceSquared(enemy.pos) <= 
						UnitType.Terran_Siege_Tank_Siege_Mode.sightRange()*UnitType.Terran_Siege_Tank_Siege_Mode.sightRange())
				{
					agent.unit.siege();
					break;
				}
			}
		}
		else if (agent.unit.getType() == UnitType.Terran_Siege_Tank_Siege_Mode)
		{
			boolean inrange = false;
			for(EnemyPosition enemy : EnemyManager.getManager().enemyBuildingMemory)
			{
				if(enemy.type == UnitType.Protoss_Photon_Cannon
						&& agent.distanceSquared(enemy.pos) <= 
								UnitType.Terran_Siege_Tank_Siege_Mode.sightRange()*UnitType.Terran_Siege_Tank_Siege_Mode.sightRange())
				{
					inrange = true;
					break;
				}
			}
			
			if(!inrange)
				agent.unit.unsiege();
		}
	}

	@Override
	public boolean replace(Command command)
	{
		if (!command.getClass().equals(AntiCannonPush.class))
			return true;
		
		return ((AntiCannonPush)command).target.getX() == target.getX() && ((AntiCannonPush)command).target.getY() == target.getY();
	}

}
