/*
* Tyr is an AI for StarCraft: Broodwar, 
* 
* Please visit https://github.com/SimonPrins/Tyr for further information.
* 
* Copyright 2015 Simon Prins
*
* This file is part of Tyr.
* Tyr is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 2 of the License, or
* (at your option) any later version.
* Tyr is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
* You should have received a copy of the GNU General Public License
* along with Tyr.  If not, see http://www.gnu.org/licenses/.
*/


package com.tyr;

import bwapi.Position;
import bwapi.Unit;
import bwapi.UnitType;


/**
 * This class is used to register the position of enemy buildings.
 * @author Simon
 *
 */
public class EnemyPosition
{
	/**
	 * The type of building.
	 */
	public UnitType type;
	
	/**
	 * The position where the building is located.
	 */
	public Position pos;
	
	/**
	 * Is the building completed or not?
	 */
	public boolean completed;
	
	/**
	 * The id of this unit.
	 */
	public int id;
	
	/**
	 * This class is used to register the position of enemy buildings.
	 * @param id The id of the unit.
	 * @param type The type of building.
	 * @param pos The position where the building is located.
	 * @param completed Is the building completed or not?
	 */
	public EnemyPosition(int id, UnitType type, Position pos, boolean completed)
	{
		this.id = id;
		this.type = type;
		this.pos = pos;
		this.completed = completed;
	}
	
	@Override
	public boolean equals(Object other)
	{
		if(other.getClass() != this.getClass())
			return false;
		return id == ((EnemyPosition)other).id;
	}
	
	
	@Override
	public int hashCode()
	{
		return id;
	}

	public int distanceSq(Position pos) {
		int dx = this.pos.getX() - pos.getX();
		int dy = this.pos.getY() - pos.getY();
		return dx*dx + dy*dy;
	}

	public int distanceSq(Unit unit) {
		return distanceSq(unit.getPosition());
	}
}
