/*
 * Decompiled with CFR 0.152.
 */
package com.tyr.unitgroups;

import bwapi.Color;
import bwapi.Game;
import bwapi.Player;
import bwapi.Position;
import bwapi.Unit;
import com.tyr.DebugMessages;
import com.tyr.Tyr;
import com.tyr.agents.Agent;
import com.tyr.unitgroups.MineralWorkers;
import com.tyr.unitgroups.OutOfJob;
import com.tyr.unitgroups.PatchWorkers;
import com.tyr.unitgroups.UnitGroup;
import java.util.ArrayList;

public class WorkerGroup
extends UnitGroup {
    public static boolean evacuateThreatenedBases = true;
    public ArrayList<MineralWorkers> mineralWorkers = new ArrayList();
    private OutOfJob outOfJob = new OutOfJob();

    public WorkerGroup(OutOfJob rejects) {
        super(rejects);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void onFrame(Game game, Player self, Tyr bot) {
        block18: {
            block19: {
                if (this.mineralWorkers.size() <= 0) break block18;
                size = this.units.size();
                minedOut = new ArrayList<MineralWorkers>();
                for (MineralWorkers mw : this.mineralWorkers) {
                    if (!mw.minedOut()) continue;
                    minedOut.add(mw);
                }
                for (MineralWorkers mw : minedOut) {
                    this.mineralWorkers.remove(mw);
                    mw.clear(this.outOfJob);
                }
                totalPatches = 0;
                totalWorkers = this.outOfJob.units.size();
                safeExists = false;
                for (MineralWorkers mw : this.mineralWorkers) {
                    if (mw.underAttack) continue;
                    safeExists = true;
                }
                if (!WorkerGroup.evacuateThreatenedBases) {
                    safeExists = false;
                }
                for (MineralWorkers mw : this.mineralWorkers) {
                    if (mw.underAttack && safeExists) continue;
                    if (mw.resourceDepot.isCompleted()) {
                        totalPatches += mw.minerals.size();
                    }
                    for (PatchWorkers patch : mw.patchWorkers) {
                        totalWorkers += patch.units.size();
                    }
                }
                if (totalPatches <= 0) break block19;
                block5: for (MineralWorkers mw : this.mineralWorkers) {
                    if (!mw.underAttack || !safeExists) ** GOTO lbl37
                    continue;
                    while ((worker = mw.pop()) != null) {
                        this.outOfJob.add(worker);
lbl37:
                        // 2 sources

                        if (mw.size() > totalWorkers * mw.minerals.size() / totalPatches + 1 || mw.minerals.size() == 0) continue;
                        continue block5;
                    }
                }
            }
            if (this.units.size() > size) {
                DebugMessages.addMessage("WorkerGroup incorrect size 1: " + (this.units.size() - size));
            }
            filled = 0;
            while (this.outOfJob.units.size() > 0) {
                worker = this.outOfJob.pop();
                done = false;
                while (filled < this.mineralWorkers.size()) {
                    if (!(this.mineralWorkers.get((int)filled).underAttack && safeExists || !this.mineralWorkers.get((int)filled).resourceDepot.isCompleted() || totalPatches != 0 && this.mineralWorkers.get(filled).size() >= totalWorkers * this.mineralWorkers.get((int)filled).minerals.size() / totalPatches + 1 || this.mineralWorkers.get((int)filled).minerals.size() <= 0)) {
                        this.mineralWorkers.get(filled).add(worker);
                        done = true;
                        break;
                    }
                    ++filled;
                }
                if (done) continue;
                this.outOfJob.add(worker);
                break;
            }
            if (this.units.size() > size) {
                DebugMessages.addMessage("WorkerGroup incorrect size 2: " + (this.units.size() - size));
            }
            for (MineralWorkers mw : this.mineralWorkers) {
                mw.onFrame(game, self, bot);
            }
            if (this.units.size() > size) {
                DebugMessages.addMessage("WorkerGroup incorrect size 3: " + (this.units.size() - size));
            }
        }
        if (this.outOfJob.units.size() > 0) {
            DebugMessages.addMessage("OutOfJob workers: " + this.outOfJob.units.size());
        }
        for (Agent agent : this.outOfJob.units) {
            agent.drawCircle(Color.Orange);
        }
    }

    @Override
    public Agent pop() {
        Agent result = null;
        if (!this.outOfJob.units.isEmpty()) {
            result = (Agent)this.outOfJob.units.get(this.outOfJob.units.size() - 1);
            this.outOfJob.remove(this.outOfJob.units.size() - 1);
            return result;
        }
        for (MineralWorkers mw : this.mineralWorkers) {
            result = mw.pop();
            if (result == null) continue;
            this.units.remove(result);
            return result;
        }
        return null;
    }

    @Override
    public void cleanup() {
        super.cleanup();
        for (MineralWorkers base : this.mineralWorkers) {
            base.cleanup();
        }
    }

    public Agent pop(Position pos) {
        return this.pop(pos, false);
    }

    public Agent pop(Position pos, boolean healthyOnly) {
        if (pos == null) {
            return this.pop();
        }
        Agent result = null;
        UnitGroup mwResult = null;
        double distance = Double.MAX_VALUE;
        for (MineralWorkers mw : this.mineralWorkers) {
            Agent newWorker = mw.pop(pos, healthyOnly);
            if (newWorker == null) continue;
            newWorker.drawCircle(Color.Green, 6);
            double newDist = newWorker.distanceSquared(pos);
            if (newDist < distance) {
                if (mwResult != null) {
                    ((MineralWorkers)mwResult).add(result);
                }
                result = newWorker;
                mwResult = mw;
                distance = newDist;
                continue;
            }
            mw.add(newWorker);
        }
        if (result != null) {
            mwResult.remove(result);
        } else {
            result = this.outOfJob.pop();
        }
        this.units.remove(result);
        return result;
    }

    public Agent poll() {
        Agent result = null;
        if (!this.outOfJob.units.isEmpty()) {
            result = (Agent)this.outOfJob.units.get(this.outOfJob.units.size() - 1);
            return result;
        }
        for (MineralWorkers mw : this.mineralWorkers) {
            result = mw.poll();
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public Agent poll(Position pos) {
        if (pos == null) {
            return this.poll();
        }
        Agent result = null;
        double distance = Double.MAX_VALUE;
        for (MineralWorkers mw : this.mineralWorkers) {
            Agent newWorker = mw.poll(pos);
            if (newWorker == null) continue;
            newWorker.drawCircle(Color.Green, 6);
            double newDist = newWorker.distanceSquared(pos);
            if (!(newDist < distance)) continue;
            result = newWorker;
            distance = newDist;
        }
        if (result == null && !this.outOfJob.units.isEmpty()) {
            result = (Agent)this.outOfJob.units.get(this.outOfJob.units.size() - 1);
        }
        return result;
    }

    @Override
    public void add(Agent agent) {
        super.add(agent);
        this.outOfJob.add(agent);
    }

    public void newBase(Unit base) {
        this.mineralWorkers.add(new MineralWorkers(this.outOfJob, base));
    }

    @Override
    public int takeAgent(Agent agent) {
        if (agent.unit.getType().isWorker()) {
            return 1;
        }
        return -1;
    }
}

