/*
 * Decompiled with CFR 0.152.
 */
package com.tyr.unitgroups;

import bwapi.Color;
import bwapi.Game;
import bwapi.Player;
import bwapi.Position;
import bwapi.Unit;
import bwapi.UnitType;
import bwta.BaseLocation;
import com.tyr.BWTAProxy;
import com.tyr.EnemyManager;
import com.tyr.EnemyPosition;
import com.tyr.Settings;
import com.tyr.Tyr;
import com.tyr.agents.Agent;
import com.tyr.buildingplacement.SpaceManager;
import com.tyr.unitgroups.OutOfJob;
import com.tyr.unitgroups.UnitGroup;
import java.util.Iterator;

public class TankForce
extends UnitGroup {
    private Position target = null;

    public TankForce(OutOfJob rejects) {
        super(rejects);
    }

    @Override
    public void onFrame(Game game, Player self, Tyr bot) {
        if (BWTAProxy.initialized) {
            this.acquireTarget();
            if (this.target == null) {
                this.target = Settings.getRallyPoint() != null ? Settings.getRallyPoint() : SpaceManager.getMainExit();
            }
            for (Agent agent : this.units) {
                agent.drawCircle(Color.Yellow);
                if (agent.unit.isIdle() || game.getFrameCount() % 200 == 0) {
                    agent.unit.attack(this.target);
                }
                boolean targetExists = false;
                int radius = UnitType.Terran_Siege_Tank_Siege_Mode.groundWeapon().maxRange();
                for (Unit unit : EnemyManager.getEnemyUnits()) {
                    if (unit.getType().isFlyer() || unit.isLifted() || agent.distanceSquared(unit) > radius * radius) continue;
                    targetExists = true;
                    break;
                }
                if (agent.unit.getType() == UnitType.Terran_Siege_Tank_Tank_Mode) {
                    if (!targetExists) continue;
                    agent.unit.siege();
                    continue;
                }
                if (agent.unit.getType() != UnitType.Terran_Siege_Tank_Siege_Mode || targetExists) continue;
                agent.unit.unsiege();
            }
        }
    }

    public void acquireTarget() {
        this.target = null;
        Iterator<Object> iterator = EnemyManager.getManager().enemyBuildingMemory.iterator();
        if (iterator.hasNext()) {
            EnemyPosition p = iterator.next();
            this.target = p.pos;
        }
        if (this.target == null && (iterator = Tyr.bot.suspectedEnemy.iterator()).hasNext()) {
            BaseLocation b = (BaseLocation)iterator.next();
            this.target = b.getPosition();
        }
    }

    @Override
    public void add(Agent agent) {
        super.add(agent);
    }
}

