/*
 * Decompiled with CFR 0.152.
 */
package com.tyr.unitgroups;

import bwapi.Color;
import bwapi.Game;
import bwapi.Player;
import bwapi.Position;
import bwapi.Unit;
import bwapi.UnitType;
import bwapi.WeaponType;
import bwta.BaseLocation;
import bwta.Region;
import com.tyr.BWTAProxy;
import com.tyr.DebugMessages;
import com.tyr.EnemyManager;
import com.tyr.PositionUtil;
import com.tyr.Tyr;
import com.tyr.agents.Agent;
import com.tyr.buildingplacement.SpaceManager;
import com.tyr.tasks.ObserverSolution;
import com.tyr.unitgroups.IAttackGroup;
import com.tyr.unitgroups.ZealotDropGroup;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class DistributeAttackGroup
extends IAttackGroup {
    private double maxTargetRange = 300.0;
    public static int threatRange = 450;
    public static int waitDistance = -400;
    private int initialBonusDist = 200;
    private Map<Integer, EnemyUnit> enemyMap = new HashMap<Integer, EnemyUnit>();
    private Map<Integer, Integer> attackMap = new HashMap<Integer, Integer>();
    private List<Unit> enemyTanks = new ArrayList<Unit>();
    private int mode = 0;
    private static final int ATTACK = 0;
    private static final int RETREAT = 1;
    private static final int SAFE_MOVE_OUT = 2;
    private int lastRetreatFrame = -10000;
    public static int requiredForAttack = 15;
    public static int requiredForRetreat = 10;
    private List<ZealotDropGroup> drops = new ArrayList<ZealotDropGroup>();

    public DistributeAttackGroup(Position target) {
        super(target);
    }

    @Override
    public void onFrame(Game game, Player self, Tyr bot) {
        boolean bl;
        Tyr.drawCircle(this.target, Color.Orange, 64);
        for (ZealotDropGroup drop : this.drops) {
            drop.cleanup();
        }
        int i = this.units.size() - 1;
        while (i >= 0) {
            block73: {
                Agent agent = (Agent)this.units.get(i);
                if (agent.unit.getType() == UnitType.Protoss_Shuttle) {
                    for (ZealotDropGroup drop : this.drops) {
                        if (!drop.needsShuttle()) continue;
                        this.units.remove(i);
                        drop.add(agent);
                        break block73;
                    }
                    ZealotDropGroup drop2 = new ZealotDropGroup();
                    this.units.remove(i);
                    drop2.add(agent);
                    this.drops.add(drop2);
                }
            }
            --i;
        }
        for (ZealotDropGroup drop : this.drops) {
            if (!drop.needsShuttle()) {
                int i2 = this.units.size() - 1;
                while (i2 >= 0) {
                    if (drop.getZealots() >= 4) break;
                    Agent agent = (Agent)this.units.get(i2);
                    if (agent.unit.getType() == UnitType.Protoss_Zealot) {
                        this.units.remove(i2);
                        drop.add(agent);
                    }
                    --i2;
                }
            }
            drop.setTarget(this.getDropTarget());
            drop.onFrame(game, self, bot);
        }
        if (this.mode == 2) {
            this.safeMoveOut();
            return;
        }
        Agent observer = ObserverSolution.getArmyObserver();
        boolean attackingMainOrNatural = Tyr.bot.suspectedEnemy.size() == 1 && this.target != null && PositionUtil.distanceSq(Tyr.bot.suspectedEnemy.get(0).getPosition(), this.target) <= 40000 || SpaceManager.getEnemyNatural() != null && PositionUtil.distanceSq(SpaceManager.getEnemyNatural().getPosition(), this.target) <= 40000;
        for (Agent agent : this.units) {
            if (agent.unit.getType() != UnitType.Protoss_Reaver) continue;
            agent.drawCircle(Color.Purple);
            if (agent.unit.isTraining()) continue;
            agent.unit.train(UnitType.Protoss_Scarab);
        }
        int i3 = this.enemyTanks.size() - 1;
        while (i3 >= 0) {
            Unit unit = this.enemyTanks.get(i3);
            Position pos = EnemyManager.getManager().getLastPosition(unit);
            for (Agent agent : this.units) {
                if (pos != null && agent.distanceSquared(pos) > 40000) continue;
                this.enemyTanks.remove(i3);
                break;
            }
            --i3;
        }
        ArrayList<Unit> spiderMines = new ArrayList<Unit>();
        for (Unit unit : EnemyManager.getEnemyUnits()) {
            if (unit.getType() == UnitType.Terran_Vulture_Spider_Mine) {
                spiderMines.add(unit);
            }
            if (unit.getType() != UnitType.Terran_Siege_Tank_Siege_Mode && unit.getType() != UnitType.Terran_Siege_Tank_Tank_Mode || this.enemyTanks.contains(unit)) continue;
            this.enemyTanks.add(unit);
        }
        boolean lowGroundTanks = false;
        boolean highGroundTanks = false;
        for (Unit tank : this.enemyTanks) {
            Object pos;
            if (lowGroundTanks && highGroundTanks || (pos = EnemyManager.getManager().getLastPosition(tank)) == null) continue;
            boolean highGround = DistributeAttackGroup.isOnHighGround(tank);
            if (highGround) {
                highGroundTanks = true;
                continue;
            }
            lowGroundTanks = true;
        }
        HashSet<Unit> targettableEnemies = new HashSet<Unit>();
        block10: for (Unit unit : EnemyManager.getEnemyUnits()) {
            if (!unit.getType().isWorker() && unit.getType() != UnitType.Terran_Vulture) continue;
            for (BaseLocation pos : bot.expands) {
                if (PositionUtil.distanceSq(pos.getPosition(), unit) > 90000) continue;
                targettableEnemies.add(unit);
                break;
            }
            for (BaseLocation pos : bot.suspectedEnemy) {
                if (PositionUtil.distanceSq(pos.getPosition(), unit) > 90000) continue;
                targettableEnemies.add(unit);
                continue block10;
            }
        }
        int correctedWaitDist = waitDistance + this.initialBonusDist;
        int waiting = 0;
        int attacking = 0;
        block13: for (Agent agent : this.units) {
            if (agent.distanceSquared(this.target) < (correctedWaitDist - 200) * (correctedWaitDist - 200)) {
                agent.drawCircle(Color.Red);
                ++attacking;
                ++waiting;
                continue;
            }
            if (agent.distanceSquared(this.target) < (correctedWaitDist + 400) * (correctedWaitDist + 400)) {
                if (agent.distanceSquared(this.target) < correctedWaitDist * correctedWaitDist) {
                    agent.drawCircle(Color.Blue);
                } else {
                    agent.drawCircle(Color.Teal);
                }
                ++waiting;
                continue;
            }
            for (Unit unit : this.enemyTanks) {
                Position pos = EnemyManager.getManager().getLastPosition(unit);
                if (agent.distanceSquared(pos) >= (correctedWaitDist + 400) * (correctedWaitDist + 400)) continue;
                if (agent.distanceSquared(pos) < correctedWaitDist * correctedWaitDist) {
                    agent.drawCircle(Color.Blue);
                } else {
                    agent.drawCircle(Color.Teal);
                }
                ++waiting;
                continue block13;
            }
        }
        ArrayList<Integer> removeIDs = new ArrayList<Integer>();
        for (Integer id : this.enemyMap.keySet()) {
            if (this.enemyMap.get(id).isDead()) {
                removeIDs.add(id);
                continue;
            }
            Agent.clean(this.enemyMap.get((Object)id).attackingAgents);
        }
        for (Integer id : removeIDs) {
            this.enemyMap.remove(id);
        }
        removeIDs = new ArrayList();
        for (Integer id : this.attackMap.keySet()) {
            if (this.enemyMap.containsKey(this.attackMap.get(id))) continue;
            removeIDs.add(id);
        }
        for (Integer id : removeIDs) {
            this.attackMap.remove(id);
        }
        boolean contain = EnemyManager.getManager().getAllCount(UnitType.Terran_Command_Center) <= 1 && !lowGroundTanks && highGroundTanks && waiting < 25;
        boolean bl2 = bl = !contain && (waiting > requiredForRetreat || attacking > 5);
        if (waiting <= 10) {
            this.mode = 1;
            this.lastRetreatFrame = game.getFrameCount();
        } else if (contain && waiting < requiredForAttack) {
            this.mode = 1;
            this.lastRetreatFrame = game.getFrameCount();
        } else if (contain && !lowGroundTanks && EnemyManager.getManager().getAllCount(UnitType.Terran_Command_Center) <= 1 && waiting < 15) {
            this.mode = 1;
            this.lastRetreatFrame = game.getFrameCount();
        } else if (game.getFrameCount() - this.lastRetreatFrame >= 200 && this.mode == 1 && !contain && waiting >= requiredForAttack) {
            this.initialBonusDist = 0;
            this.mode = 0;
        }
        if (highGroundTanks) {
            DebugMessages.addMessage("Highground tanks detected.");
        }
        if (lowGroundTanks) {
            DebugMessages.addMessage("Lowground tanks detected.");
        }
        if (contain) {
            DebugMessages.addMessage("Containing the enemy.");
        } else if (bl) {
            DebugMessages.addMessage("Attacking the enemy.");
        }
        for (Agent agent : this.units) {
            EnemyUnit currentTarget;
            if (this.attackMap.containsKey(agent.unit.getID())) {
                if ((agent.unit.getID() + game.getFrameCount()) % 15 != 0) continue;
                boolean removed = false;
                if ((agent.unit.getID() + game.getFrameCount()) % 200 != 0) {
                    EnemyUnit enemy = this.enemyMap.get(this.attackMap.get(agent.unit.getID()));
                    if (DistributeAttackGroup.isOnHighGround(enemy.enemy) || game.getGroundHeight(agent.unit.getTilePosition()) < game.getGroundHeight(enemy.enemy.getTilePosition()) || (enemy.enemy.getType().isWorker() || enemy.enemy.getType() == UnitType.Terran_Vulture) && !targettableEnemies.contains(enemy.enemy) || agent.unit.getType() == UnitType.Protoss_Zealot && enemy.enemy.getType() == UnitType.Terran_Siege_Tank_Tank_Mode && agent.distanceSquared(this.target) >= 1000000 || agent.unit.getType().airWeapon() == WeaponType.None && enemy.enemy.isLifted()) {
                        enemy.attackingAgents.remove(agent);
                        this.attackMap.remove(agent.unit.getID());
                        removed = true;
                    }
                }
                currentTarget = !removed ? this.enemyMap.get(this.attackMap.get(agent.unit.getID())) : null;
            } else {
                currentTarget = null;
            }
            EnemyUnit target = currentTarget;
            double enemyDistance = this.maxTargetRange * this.maxTargetRange;
            if (target != null) {
                enemyDistance = agent.distanceSquared(target.enemy);
            }
            if (agent.unit.getType() == UnitType.Protoss_Dragoon) {
                boolean mineIsClose = false;
                for (Unit mine : spiderMines) {
                    if (agent.distanceSquared(mine) > 90000) continue;
                    mineIsClose = true;
                    break;
                }
                if (mineIsClose) continue;
            }
            for (Unit enemy : EnemyManager.getEnemyUnits()) {
                EnemyUnit unit;
                if (enemy.getType().isBuilding() && !enemy.getType().isResourceDepot() || enemy.getType() == UnitType.Protoss_Observer || enemy.getType() == UnitType.Terran_Vulture_Spider_Mine || !enemy.isVisible() || enemy.getType() == UnitType.Terran_Vulture && agent.unit.getType() == UnitType.Protoss_Zealot || agent.unit.getType().airWeapon() == WeaponType.None && enemy.getType().isFlyer() || agent.unit.getType().groundWeapon() == WeaponType.None && !enemy.getType().isFlyer() || Tyr.bot.suspectedEnemy.size() == 1 && this.units.size() < 30 && DistributeAttackGroup.isOnHighGround(enemy) || game.getGroundHeight(agent.unit.getTilePosition()) < game.getGroundHeight(enemy.getTilePosition())) continue;
                int distanceSq = agent.distanceSquared(enemy);
                int maxDist = enemy.getType() == UnitType.Terran_Siege_Tank_Siege_Mode || enemy.getType() == UnitType.Terran_Siege_Tank_Tank_Mode ? 202500 : (int)(this.maxTargetRange * this.maxTargetRange);
                if (agent.unit.getType() == UnitType.Protoss_Zealot && enemy.getType() == UnitType.Terran_Siege_Tank_Tank_Mode && agent.distanceSquared(this.target) >= 1000000 || distanceSq >= maxDist) continue;
                if (!this.enemyMap.containsKey(enemy.getID())) {
                    unit = new EnemyUnit(enemy);
                    this.enemyMap.put(enemy.getID(), unit);
                } else {
                    unit = this.enemyMap.get(enemy.getID());
                }
                if ((enemy.getType().isWorker() || enemy.getType() == UnitType.Terran_Vulture) && !targettableEnemies.contains(enemy) || (enemy.getType().isWorker() || enemy.getType() == UnitType.Terran_Marine || enemy.getType() == UnitType.Terran_Firebat) && unit.attackingAgents.size() > 1 || (enemy.getType() == UnitType.Terran_Vulture || enemy.getType() == UnitType.Terran_Wraith) && unit.attackingAgents.size() > 2) continue;
                if (target == null) {
                    target = unit;
                    enemyDistance = distanceSq;
                    continue;
                }
                if (DistributeAttackGroup.getPriority(target.enemy.getType()) > DistributeAttackGroup.getPriority(enemy.getType())) continue;
                if (DistributeAttackGroup.getPriority(target.enemy.getType()) < DistributeAttackGroup.getPriority(enemy.getType())) {
                    target = unit;
                    enemyDistance = distanceSq;
                    continue;
                }
                if (unit.attackingAgents.size() < target.attackingAgents.size() && !Agent.isTank(target.enemy)) {
                    target = unit;
                    enemyDistance = distanceSq;
                    continue;
                }
                if (unit.attackingAgents.size() > target.attackingAgents.size() && !Agent.isTank(target.enemy) || !((double)distanceSq < enemyDistance)) continue;
                target = unit;
                enemyDistance = distanceSq;
            }
            if (target == null || target == currentTarget) continue;
            if (currentTarget != null) {
                currentTarget.attackingAgents.remove(agent);
            }
            target.attackingAgents.add(agent);
            this.attackMap.put(agent.unit.getID(), target.enemy.getID());
        }
        for (Agent agent : this.units) {
            int obsDist;
            if (agent.unit.getType() == UnitType.Protoss_Zealot && !this.attackMap.containsKey(agent.unit.getID())) {
                boolean mineIsClose = false;
                for (Unit mine : spiderMines) {
                    if (agent.distanceSquared(mine) > 90000) continue;
                    mineIsClose = true;
                    break;
                }
                if (mineIsClose) {
                    agent.unit.move(Tyr.getStartLocation());
                    continue;
                }
            }
            int dist = agent.distanceSquared(this.target);
            if (this.mode == 1 && dist > (correctedWaitDist - 200) * (correctedWaitDist - 200)) {
                boolean retreat;
                boolean bl3 = retreat = dist < correctedWaitDist * correctedWaitDist;
                if (!retreat) {
                    for (Unit tank : this.enemyTanks) {
                        Position pos = EnemyManager.getManager().getLastPosition(tank);
                        if (agent.distanceSquared(pos) >= correctedWaitDist * correctedWaitDist) continue;
                        retreat = true;
                        break;
                    }
                }
                if (retreat) {
                    agent.unit.move(Tyr.tileToPosition(self.getStartLocation()));
                    continue;
                }
            }
            if (agent.unit.getType() == UnitType.Protoss_Reaver) {
                if (agent.unit.isMoving()) {
                    for (Unit enemy : EnemyManager.getEnemyUnits()) {
                        if (enemy.isLifted() || enemy.getType().isFlyer() || agent.distanceSquared(enemy) > 62500) continue;
                        agent.unit.stop();
                        return;
                    }
                }
                agent.stutterstep(this.target, false);
                continue;
            }
            if (this.attackMap.containsKey(agent.unit.getID())) {
                game.drawLineMap(agent.unit.getPosition(), this.enemyMap.get((Object)this.attackMap.get((Object)Integer.valueOf((int)agent.unit.getID()))).enemy.getPosition(), Color.Red);
                if (this.enemyMap.get(this.attackMap.get(agent.unit.getID())) == null || this.enemyMap.get((Object)this.attackMap.get((Object)Integer.valueOf((int)agent.unit.getID()))).enemy == null) {
                    agent.drawCircle(Color.Red, 16);
                    continue;
                }
                agent.attack(this.enemyMap.get((Object)this.attackMap.get((Object)Integer.valueOf((int)agent.unit.getID()))).enemy);
                continue;
            }
            if (attackingMainOrNatural && observer != null && agent.distanceSquared(Tyr.getStartLocation()) >= 1000000 && agent.distanceSquared(this.target) >= 640000 && (obsDist = observer.distanceSquared(agent)) <= 160000 && obsDist >= 40000) {
                agent.unit.move(observer.unit.getPosition());
                game.drawLineMap(agent.unit.getPosition(), observer.unit.getPosition(), Color.Yellow);
                continue;
            }
            agent.drawCircle(Color.Orange);
            agent.attack(this.target);
        }
    }

    private Position getDropTarget() {
        int dist = 1000000000;
        Position result = Tyr.getStartLocation();
        for (Agent agent : this.units) {
            int newDist = agent.distanceSquared(this.target);
            if (newDist >= dist) continue;
            result = agent.unit.getPosition();
            dist = newDist;
        }
        return result;
    }

    private void safeMoveOut() {
        Agent zealot = null;
        HashSet<Agent> safeDragoons = new HashSet<Agent>();
        for (Agent agent : this.units) {
            if (zealot == null && agent.unit.getType() == UnitType.Protoss_Zealot) {
                zealot = agent;
                continue;
            }
            if (safeDragoons.size() < 5 && agent.unit.getType() == UnitType.Protoss_Dragoon) {
                safeDragoons.add(agent);
                agent.drawCircle(Color.Green);
                continue;
            }
            agent.drawCircle(Color.Blue);
        }
        if (zealot == null && this.units.size() <= 5) {
            return;
        }
        if (zealot == null || zealot.distanceSquared(this.target) <= (waitDistance + this.initialBonusDist + 200) * (waitDistance + this.initialBonusDist + 200)) {
            this.mode = 1;
            return;
        }
        zealot.drawCircle(Color.Orange);
        int dragoonsTooFar = 0;
        for (Agent agent : this.units) {
            if (agent == zealot) continue;
            if (agent.distanceSquared(Tyr.getStartLocation()) <= 1000000) {
                if (agent.unit.getType() == UnitType.Protoss_Zealot) {
                    agent.move(this.target);
                    continue;
                }
                agent.attack(this.target);
                continue;
            }
            int dist = agent.distanceSquared(zealot);
            if (safeDragoons.contains(agent)) {
                if (dist <= 4096) {
                    Tyr.game.drawLineMap(agent.unit.getPosition(), Tyr.getStartLocation(), Color.Red);
                    agent.attack(Tyr.getStartLocation());
                    continue;
                }
                if (dist <= 38416) {
                    Tyr.game.drawLineMap(agent.unit.getPosition(), zealot.unit.getPosition(), Color.Red);
                    agent.attack(zealot.unit.getPosition());
                    continue;
                }
                Tyr.game.drawLineMap(agent.unit.getPosition(), zealot.unit.getPosition(), Color.Blue);
                agent.move(zealot.unit.getPosition());
                ++dragoonsTooFar;
                continue;
            }
            if (agent.unit.getType() == UnitType.Protoss_Zealot) {
                if (dist <= 36864) {
                    Tyr.game.drawLineMap(agent.unit.getPosition(), Tyr.getStartLocation(), Color.Blue);
                    agent.move(Tyr.getStartLocation());
                    continue;
                }
                Tyr.game.drawLineMap(agent.unit.getPosition(), zealot.unit.getPosition(), Color.Blue);
                agent.move(zealot.unit.getPosition());
                continue;
            }
            if (dist <= 36864) {
                Tyr.game.drawLineMap(agent.unit.getPosition(), Tyr.getStartLocation(), Color.Red);
                agent.attack(Tyr.getStartLocation());
                continue;
            }
            if (dist <= 65536) {
                Tyr.game.drawLineMap(agent.unit.getPosition(), zealot.unit.getPosition(), Color.Red);
                agent.attack(zealot.unit.getPosition());
                continue;
            }
            Tyr.game.drawLineMap(agent.unit.getPosition(), zealot.unit.getPosition(), Color.Blue);
            agent.move(zealot.unit.getPosition());
        }
        if (dragoonsTooFar >= 3 && BWTAProxy.getRegion(zealot.unit.getPosition()) != BWTAProxy.getRegion(Tyr.getStartLocation())) {
            zealot.unit.holdPosition();
        } else {
            Tyr.game.drawLineMap(zealot.unit.getPosition(), this.target, Color.Orange);
            zealot.move(this.target);
        }
    }

    private static boolean isOnHighGround(Unit enemy) {
        Region enemyRegion = Tyr.bot.suspectedEnemy.size() == 0 ? null : BWTAProxy.getRegion(Tyr.bot.suspectedEnemy.get(0).getPosition());
        if (enemyRegion == null) {
            Tyr.drawCircle(enemy.getPosition(), Color.Red, 4);
        } else if (BWTAProxy.getRegion(enemy.getPosition()) == enemyRegion) {
            Tyr.drawCircle(enemy.getPosition(), Color.Yellow, 4);
        }
        return enemyRegion != null && BWTAProxy.getRegion(enemy.getPosition()) == enemyRegion;
    }

    private static int getPriority(UnitType type) {
        if (type.isResourceDepot()) {
            return 2;
        }
        if (type.isWorker()) {
            return 1;
        }
        return 3;
    }

    private static class EnemyUnit {
        public Unit enemy;
        public List<Agent> attackingAgents = new ArrayList<Agent>();

        public EnemyUnit(Unit enemy) {
            this.enemy = enemy;
        }

        public boolean isDead() {
            return this.enemy.getHitPoints() <= 0 || this.enemy.getRemoveTimer() != 0 || !this.enemy.exists();
        }
    }
}

