/*
 * Decompiled with CFR 0.152.
 */
package com.tyr.tasks;

import bwapi.Game;
import bwapi.Player;
import bwapi.Position;
import bwapi.UnitType;
import com.tyr.DebugMessages;
import com.tyr.OrderedExpands;
import com.tyr.PositionUtil;
import com.tyr.Tyr;
import com.tyr.agents.Agent;
import com.tyr.tasks.Solution;
import com.tyr.tasks.Task;
import com.tyr.unitgroups.ZealotDropGroup;
import java.util.ArrayList;
import java.util.List;

public class ZealotDropSolution
extends Solution {
    private OrderedExpands cwExpands = new OrderedExpands(true, true, true, true);
    List<ZealotDropGroup> zealotDropGroups = new ArrayList<ZealotDropGroup>();
    private int mode = 0;
    private static final int GATHER = 0;
    private static final int MOVE = 1;
    private static final int DROP = 2;

    public ZealotDropSolution(Task task, int shuttleCount) {
        super(task);
        int i = 0;
        while (i < shuttleCount) {
            ZealotDropGroup group = new ZealotDropGroup();
            group.attackMode = 1;
            this.zealotDropGroups.add(group);
            ++i;
        }
    }

    @Override
    public void onFrame(Game game, Player self, Tyr bot) {
        if (this.mode == 0) {
            this.gather();
        } else if (this.mode == 1) {
            this.move();
        } else {
            this.drop();
        }
        DebugMessages.addMessage("Going for drop. Mode: " + this.mode);
        for (ZealotDropGroup drop : this.zealotDropGroups) {
            drop.cleanup();
            drop.onFrame(game, self, bot);
        }
    }

    private void gather() {
        boolean finished = true;
        for (ZealotDropGroup drop : this.zealotDropGroups) {
            if (!drop.needsShuttle() && drop.getZealots() >= 4) continue;
            finished = false;
            break;
        }
        if (finished) {
            this.mode = 1;
        }
    }

    private void move() {
        if (Tyr.bot.suspectedEnemy.size() == 0) {
            return;
        }
        Position target = this.getTarget();
        if (target == null) {
            return;
        }
        Position enemyMain = Tyr.bot.suspectedEnemy.get(0).getPosition();
        if (PositionUtil.distanceSq(target, enemyMain) <= 10000) {
            this.mode = 2;
        }
        for (ZealotDropGroup drop : this.zealotDropGroups) {
            drop.setTarget(target);
        }
    }

    private void drop() {
        if (Tyr.bot.suspectedEnemy.size() == 0) {
            return;
        }
        Position target = Tyr.bot.suspectedEnemy.get(0).getPosition();
        for (ZealotDropGroup drop : this.zealotDropGroups) {
            drop.setTarget(target);
        }
    }

    public void add(Agent agent) {
        if (agent.unit.getType() == UnitType.Protoss_Shuttle) {
            for (ZealotDropGroup drop : this.zealotDropGroups) {
                if (!drop.needsShuttle()) continue;
                drop.add(agent);
                return;
            }
        } else {
            for (ZealotDropGroup drop : this.zealotDropGroups) {
                if (drop.getZealots() >= 4) continue;
                drop.add(agent);
                return;
            }
        }
        Tyr.bot.hobos.add(agent);
    }

    private Position getTarget() {
        if (!this.cwExpands.tryInitialize()) {
            return null;
        }
        Position current = this.cwExpands.getPos();
        if (current == null) {
            this.cwExpands.next();
        } else {
            for (ZealotDropGroup drop : this.zealotDropGroups) {
                if (drop.getShuttle() == null || drop.getShuttle().distanceSquared(current) > 40000) continue;
                this.cwExpands.next();
                break;
            }
        }
        return this.cwExpands.getPos();
    }

    public int getZealots() {
        int zealots = 0;
        for (ZealotDropGroup drop : this.zealotDropGroups) {
            zealots += drop.getZealots();
        }
        return zealots;
    }

    public int getShuttles() {
        int shuttles = 0;
        for (ZealotDropGroup drop : this.zealotDropGroups) {
            if (drop.needsShuttle()) continue;
            ++shuttles;
        }
        return shuttles;
    }
}

