/*
 * Decompiled with CFR 0.152.
 */
package com.tyr.tasks;

import bwapi.Color;
import bwapi.Game;
import bwapi.Player;
import bwapi.Position;
import com.tyr.BWTAProxy;
import com.tyr.EnemyManager;
import com.tyr.Tyr;
import com.tyr.agents.Agent;
import com.tyr.agents.None;
import com.tyr.buildingplacement.SpaceManager;
import com.tyr.tasks.Solution;
import com.tyr.tasks.Task;
import com.tyr.unitgroups.AttackGroup;
import com.tyr.unitgroups.UnitGroup;
import java.util.ArrayList;

public class WraithDefenseSolution
extends Solution {
    private AttackGroup attackGroup = new AttackGroup(this.attackTarget);
    private Position attackTarget;
    private Position defendTarget;
    private final int ATTACK = 1;
    private final int DEFEND = 2;
    private int phase = 1;

    public WraithDefenseSolution(Task task) {
        super(task);
    }

    @Override
    public void onFrame(Game game, Player self, Tyr bot) {
        if (!BWTAProxy.initialized) {
            return;
        }
        if (this.defendTarget == null) {
            this.defendTarget = SpaceManager.getNatural();
        }
        if (this.attackTarget == null && this.defendTarget != null) {
            ArrayList<Position> expands = EnemyManager.getManager().getOrderedExpands();
            if (expands == null) {
                return;
            }
            int selfPos = EnemyManager.getManager().getSelfPos();
            int defendPos = 0;
            while (defendPos < expands.size()) {
                if (expands.get(defendPos).getDistance(this.defendTarget) < 100.0) break;
                ++defendPos;
            }
            int attackPos = defendPos > selfPos ? (defendPos + 1) % expands.size() : (defendPos - 1 + expands.size()) % expands.size();
            this.attackTarget = expands.get(attackPos);
        }
        if (this.attackTarget == null || this.defendTarget == null) {
            return;
        }
        Tyr.drawCircle(this.phase == 1 ? this.attackTarget : this.defendTarget, this.phase == 1 ? Color.Orange : Color.Green, 64);
        if (this.size() == 0) {
            return;
        }
        this.determinePhase();
        this.attackGroup.cleanup();
        this.attackGroup.setTarget(this.phase == 1 ? this.attackTarget : this.defendTarget);
        this.attackGroup.onFrame(game, self, bot);
    }

    private void determinePhase() {
        if (this.phase == 2) {
            for (Agent agent : this.attackGroup.units) {
                if (agent.distanceSquared(this.defendTarget) <= 40000) continue;
                return;
            }
            this.phase = 1;
        } else {
            for (Agent agent : this.attackGroup.units) {
                if (agent.distanceSquared(this.attackTarget) <= 40000) continue;
                return;
            }
            this.phase = 2;
        }
    }

    public void add(Agent agent) {
        this.attackGroup.add(agent);
    }

    public void done(UnitGroup unitGroup) {
        for (Agent unit : this.attackGroup.units) {
            unitGroup.add(unit);
            unit.order(new None(unit));
        }
        this.attackGroup.units = new ArrayList();
    }

    public void clear() {
        this.attackGroup.clear();
    }

    public int size() {
        return this.attackGroup.units.size();
    }
}

