/*
 * Decompiled with CFR 0.152.
 */
package com.tyr.tasks;

import bwapi.Game;
import bwapi.Player;
import bwapi.Position;
import bwapi.UnitType;
import bwta.BaseLocation;
import com.tyr.EnemyManager;
import com.tyr.EnemyPosition;
import com.tyr.Settings;
import com.tyr.Tyr;
import com.tyr.agents.Agent;
import com.tyr.tasks.MarineHarassSolution;
import com.tyr.tasks.Task;
import java.util.Iterator;

public class PokeTask
extends Task {
    private Position target;
    public static int required = 5;
    public static int defendingUnitsNeeded = 5;
    private static boolean attackSent = false;
    private static boolean done = false;

    @Override
    public boolean isRequired(Game game, Player self, Tyr bot) {
        if (!done && attackSent && this.solution == null) {
            done = true;
        }
        if (this.solution != null) {
            if (((MarineHarassSolution)this.solution).size() == 0) {
                this.solution = null;
            } else {
                return true;
            }
        }
        if (this.solution == null && Settings.getBlockAttack()) {
            return false;
        }
        if (attackSent) {
            return false;
        }
        return bot.homeGroup.units.size() >= defendingUnitsNeeded;
    }

    @Override
    public void solve(Game game, Player self, Tyr bot) {
        boolean newTarget = this.acquireTarget(bot);
        if (newTarget) {
            ((MarineHarassSolution)this.solution).setTarget(this.target);
        }
        if (bot.homeGroup.units.size() >= defendingUnitsNeeded && !attackSent) {
            int i = required - 1;
            while (i >= 0) {
                Agent agent = (Agent)bot.homeGroup.units.get(i);
                if (agent.unit.getType() != UnitType.Terran_Battlecruiser && agent.unit.getType() != UnitType.Terran_Science_Vessel) {
                    ((MarineHarassSolution)this.solution).add(agent);
                    bot.homeGroup.units.remove(i);
                }
                --i;
            }
            attackSent = true;
        }
        super.solve(game, self, bot);
    }

    @Override
    public void findSolution(Game game, Player self, Tyr bot) {
        this.acquireTarget(bot);
        this.solution = new MarineHarassSolution(this, this.target);
    }

    public boolean acquireTarget(Tyr bot) {
        if (this.target != null) {
            for (EnemyPosition p : EnemyManager.getManager().enemyBuildingMemory) {
                if (p.pos.getX() != this.target.getX() || p.pos.getY() != this.target.getY()) continue;
                return false;
            }
        }
        Position newTarget = null;
        Iterator<Object> iterator = EnemyManager.getManager().enemyBuildingMemory.iterator();
        if (iterator.hasNext()) {
            EnemyPosition p = iterator.next();
            newTarget = p.pos;
        }
        if (newTarget == null && (iterator = bot.suspectedEnemy.iterator()).hasNext()) {
            BaseLocation b = (BaseLocation)iterator.next();
            newTarget = b.getPosition();
        }
        if (newTarget == null) {
            return false;
        }
        if (this.target == null) {
            this.target = newTarget;
            return true;
        }
        if (this.target.getX() == newTarget.getX() && this.target.getY() == newTarget.getY()) {
            return false;
        }
        this.target = newTarget;
        return true;
    }

    public static boolean getAttackSent() {
        return attackSent;
    }

    public static boolean getDone() {
        return done;
    }

    public void done() {
        done = true;
        ((MarineHarassSolution)this.solution).done(Tyr.bot.hobos);
    }

    public static void reset() {
        done = false;
        attackSent = false;
    }

    public static void disable() {
        attackSent = false;
    }
}

