/*
 * Decompiled with CFR 0.152.
 */
package com.tyr.tasks;

import bwapi.Color;
import bwapi.Game;
import bwapi.Order;
import bwapi.Player;
import bwapi.Position;
import bwta.BaseLocation;
import com.tyr.DebugMessages;
import com.tyr.EnemyManager;
import com.tyr.EnemyPosition;
import com.tyr.Tyr;
import com.tyr.agents.Agent;
import com.tyr.tasks.Solution;
import com.tyr.tasks.Task;
import com.tyr.unitgroups.HarassBaseGroup;
import com.tyr.unitgroups.MineralWorkers;
import java.util.ArrayList;

public class DropHarassSolution
extends Solution {
    private HarassBaseGroup harassGroup;
    private int currentPos;
    private int currentDir = 1;
    private Position target;
    private ArrayList<Agent> dropships;
    private ArrayList<Agent> units;
    private ArrayList<Position> orderedExpands;
    private int mode = 0;
    private static final int load = 0;
    private static final int moveOut = 1;
    private static final int attack = 2;

    public DropHarassSolution(Task task, ArrayList<Agent> dropships, ArrayList<Agent> units) {
        super(task);
        this.determineTarget();
        this.dropships = dropships;
        this.units = units;
    }

    @Override
    public void onFrame(Game game, Player self, Tyr bot) {
        int i = this.dropships.size() - 1;
        while (i >= 0) {
            if (this.dropships.get(i).isDead()) {
                this.dropships.remove(i);
            }
            --i;
        }
        i = this.units.size() - 1;
        while (i >= 0) {
            if (this.units.get(i).isDead()) {
                this.units.remove(i);
            }
            --i;
        }
        if (this.units.size() == 0) {
            this.mode = 0;
        }
        DebugMessages.addMessage("Dropship mode = " + this.mode);
        if (this.mode == 0) {
            this.load();
        } else if (this.mode == 1) {
            this.moveOut();
        } else if (this.mode == 2) {
            this.attack();
        }
    }

    private void attack() {
        if (this.dropships.size() == 0) {
            this.harassGroup.cleanup();
            this.harassGroup.onFrame(Tyr.game, Tyr.self, Tyr.bot);
            return;
        }
        Agent dropship = this.dropships.get(0);
        boolean isCarrying = false;
        for (Agent agent : this.units) {
            if (!agent.unit.isLoaded()) continue;
            this.dropships.get((int)0).unit.unload(agent.unit);
            isCarrying = true;
            break;
        }
        if (isCarrying && Tyr.bot.spaceManager.map[dropship.unit.getTilePosition().getX()][dropship.unit.getTilePosition().getY()] != 1) {
            dropship.unit.move(this.target);
        }
        if (isCarrying && Tyr.bot.spaceManager.map[dropship.unit.getTilePosition().getX()][dropship.unit.getTilePosition().getY()] == 1 && dropship.unit.getOrder() == Order.Move) {
            dropship.unit.stop();
        }
        if (!isCarrying) {
            dropship.unit.move(Tyr.tileToPosition(Tyr.self.getStartLocation()));
            this.harassGroup.cleanup();
            this.harassGroup.onFrame(Tyr.game, Tyr.self, Tyr.bot);
        }
    }

    private void moveOut() {
        this.determineTarget();
        int dist = 0;
        for (Agent agent : this.dropships) {
            agent.unit.move(this.target);
            Tyr.game.drawLineMap(agent.unit.getX(), agent.unit.getY(), this.target.getX(), this.target.getY(), Color.Blue);
            dist = Math.max(dist, agent.distanceSquared(this.target));
        }
        if (dist > 40000) {
            return;
        }
        for (EnemyPosition enemy : EnemyManager.getManager().enemyBuildingMemory) {
            if (!enemy.type.isResourceDepot() || !(enemy.pos.getDistance(this.target) < 100.0)) continue;
            this.mode = 2;
            this.harassGroup = new HarassBaseGroup(this.target, false);
            this.currentDir *= -1;
            for (Agent agent : this.units) {
                this.harassGroup.add(agent);
            }
        }
    }

    private void load() {
        boolean done = true;
        for (Agent agent : this.units) {
            if (agent.unit.isLoaded()) continue;
            done = false;
            this.dropships.get((int)0).unit.load(agent.unit);
            if (agent.unit.getTargetPosition() != null && !(agent.unit.getTargetPosition().getDistance(this.dropships.get((int)0).unit.getPosition()) >= 100.0)) continue;
            agent.unit.move(this.dropships.get((int)0).unit.getPosition());
        }
        if (done) {
            this.mode = 1;
            return;
        }
    }

    private boolean determineTarget() {
        int i;
        boolean result = false;
        ArrayList<Position> orderedExpands = EnemyManager.getManager().getOrderedExpands();
        if (orderedExpands != null) {
            i = 0;
            while (i < orderedExpands.size()) {
                Position pos = orderedExpands.get(i);
                Tyr.drawCircle(pos, Color.Red, 32);
                Tyr.game.drawTextMap(pos.getX(), pos.getY(), String.valueOf(i));
                ++i;
            }
            if (this.target != null) {
                Tyr.drawCircle(this.target, Color.Red);
            }
        }
        if (this.target == null) {
            if (orderedExpands == null) {
                DebugMessages.addMessage("orderedExpands is null.");
                return false;
            }
            this.currentPos = EnemyManager.getManager().getSelfPos();
            if (this.currentPos != -1) {
                this.target = orderedExpands.get(this.currentPos);
                result = true;
            }
        }
        i = 0;
        while (i < 2 * orderedExpands.size()) {
            boolean isIsland = false;
            for (BaseLocation loc : Tyr.bot.expands) {
                if (!loc.isIsland() || !(loc.getDistance(this.target) <= 128.0)) continue;
                isIsland = true;
            }
            if (!isIsland && this.target != null && !Tyr.game.isVisible(Tyr.positionToTile(this.target))) break;
            boolean closeEnough = false;
            for (MineralWorkers base : Tyr.bot.workForce.mineralWorkers) {
                if (base.resourceDepot == null || base.resourceDepot.getDistance(this.target) >= 100) continue;
                closeEnough = true;
            }
            if (!isIsland && !closeEnough && this.dropships != null) {
                for (Agent agent : this.dropships) {
                    if (agent == null || agent.distanceSquared(this.target) >= 16384) continue;
                    closeEnough = true;
                }
            }
            if (!isIsland && !closeEnough) break;
            this.nextTarget();
            result = true;
            ++i;
        }
        return result;
    }

    private void nextTarget() {
        if (this.orderedExpands == null) {
            this.orderedExpands = (ArrayList)EnemyManager.getManager().getOrderedExpands().clone();
            if (this.orderedExpands == null) {
                return;
            }
            if (Tyr.bot.suspectedEnemy.size() == 1) {
                this.orderedExpands.add(Tyr.bot.suspectedEnemy.get(0).getPosition());
            }
        }
        this.currentPos += this.currentDir;
        if (this.currentPos >= this.orderedExpands.size() || this.currentPos < 0) {
            this.currentDir *= -1;
            this.currentPos += 2 * this.currentDir;
        }
        this.target = this.orderedExpands.get(this.currentPos);
    }

    public boolean done() {
        return this.units.size() == 0 || this.mode != 2 && this.dropships.size() == 0;
    }

    public void clear() {
        for (Agent dropship : this.dropships) {
            Tyr.bot.hobos.add(dropship);
        }
        for (Agent agent : this.units) {
            Tyr.bot.hobos.add(agent);
        }
    }
}

