/*
 * Decompiled with CFR 0.152.
 */
package com.tyr.tasks;

import bwapi.Game;
import bwapi.Player;
import bwapi.Unit;
import bwapi.WeaponType;
import com.tyr.Tyr;
import com.tyr.agents.Agent;
import com.tyr.tasks.DestroyBuildingsSolution;
import com.tyr.tasks.Task;
import java.util.List;

public class DestroyBuildingsTask
extends Task {
    private List<Unit> targets;

    public DestroyBuildingsTask(List<Unit> targets) {
        this.targets = targets;
    }

    @Override
    public boolean isRequired(Game game, Player self, Tyr bot) {
        return this.targets != null && this.targets.size() > 0;
    }

    @Override
    public void solve(Game game, Player self, Tyr bot) {
        if (this.targets == null) {
            return;
        }
        int i = this.targets.size() - 1;
        while (i >= 0) {
            if (this.targets.get(i) == null || this.targets.get(i).getRemoveTimer() > 0 || this.targets.get(i).getHitPoints() <= 0 || !this.targets.get(i).exists()) {
                this.targets.remove(i);
            }
            --i;
        }
        if (this.targets.size() == 0) {
            ((DestroyBuildingsSolution)this.solution).done(bot.hobos);
        } else {
            i = bot.homeGroup.units.size() - 1;
            while (i >= 0) {
                Agent agent = (Agent)bot.homeGroup.units.get(i);
                if (agent.unit.getType().groundWeapon() != WeaponType.None) {
                    ((DestroyBuildingsSolution)this.solution).add(agent);
                    bot.homeGroup.units.remove(i);
                }
                --i;
            }
        }
        if (!this.targets.isEmpty()) {
            ((DestroyBuildingsSolution)this.solution).setTarget(this.targets.get(this.targets.size() - 1));
        }
        super.solve(game, self, bot);
    }

    @Override
    public void findSolution(Game game, Player self, Tyr bot) {
        this.solution = new DestroyBuildingsSolution(this);
    }
}

