/*
 * Decompiled with CFR 0.152.
 */
package com.tyr.tasks;

import bwapi.Color;
import bwapi.Game;
import bwapi.Player;
import bwapi.Position;
import bwapi.TechType;
import bwapi.Unit;
import bwapi.UnitType;
import bwapi.WeaponType;
import bwta.Region;
import com.tyr.BWTAProxy;
import com.tyr.DebugMessages;
import com.tyr.EnemyManager;
import com.tyr.EnemyPosition;
import com.tyr.Force;
import com.tyr.ForceTracker;
import com.tyr.Tyr;
import com.tyr.agents.Agent;
import com.tyr.agents.Attack;
import com.tyr.agents.FocusTarget;
import com.tyr.agents.None;
import com.tyr.buildingplacement.SpaceManager;
import com.tyr.tasks.SolutionItem;
import com.tyr.tasks.Task;
import com.tyr.unitgroups.AttackGroup;
import com.tyr.unitgroups.UnitGroup;
import java.util.ArrayList;

public class AttackRegroupSolution
extends SolutionItem
implements Force {
    private AttackGroup attackGroup;
    private Position attackTarget;
    private Position regroupTarget;
    private EnemyPosition focusTarget;
    private int regroupTime;
    private final int ATTACK = 1;
    private final int REGROUP = 2;
    private final int FOCUS = 3;
    private int phase = 1;
    private Position averagePos;
    public static boolean focusWorkers = true;

    public AttackRegroupSolution(Task task, Position attackTarget) {
        super(task);
        ForceTracker.register(this);
        this.attackTarget = attackTarget;
        this.attackGroup = new AttackGroup(attackTarget);
    }

    public void setTarget(Position attackTarget) {
        this.attackTarget = attackTarget;
    }

    @Override
    public void onFrame(Game game, Player self, Tyr bot) {
        this.determinePhase();
        Tyr.drawCircle(this.phase == 1 ? this.attackTarget : this.regroupTarget, this.phase == 1 ? Color.Orange : Color.Green, 64);
        this.attackGroup.cleanup();
        if (this.phase != 3) {
            int count = 0;
            for (Unit unit : EnemyManager.getEnemyUnits()) {
                if (!unit.getType().isBuilding() && unit.getType().groundWeapon() != WeaponType.None && !unit.isCloaked() && !unit.getType().isWorker() && unit.getDistance(this.averagePos) < 600 && ++count >= 10) break;
            }
            if (count >= 10) {
                for (Agent agent : this.attackGroup.units) {
                    if (agent.unit.getType() != UnitType.Terran_Marine || agent.unit.getHitPoints() <= agent.unit.getType().maxHitPoints() - 10 || agent.unit.isStimmed() || !self.hasResearched(TechType.Stim_Packs)) continue;
                    agent.unit.useTech(TechType.Stim_Packs);
                }
            }
            int prio = 100;
            int distance = Integer.MAX_VALUE;
            Unit killTarget = null;
            for (Unit unit : EnemyManager.getEnemyUnits()) {
                int newDistance;
                if (unit.getType() == UnitType.Zerg_Larva || unit.isMorphing() || !unit.isVisible()) continue;
                int newPrio = 100;
                newPrio = unit.getType().groundWeapon() == WeaponType.None && unit.getType() != UnitType.Terran_Bunker ? 10 : (unit.getType().isWorker() ? 9 : 8);
                if (newPrio > prio || (newDistance = unit.getDistance(this.getCenter())) >= 800 || newPrio > 8 && newDistance >= 500 || newPrio >= prio && newDistance >= distance) continue;
                distance = newDistance;
                prio = newPrio;
                killTarget = unit;
            }
            if (prio == 8 || !focusWorkers) {
                this.attackGroup.setKillTarget(null);
            } else {
                this.attackGroup.setKillTarget(killTarget);
            }
            this.attackGroup.setTarget(this.phase == 1 ? this.attackTarget : this.regroupTarget);
            this.attackGroup.onFrame(game, self, bot);
        }
        boolean attackerRemaining = false;
        for (Agent agent : this.attackGroup.units) {
            if (agent.unit.getType() == UnitType.Terran_Medic) continue;
            attackerRemaining = true;
            break;
        }
        if (!attackerRemaining) {
            this.attackGroup.clear();
        }
    }

    private void determinePhase() {
        block25: {
            double armySpread;
            block24: {
                if (this.phase == 3) {
                    if (Tyr.game.isVisible(Tyr.positionToTile(this.focusTarget.pos))) {
                        boolean found = false;
                        for (Unit unit : EnemyManager.getEnemyUnits()) {
                            if (unit.getType() != this.focusTarget.type || Math.abs(unit.getX() - this.focusTarget.pos.getX()) > 10 || Math.abs(unit.getY() - this.focusTarget.pos.getY()) > 10) continue;
                            found = true;
                            break;
                        }
                        if (!found) {
                            for (Agent agent : this.attackGroup.units) {
                                agent.order(new None(agent));
                                agent.unit.stop();
                            }
                            this.phase = 1;
                        }
                    }
                    if (this.phase == 3) {
                        DebugMessages.addMessage("Focus firing " + this.size());
                        return;
                    }
                }
                this.getAveragePos();
                Tyr.drawCircle(this.averagePos, Color.Orange, 8);
                armySpread = 0.0;
                for (Agent agent : this.attackGroup.units) {
                    armySpread += (double)agent.distanceSquared(this.averagePos);
                }
                DebugMessages.addMessage(String.valueOf(this.phase == 1 ? "Attacking" : "Regrouping") + " " + this.size() + " " + ((int)(armySpread /= (double)this.attackGroup.units.size() + (double)this.attackGroup.units.size() / 60.0) + 500) / 1000 * 1000);
                for (EnemyPosition enemyPos : EnemyManager.getManager().enemyDefensiveStructures) {
                    boolean inRange = false;
                    boolean allInRange = true;
                    for (Agent agent : this.attackGroup.units) {
                        if (agent.distanceSquared(enemyPos.pos) <= 160000) {
                            inRange = true;
                        } else {
                            allInRange = false;
                        }
                        if (inRange && !allInRange) break;
                    }
                    if (!inRange) continue;
                    if (allInRange) {
                        this.focusTarget = enemyPos;
                        this.phase = 3;
                        for (Agent agent : this.attackGroup.units) {
                            if (agent.unit.getType() == UnitType.Terran_Siege_Tank_Siege_Mode || agent.unit.getType() == UnitType.Terran_Siege_Tank_Tank_Mode) {
                                agent.order(new Attack(agent, enemyPos.pos));
                                continue;
                            }
                            agent.order(new FocusTarget(agent, enemyPos));
                        }
                        break;
                    }
                    if (!(armySpread >= 40000.0)) continue;
                    if (this.phase != 2) {
                        this.phase = 2;
                        this.regroupTime = Tyr.game.getFrameCount();
                    }
                    double distanceSq = 2.0E9;
                    Position baseCenter = BWTAProxy.getRegion(Tyr.self.getStartLocation()).getCenter();
                    Position mainExit = SpaceManager.getMainExit();
                    for (Agent agent : this.attackGroup.units) {
                        Region r;
                        Position containingRegionCenter;
                        double myDistSq;
                        if (agent.unit.getType() == UnitType.Terran_Medic || (myDistSq = (containingRegionCenter = (r = BWTAProxy.getRegion(agent.unit.getPosition())) != null ? r.getCenter() : agent.unit.getPosition()).getX() == baseCenter.getX() && containingRegionCenter.getY() == baseCenter.getY() ? (double)(agent.distanceSquared(mainExit) + Tyr.game.mapHeight() * 32 * Tyr.game.mapHeight() * 32 + Tyr.game.mapWidth() * 32 * Tyr.game.mapWidth() * 32) : (double)agent.distanceSquared(enemyPos.pos)) < 160000.0 || !(myDistSq < distanceSq)) continue;
                        distanceSq = myDistSq;
                        this.regroupTarget = agent.unit.getPosition();
                    }
                }
                if (this.phase != 1) break block24;
                if (!(armySpread >= 75000.0)) break block25;
                this.phase = 2;
                this.regroupTime = Tyr.game.getFrameCount();
                double distanceSq = 2.0E9;
                Position baseCenter = BWTAProxy.getRegion(Tyr.self.getStartLocation()).getCenter();
                Position mainExit = SpaceManager.getMainExit();
                for (Agent agent : this.attackGroup.units) {
                    Region r;
                    Position containingRegionCenter;
                    double myDistSq;
                    if (agent.unit.getType() == UnitType.Terran_Medic || (myDistSq = (containingRegionCenter = (r = BWTAProxy.getRegion(agent.unit.getPosition())) != null ? r.getCenter() : agent.unit.getPosition()).getX() == baseCenter.getX() && containingRegionCenter.getY() == baseCenter.getY() ? (double)(agent.distanceSquared(mainExit) + Tyr.game.mapHeight() * 32 * Tyr.game.mapHeight() * 32 + Tyr.game.mapWidth() * 32 * Tyr.game.mapWidth() * 32) : (double)agent.distanceSquared(this.attackTarget)) < 160000.0 || !(myDistSq < distanceSq)) continue;
                    distanceSq = myDistSq;
                    this.regroupTarget = agent.unit.getPosition();
                }
                break block25;
            }
            if (this.phase == 2) {
                int elapsedTime = Tyr.game.getFrameCount() - this.regroupTime;
                int min = 20000;
                if (elapsedTime > 200) {
                    min += (elapsedTime - 200) * 55;
                }
                if (armySpread <= (double)min) {
                    this.phase = 1;
                } else if (elapsedTime >= 1200) {
                    this.phase = 1;
                    int i = this.attackGroup.units.size() - 1;
                    while (i >= 0) {
                        if (((Agent)this.attackGroup.units.get(i)).distanceSquared(this.averagePos) >= 262144) {
                            Agent agent = (Agent)this.attackGroup.units.get(i);
                            agent.order(new None(agent));
                            agent.unit.stop();
                            Tyr.bot.hobos.add(agent);
                            this.attackGroup.units.remove(i);
                        }
                        --i;
                    }
                }
            }
        }
    }

    @Override
    public void add(Agent agent) {
        this.attackGroup.add(agent);
    }

    public void done(UnitGroup unitGroup) {
        for (Agent unit : this.attackGroup.units) {
            unitGroup.add(unit);
            unit.order(new None(unit));
        }
        this.attackGroup.units = new ArrayList();
    }

    public void addToScanner() {
        for (Agent agent : this.attackGroup.units) {
            Tyr.bot.scanner.add(agent);
        }
        this.attackGroup.units = new ArrayList();
    }

    @Override
    public void clear() {
        this.attackGroup.clear();
    }

    @Override
    public int size() {
        return this.attackGroup.units.size();
    }

    private void getAveragePos() {
        double averageX = 0.0;
        double averageY = 0.0;
        for (Agent agent : this.attackGroup.units) {
            Position pos = agent.unit.getPosition();
            averageX += (double)pos.getX();
            averageY += (double)pos.getY();
        }
        this.averagePos = new Position((int)(averageX /= (double)this.attackGroup.units.size()), (int)(averageY /= (double)this.attackGroup.units.size()));
    }

    @Override
    public Position getCenter() {
        if (this.averagePos == null) {
            this.getAveragePos();
        }
        return this.averagePos;
    }

    @Override
    public boolean done() {
        return this.size() == 0;
    }

    @Override
    public boolean disabled() {
        return false;
    }
}

