/*
 * Decompiled with CFR 0.152.
 */
package com.tyr.builds;

import bwapi.Game;
import bwapi.Player;
import bwapi.TechType;
import bwapi.Unit;
import bwapi.UnitType;
import bwapi.UpgradeType;
import com.tyr.DebugMessages;
import com.tyr.EnemyManager;
import com.tyr.Settings;
import com.tyr.StopWatch;
import com.tyr.Tyr;
import com.tyr.UnitTracker;
import com.tyr.agents.Agent;
import com.tyr.agents.BunkerAgent;
import com.tyr.buildingplacement.DefensiveStructures;
import com.tyr.builds.CompositeBuildOrder;
import com.tyr.builds.ExpandPart;
import com.tyr.builds.GenericPartFactory;
import com.tyr.builds.SupplyDepotPart;
import com.tyr.builds.WorkerScoutPart;
import com.tyr.requirements.Requirement;
import com.tyr.requirements.TechRequirement;
import com.tyr.requirements.UnitRequirement;
import com.tyr.tasks.AssignScience;
import com.tyr.tasks.AttackTask;
import com.tyr.tasks.CorsairHarassTask;
import com.tyr.tasks.ScoutExpansionsTask;
import com.tyr.unitgroups.AttackGroup;
import com.tyr.unitgroups.HomeGroup;
import com.tyr.unitgroups.MineralWorkers;

public class TvZFE
extends CompositeBuildOrder {
    private int minimumArmySize = 10;
    private int maximumArmySize = 50;
    private boolean lingRush = false;
    private boolean turtle = false;
    private boolean lurkersDetected = false;
    private boolean massLurkers = false;
    private boolean techRush = false;
    private int mostOpponentLings;
    boolean firstAttackDone = false;
    private ScoutExpansionsTask scoutExpansionsTask = null;

    @Override
    public void initialize(Game game, Player self, Tyr bot) {
        Settings.setRequiredSize(this.minimumArmySize);
        Settings.setMaximumSize(this.maximumArmySize);
        Settings.setLargeInvasionDist(720);
        Settings.setSmallInvasionDist(480);
        Settings.setWorkersPerGas(1);
        AttackTask.useAntiLurker = true;
        AttackTask.prioritizeExpands = true;
        AttackGroup.fearLurkers = true;
        HomeGroup.keepTanksSieged = true;
        this.add(new SupplyDepotPart());
        this.add(new WorkerScoutPart(1000).doubleScout());
        this.add(new ExpandPart(true));
        ExpandPart.maximumCcs = 2;
        this.add(new GenericPartFactory(UnitType.Terran_Barracks).setMax(1).setCost(100, 0).create());
        this.add(new GenericPartFactory(UnitType.Terran_Barracks).setMax(2).setCost(100, 0).add(new UnitRequirement(UnitType.Terran_Command_Center, 2)).create());
        this.add(new GenericPartFactory(UnitType.Terran_Barracks).setMax(2).setCost(100, 0).add(new Requirement(){

            @Override
            public boolean met() {
                return TvZFE.this.lingRush && TvZFE.count(BUNKER) > 0;
            }
        }).create());
        this.add(new GenericPartFactory(UnitType.Terran_Barracks).setMax(3).add(new Requirement(){

            @Override
            public boolean met() {
                return TvZFE.this.turtle;
            }
        }).create());
        this.add(new GenericPartFactory(BARRACKS).setMax(3).add(new UnitRequirement(ACADEMY)).add(new UnitRequirement(UnitType.Terran_Command_Center, 2)).create());
        this.add(new GenericPartFactory(UnitType.Terran_Barracks).setMax(5).setCost(200, 0).add(new UnitRequirement(ENGINEERING_BAY)).add(new UnitRequirement(ACADEMY)).add(new UnitRequirement(UnitType.Terran_Command_Center, 2)).create());
        this.add(new GenericPartFactory(UnitType.Terran_Barracks).setMax(8).setCost(400, 0).add(new UnitRequirement(FACTORY)).add(new UnitRequirement(STARPORT)).add(new UnitRequirement(UnitType.Terran_Command_Center, 2)).create());
        this.add(new GenericPartFactory(UnitType.Terran_Barracks).setMax(8).setCost(250, 0).add(new UnitRequirement(FACTORY)).add(new UnitRequirement(SCIENCE_VESSEL)).add(new UnitRequirement(UnitType.Terran_Command_Center, 2)).create());
        this.add(new GenericPartFactory(UnitType.Terran_Factory).add(new UnitRequirement(BARRACKS, 2)).add(new UnitRequirement(ENGINEERING_BAY)).add(new UnitRequirement(MISSILE_TURRET)).add(new UnitRequirement(COMSAT)).add(new Requirement(){

            @Override
            public boolean met() {
                return TvZFE.this.lurkersDetected;
            }
        }).create());
        this.add(new GenericPartFactory(UnitType.Terran_Factory).setMax(2).add(new UnitRequirement(BARRACKS, 5)).add(new UnitRequirement(SCIENCE_VESSEL)).add(new UnitRequirement(UnitType.Terran_Command_Center, 2)).add(new Requirement(){

            @Override
            public boolean met() {
                return TvZFE.this.massLurkers;
            }
        }).create());
        this.add(new GenericPartFactory(UnitType.Terran_Factory).add(new UnitRequirement(BARRACKS, 5)).add(new UnitRequirement(UnitType.Terran_Command_Center, 2)).create());
        this.add(new GenericPartFactory(UnitType.Terran_Starport).add(new UnitRequirement(UnitType.Terran_Factory, 1, true)).add(new TechRequirement(TechType.Tank_Siege_Mode, true)).create());
        this.add(new GenericPartFactory(ACADEMY).add(new UnitRequirement(BARRACKS, 2)).add(new UnitRequirement(REFINERY)).create());
        this.add(new GenericPartFactory(UnitType.Terran_Engineering_Bay).add(new UnitRequirement(ACADEMY)).create());
        this.add(new GenericPartFactory(UnitType.Terran_Engineering_Bay).add(new UnitRequirement(BARRACKS, 2)).add(new Requirement(){

            @Override
            public boolean met() {
                return TvZFE.this.lurkersDetected;
            }
        }).create());
        this.add(new GenericPartFactory(UnitType.Terran_Science_Facility).add(new UnitRequirement(UnitType.Terran_Starport, 1, true)).create());
        bot.taskManager.potentialTasks.add(new AssignScience());
        bot.taskManager.potentialTasks.add(new CorsairHarassTask());
        Tyr.bot.groups.remove(Tyr.bot.swarm);
        super.initialize(game, self, bot);
    }

    @Override
    public void onFrame(Game game, Player self, Tyr bot) {
        int count;
        boolean buildDetectionInMain;
        DebugMessages.addMessage("TvZ build.");
        DebugMessages.addMessage("Most enemy zerglings: " + this.mostOpponentLings);
        StopWatch watch = new StopWatch();
        watch.start();
        super.onFrame(game, self, bot);
        long time = watch.time();
        if (time > 55L) {
            DebugMessages.addMessage("Bio super time: " + time);
        }
        if (EnemyManager.getManager().getEnemyTypes().contains(ZERGLING) && TvZFE.completed(CC) < 2 && TvZFE.completed(MARINE) < 5) {
            this.lingRush = true;
        }
        if (EnemyManager.getManager().getEnemyTypes().contains(POOL) && game.getFrameCount() <= 3500) {
            this.lingRush = true;
        }
        if (this.lingRush && game.getFrameCount() <= 4500 && EnemyManager.getManager().getEnemyTypes().contains(EXTRACTOR)) {
            this.techRush = true;
        }
        if (TvZFE.completed(BUNKER) > 0 && TvZFE.completed(MISSILE_TURRET) > 0 && TvZFE.completed(COMSAT) > 0) {
            this.techRush = false;
        }
        this.mostOpponentLings = Math.max(this.mostOpponentLings, EnemyManager.getManager().getAllCount(ZERGLING));
        if (this.mostOpponentLings >= 12 && !this.firstAttackDone && Settings.getRequiredSize() == 10) {
            this.firstAttackDone = true;
            Settings.setRequiredSize(25);
        }
        if (ExpandPart.maximumCcs <= 2 && UnitTracker.getCcCount() >= 2 && UnitTracker.countTanks() > 0 && TvZFE.completed(SCIENCE_FACILITY) > 0 && TvZFE.completed(SCIENCE_VESSEL) > 0) {
            int patchCount = 0;
            for (MineralWorkers base : bot.workForce.mineralWorkers) {
                patchCount += base.minerals.size();
            }
            if (patchCount < 14) {
                ExpandPart.maximumCcs = 100;
            }
        } else if (ExpandPart.maximumCcs <= 2) {
            ExpandPart.maximumCcs = this.techRush || this.turtle && TvZFE.count(MARINE) < 12 || this.lurkersDetected && TvZFE.completedTanks() == 0 || this.lurkersPresent() ? 1 : 2;
        }
        if (this.scoutExpansionsTask == null && this.firstAttackDone && AttackTask.getAttackSent()) {
            this.scoutExpansionsTask = new ScoutExpansionsTask();
            bot.taskManager.potentialTasks.add(this.scoutExpansionsTask);
        }
        boolean disableBunkers = UnitTracker.getCcCount() > 1 && TvZFE.count(MARINE) >= 8 || self.completedUnitCount(UnitType.Terran_Marine) + self.completedUnitCount(UnitType.Terran_Medic) >= 10 && !AttackTask.getAttackSent();
        DebugMessages.addMessage("Disabling bunkers: " + disableBunkers);
        for (Unit structure : bot.defensiveStructures.get((int)0).defences) {
            if (structure.getType() != UnitType.Terran_Bunker) continue;
            BunkerAgent bunker = (BunkerAgent)Tyr.bot.agentMap.get(structure.getID());
            bunker.disabled = disableBunkers;
        }
        if (!this.firstAttackDone && !EnemyManager.getManager().enemyDefensiveStructures.isEmpty()) {
            this.firstAttackDone = true;
            Settings.setRequiredSize(25);
            AttackTask.setAttackSent(false);
            AttackTask.cancelAttacks();
        }
        if (EnemyManager.getManager().getEnemyTypes().contains(LURKER) || EnemyManager.getManager().getEnemyTypes().contains(HYDRA) || EnemyManager.getManager().getEnemyTypes().contains(HYDRA_DEN) || EnemyManager.getManager().getEnemyTypes().contains(LURKER_EGG)) {
            this.lurkersDetected = true;
        }
        if (EnemyManager.getManager().getAllCount(LURKER) + EnemyManager.getManager().getAllCount(LURKER_EGG) >= 8) {
            this.massLurkers = true;
        }
        if (this.lingRush && TvZFE.count(MARINE) < 10) {
            DebugMessages.addMessage("Ling rush detected.");
        }
        if (this.lingRush && TvZFE.completed(CC) > 1 && TvZFE.completed(MARINE) < 5) {
            for (Unit unit : self.getUnits()) {
                if (!unit.isBeingConstructed() || !unit.getType().isResourceDepot()) continue;
                unit.cancelConstruction();
                break;
            }
        }
        if (UnitTracker.count(FACTORY) > 0 && bot.getAvailableGas() < 400) {
            Settings.setWorkersPerGas(3);
        } else if (UnitTracker.count(UnitType.Terran_Factory) > 0 || UnitTracker.count(UnitType.Terran_Engineering_Bay) > 0) {
            Settings.setWorkersPerGas(2);
        }
        time = watch.time();
        if (time > 55L) {
            DebugMessages.addMessage("Bio tier 1 time: " + time);
        }
        if (bot.getAvailableMinerals() >= 100 && UnitTracker.getGeyserCount() > 0 && UnitTracker.count(UnitType.Terran_Command_Center) >= 2 && UnitTracker.count(UnitType.Terran_Barracks) >= 2 && UnitTracker.count(UnitType.Terran_Marine) >= 6 && (UnitTracker.count(UnitType.Terran_Refinery) == 0 || UnitTracker.count(UnitType.Terran_Factory) > 0 || TvZFE.minerals() >= 500)) {
            bot.spaceManager.build(UnitType.Terran_Refinery);
        }
        if (bot.getAvailableMinerals() >= 100 && UnitTracker.getGeyserCount() > 0 && UnitTracker.count(UnitType.Terran_Barracks) >= 2 && TvZFE.count(BUNKER) > 0 && TvZFE.count(MARINE) >= 3 && this.techRush && UnitTracker.count(UnitType.Terran_Refinery) == 0) {
            bot.spaceManager.build(UnitType.Terran_Refinery);
        }
        if ((time = watch.time()) > 55L) {
            DebugMessages.addMessage("Bio refinery: " + time + " geyserCount: " + UnitTracker.getGeyserCount());
        }
        boolean bl = buildDetectionInMain = (this.lurkersDetected || this.techRush) && TvZFE.completed(MISSILE_TURRET) == 0;
        if (bot.getAvailableMinerals() >= 50 && TvZFE.completed(BARRACKS) >= 1 && TvZFE.count(MARINE) >= 1 && TvZFE.count(BUNKER) < 2) {
            for (DefensiveStructures structures : bot.defensiveStructures) {
                count = structures.getUnitCount(UnitType.Terran_Bunker);
                if (count != 0 || structures.defendedPosition.getDistance(Tyr.tileToPosition(self.getStartLocation())) <= 200.0) continue;
                bot.spaceManager.buildDefensive(UnitType.Terran_Bunker, structures);
                break;
            }
        }
        if (bot.getAvailableMinerals() >= 50 && self.completedUnitCount(UnitType.Terran_Barracks) >= 1 && UnitTracker.count(UnitType.Terran_Bunker) < 1 && (this.lingRush || buildDetectionInMain) && bot.defensiveStructures.size() > 0) {
            bot.spaceManager.buildDefensive(UnitType.Terran_Bunker, bot.defensiveStructures.get(0));
        }
        if ((time = watch.time()) > 55L) {
            DebugMessages.addMessage("Bio bunker time: " + time);
        }
        if (bot.defensiveStructures.size() == 1 && this.techRush && TvZFE.completed(ENGINEERING_BAY) >= 1 && TvZFE.minerals() >= 75 && TvZFE.count(BUNKER) > 0 && TvZFE.count(MISSILE_TURRET) == 0) {
            bot.spaceManager.buildDefensive(MISSILE_TURRET, bot.defensiveStructures.get(0));
        }
        if (TvZFE.completed(ENGINEERING_BAY) >= 1 && TvZFE.minerals() >= 75) {
            for (DefensiveStructures structures : bot.defensiveStructures) {
                if (!this.turtle && !this.lurkersDetected && structures.defendedPosition.getDistance(Tyr.tileToPosition(self.getStartLocation())) <= 200.0 || (count = structures.getUnitCount(MISSILE_TURRET)) >= 1 || structures.defences.size() <= 0) continue;
                bot.spaceManager.buildDefensive(MISSILE_TURRET, structures);
                break;
            }
        }
        if ((time = watch.time()) > 55L) {
            DebugMessages.addMessage("Bio turrets time: " + time);
        }
    }

    private boolean lurkersPresent() {
        for (Unit enemy : EnemyManager.getEnemyUnits()) {
            if (enemy.getType() != LURKER) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean overrideStructureOrder(Game game, Player self, Tyr bot, Agent agent) {
        if (super.overrideStructureOrder(game, self, bot, agent)) {
            return true;
        }
        if (agent.unit.getType() == UnitType.Terran_Barracks) {
            if (UnitTracker.count(UnitType.Terran_Command_Center) < 2 && bot.getAvailableMinerals() < 400 && !this.lingRush && TvZFE.count(MARINE) > 0) {
                return true;
            }
            if (this.lingRush && TvZFE.count(CC) < 2) {
                if ((TvZFE.count(MARINE) + TvZFE.count(MEDIC) < 9 || this.turtle || this.mostOpponentLings > 6 || this.techRush) && (TvZFE.count(MARINE) + TvZFE.count(MEDIC) < 13 || this.turtle) && TvZFE.count(MARINE) + TvZFE.count(MEDIC) < 15 && !agent.unit.isTraining() && TvZFE.minerals() >= 50) {
                    if (TvZFE.completed(ACADEMY) > 0 && TvZFE.gas() >= 25 && TvZFE.count(MEDIC) * 4 < TvZFE.count(MARINE) && TvZFE.count(MARINE) >= 6) {
                        agent.unit.train(MEDIC);
                    } else {
                        agent.unit.train(MARINE);
                    }
                }
                return true;
            }
            if ((UnitTracker.count(UnitType.Terran_Siege_Tank_Siege_Mode) + UnitTracker.count(UnitType.Terran_Siege_Tank_Siege_Mode) == 0 || !self.isResearching(TechType.Tank_Siege_Mode) && !self.hasResearched(TechType.Tank_Siege_Mode)) && bot.getAvailableMinerals() < 200 && UnitTracker.count(UnitType.Terran_Marine) >= 5 && this.lurkersDetected) {
                return true;
            }
            if (!agent.unit.isTraining() && Tyr.bot.getAvailableGas() >= 25 && Tyr.bot.getAvailableMinerals() >= 50 && self.completedUnitCount(UnitType.Terran_Academy) > 0 && UnitTracker.count(UnitType.Terran_Medic) * 4 < UnitTracker.count(UnitType.Terran_Marine) - 4 * UnitTracker.count(UnitType.Terran_Bunker)) {
                agent.unit.train(UnitType.Terran_Medic);
                return true;
            }
        } else {
            if (agent.unit.getType() == UnitType.Terran_Academy) {
                if (bot.getAvailableGas() >= 150 && bot.getAvailableMinerals() >= 150 && !agent.unit.isResearching() && self.getUpgradeLevel(UpgradeType.U_238_Shells) == 0) {
                    agent.unit.upgrade(UpgradeType.U_238_Shells);
                } else if (bot.getAvailableMinerals() >= 100 && bot.getAvailableGas() >= 100 && !agent.unit.isResearching() && !self.hasResearched(TechType.Stim_Packs)) {
                    agent.unit.research(TechType.Stim_Packs);
                }
                return true;
            }
            if (agent.unit.getType() == UnitType.Terran_Starport) {
                if (UnitTracker.count(UnitType.Terran_Command_Center) < 2 && bot.getAvailableMinerals() < 400) {
                    return true;
                }
                if (UnitTracker.count(UnitType.Terran_Science_Vessel) >= 2 && UnitTracker.countTanks() >= 4 && UnitTracker.count(UnitType.Terran_Armory) == 0) {
                    return true;
                }
                if (agent.unit.getAddon() != null) {
                    if (!agent.unit.isTraining() && UnitTracker.count(UnitType.Terran_Science_Facility) > 0 && bot.getAvailableMinerals() >= 100 && bot.getAvailableGas() >= 225) {
                        agent.unit.train(UnitType.Terran_Science_Vessel);
                    }
                    return true;
                }
                if (UnitTracker.count(UnitType.Terran_Control_Tower) == 0) {
                    if (UnitTracker.count(UnitType.Terran_Science_Facility) > 0 && bot.getAvailableMinerals() >= 50 && bot.getAvailableGas() >= 50) {
                        agent.unit.buildAddon(UnitType.Terran_Control_Tower);
                    }
                    return true;
                }
                return UnitTracker.count(UnitType.Terran_Science_Vessel) == 0;
            }
            if (agent.unit.getType() == UnitType.Terran_Factory) {
                if (UnitTracker.count(UnitType.Terran_Command_Center) < 2 && bot.getAvailableMinerals() < 400) {
                    return true;
                }
                if (UnitTracker.count(UnitType.Terran_Siege_Tank_Siege_Mode) + UnitTracker.count(UnitType.Terran_Siege_Tank_Tank_Mode) < 2) {
                    return false;
                }
                if (!self.hasResearched(TechType.Irradiate) && bot.getAvailableGas() < 350 && UnitTracker.countTanks() >= 4) {
                    return true;
                }
                return UnitTracker.countTanks() >= (this.massLurkers ? 12 : 4);
            }
            if (agent.unit.getType() == UnitType.Terran_Science_Facility) {
                if (!self.hasResearched(TechType.Irradiate) && bot.getAvailableMinerals() >= 200 && bot.getAvailableGas() >= 200 && UnitTracker.count(UnitType.Terran_Science_Vessel) > 0) {
                    agent.unit.research(TechType.Irradiate);
                    return true;
                }
                return false;
            }
            if (agent.unit.getType() == UnitType.Terran_Engineering_Bay) {
                return false;
            }
        }
        return false;
    }
}

