/*
 * Decompiled with CFR 0.152.
 */
package com.tyr.builds;

import bwapi.Game;
import bwapi.Player;
import bwapi.Race;
import bwapi.TechType;
import bwapi.Unit;
import bwapi.UnitType;
import bwapi.UpgradeType;
import com.tyr.DebugMessages;
import com.tyr.EnemyManager;
import com.tyr.Settings;
import com.tyr.StopWatch;
import com.tyr.Tyr;
import com.tyr.UnitTracker;
import com.tyr.agents.Agent;
import com.tyr.buildingplacement.DefensiveStructures;
import com.tyr.builds.CompositeBuildOrder;
import com.tyr.builds.ExpandPart;
import com.tyr.builds.SupplyDepotPart;
import com.tyr.builds.WorkerScoutPart;
import com.tyr.tasks.ConstantPushTask;
import com.tyr.tasks.VultureHarassTask;
import com.tyr.unitgroups.AttackGroup;

public class TAntiZealot
extends CompositeBuildOrder {
    public boolean commit;
    public boolean buildBunker = true;
    public boolean expand = false;
    public Race enemyRace = Race.Unknown;
    private boolean dragoonEncountered = false;
    public boolean goTank = false;
    private VultureHarassTask vultureHarass;
    private ConstantPushTask constantPushTask;

    public TAntiZealot() {
    }

    public TAntiZealot(boolean commit) {
        this.commit = commit;
    }

    public TAntiZealot(boolean commit, boolean buildBunker, boolean expand, boolean goTank) {
        this.commit = commit;
        this.buildBunker = buildBunker;
        this.expand = expand;
        this.goTank = goTank;
    }

    @Override
    public void initialize(Game game, Player self, Tyr bot) {
        this.add(new SupplyDepotPart());
        this.add(new WorkerScoutPart(1600));
        if (this.expand) {
            this.add(new ExpandPart(true));
            ExpandPart.maximumCcs = 1;
        }
        if (this.commit) {
            this.constantPushTask = new ConstantPushTask();
            bot.taskManager.potentialTasks.add(this.constantPushTask);
            AttackGroup.offensiveMines = true;
            this.vultureHarass = new VultureHarassTask(true);
            bot.taskManager.potentialTasks.add(this.vultureHarass);
            VultureHarassTask.defendingUnitsNeeded = 4;
        }
        super.initialize(game, self, bot);
    }

    @Override
    public void onFrame(Game game, Player self, Tyr bot) {
        DebugMessages.addMessage("Countering Zealot push.");
        StopWatch watch = new StopWatch();
        watch.start();
        if (this.commit) {
            if (UnitTracker.count(UnitType.Terran_Vulture) >= 12 && !this.vultureHarass.isHarassing()) {
                DebugMessages.addMessage("Stopping vulture push!");
                ConstantPushTask.paused.add(UnitType.Terran_Vulture);
            } else {
                if (UnitTracker.count(UnitType.Terran_Vulture) < 12) {
                    DebugMessages.addMessage("Continueing vulture push, vultures: " + UnitTracker.count(UnitType.Terran_Vulture));
                } else {
                    DebugMessages.addMessage("Continueing vulture push, already harassing.");
                }
                ConstantPushTask.paused.remove(UnitType.Terran_Vulture);
            }
        }
        if (this.enemyRace == Race.Unknown) {
            for (Unit enemy : EnemyManager.getEnemyUnits()) {
                if (enemy.getType().getRace() == Race.Protoss) {
                    this.enemyRace = Race.Protoss;
                    continue;
                }
                if (enemy.getType().getRace() == Race.Terran) {
                    this.enemyRace = Race.Terran;
                    continue;
                }
                if (enemy.getType().getRace() != Race.Zerg) continue;
                this.enemyRace = Race.Zerg;
                this.buildBunker = true;
            }
        }
        if (this.enemyRace == Race.Protoss && !this.dragoonEncountered) {
            for (Unit enemy : EnemyManager.getEnemyUnits()) {
                if (enemy.getType() != UnitType.Protoss_Dragoon) continue;
                this.dragoonEncountered = true;
                break;
            }
        }
        if (this.constantPushTask != null) {
            if (this.dragoonEncountered && !self.hasResearched(TechType.Tank_Siege_Mode)) {
                VultureHarassTask.defendingUnitsNeeded = 200;
                this.constantPushTask.stop();
            } else {
                VultureHarassTask.defendingUnitsNeeded = 4;
                this.constantPushTask.go();
            }
        }
        super.onFrame(game, self, bot);
        if (UnitTracker.count(UnitType.Terran_Factory) < 1 && (bot.getAvailableGas() >= 100 || bot.getAvailableMinerals() < 100)) {
            Settings.setWorkersPerGas(1);
        } else if (!(UnitTracker.count(UnitType.Terran_Factory) > 2 && bot.getAvailableGas() < 300 || bot.getAvailableGas() < 100 && bot.getAvailableMinerals() >= 150)) {
            Settings.setWorkersPerGas(2);
        } else {
            Settings.setWorkersPerGas(3);
        }
        long time = watch.time();
        if (time > 55L) {
            DebugMessages.addMessage("Zealot counter super time: " + time);
        }
        if (ExpandPart.maximumCcs == 1 && bot.getAvailableMinerals() >= 600) {
            ExpandPart.maximumCcs = 2;
        } else if (ExpandPart.maximumCcs == 2 && bot.getAvailableMinerals() >= 600 && self.completedUnitCount(UnitType.Terran_Command_Center) >= 2) {
            ExpandPart.maximumCcs = 3;
        }
        if (bot.getAvailableMinerals() >= 100 && UnitTracker.count(UnitType.Terran_Refinery) > 0 && (bot.getAvailableMinerals() >= 150 || UnitTracker.getCcCount() > 1) && UnitTracker.count(UnitType.Terran_Barracks) == 0) {
            bot.spaceManager.build(UnitType.Terran_Barracks);
        }
        if (UnitTracker.count(UnitType.Terran_Refinery) < UnitTracker.count(UnitType.Terran_Command_Center) && (UnitTracker.count(UnitType.Terran_Refinery) == 0 || UnitTracker.count(UnitType.Terran_Factory) >= 1) && bot.getAvailableMinerals() >= 100 && UnitTracker.getGeyserCount() > 0) {
            bot.spaceManager.build(UnitType.Terran_Refinery);
        }
        if (!(bot.getAvailableMinerals() < 200 || bot.getAvailableGas() < 100 || this.commit && UnitTracker.count(UnitType.Terran_Bunker) <= 0 && this.buildBunker || UnitTracker.count(UnitType.Terran_Barracks) < 1 || UnitTracker.count(UnitType.Terran_Factory) >= Math.min(7, 3 * UnitTracker.count(UnitType.Terran_Command_Center)) || this.enemyRace == Race.Protoss && UnitTracker.count(UnitType.Terran_Command_Center) <= 1 && this.commit && UnitTracker.count(UnitType.Terran_Factory) >= 2 || UnitTracker.count(UnitType.Terran_Factory) != 0 && (bot.getAvailableMinerals() < 200 || bot.getAvailableGas() < 100))) {
            bot.spaceManager.build(UnitType.Terran_Factory);
        }
        if ((time = watch.time()) > 55L) {
            DebugMessages.addMessage("Zealot counter tier 1 time: " + time);
        }
        time = watch.time();
        if (bot.getAvailableMinerals() >= 150 && UnitTracker.count(UnitType.Terran_Barracks) != 0 && UnitTracker.count(UnitType.Terran_Refinery) != 0 && UnitTracker.count(UnitType.Terran_Academy) == 0 && (bot.homeGroup.units.size() >= 10 || UnitTracker.count(UnitType.Terran_Vulture) >= 6 || this.dragoonEncountered)) {
            bot.spaceManager.build(UnitType.Terran_Academy);
        }
        if (game.enemy().getRace() != Race.Zerg && UnitTracker.count(UnitType.Terran_Armory) < 2 && bot.getAvailableGas() >= 50 && bot.getAvailableMinerals() >= 100 && this.commit && self.completedUnitCount(UnitType.Terran_Factory) > 0 && (this.vultureHarass.isHarassing() || game.enemy().getRace() == Race.Terran)) {
            bot.spaceManager.build(UnitType.Terran_Armory);
        }
        if ((time = watch.time()) > 55L) {
            DebugMessages.addMessage("Zealot counter tier 2 time: " + time);
        }
        if (this.buildBunker && bot.getAvailableMinerals() >= 50 && (bot.getAvailableMinerals() >= 100 || UnitTracker.count(UnitType.Terran_Factory) > 1) && (UnitTracker.count(UnitType.Terran_Factory) >= 1 || this.commit) && self.completedUnitCount(UnitType.Terran_Barracks) >= 1 && UnitTracker.count(UnitType.Terran_Bunker) < 2) {
            for (DefensiveStructures structures : bot.defensiveStructures) {
                int count = structures.getUnitCount(UnitType.Terran_Bunker);
                if (count >= 1) continue;
                if (bot.defensiveStructures.size() > 1 && structures.defendedPosition.getDistance(Tyr.tileToPosition(self.getStartLocation())) <= 200.0) {
                    if (UnitTracker.count(UnitType.Terran_Bunker) != 0) break;
                    continue;
                }
                bot.spaceManager.buildDefensive(UnitType.Terran_Bunker, structures);
                break;
            }
        }
        if ((time = watch.time()) > 55L) {
            DebugMessages.addMessage("Zealot counter bunker time: " + time);
        }
    }

    @Override
    public boolean overrideStructureOrder(Game game, Player self, Tyr bot, Agent agent) {
        if (super.overrideStructureOrder(game, self, bot, agent)) {
            return true;
        }
        if (agent.unit.getType() == UnitType.Terran_Barracks) {
            if (!this.buildBunker) {
                return true;
            }
            if (UnitTracker.count(UnitType.Terran_Factory) == 0 || UnitTracker.count(UnitType.Terran_Marine) >= Math.max(4, UnitTracker.count(UnitType.Terran_Bunker) * 4)) {
                return true;
            }
        }
        if (agent.unit.getType() == UnitType.Terran_Starport) {
            return true;
        }
        if (agent.unit.getType() == UnitType.Terran_Factory) {
            if (this.goTank && this.enemyRace == Race.Protoss && agent.unit.getAddon() != null) {
                return false;
            }
            if (self.completedUnitCount(UnitType.Terran_Factory) >= (this.enemyRace == Race.Protoss && this.goTank ? 2 : 3) && UnitTracker.usableAddOns(UnitType.Terran_Machine_Shop) == 0 && !agent.unit.isTraining() && this.commit) {
                UnitTracker.addAddOn(UnitType.Terran_Machine_Shop);
                agent.unit.buildAddon(UnitType.Terran_Machine_Shop);
            } else if (!(UnitTracker.count(UnitType.Terran_Armory) < 1 || agent.unit.isTraining() || UnitTracker.count(UnitType.Terran_Goliath) >= 4 && UnitTracker.count(UnitType.Terran_Goliath) >= UnitTracker.count(UnitType.Terran_Vulture) - 12 || bot.getAvailableMinerals() < 100 || bot.getAvailableGas() < 50)) {
                agent.unit.train(UnitType.Terran_Goliath);
            } else if (bot.getAvailableMinerals() >= 75 && !agent.unit.isTraining()) {
                agent.unit.train(UnitType.Terran_Vulture);
            }
            return true;
        }
        if (agent.unit.getType() == UnitType.Terran_Armory) {
            if (bot.getAvailableMinerals() >= UpgradeType.Terran_Vehicle_Weapons.mineralPrice() && bot.getAvailableGas() >= UpgradeType.Terran_Vehicle_Weapons.gasPrice()) {
                agent.unit.upgrade(UpgradeType.Terran_Vehicle_Weapons);
            }
            if (bot.getAvailableMinerals() >= UpgradeType.Terran_Vehicle_Plating.mineralPrice() && bot.getAvailableGas() >= UpgradeType.Terran_Vehicle_Plating.gasPrice()) {
                agent.unit.upgrade(UpgradeType.Terran_Vehicle_Plating);
            }
            return true;
        }
        if (agent.unit.getType() == UnitType.Terran_Engineering_Bay) {
            return true;
        }
        if (agent.unit.getType() == UnitType.Terran_Machine_Shop) {
            if (this.goTank && this.enemyRace == Race.Protoss && !self.hasResearched(TechType.Tank_Siege_Mode)) {
                return false;
            }
            if (!agent.unit.isResearching() && (this.commit || self.hasResearched(TechType.Tank_Siege_Mode)) && !self.hasResearched(TechType.Spider_Mines) && bot.getAvailableMinerals() >= 100 && bot.getAvailableGas() >= 100) {
                agent.unit.research(TechType.Spider_Mines);
            } else if (!agent.unit.isResearching() && self.hasResearched(TechType.Spider_Mines) && bot.getAvailableMinerals() >= 100 && bot.getAvailableGas() >= 100) {
                agent.unit.upgrade(UpgradeType.Charon_Boosters);
            } else if (UnitTracker.count(UnitType.Terran_Armory) > 0 && !agent.unit.isResearching() && self.hasResearched(TechType.Spider_Mines) && bot.getAvailableMinerals() >= 100 && bot.getAvailableGas() >= 100) {
                agent.unit.upgrade(UpgradeType.Charon_Boosters);
            }
            if (!this.goTank || this.enemyRace != Race.Protoss) {
                return true;
            }
        }
        return false;
    }
}

