/*
 * Decompiled with CFR 0.152.
 */
package com.tyr.builds;

import bwapi.Game;
import bwapi.Player;
import bwapi.Position;
import bwapi.Race;
import bwapi.Unit;
import bwapi.UnitType;
import bwapi.UpgradeType;
import bwta.BWTA;
import com.tyr.DebugMessages;
import com.tyr.EnemyManager;
import com.tyr.EnemyPosition;
import com.tyr.PositionUtil;
import com.tyr.Settings;
import com.tyr.Tyr;
import com.tyr.UnitTracker;
import com.tyr.agents.Agent;
import com.tyr.agents.Attack;
import com.tyr.buildingplacement.SpaceManager;
import com.tyr.builds.CompositeBuildOrder;
import com.tyr.builds.ExpandPart;
import com.tyr.builds.WorkerScoutPart;
import com.tyr.requirements.ConjRequirement;
import com.tyr.requirements.CostRequirement;
import com.tyr.requirements.UnitRequirement;
import com.tyr.tasks.BuildAtLocationSolution;
import com.tyr.tasks.BuildAtLocationTask;
import com.tyr.tasks.ClearExpandsTask;
import com.tyr.tasks.ConstantPushTask;
import com.tyr.tasks.DefendMainTask;
import com.tyr.tasks.LocalDefenseTask;
import com.tyr.tasks.SmeltingTask;
import com.tyr.unitgroups.AttackGroup;
import com.tyr.unitgroups.DistributeAttackGroup;
import com.tyr.unitgroups.PrioritizedAttackGroup;
import java.util.ArrayList;

public class SafeTwoGate
extends CompositeBuildOrder {
    private ConstantPushTask pressureTask;
    private LocalDefenseTask localDefenseTask;
    private LocalDefenseTask naturalDefenseTask;
    private ConstantPushTask constantPushTask;
    private SmeltingTask smeltingTask;
    private int armySize;
    boolean defensesInitialized = false;
    private Position natural = null;
    boolean dragoonsFirst;
    boolean buildCannons;
    boolean detectionNeeded;
    boolean takeExpands;
    boolean prioritizeExpands = false;
    boolean attackStarted = false;
    private int mode = 0;
    private boolean vIron = false;
    private boolean zealotOnly = false;

    public SafeTwoGate() {
        this(20, false, true, false, false, false);
    }

    public SafeTwoGate(boolean vIron) {
        this(vIron ? 20 : 20, vIron, !vIron, false, false, false);
        this.vIron = vIron;
    }

    public SafeTwoGate(int armySize, boolean dragoonsFirst, boolean buildCannons, boolean detectionNeeded, boolean takeExpands, boolean zealotOnly) {
        this.armySize = armySize;
        this.dragoonsFirst = dragoonsFirst;
        this.buildCannons = buildCannons;
        this.detectionNeeded = detectionNeeded;
        this.takeExpands = takeExpands;
        this.zealotOnly = zealotOnly;
    }

    @Override
    public void initialize(Game game, Player self, Tyr bot) {
        if (this.vIron) {
            DefendMainTask.keepZealotsBack = true;
            this.mode = 3;
            this.localDefenseTask = new LocalDefenseTask(BWTA.getRegion(Tyr.getStartLocation()), 0);
            this.naturalDefenseTask = new LocalDefenseTask(null, 0);
        }
        if (game.enemy().getRace() == Race.Zerg) {
            this.pressureTask = new ConstantPushTask(1);
            this.pressureTask.stop = true;
            Tyr.bot.taskManager.potentialTasks.add(this.pressureTask);
            PrioritizedAttackGroup.allowRetreat = true;
            PrioritizedAttackGroup.ignoreAfterNonAggressive = Integer.MAX_VALUE;
        }
        DistributeAttackGroup.waitDistance = 800;
        if (this.smeltingTask != null) {
            Tyr.bot.taskManager.potentialTasks.add(this.smeltingTask);
        }
        if (this.localDefenseTask != null) {
            Tyr.bot.taskManager.potentialTasks.add(this.localDefenseTask);
        }
        if (this.naturalDefenseTask != null) {
            Tyr.bot.taskManager.potentialTasks.add(this.naturalDefenseTask);
        }
        Settings.setRequiredSize(100);
        Settings.setMaximumSize(100);
        Settings.setMaximumWorkers(7);
        Settings.setWorkersPerGas(2);
        Settings.setLargeInvasionDist(768);
        ExpandPart.maximumCcs = 1;
        ClearExpandsTask.allowFullAssault = false;
        AttackGroup.hunting = true;
        if (game.mapFileName().contains("Alchemist") || this.vIron) {
            this.add(new WorkerScoutPart(100));
        } else {
            this.add(new WorkerScoutPart(1600));
        }
        this.add(new ExpandPart(true));
        Attack.requiredAtCannon = 0;
        Attack.dontWaitAtCannon = true;
        this.constantPushTask = new ConstantPushTask(null, this.mode);
        this.constantPushTask.stop = true;
        bot.taskManager.potentialTasks.add(this.constantPushTask);
        ConstantPushTask.prioritizeExpands = true;
        super.initialize(game, self, bot);
    }

    private static int armySize() {
        return SafeTwoGate.completed(ZEALOT) + SafeTwoGate.completed(DRAGOON);
    }

    private Position getDefensivePosition() {
        boolean expand = false;
        if (!expand) {
            Position startLocation = Tyr.tileToPosition(Tyr.self.getStartLocation());
            Position mainExit = SpaceManager.getMainExit();
            return new Position((startLocation.getX() + mainExit.getX()) / 2, (startLocation.getY() + mainExit.getY()) / 2);
        }
        Position location = SpaceManager.getNatural();
        ArrayList<Position> minerals = new ArrayList<Position>();
        for (EnemyPosition neutralUnit : EnemyManager.getManager().neutralBuildingMemory) {
            if (!neutralUnit.type.isMineralField() || !(neutralUnit.pos.getDistance(location) <= 270.0)) continue;
            minerals.add(neutralUnit.pos);
        }
        return SpaceManager.getDefensePosPositions(location, minerals);
    }

    @Override
    public void onFrame(Game game, Player self, Tyr bot) {
        Position defensivePosition;
        boolean takeExpands;
        DebugMessages.addMessage("Army size: " + SafeTwoGate.armySize());
        if (this.pressureTask != null) {
            if (this.pressureTask.stop && SafeTwoGate.completed(ZEALOT) + SafeTwoGate.completed(DRAGOON) >= 4) {
                this.pressureTask.stop = false;
            }
            if (EnemyManager.getManager().getAllCount(UnitType.Zerg_Sunken_Colony) >= 2 || EnemyManager.getManager().getAllCount(UnitType.Zerg_Zergling) > 6) {
                this.pressureTask.remove();
                this.pressureTask = null;
            }
        }
        boolean bl = takeExpands = this.takeExpands && this.attackStarted;
        if (UnitTracker.getCcCount() <= 1) {
            if (this.natural == null) {
                this.natural = SpaceManager.getNatural();
            }
            if (this.natural != null) {
                for (Unit enemy : EnemyManager.getEnemyUnits()) {
                    if (PositionUtil.distanceSq(enemy, this.natural) > Settings.getSmallInvasionDist() * Settings.getSmallInvasionDist()) continue;
                    takeExpands = false;
                    break;
                }
            }
        }
        if (takeExpands) {
            if (SafeTwoGate.armySize() >= this.armySize + 3) {
                this.prioritizeExpands = true;
            }
            ExpandPart.maximumCcs = SafeTwoGate.armySize() >= 28 && SafeTwoGate.completed(NEXUS) >= 2 ? 3 : 2;
        } else {
            ExpandPart.maximumCcs = 1;
        }
        if (SafeTwoGate.completed(NEXUS) > 1 && SafeTwoGate.count(ZEALOT) + SafeTwoGate.count(DRAGOON) >= 30) {
            this.detectionNeeded = true;
        }
        if (this.localDefenseTask != null && SafeTwoGate.armySize() > 25) {
            this.localDefenseTask.setDefendersNeeded(3);
        }
        if (this.vIron && SafeTwoGate.count(DRAGOON) + SafeTwoGate.count(ZEALOT) >= 18) {
            this.takeExpands = true;
            this.prioritizeExpands = true;
        }
        if (this.vIron && SafeTwoGate.armySize() >= 23) {
            this.detectionNeeded = true;
            DistributeAttackGroup.requiredForAttack = 20;
            DistributeAttackGroup.requiredForRetreat = 15;
        }
        if (this.vIron && SafeTwoGate.armySize() >= 16 && this.localDefenseTask.getDefendersNeeded() == 0) {
            this.localDefenseTask.setDefendersNeeded(1);
        }
        if (this.naturalDefenseTask != null && this.naturalDefenseTask.getDefendersNeeded() == 0 && Tyr.bot.workForce.mineralWorkers.size() >= 2) {
            this.naturalDefenseTask.setDefendersNeeded(2);
            this.naturalDefenseTask.setDefendedPosition(Tyr.bot.workForce.mineralWorkers.get((int)1).resourceDepot.getPosition());
        }
        if (this.buildCannons && !this.defensesInitialized && game.getFrameCount() >= 100 && self.completedUnitCount(UnitType.Protoss_Zealot) + self.completedUnitCount(UnitType.Protoss_Dragoon) >= 17 && (defensivePosition = this.getDefensivePosition()) != null) {
            this.initializeDefenses(defensivePosition);
        }
        if (this.zealotOnly && UnitTracker.count(ZEALOT) >= 6) {
            this.zealotOnly = false;
        }
        super.onFrame(game, self, bot);
        if (SafeTwoGate.gas() >= 400) {
            Settings.setWorkersPerGas(2);
        } else if (SafeTwoGate.gas() < 250 && SafeTwoGate.count(GATEWAY) >= 12 || SafeTwoGate.gas() + 400 < SafeTwoGate.minerals()) {
            Settings.setWorkersPerGas(3);
        }
        if (SafeTwoGate.armySize() >= 23) {
            SmeltingTask.disabled = true;
        }
        if (this.constantPushTask != null && SafeTwoGate.completed(ZEALOT) + SafeTwoGate.completed(DRAGOON) <= 10) {
            this.constantPushTask.stop = true;
        }
        if (this.constantPushTask != null && SafeTwoGate.completed(ZEALOT) + SafeTwoGate.completed(DRAGOON) >= this.armySize) {
            this.attackStarted = true;
            this.constantPushTask.stop = false;
        }
        if (UnitTracker.count(UnitType.Protoss_Cybernetics_Core) > 0) {
            Settings.setMaximumWorkers(30);
        } else if (UnitTracker.count(UnitType.Protoss_Gateway) >= 4) {
            Settings.setMaximumWorkers(25);
        } else if (UnitTracker.count(UnitType.Protoss_Gateway) >= 2) {
            Settings.setMaximumWorkers(9);
        }
        if (SafeTwoGate.armySize() >= 2 && UnitTracker.count(UnitType.Protoss_Gateway) < 4) {
            Settings.setMaximumWorkers(20);
        }
        if (UnitTracker.count(UnitType.Protoss_Probe) >= 7 && UnitTracker.count(UnitType.Protoss_Pylon) == 0 && bot.getAvailableMinerals() >= 100) {
            bot.spaceManager.build(UnitType.Protoss_Pylon);
        }
        if (self.completedUnitCount(UnitType.Protoss_Pylon) > 0 && bot.getAvailableMinerals() >= 250 && UnitTracker.count(UnitType.Protoss_Gateway) == 0) {
            bot.spaceManager.build(UnitType.Protoss_Gateway);
        }
        if (UnitTracker.count(UnitType.Protoss_Gateway) == 1 && bot.getAvailableMinerals() >= 100 && (!this.dragoonsFirst || SafeTwoGate.count(CYBERNETICS_CORE) > 0 && SafeTwoGate.count(ASSIMILATOR) > 0)) {
            bot.spaceManager.build(UnitType.Protoss_Gateway);
        }
        if (!this.pauseProduction()) {
            if (UnitTracker.count(UnitType.Protoss_Gateway) < 4 && bot.getAvailableMinerals() >= 300 && UnitTracker.count(UnitType.Protoss_Cybernetics_Core) > 0) {
                bot.spaceManager.build(UnitType.Protoss_Gateway);
            }
            if (UnitTracker.count(UnitType.Protoss_Gateway) >= 3 && UnitTracker.count(UnitType.Protoss_Gateway) < 7 && bot.getAvailableMinerals() >= 300 && SafeTwoGate.count(ZEALOT) + SafeTwoGate.count(DRAGOON) >= 7 && (!this.vIron || this.attackStarted)) {
                bot.spaceManager.build(UnitType.Protoss_Gateway);
            }
        }
        if (self.supplyTotal() + UnitTracker.getSupplyConstructing() - self.supplyUsed() <= UnitTracker.count(UnitType.Protoss_Gateway) * 3 + UnitTracker.getCcCount() * 3 && bot.getAvailableMinerals() >= 100 && self.supplyTotal() + UnitTracker.getSupplyConstructing() < 400 && UnitTracker.count(UnitType.Protoss_Pylon) >= 1 && (SafeTwoGate.armySize() >= 2 || self.supplyTotal() + UnitTracker.getSupplyConstructing() - self.supplyUsed() < 4)) {
            bot.spaceManager.build(UnitType.Protoss_Pylon);
        }
        if (UnitTracker.count(UnitType.Protoss_Assimilator) < 2 && bot.getAvailableMinerals() >= 100 && UnitTracker.getGeyserCount() > 0 && (SafeTwoGate.count(CYBERNETICS_CORE) > 0 || this.dragoonsFirst && SafeTwoGate.minerals() >= 300) && (UnitTracker.count(UnitType.Protoss_Zealot) >= 3 || this.dragoonsFirst) && !this.zealotOnly) {
            bot.spaceManager.build(UnitType.Protoss_Assimilator);
        }
        if (bot.getAvailableMinerals() >= 200 && UnitTracker.count(UnitType.Protoss_Cybernetics_Core) < 1 && SafeTwoGate.completed(GATEWAY) > 0 && (UnitTracker.count(UnitType.Protoss_Zealot) >= 3 || this.dragoonsFirst) && !this.zealotOnly) {
            bot.spaceManager.build(UnitType.Protoss_Cybernetics_Core);
        }
        if (!(bot.getAvailableMinerals() < 150 || UnitTracker.count(UnitType.Protoss_Dragoon) + UnitTracker.count(UnitType.Protoss_Zealot) < 15 || UnitTracker.count(UnitType.Protoss_Forge) != 0 || this.vIron && SafeTwoGate.armySize() < 20)) {
            bot.spaceManager.build(UnitType.Protoss_Forge);
        }
        if (bot.getAvailableMinerals() >= 300 && UnitTracker.count(UnitType.Protoss_Nexus) >= 2 && UnitTracker.count(UnitType.Protoss_Cybernetics_Core) > 0 && UnitTracker.count(UnitType.Protoss_Forge) < 2) {
            bot.spaceManager.build(UnitType.Protoss_Forge);
        }
        if (bot.getAvailableMinerals() >= 150 && bot.getAvailableGas() >= 100 && UnitTracker.count(UnitType.Protoss_Citadel_of_Adun) == 0 && self.completedUnitCount(UnitType.Protoss_Cybernetics_Core) > 0 && UnitTracker.count(UnitType.Protoss_Gateway) >= 4 && SafeTwoGate.count(ZEALOT) + SafeTwoGate.count(DRAGOON) >= 20) {
            bot.spaceManager.build(UnitType.Protoss_Citadel_of_Adun);
        }
        if (SafeTwoGate.gas() >= 200 && SafeTwoGate.minerals() >= 200 && (SafeTwoGate.count(GATEWAY) >= 7 || this.detectionNeeded) && SafeTwoGate.count(ROBOTICS_FACILITY) == 0 && SafeTwoGate.count(GATEWAY) >= 2) {
            bot.spaceManager.build(ROBOTICS_FACILITY);
        }
        if (SafeTwoGate.gas() >= 50 && SafeTwoGate.minerals() >= 100 && SafeTwoGate.completed(ROBOTICS_FACILITY) > 0 && SafeTwoGate.count(OBSERVATORY) == 0) {
            bot.spaceManager.build(OBSERVATORY);
        }
    }

    private void initializeDefenses(Position defensivePosition) {
        this.defensesInitialized = true;
        BuildAtLocationSolution.buildingDistance = 200;
        BuildAtLocationTask buildTask = new BuildAtLocationTask(defensivePosition, true);
        buildTask.addBuilding(UnitType.Protoss_Pylon, new UnitRequirement(UnitType.Protoss_Probe, 7));
        buildTask.addBuilding(UnitType.Protoss_Photon_Cannon, new ConjRequirement().addRequirement(new UnitRequirement(UnitType.Protoss_Forge, 1, true)).addRequirement(new CostRequirement(150, 0)));
        buildTask.addBuilding(UnitType.Protoss_Photon_Cannon, new ConjRequirement().addRequirement(new UnitRequirement(UnitType.Protoss_Forge, 1, true)).addRequirement(new CostRequirement(150, 0)));
        buildTask.addBuilding(UnitType.Protoss_Photon_Cannon, new ConjRequirement().addRequirement(new UnitRequirement(UnitType.Protoss_Forge, 1, true)).addRequirement(new CostRequirement(150, 0)));
        buildTask.addBuilding(UnitType.Protoss_Photon_Cannon, new ConjRequirement().addRequirement(new UnitRequirement(UnitType.Protoss_Forge, 1, true)).addRequirement(new CostRequirement(150, 0)));
        Tyr.bot.taskManager.potentialTasks.add(buildTask);
    }

    private boolean pauseProduction() {
        if (SafeTwoGate.gas() > 250 && SafeTwoGate.minerals() > 400) {
            return false;
        }
        if (this.detectionNeeded && SafeTwoGate.armySize() >= 2 && SafeTwoGate.count(GATEWAY) > 2 && SafeTwoGate.completed(CYBERNETICS_CORE) > 0 && SafeTwoGate.count(ROBOTICS_FACILITY) == 0) {
            return true;
        }
        if (this.detectionNeeded && SafeTwoGate.armySize() >= 2 && SafeTwoGate.completed(CYBERNETICS_CORE) > 0 && SafeTwoGate.completed(ROBOTICS_FACILITY) == 1 && SafeTwoGate.count(OBSERVATORY) == 0) {
            return true;
        }
        if (this.detectionNeeded && SafeTwoGate.armySize() >= 2 && SafeTwoGate.completed(CYBERNETICS_CORE) > 0 && SafeTwoGate.completed(OBSERVATORY) == 1 && SafeTwoGate.count(OBSERVER) == 0) {
            return true;
        }
        if (SafeTwoGate.completed(CITADEL) > 0 && Tyr.self.getUpgradeLevel(UpgradeType.Leg_Enhancements) == 0 && !Tyr.self.isUpgrading(UpgradeType.Leg_Enhancements)) {
            return true;
        }
        if (UnitTracker.count(CITADEL) == 0 && SafeTwoGate.completed(CYBERNETICS_CORE) > 0 && SafeTwoGate.count(GATEWAY) >= 4 && SafeTwoGate.count(ZEALOT) + SafeTwoGate.count(DRAGOON) >= 20) {
            return true;
        }
        if (this.prioritizeExpands && SafeTwoGate.minerals() < 400 && SafeTwoGate.count(NEXUS) <= 1) {
            return true;
        }
        if (SafeTwoGate.minerals() >= 300) {
            return false;
        }
        if (SafeTwoGate.count(ZEALOT) >= 2 && SafeTwoGate.count(CYBERNETICS_CORE) == 0) {
            return true;
        }
        return SafeTwoGate.count(ZEALOT) >= 2 && SafeTwoGate.count(ASSIMILATOR) == 0;
    }

    @Override
    public boolean overrideStructureOrder(Game game, Player self, Tyr bot, Agent agent) {
        if (agent.unit.getType() == UnitType.Protoss_Gateway && !agent.unit.isTraining()) {
            if (this.vIron && SafeTwoGate.count(DRAGOON) <= 6 && SafeTwoGate.count(ZEALOT) >= 5 && !this.pauseProduction()) {
                if (bot.getAvailableMinerals() >= 125 && bot.getAvailableGas() >= 50) {
                    agent.unit.build(DRAGOON);
                }
                return true;
            }
            if (!(this.pauseProduction() && SafeTwoGate.minerals() < 300 || SafeTwoGate.count(ZEALOT) + (this.dragoonsFirst ? 3 : 0) > SafeTwoGate.count(DRAGOON) && (this.dragoonsFirst || SafeTwoGate.completed(CYBERNETICS_CORE) != 0) || this.dragoonsFirst && SafeTwoGate.count(DRAGOON) < 10 || bot.getAvailableMinerals() < 100)) {
                agent.unit.build(ZEALOT);
            } else if (!this.pauseProduction() && (SafeTwoGate.count(ZEALOT) + (this.dragoonsFirst ? 3 : 0) > SafeTwoGate.count(DRAGOON) || this.dragoonsFirst && SafeTwoGate.count(DRAGOON) < 10) && bot.getAvailableMinerals() >= 125 && bot.getAvailableGas() >= 50) {
                agent.unit.build(DRAGOON);
            }
            return true;
        }
        if (agent.unit.getType() == UnitType.Protoss_Cybernetics_Core && !agent.unit.isUpgrading()) {
            if (bot.getAvailableMinerals() >= UpgradeType.Singularity_Charge.mineralPrice() && SafeTwoGate.count(DRAGOON) >= 3 && bot.getAvailableGas() >= UpgradeType.Singularity_Charge.gasPrice()) {
                agent.unit.upgrade(UpgradeType.Singularity_Charge);
            }
        } else if (agent.unit.getType() == UnitType.Protoss_Forge && !agent.unit.isUpgrading()) {
            if (bot.getAvailableMinerals() >= UpgradeType.Protoss_Ground_Weapons.mineralPrice() && bot.getAvailableGas() >= UpgradeType.Protoss_Ground_Weapons.gasPrice()) {
                agent.unit.upgrade(UpgradeType.Protoss_Ground_Weapons);
            }
            if (bot.getAvailableMinerals() >= UpgradeType.Protoss_Ground_Armor.mineralPrice() && bot.getAvailableGas() >= UpgradeType.Protoss_Ground_Armor.gasPrice()) {
                agent.unit.upgrade(UpgradeType.Protoss_Ground_Armor);
            }
        } else if (agent.unit.getType() == CITADEL && !agent.unit.isUpgrading()) {
            if (SafeTwoGate.gas() >= UpgradeType.Leg_Enhancements.gasPrice() && SafeTwoGate.minerals() >= UpgradeType.Leg_Enhancements.mineralPrice()) {
                agent.unit.upgrade(UpgradeType.Leg_Enhancements);
            }
        } else if (agent.unit.getType() == ROBOTICS_FACILITY) {
            if (SafeTwoGate.count(OBSERVER) < 2 && SafeTwoGate.minerals() >= 25 && SafeTwoGate.gas() >= 75 && !agent.unit.isTraining()) {
                agent.unit.build(OBSERVER);
            }
            return true;
        }
        return false;
    }
}

