/*
 * Decompiled with CFR 0.152.
 */
package com.tyr.builds;

import bwapi.Game;
import bwapi.Player;
import bwapi.Unit;
import bwapi.UnitType;
import bwapi.UpgradeType;
import bwta.BWTA;
import com.tyr.DebugMessages;
import com.tyr.EnemyManager;
import com.tyr.PositionUtil;
import com.tyr.Settings;
import com.tyr.Tyr;
import com.tyr.UnitTracker;
import com.tyr.agents.Agent;
import com.tyr.agents.Attack;
import com.tyr.buildingplacement.SpaceManager;
import com.tyr.builds.CompositeBuildOrder;
import com.tyr.builds.ExpandPart;
import com.tyr.builds.WorkerScoutPart;
import com.tyr.tasks.ClearExpandsTask;
import com.tyr.tasks.ClearMinesTask;
import com.tyr.tasks.ConstantPushTask;
import com.tyr.tasks.DefendMainTask;
import com.tyr.tasks.DragoonSquadTask;
import com.tyr.tasks.LocalDefenseTask;
import com.tyr.tasks.PokeTask;
import com.tyr.unitgroups.DistributeAttackGroup;
import java.util.ArrayList;

public class SafeGateExpand
extends CompositeBuildOrder {
    private ClearMinesTask clearMinesTask;
    private LocalDefenseTask localDefenseTask;
    private LocalDefenseTask naturalDefenseTask;
    private LocalDefenseTask thirdDefenseTask;
    private ConstantPushTask constantPushTask;
    private ConstantPushTask pokeTask;
    private int armySize = 40;
    boolean detectionNeeded;
    boolean attackStarted = false;
    boolean pokeSent = true;
    boolean scoutBuilt = false;

    @Override
    public void initialize(Game game, Player self, Tyr bot) {
        DefendMainTask.keepZealotsBack = true;
        this.addTask(new DragoonSquadTask());
        this.clearMinesTask = new ClearMinesTask();
        this.addTask(this.clearMinesTask);
        this.localDefenseTask = new LocalDefenseTask(BWTA.getRegion(Tyr.getStartLocation()), 0);
        this.addTask(this.localDefenseTask);
        this.naturalDefenseTask = new LocalDefenseTask(null, 0);
        this.addTask(this.naturalDefenseTask);
        this.thirdDefenseTask = new LocalDefenseTask(null, 0);
        this.addTask(this.thirdDefenseTask);
        this.pokeTask = new ConstantPushTask(3);
        DistributeAttackGroup.waitDistance = 800;
        Settings.setRequiredSize(100);
        Settings.setMaximumSize(100);
        Settings.setMaximumWorkers(7);
        Settings.setWorkersPerGas(2);
        Settings.setLargeInvasionDist(768);
        ExpandPart.maximumCcs = 2;
        ClearExpandsTask.allowFullAssault = false;
        this.add(new WorkerScoutPart(1600));
        this.add(new ExpandPart(true));
        Attack.requiredAtCannon = 0;
        this.constantPushTask = new ConstantPushTask(3);
        this.constantPushTask.stop = true;
        this.addTask(this.constantPushTask);
        ConstantPushTask.prioritizeExpands = true;
        ConstantPushTask.reinforcementSize = 5;
        super.initialize(game, self, bot);
    }

    private static int armySize() {
        return SafeGateExpand.completed(ZEALOT) + SafeGateExpand.completed(DRAGOON);
    }

    @Override
    public void onFrame(Game game, Player self, Tyr bot) {
        DebugMessages.addMessage("Army size: " + SafeGateExpand.armySize());
        if (SafeGateExpand.completed(SCOUT) > 0) {
            this.scoutBuilt = true;
        }
        if (!this.pokeSent && SafeGateExpand.completed(DRAGOON) >= 12) {
            Tyr.bot.taskManager.potentialTasks.add(this.pokeTask);
            PokeTask.defendingUnitsNeeded = 0;
            PokeTask.required = 10;
            this.pokeSent = true;
        }
        if (this.pokeSent && this.pokeTask != null) {
            ArrayList<Unit> enemyTanks = new ArrayList<Unit>();
            for (Unit enemy : EnemyManager.getEnemyUnits()) {
                if (!Agent.isTank(enemy)) continue;
                enemyTanks.add(enemy);
            }
            block1: for (Unit unit : self.getUnits()) {
                if (unit.getType() != DRAGOON && unit.getType() != ZEALOT) continue;
                for (Unit enemy : enemyTanks) {
                    if (PositionUtil.distanceSq(unit, enemy) > 1000000) continue;
                    this.pokeTask.remove();
                    this.pokeTask = null;
                    break block1;
                }
            }
        }
        if (SafeGateExpand.completed(NEXUS) > 1 && SafeGateExpand.count(ZEALOT) + SafeGateExpand.count(DRAGOON) >= 8) {
            this.detectionNeeded = true;
        }
        if (SafeGateExpand.armySize() >= 23) {
            this.detectionNeeded = true;
        }
        if (SafeGateExpand.armySize() >= 16) {
            this.localDefenseTask.setDefendersNeeded(1);
        }
        if (this.naturalDefenseTask != null && this.naturalDefenseTask.getDefendersNeeded() == 0 && Tyr.bot.workForce.mineralWorkers.size() >= 2) {
            this.naturalDefenseTask.setDefendersNeeded(2);
            this.naturalDefenseTask.setDefendedPosition(Tyr.bot.workForce.mineralWorkers.get((int)1).resourceDepot.getPosition());
        }
        if (this.thirdDefenseTask != null && this.thirdDefenseTask.getDefendersNeeded() == 0 && Tyr.bot.workForce.mineralWorkers.size() >= 3) {
            this.thirdDefenseTask.setDefendersNeeded(3);
            this.thirdDefenseTask.setDefendedPosition(Tyr.bot.workForce.mineralWorkers.get((int)2).resourceDepot.getPosition());
        }
        super.onFrame(game, self, bot);
        if (SafeGateExpand.gas() >= 400) {
            Settings.setWorkersPerGas(2);
        } else if (SafeGateExpand.gas() < 250 && SafeGateExpand.count(GATEWAY) >= 12 || SafeGateExpand.gas() + 400 < SafeGateExpand.minerals()) {
            Settings.setWorkersPerGas(3);
        }
        if (this.constantPushTask != null && SafeGateExpand.completed(ZEALOT) + SafeGateExpand.completed(DRAGOON) <= 10) {
            this.constantPushTask.stop = true;
        }
        if (this.constantPushTask != null && SafeGateExpand.completed(ZEALOT) + SafeGateExpand.completed(DRAGOON) >= this.armySize) {
            this.attackStarted = true;
            this.constantPushTask.stop = false;
            ExpandPart.maximumCcs = 3;
        }
        if (SafeGateExpand.count(NEXUS) > 1) {
            Settings.setMaximumWorkers(40);
        } else if (UnitTracker.count(UnitType.Protoss_Cybernetics_Core) > 0) {
            Settings.setMaximumWorkers(30);
        } else if (UnitTracker.count(UnitType.Protoss_Gateway) >= 4) {
            Settings.setMaximumWorkers(25);
        } else if (UnitTracker.count(UnitType.Protoss_Gateway) >= 2) {
            Settings.setMaximumWorkers(9);
        }
        if (SafeGateExpand.armySize() >= 2 && UnitTracker.count(UnitType.Protoss_Gateway) < 4) {
            Settings.setMaximumWorkers(20);
        }
        if (UnitTracker.count(UnitType.Protoss_Probe) >= 7 && UnitTracker.count(UnitType.Protoss_Pylon) == 0 && bot.getAvailableMinerals() >= 100) {
            bot.spaceManager.build(UnitType.Protoss_Pylon);
        }
        if (SpaceManager.noPower && SafeGateExpand.minerals() >= 100 && SafeGateExpand.count(PYLON) == SafeGateExpand.completed(PYLON)) {
            bot.spaceManager.build(PYLON);
        }
        if (self.completedUnitCount(UnitType.Protoss_Pylon) > 0 && bot.getAvailableMinerals() >= 125 && UnitTracker.count(UnitType.Protoss_Gateway) == 0 && SafeGateExpand.count(NEXUS) > 1) {
            bot.spaceManager.build(UnitType.Protoss_Gateway);
        }
        if (UnitTracker.count(UnitType.Protoss_Gateway) == 1 && bot.getAvailableMinerals() >= 100 && SafeGateExpand.count(CYBERNETICS_CORE) > 0 && SafeGateExpand.count(ASSIMILATOR) > 0 && SafeGateExpand.count(NEXUS) > 1) {
            bot.spaceManager.build(UnitType.Protoss_Gateway);
        }
        if (!this.pauseProduction()) {
            if (UnitTracker.count(UnitType.Protoss_Gateway) < 4 && bot.getAvailableMinerals() >= 300 && UnitTracker.count(UnitType.Protoss_Cybernetics_Core) > 0) {
                bot.spaceManager.build(UnitType.Protoss_Gateway);
            }
            if (UnitTracker.count(UnitType.Protoss_Gateway) >= 3 && UnitTracker.count(UnitType.Protoss_Gateway) < 7 && bot.getAvailableMinerals() >= 300 && SafeGateExpand.count(ZEALOT) + SafeGateExpand.count(DRAGOON) >= 7) {
                bot.spaceManager.build(UnitType.Protoss_Gateway);
            }
            if (UnitTracker.count(UnitType.Protoss_Gateway) >= 7 && UnitTracker.count(UnitType.Protoss_Gateway) < 12 && bot.getAvailableMinerals() >= 300 && SafeGateExpand.count(ZEALOT) + SafeGateExpand.count(DRAGOON) >= 7) {
                bot.spaceManager.build(UnitType.Protoss_Gateway);
            }
        }
        if (self.supplyTotal() + UnitTracker.getSupplyConstructing() - self.supplyUsed() <= UnitTracker.count(UnitType.Protoss_Gateway) * 3 + UnitTracker.getCcCount() * 3 && bot.getAvailableMinerals() >= 100 && self.supplyTotal() + UnitTracker.getSupplyConstructing() < 400 && UnitTracker.count(UnitType.Protoss_Pylon) >= 1 && (SafeGateExpand.armySize() >= 2 || self.supplyTotal() + UnitTracker.getSupplyConstructing() - self.supplyUsed() < 4)) {
            bot.spaceManager.build(UnitType.Protoss_Pylon);
        }
        if (UnitTracker.count(UnitType.Protoss_Assimilator) < 2 && bot.getAvailableMinerals() >= 100 && UnitTracker.getGeyserCount() > 0 && (SafeGateExpand.count(CYBERNETICS_CORE) > 0 || SafeGateExpand.minerals() >= 300) && SafeGateExpand.count(NEXUS) >= 2) {
            bot.spaceManager.build(UnitType.Protoss_Assimilator);
        }
        if (bot.getAvailableMinerals() >= 200 && UnitTracker.count(UnitType.Protoss_Cybernetics_Core) < 1 && SafeGateExpand.completed(GATEWAY) > 0) {
            bot.spaceManager.build(UnitType.Protoss_Cybernetics_Core);
        }
        if (bot.getAvailableMinerals() >= 150 && UnitTracker.count(UnitType.Protoss_Dragoon) + UnitTracker.count(UnitType.Protoss_Zealot) >= 15 && UnitTracker.count(UnitType.Protoss_Forge) == 0) {
            bot.spaceManager.build(UnitType.Protoss_Forge);
        }
        if (bot.getAvailableMinerals() >= 300 && UnitTracker.count(UnitType.Protoss_Nexus) >= 2 && UnitTracker.count(UnitType.Protoss_Cybernetics_Core) > 0 && UnitTracker.count(UnitType.Protoss_Forge) < 2) {
            bot.spaceManager.build(UnitType.Protoss_Forge);
        }
        if (SafeGateExpand.count(SHUTTLE) > 0 && bot.getAvailableMinerals() >= 150 && bot.getAvailableGas() >= 100 && UnitTracker.count(UnitType.Protoss_Citadel_of_Adun) == 0 && self.completedUnitCount(UnitType.Protoss_Cybernetics_Core) > 0 && UnitTracker.count(UnitType.Protoss_Gateway) >= 4 && SafeGateExpand.count(ZEALOT) + SafeGateExpand.count(DRAGOON) >= 20) {
            bot.spaceManager.build(UnitType.Protoss_Citadel_of_Adun);
        }
        if (SafeGateExpand.gas() >= 200 && SafeGateExpand.minerals() >= 200 && (SafeGateExpand.count(GATEWAY) >= 7 || this.detectionNeeded) && SafeGateExpand.count(ROBOTICS_FACILITY) < 2 && SafeGateExpand.count(GATEWAY) >= 2) {
            bot.spaceManager.build(ROBOTICS_FACILITY);
        }
        if (SafeGateExpand.gas() >= 50 && SafeGateExpand.minerals() >= 100 && SafeGateExpand.completed(ROBOTICS_FACILITY) > 0 && SafeGateExpand.count(OBSERVATORY) == 0) {
            bot.spaceManager.build(OBSERVATORY);
        }
    }

    private boolean pauseProduction() {
        if (SafeGateExpand.gas() > 250 && SafeGateExpand.minerals() > 400) {
            return false;
        }
        if (this.detectionNeeded && SafeGateExpand.count(DRAGOON) >= 2 && SafeGateExpand.count(GATEWAY) > 2 && SafeGateExpand.completed(CYBERNETICS_CORE) > 0 && SafeGateExpand.count(ROBOTICS_FACILITY) == 0) {
            return true;
        }
        if (this.detectionNeeded && SafeGateExpand.armySize() >= 2 && SafeGateExpand.completed(CYBERNETICS_CORE) > 0 && SafeGateExpand.completed(ROBOTICS_FACILITY) == 1 && SafeGateExpand.count(OBSERVATORY) == 0) {
            return true;
        }
        if (this.detectionNeeded && SafeGateExpand.armySize() >= 2 && SafeGateExpand.completed(CYBERNETICS_CORE) > 0 && SafeGateExpand.completed(OBSERVATORY) == 1 && SafeGateExpand.count(OBSERVER) < 3 && SafeGateExpand.completed(OBSERVER) == SafeGateExpand.count(OBSERVER)) {
            return true;
        }
        if (SafeGateExpand.completed(STARGATE) > 0 && SafeGateExpand.count(SCOUT) == 0) {
            return true;
        }
        if (UnitTracker.count(CITADEL) == 0 && SafeGateExpand.completed(CYBERNETICS_CORE) > 0 && SafeGateExpand.count(GATEWAY) >= 4 && SafeGateExpand.count(ZEALOT) + SafeGateExpand.count(DRAGOON) >= 20) {
            return true;
        }
        if (SafeGateExpand.minerals() < 400 && SafeGateExpand.count(NEXUS) <= 2 && SafeGateExpand.count(NEXUS) < ExpandPart.maximumCcs) {
            return true;
        }
        if (SafeGateExpand.minerals() >= 300) {
            return false;
        }
        if (SafeGateExpand.completed(OBSERVER) >= 3 && SafeGateExpand.completed(ROBOTICS_FACILITY) > 0 && SafeGateExpand.count(SHUTTLE) < 2 && SafeGateExpand.count(SHUTTLE) == SafeGateExpand.completed(SHUTTLE)) {
            return true;
        }
        if (SafeGateExpand.count(ZEALOT) >= 2 && SafeGateExpand.count(CYBERNETICS_CORE) == 0) {
            return true;
        }
        return SafeGateExpand.count(ZEALOT) >= 2 && SafeGateExpand.count(ASSIMILATOR) == 0;
    }

    @Override
    public boolean overrideStructureOrder(Game game, Player self, Tyr bot, Agent agent) {
        if (agent.unit.getType() == UnitType.Protoss_Gateway && !agent.unit.isTraining()) {
            if (SafeGateExpand.count(DRAGOON) <= 10 && !this.pauseProduction()) {
                if (bot.getAvailableMinerals() >= 125 && bot.getAvailableGas() >= 50) {
                    agent.unit.build(DRAGOON);
                }
                return true;
            }
            if (!(this.pauseProduction() && SafeGateExpand.minerals() < 300 || SafeGateExpand.count(ZEALOT) + 3 > SafeGateExpand.count(DRAGOON) || SafeGateExpand.count(DRAGOON) < 10 || bot.getAvailableMinerals() < 100)) {
                agent.unit.build(ZEALOT);
            } else if (!this.pauseProduction() && SafeGateExpand.count(ZEALOT) + 3 > SafeGateExpand.count(DRAGOON) && bot.getAvailableMinerals() >= 125 && bot.getAvailableGas() >= 50) {
                agent.unit.build(DRAGOON);
            }
            return true;
        }
        if (agent.unit.getType() == UnitType.Protoss_Cybernetics_Core && !agent.unit.isUpgrading()) {
            if (bot.getAvailableMinerals() >= UpgradeType.Singularity_Charge.mineralPrice() && SafeGateExpand.count(DRAGOON) >= 3 && bot.getAvailableGas() >= UpgradeType.Singularity_Charge.gasPrice()) {
                agent.unit.upgrade(UpgradeType.Singularity_Charge);
            }
        } else if (agent.unit.getType() == UnitType.Protoss_Forge && !agent.unit.isUpgrading()) {
            if (bot.getAvailableMinerals() >= UpgradeType.Protoss_Ground_Weapons.mineralPrice() && bot.getAvailableGas() >= UpgradeType.Protoss_Ground_Weapons.gasPrice()) {
                agent.unit.upgrade(UpgradeType.Protoss_Ground_Weapons);
            }
            if (bot.getAvailableMinerals() >= UpgradeType.Protoss_Ground_Armor.mineralPrice() && bot.getAvailableGas() >= UpgradeType.Protoss_Ground_Armor.gasPrice()) {
                agent.unit.upgrade(UpgradeType.Protoss_Ground_Armor);
            }
        } else if (agent.unit.getType() == CITADEL && !agent.unit.isUpgrading()) {
            if (SafeGateExpand.gas() >= UpgradeType.Leg_Enhancements.gasPrice() && SafeGateExpand.minerals() >= UpgradeType.Leg_Enhancements.mineralPrice()) {
                agent.unit.upgrade(UpgradeType.Leg_Enhancements);
            }
        } else {
            if (agent.unit.getType() == ROBOTICS_FACILITY) {
                if (SafeGateExpand.count(OBSERVER) < 3 && SafeGateExpand.minerals() >= 25 && SafeGateExpand.gas() >= 75 && !agent.unit.isTraining()) {
                    agent.unit.build(OBSERVER);
                }
                if (SafeGateExpand.minerals() >= 200 && !agent.unit.isTraining() && SafeGateExpand.count(SHUTTLE) < 2) {
                    agent.unit.build(SHUTTLE);
                }
                return true;
            }
            if (agent.unit.getType() == STARGATE) {
                if (SafeGateExpand.count(SCOUT) == 0 && !agent.unit.isTraining()) {
                    agent.unit.train(SCOUT);
                }
                return true;
            }
        }
        return false;
    }
}

