/*
 * Decompiled with CFR 0.152.
 */
package com.tyr.builds;

import bwapi.Game;
import bwapi.Player;
import bwapi.Position;
import bwapi.Race;
import bwapi.Unit;
import bwapi.UnitType;
import bwapi.UpgradeType;
import bwta.BWTA;
import com.tyr.EnemyManager;
import com.tyr.EnemyPosition;
import com.tyr.Settings;
import com.tyr.Tyr;
import com.tyr.UnitTracker;
import com.tyr.agents.Agent;
import com.tyr.agents.Attack;
import com.tyr.buildingplacement.SpaceManager;
import com.tyr.builds.CompositeBuildOrder;
import com.tyr.builds.ExpandPart;
import com.tyr.builds.WorkerScoutPart;
import com.tyr.requirements.ConjRequirement;
import com.tyr.requirements.CostRequirement;
import com.tyr.requirements.UnitRequirement;
import com.tyr.tasks.BuildAtLocationTask;
import com.tyr.tasks.ClearExpandsTask;
import com.tyr.tasks.ConstantPushTask;
import com.tyr.tasks.LocalDefenseTask;
import java.util.ArrayList;

public class DragoonPush
extends CompositeBuildOrder {
    private ConstantPushTask constantPushTask;
    private LocalDefenseTask localDefenseTask;
    private LocalDefenseTask thirdDefenseTask;
    private ClearExpandsTask clearExpandsTask;
    private boolean cannonDefense;
    private boolean earlyZealots;
    private boolean takeExpands;
    private boolean twoGateOpener;
    private boolean defensesInitialized;
    private boolean expandFirst = true;
    private boolean detectionNeeded;
    public boolean attackStarted;
    private boolean upgradeLegSpeed;
    private boolean clearExpands;
    private boolean buildReaver = false;
    private Race opponentRace = Race.Unknown;
    private int armySize = 25;
    private int retreatSize = 10;

    public DragoonPush(int armySize, boolean cannonDefense, boolean detectionNeeded, boolean earlyZealots, boolean takeExpands, boolean twoGateOpener, boolean clearExpands, boolean buildReaver) {
        this.armySize = armySize;
        this.cannonDefense = cannonDefense;
        this.defensesInitialized = !cannonDefense;
        this.detectionNeeded = detectionNeeded;
        this.earlyZealots = earlyZealots;
        this.takeExpands = takeExpands;
        this.twoGateOpener = twoGateOpener;
        this.clearExpands = clearExpands;
        this.buildReaver = buildReaver;
    }

    public DragoonPush(int armySize, int retreatSize, boolean cannonDefense, boolean detectionNeeded, boolean earlyZealots, boolean takeExpands, boolean twoGateOpener, boolean clearExpands, boolean buildReaver) {
        this.armySize = armySize;
        this.retreatSize = retreatSize;
        this.cannonDefense = cannonDefense;
        this.defensesInitialized = !cannonDefense;
        this.detectionNeeded = detectionNeeded;
        this.earlyZealots = earlyZealots;
        this.takeExpands = takeExpands;
        this.twoGateOpener = twoGateOpener;
        this.clearExpands = clearExpands;
        this.buildReaver = buildReaver;
    }

    @Override
    public void initialize(Game game, Player self, Tyr bot) {
        Settings.setRequiredSize(100);
        Settings.setMaximumSize(100);
        Settings.setMaximumWorkers(40);
        Settings.setSmallInvasionDist(480);
        Settings.setLargeInvasionDist(768);
        Settings.setWorkersPerGas(2);
        Attack.dontWaitAtCannon = true;
        this.add(new ExpandPart(true));
        if (game.mapFileName().contains("Alchemist")) {
            this.add(new WorkerScoutPart(100));
        } else {
            this.add(new WorkerScoutPart(1600));
        }
        ExpandPart.maximumCcs = 2;
        this.localDefenseTask = new LocalDefenseTask(BWTA.getRegion(self.getStartLocation()), 0);
        bot.taskManager.potentialTasks.add(this.localDefenseTask);
        this.thirdDefenseTask = new LocalDefenseTask(null, 0);
        bot.taskManager.potentialTasks.add(this.thirdDefenseTask);
        this.constantPushTask = new ConstantPushTask(null, 0);
        this.constantPushTask.stop = true;
        this.clearExpandsTask = new ClearExpandsTask();
        bot.taskManager.potentialTasks.add(this.clearExpandsTask);
        bot.taskManager.potentialTasks.add(this.constantPushTask);
        ConstantPushTask.prioritizeExpands = true;
        super.initialize(game, self, bot);
    }

    private Position getDefensivePosition() {
        Position location = SpaceManager.getNatural();
        if (location == null) {
            return null;
        }
        ArrayList<Position> minerals = new ArrayList<Position>();
        for (EnemyPosition neutralUnit : EnemyManager.getManager().neutralBuildingMemory) {
            if (!neutralUnit.type.isMineralField() || !(neutralUnit.pos.getDistance(location) <= 270.0)) continue;
            minerals.add(neutralUnit.pos);
        }
        return SpaceManager.getDefensePosPositions(location, minerals);
    }

    @Override
    public void onFrame(Game game, Player self, Tyr bot) {
        Position defensivePosition;
        super.onFrame(game, self, bot);
        if (this.opponentRace == Race.Unknown && this.opponentRace == Race.Unknown) {
            for (Unit unit : EnemyManager.getEnemyUnits()) {
                if (unit.getType().getRace() == Race.Zerg) {
                    this.opponentRace = Race.Zerg;
                } else if (unit.getType().getRace() == Race.Terran) {
                    this.opponentRace = Race.Terran;
                } else if (unit.getType().getRace() == Race.Protoss) {
                    this.opponentRace = Race.Protoss;
                }
                if (this.opponentRace != Race.Unknown) break;
            }
        }
        if (this.twoGateOpener && DragoonPush.count(ZEALOT) < 6) {
            Settings.setWorkersPerGas(3);
            if (self.supplyTotal() + UnitTracker.getSupplyConstructing() - self.supplyUsed() <= DragoonPush.count(GATEWAY) * 3 + UnitTracker.getCcCount() * 3 && DragoonPush.minerals() >= 100) {
                bot.spaceManager.build(PYLON);
            }
            if (DragoonPush.minerals() >= 150 && DragoonPush.count(GATEWAY) == 0 && DragoonPush.completed(PYLON) > 0) {
                bot.spaceManager.build(GATEWAY);
            }
            if (DragoonPush.minerals() >= 150 && DragoonPush.count(GATEWAY) < 2) {
                bot.spaceManager.build(GATEWAY);
            }
            return;
        }
        if (this.clearExpands) {
            if (DragoonPush.completed(ZEALOT) + DragoonPush.completed(DRAGOON) >= this.armySize + 1) {
                this.clearExpandsTask.setActive(true);
            }
            if (DragoonPush.completed(ZEALOT) + DragoonPush.completed(DRAGOON) <= this.armySize - 5) {
                this.clearExpandsTask.setActive(false);
            }
        }
        if (!this.defensesInitialized && game.getFrameCount() >= 100 && (defensivePosition = this.getDefensivePosition()) != null) {
            this.initializeDefenses(defensivePosition);
        }
        if (DragoonPush.gas() >= 400) {
            Settings.setWorkersPerGas(2);
        } else if (DragoonPush.gas() < 250 && DragoonPush.count(GATEWAY) >= 12 || DragoonPush.gas() + 400 < DragoonPush.minerals()) {
            Settings.setWorkersPerGas(3);
        }
        if (this.twoGateOpener && (self.getUpgradeLevel(UpgradeType.Leg_Enhancements) > 0 || EnemyManager.getManager().getEnemyTypes().contains(SCARAB))) {
            this.armySize = 20;
        }
        if (this.constantPushTask != null && DragoonPush.completed(ZEALOT) + DragoonPush.completed(DRAGOON) <= this.retreatSize) {
            this.constantPushTask.stop = true;
        }
        if (this.constantPushTask != null && DragoonPush.completed(ZEALOT) + DragoonPush.completed(DRAGOON) >= this.armySize) {
            this.constantPushTask.stop = false;
            this.attackStarted = true;
            this.localDefenseTask.setDefendersNeeded(3);
            if (this.takeExpands) {
                ExpandPart.maximumCcs = 100;
            }
            if (this.opponentRace == Race.Zerg || this.opponentRace == Race.Unknown) {
                this.detectionNeeded = true;
            }
        }
        if (this.thirdDefenseTask.getDefendersNeeded() == 0 && Tyr.bot.workForce.mineralWorkers.size() >= 3) {
            this.thirdDefenseTask.setDefendersNeeded(3);
            this.thirdDefenseTask.setDefendedPosition(Tyr.bot.workForce.mineralWorkers.get((int)2).resourceDepot.getPosition());
        }
        if (DragoonPush.completed(ZEALOT) + DragoonPush.completed(DRAGOON) >= 9) {
            this.upgradeLegSpeed = true;
        }
        if (EnemyManager.getManager().getEnemyTypes().contains(DARK_TEMPLAR) || EnemyManager.getManager().getEnemyTypes().contains(UnitType.Zerg_Lurker)) {
            this.detectionNeeded = true;
        }
        if (!(self.supplyTotal() + UnitTracker.getSupplyConstructing() - self.supplyUsed() > DragoonPush.count(GATEWAY) * 3 + UnitTracker.getCcCount() * 3 || DragoonPush.minerals() < 100 || self.supplyTotal() + UnitTracker.getSupplyConstructing() >= 400 || this.cannonDefense && DragoonPush.count(PYLON) <= 0)) {
            bot.spaceManager.build(PYLON);
        }
        if (!(DragoonPush.count(NEXUS) < 2 && this.expandFirst || DragoonPush.minerals() < 150 || DragoonPush.count(GATEWAY) != 0 || DragoonPush.completed(PYLON) <= 0 || DragoonPush.count(PYLON) <= 0)) {
            bot.spaceManager.build(GATEWAY);
        }
        if (!(DragoonPush.count(NEXUS) < 2 && this.expandFirst || DragoonPush.count(NEXUS) < 2 && DragoonPush.minerals() < 500 && this.expandFirst || DragoonPush.minerals() < 150 || DragoonPush.count(GATEWAY) >= 2 || DragoonPush.count(CYBERNETICS_CORE) <= 0)) {
            bot.spaceManager.build(GATEWAY);
        }
        if (!this.pauseProduction()) {
            if (!(DragoonPush.count(NEXUS) < 2 && this.expandFirst || DragoonPush.minerals() < 250 || DragoonPush.count(GATEWAY) >= 4 || DragoonPush.count(CYBERNETICS_CORE) <= 0)) {
                bot.spaceManager.build(GATEWAY);
            }
            if (DragoonPush.count(NEXUS) >= 2 && DragoonPush.minerals() >= 250 && DragoonPush.count(CYBERNETICS_CORE) > 0 && DragoonPush.count(GATEWAY) < 8) {
                bot.spaceManager.build(GATEWAY);
            }
            if (DragoonPush.count(NEXUS) >= 2 && DragoonPush.minerals() >= 150 && DragoonPush.completed(GATEWAY) >= 8 && DragoonPush.count(GATEWAY) < 12) {
                bot.spaceManager.build(GATEWAY);
            }
        }
        if (!(DragoonPush.minerals() < 100 || UnitTracker.getGeyserCount() <= 0 || DragoonPush.count(GATEWAY) <= 0 || DragoonPush.count(NEXUS) < 2 && this.expandFirst)) {
            bot.spaceManager.build(ASSIMILATOR);
        }
        if (!(DragoonPush.minerals() < 200 || DragoonPush.count(CYBERNETICS_CORE) >= 1 || DragoonPush.completed(GATEWAY) <= 0 || DragoonPush.count(NEXUS) < 2 && this.expandFirst)) {
            bot.spaceManager.build(CYBERNETICS_CORE);
        }
        if (DragoonPush.gas() >= 200 && DragoonPush.minerals() >= 200 && (DragoonPush.count(GATEWAY) >= 8 || this.detectionNeeded || this.buildReaver) && DragoonPush.count(ROBOTICS_FACILITY) == 0 && (DragoonPush.count(DRAGOON) >= 5 || this.buildReaver)) {
            bot.spaceManager.build(ROBOTICS_FACILITY);
        }
        if (DragoonPush.gas() >= 50 && DragoonPush.minerals() >= 100 && DragoonPush.completed(ROBOTICS_FACILITY) > 0 && DragoonPush.count(OBSERVATORY) == 0 && this.detectionNeeded) {
            bot.spaceManager.build(OBSERVATORY);
        }
        if (!(DragoonPush.minerals() < 150 || DragoonPush.count(FORGE) >= 2 || DragoonPush.count(DRAGOON) < 2 || this.buildReaver && DragoonPush.count(REAVER) <= 0)) {
            bot.spaceManager.build(FORGE);
        }
        if (this.upgradeLegSpeed && DragoonPush.minerals() >= 150 && DragoonPush.gas() >= 100 && DragoonPush.count(CITADEL) == 0 && DragoonPush.completed(CYBERNETICS_CORE) > 0 && DragoonPush.count(NEXUS) >= 2 && (!this.buildReaver || DragoonPush.count(REAVER) > 0)) {
            bot.spaceManager.build(CITADEL);
        }
        if (bot.getAvailableGas() >= 100 && bot.getAvailableMinerals() >= 150 && self.completedUnitCount(UnitType.Protoss_Robotics_Facility) > 0 && UnitTracker.count(UnitType.Protoss_Robotics_Support_Bay) == 0 && this.buildReaver) {
            bot.spaceManager.build(UnitType.Protoss_Robotics_Support_Bay);
        }
    }

    private void initializeDefenses(Position defensivePosition) {
        this.defensesInitialized = true;
        BuildAtLocationTask buildTask = new BuildAtLocationTask(defensivePosition, true);
        buildTask.addBuilding(PYLON, new UnitRequirement(PROBE, 7));
        buildTask.addBuilding(FORGE, new ConjRequirement().addRequirement(new UnitRequirement(PYLON, 1, true)).addRequirement(new CostRequirement(100, 0)));
        buildTask.addBuilding(CANNON, new ConjRequirement().addRequirement(new UnitRequirement(FORGE, 1, true)).addRequirement(new CostRequirement(150, 0)));
        if (this.earlyZealots) {
            buildTask.addBuilding(GATEWAY, new ConjRequirement().addRequirement(new CostRequirement(150, 0)));
        } else {
            buildTask.addBuilding(GATEWAY, new ConjRequirement().addRequirement(new CostRequirement(150, 0)).addRequirement(new UnitRequirement(NEXUS, 2, true)));
        }
        Tyr.bot.taskManager.potentialTasks.add(buildTask);
    }

    private boolean pauseProduction() {
        if (DragoonPush.gas() > 250 && DragoonPush.minerals() > 400) {
            return false;
        }
        if (this.upgradeLegSpeed && DragoonPush.count(CITADEL) == 0 && (!this.buildReaver || DragoonPush.count(REAVER) > 0)) {
            return true;
        }
        if (DragoonPush.completed(CITADEL) > 0 && !Tyr.self.isUpgrading(UpgradeType.Leg_Enhancements) && Tyr.self.getUpgradeLevel(UpgradeType.Leg_Enhancements) == 0) {
            return true;
        }
        if (this.detectionNeeded && DragoonPush.count(DRAGOON) >= 5 && DragoonPush.count(ROBOTICS_FACILITY) == 0) {
            return true;
        }
        if (this.buildReaver && DragoonPush.count(GATEWAY) >= 3 && DragoonPush.completed(CYBERNETICS_CORE) > 0 && DragoonPush.count(ROBOTICS_FACILITY) == 0 && DragoonPush.count(DRAGOON) >= 2) {
            return true;
        }
        if (this.buildReaver && DragoonPush.completed(ROBOTICS_FACILITY) > 0 && DragoonPush.count(ROBO_SUPPORT) == 0) {
            return true;
        }
        if (this.detectionNeeded && DragoonPush.count(DRAGOON) >= 5 && DragoonPush.completed(ROBOTICS_FACILITY) == 1 && DragoonPush.count(OBSERVATORY) == 0) {
            return true;
        }
        if (this.detectionNeeded && DragoonPush.count(DRAGOON) >= 5 && DragoonPush.completed(OBSERVATORY) == 1 && DragoonPush.count(OBSERVER) == 0) {
            return true;
        }
        if (this.buildReaver && DragoonPush.count(REAVER) == DragoonPush.completed(REAVER) && DragoonPush.count(REAVER) < 3 && DragoonPush.completed(ROBO_SUPPORT) > 0 && DragoonPush.completed(ROBOTICS_FACILITY) > 0) {
            return true;
        }
        return this.takeExpands && this.attackStarted && DragoonPush.count(NEXUS) < 3;
    }

    @Override
    public boolean overrideStructureOrder(Game game, Player self, Tyr bot, Agent agent) {
        if (agent.unit.getType() == GATEWAY && !agent.unit.isTraining()) {
            if (this.twoGateOpener && DragoonPush.count(ZEALOT) < 6 && DragoonPush.minerals() >= 100) {
                agent.unit.build(ZEALOT);
            }
            boolean pause = this.pauseProduction();
            if (this.earlyZealots && DragoonPush.completed(CYBERNETICS_CORE) == 0 && DragoonPush.minerals() >= 100) {
                agent.unit.build(ZEALOT);
            }
            if (!(DragoonPush.count(ZEALOT) >= DragoonPush.count(DRAGOON) - 5 || DragoonPush.minerals() < 100 || DragoonPush.minerals() < 400 && pause)) {
                agent.unit.build(ZEALOT);
            } else if (DragoonPush.minerals() >= 125 && DragoonPush.gas() >= 50 && (DragoonPush.minerals() >= 400 && DragoonPush.gas() > 200 || !pause)) {
                agent.unit.build(DRAGOON);
            }
            return true;
        }
        if (agent.unit.getType() == FORGE && !agent.unit.isUpgrading()) {
            if (DragoonPush.minerals() >= UpgradeType.Protoss_Ground_Weapons.mineralPrice() && DragoonPush.gas() >= UpgradeType.Protoss_Ground_Weapons.gasPrice()) {
                agent.unit.upgrade(UpgradeType.Protoss_Ground_Weapons);
            }
            if (DragoonPush.minerals() >= UpgradeType.Protoss_Ground_Armor.mineralPrice() && DragoonPush.gas() >= UpgradeType.Protoss_Ground_Armor.gasPrice()) {
                agent.unit.upgrade(UpgradeType.Protoss_Ground_Armor);
            }
        } else if (agent.unit.getType() == CYBERNETICS_CORE && !agent.unit.isUpgrading()) {
            if (!(DragoonPush.minerals() < UpgradeType.Singularity_Charge.mineralPrice() || DragoonPush.gas() < UpgradeType.Singularity_Charge.gasPrice() || this.buildReaver && DragoonPush.count(DRAGOON) <= 5)) {
                agent.unit.upgrade(UpgradeType.Singularity_Charge);
            }
        } else {
            if (agent.unit.getType() == ROBOTICS_FACILITY) {
                if (!(DragoonPush.count(OBSERVER) >= 2 || DragoonPush.completed(OBSERVATORY) <= 0 || DragoonPush.minerals() < 25 || DragoonPush.gas() < 75 || agent.unit.isTraining() || this.buildReaver && DragoonPush.count(REAVER) <= 0)) {
                    agent.unit.build(OBSERVER);
                } else if (!agent.unit.isTraining() && bot.getAvailableMinerals() >= 200 && bot.getAvailableGas() >= 100 && this.buildReaver) {
                    agent.unit.build(UnitType.Protoss_Reaver);
                }
                return true;
            }
            if (agent.unit.getType() == CITADEL && !agent.unit.isUpgrading() && DragoonPush.gas() >= UpgradeType.Leg_Enhancements.gasPrice() && DragoonPush.minerals() >= UpgradeType.Leg_Enhancements.mineralPrice()) {
                agent.unit.upgrade(UpgradeType.Leg_Enhancements);
            }
        }
        return false;
    }
}

