/*
 * Decompiled with CFR 0.152.
 */
package com.tyr.buildingplacement;

import bwapi.Color;
import bwapi.Position;
import bwapi.TilePosition;
import bwapi.Unit;
import bwapi.UnitType;
import com.tyr.BWTAProxy;
import com.tyr.Tyr;
import com.tyr.agents.Agent;
import com.tyr.buildingplacement.BuildCommand;
import com.tyr.buildingplacement.BuildSiteLocator;
import com.tyr.buildingplacement.DefaultBuildSite;
import com.tyr.buildingplacement.SpaceManager;
import com.tyr.unitgroups.MineralWorkers;

public class TurretBuildSite
extends BuildSiteLocator {
    public TilePosition[] turretPositions = new TilePosition[2];
    public MineralWorkers base;

    public TurretBuildSite(MineralWorkers base) {
        this.base = base;
        this.getTurretPositions();
    }

    @Override
    public TilePosition findPlacement(UnitType building, TilePosition preferredTile, Agent worker) {
        if (building != UnitType.Terran_Missile_Turret) {
            return null;
        }
        if (!BWTAProxy.initialized) {
            return null;
        }
        TilePosition[] tilePositionArray = this.turretPositions;
        int n = this.turretPositions.length;
        int n2 = 0;
        while (n2 < n) {
            TilePosition pos = tilePositionArray[n2];
            if (pos != null && SpaceManager.canBuildHere(worker.unit, pos.getX(), pos.getY(), building, false, true, true)) {
                for (BuildCommand com : Tyr.bot.buildCommands) {
                    if (com.building == UnitType.Terran_Missile_Turret && (com.position.getX() != pos.getX() || com.position.getY() != pos.getY()) && (pos.getX() - com.position.getX()) * (pos.getX() - com.position.getX()) + (pos.getY() - com.position.getY()) * (pos.getY() - com.position.getY()) > 4) continue;
                }
                return pos;
            }
            ++n2;
        }
        return null;
    }

    private void getTurretPositions() {
        int y;
        boolean success;
        TilePosition temp;
        Agent worker;
        if (this.turretPositions[0] != null) {
            Tyr.game.drawBoxMap(this.turretPositions[0].getX() * 32, this.turretPositions[0].getY() * 32, this.turretPositions[0].getX() * 32 + 64, this.turretPositions[0].getY() * 32 + 64, Color.Orange);
            Tyr.game.drawBoxMap(this.turretPositions[1].getX() * 32, this.turretPositions[1].getY() * 32, this.turretPositions[1].getX() * 32 + 64, this.turretPositions[1].getY() * 32 + 64, Color.Orange);
            return;
        }
        Position avg = new Position(0, 0);
        for (Unit mineral : this.base.minerals) {
            avg = new Position(avg.getX() + mineral.getX(), avg.getY() + mineral.getY());
        }
        int count = this.base.minerals.size();
        if (this.base.gasWorkers != null && this.base.gasWorkers.geyser != null) {
            avg = new Position(avg.getX() + this.base.gasWorkers.geyser.getX() * 2, avg.getY() + this.base.gasWorkers.geyser.getY() * 2);
            count += 2;
        }
        avg = new Position(avg.getX() / count, avg.getY() / count);
        Position mid = this.base.resourceDepot.getPosition();
        Position dir = new Position(mid.getX() - avg.getX(), mid.getY() - avg.getY());
        int length = (int)Math.sqrt(dir.getX() * dir.getX() + dir.getY() * dir.getY());
        Position p1 = Tyr.tileToPosition(Tyr.positionToTile(new Position(mid.getX() + dir.getY() * 150 / length, mid.getY() - dir.getX() * 150 / length)));
        Position p2 = Tyr.tileToPosition(Tyr.positionToTile(new Position(mid.getX() - dir.getY() * 150 / length, mid.getY() + dir.getX() * 150 / length)));
        int i = 0;
        while (i < 6) {
            Position newp1;
            if (i == 5) {
                worker = Tyr.bot.workForce.pop();
                if (worker == null) break;
                p1 = Tyr.tileToPosition(new DefaultBuildSite().findPlacement(UnitType.Terran_Missile_Turret, Tyr.positionToTile(p1), worker));
                Tyr.bot.workForce.add(worker);
                break;
            }
            temp = Tyr.positionToTile(p1);
            success = true;
            int x = 0;
            while (success && x < 2) {
                y = 0;
                while (success && y < 2) {
                    if (temp.getX() + x >= Tyr.bot.spaceManager.map.length || temp.getY() + y >= Tyr.bot.spaceManager.map[0].length) {
                        success = false;
                        System.out.println("p1 incorrect: " + temp.getX() + ", " + temp.getY());
                    } else if (Tyr.bot.spaceManager.map[temp.getX() + x][temp.getY() + y] != 1) {
                        success = false;
                    }
                    ++y;
                }
                ++x;
            }
            if (success || (temp = Tyr.positionToTile(newp1 = Tyr.tileToPosition(Tyr.positionToTile(new Position(mid.getX() + dir.getY() * 150 / length + dir.getX() * 32 * (i + 1) / length, mid.getY() - dir.getX() * 150 / length + dir.getY() * 32 * (i + 1) / length))))).getX() < 0 || temp.getX() >= Tyr.game.mapWidth() - 2 || temp.getY() < 0 || temp.getY() >= Tyr.game.mapHeight() - 2) break;
            p1 = newp1;
            ++i;
        }
        i = 0;
        while (i < 6) {
            Position newp2;
            if (i == 5) {
                worker = Tyr.bot.workForce.pop();
                if (worker == null) break;
                p2 = Tyr.tileToPosition(new DefaultBuildSite().findPlacement(UnitType.Terran_Missile_Turret, Tyr.positionToTile(p2), worker));
                Tyr.bot.workForce.add(worker);
                break;
            }
            temp = Tyr.positionToTile(p2);
            success = true;
            int x = 0;
            while (success && x < 2) {
                y = 0;
                while (success && y < 2) {
                    if (temp.getX() + x >= Tyr.bot.spaceManager.map.length || temp.getY() + y >= Tyr.bot.spaceManager.map[0].length) {
                        success = false;
                        System.out.println("p2 incorrect: " + temp.getX() + ", " + temp.getY());
                    } else if (Tyr.bot.spaceManager.map[temp.getX() + x][temp.getY() + y] != 1) {
                        success = false;
                    }
                    ++y;
                }
                ++x;
            }
            if (success || (temp = Tyr.positionToTile(newp2 = Tyr.tileToPosition(Tyr.positionToTile(new Position(mid.getX() - dir.getY() * 150 / length + dir.getX() * 32 * (i + 1) / length, mid.getY() + dir.getX() * 150 / length + dir.getY() * 32 * (i + 1) / length))))).getX() < 0 || temp.getX() >= Tyr.game.mapWidth() - 2 || temp.getY() < 0 || temp.getY() >= Tyr.game.mapHeight() - 2) break;
            p2 = newp2;
            ++i;
        }
        this.turretPositions[0] = Tyr.positionToTile(p1);
        this.turretPositions[1] = Tyr.positionToTile(p2);
    }

    @Override
    public boolean alreadyReserved() {
        return true;
    }
}

