/*
 * Decompiled with CFR 0.152.
 */
package com.tyr.agents;

import bwapi.Color;
import bwapi.Game;
import bwapi.Player;
import bwapi.Position;
import bwapi.Unit;
import bwapi.UnitType;
import com.tyr.Tyr;
import com.tyr.agents.Agent;
import com.tyr.agents.Command;

public class DefensiveTank
extends Command {
    public Position target;
    public Agent moveAwayTarget;
    boolean sieged = false;
    private static final int maxDist = 16;
    boolean unblockExit = false;

    public DefensiveTank(Agent agent, Position target) {
        super(agent);
        this.target = target;
    }

    @Override
    public void execute(Game game, Player self, Tyr bot) {
        this.agent.drawCircle(Color.Purple);
        game.drawBoxMap(this.target.getX() - 16, this.target.getY() - 16, this.target.getX() + 16, this.target.getY() + 16, Color.Purple);
        boolean inRange = false;
        for (Unit unit : game.getUnitsInRadius(this.agent.unit.getPosition(), UnitType.Terran_Siege_Tank_Siege_Mode.groundWeapon().maxRange())) {
            if (!unit.getPlayer().isEnemy(self) || unit.isLifted() || unit.getType().isFlyer()) continue;
            inRange = true;
            break;
        }
        if (this.agent.unit.getType() == UnitType.Terran_Siege_Tank_Tank_Mode) {
            if (inRange || this.target != null && this.agent.distanceSquared(this.target) <= 256) {
                this.agent.unit.siege();
            } else if (this.target != null) {
                this.agent.unit.attack(this.target);
            }
        } else if (this.agent.unit.getType() == UnitType.Terran_Siege_Tank_Siege_Mode && !inRange && this.target != null && this.agent.distanceSquared(this.target) > 256) {
            this.agent.unit.unsiege();
        }
    }

    @Override
    public boolean replace(Command command) {
        if (!command.getClass().equals(DefensiveTank.class)) {
            return true;
        }
        if (this.target == null) {
            return false;
        }
        if (((DefensiveTank)command).target == null) {
            return true;
        }
        return ((DefensiveTank)command).target.getX() != this.target.getX() || ((DefensiveTank)command).target.getY() != this.target.getY();
    }
}

