/*
 * Decompiled with CFR 0.152.
 */
package com.tyr.agents;

import bwapi.Color;
import bwapi.Game;
import bwapi.Order;
import bwapi.Player;
import bwapi.Position;
import bwapi.Unit;
import bwapi.UnitType;
import com.tyr.BWTAProxy;
import com.tyr.EnemyManager;
import com.tyr.Tyr;
import com.tyr.agents.Agent;
import com.tyr.agents.Command;
import java.util.List;

public class Defend
extends Command {
    private Position target;
    private Unit killTarget;

    public Defend(Agent agent, Position target) {
        super(agent);
        this.target = target;
    }

    @Override
    public void execute(Game game, Player self, Tyr bot) {
        this.agent.drawCircle(Color.Green);
        if (this.agent.unit.getType() == UnitType.Terran_Siege_Tank_Siege_Mode || this.agent.unit.getType() == UnitType.Terran_Siege_Tank_Tank_Mode) {
            int radius = UnitType.Terran_Siege_Tank_Siege_Mode.groundWeapon().maxRange();
            boolean found = false;
            for (Unit unit : EnemyManager.getEnemyUnits()) {
                if (unit.getType().isFlyer() || unit.isLifted() || this.agent.distanceSquared(unit) > radius * radius) continue;
                found = true;
                break;
            }
            if (this.agent.unit.getType() == UnitType.Terran_Siege_Tank_Siege_Mode) {
                if (!found) {
                    this.agent.unit.unsiege();
                    return;
                }
            } else if (this.agent.unit.getType() == UnitType.Terran_Siege_Tank_Tank_Mode && found) {
                this.agent.unit.siege();
                return;
            }
        }
        if (bot.wallOff != null && bot.wallOff.wall.size() > 1 && BWTAProxy.initialized && BWTAProxy.getRegion(EnemyManager.getManager().getInvader().getPosition()) != BWTAProxy.getRegion(self.getStartLocation()) && this.agent.distanceSquared(this.target) <= 65536 && this.agent.unit.getOrder() != Order.HoldPosition) {
            this.agent.unit.holdPosition();
        }
        if (this.killTarget == null) {
            List<Unit> inRange = game.getUnitsInRadius(this.agent.unit.getPosition(), this.agent.unit.getType().groundWeapon().maxRange());
            for (Unit unit : inRange) {
                if (!unit.getPlayer().isEnemy(self) || unit.getType() == UnitType.Protoss_Observer) continue;
                this.killTarget = unit;
                break;
            }
        }
        if (this.killTarget != null) {
            boolean targetFlies = this.killTarget.getType().isFlyer() || this.killTarget.isLifted();
            int maxRangeSq = targetFlies ? this.agent.unit.getType().airWeapon().maxRange() : this.agent.unit.getType().groundWeapon().maxRange();
            maxRangeSq *= maxRangeSq;
            if (this.agent.distanceSquared(this.killTarget) >= maxRangeSq) {
                this.killTarget = null;
            } else {
                int n;
                game.drawLineMap(this.agent.unit.getX(), this.agent.unit.getY(), this.killTarget.getX(), this.killTarget.getY(), Color.Red);
                int n2 = n = targetFlies ? this.agent.unit.getAirWeaponCooldown() : this.agent.unit.getGroundWeaponCooldown();
                if (n == 0) {
                    if (this.agent.unit.getOrder() != Order.AttackUnit) {
                        this.agent.unit.attack(this.killTarget);
                    }
                } else {
                    Position fleeTarget = this.agent.retreatTarget(this.killTarget.getPosition(), 32.0);
                    this.agent.unit.move(fleeTarget);
                }
                return;
            }
        }
        if (EnemyManager.getManager().getInvader() != null) {
            Position orderTarget = this.agent.unit.getOrderTargetPosition();
            if (this.agent.unit.isIdle() || this.killTarget != null && (Math.abs(orderTarget.getX() - this.target.getX()) >= 128 || Math.abs(orderTarget.getY() - this.target.getY()) >= 128) || this.killTarget != null && (this.agent.unit.getGroundWeaponCooldown() == 1 || this.agent.unit.getAirWeaponCooldown() == 1)) {
                this.agent.unit.attack(EnemyManager.getManager().getInvader().getPosition());
            }
        } else if (this.agent.unit.getOrder() == Order.Move || this.agent.unit.isIdle()) {
            this.agent.unit.attack(this.target);
        }
    }

    @Override
    public boolean replace(Command command) {
        if (!command.getClass().equals(Defend.class)) {
            return true;
        }
        return ((Defend)command).target.getX() == this.target.getX() && ((Defend)command).target.getY() == this.target.getY();
    }
}

