/*
 * Decompiled with CFR 0.152.
 */
package com.tyr.agents;

import bwapi.Color;
import bwapi.Game;
import bwapi.Player;
import bwapi.Position;
import bwapi.TechType;
import bwapi.Unit;
import bwapi.UnitType;
import com.tyr.DebugMessages;
import com.tyr.EnemyManager;
import com.tyr.EnemyPosition;
import com.tyr.Tyr;
import com.tyr.agents.Agent;
import com.tyr.agents.Command;
import com.tyr.unitgroups.ScoutGroup;

public class Attack
extends Command {
    private Position target;
    private static int waitFrame;
    public static int requiredAtCannon;
    private static int waitingAtCannon;
    private static int waitingAtCannonPrev;
    private boolean moveCloser;
    public int siegeFrame = -1000000;
    public static boolean dontWaitAtCannon;

    static {
        requiredAtCannon = 10;
        dontWaitAtCannon = false;
    }

    public Attack(Agent agent, Position target) {
        super(agent);
        this.target = target;
    }

    public Attack(Agent agent, Position target, boolean moveCloser) {
        super(agent);
        this.target = target;
        this.moveCloser = moveCloser;
    }

    @Override
    public void execute(Game game, Player self, Tyr bot) {
        this.agent.drawCircle(Color.Red);
        if (waitFrame != game.getFrameCount()) {
            waitingAtCannonPrev = waitingAtCannon;
            DebugMessages.addMessage("Waiting at cannon: " + waitingAtCannon);
            waitingAtCannon = 0;
            waitFrame = game.getFrameCount();
        }
        boolean inrange = false;
        boolean proceed = bot.scout.opponentStrategy != ScoutGroup.cannons && waitingAtCannonPrev >= requiredAtCannon || this.agent.unit.getType() == UnitType.Terran_Siege_Tank_Siege_Mode || this.agent.unit.getType() == UnitType.Terran_Siege_Tank_Tank_Mode || this.agent.unit.getType() == UnitType.Protoss_Dark_Templar || dontWaitAtCannon;
        int dist = UnitType.Terran_Siege_Tank_Siege_Mode.sightRange() + 64;
        int smallDist = UnitType.Terran_Siege_Tank_Siege_Mode.sightRange() - 32;
        if (bot.scout.opponentStrategy != ScoutGroup.cannons) {
            smallDist += 32;
        }
        for (EnemyPosition enemy : EnemyManager.getManager().enemyDefensiveStructures) {
            if (this.agent.unit.getType() == UnitType.Terran_Battlecruiser) break;
            if (enemy.type != UnitType.Protoss_Photon_Cannon || Math.abs(this.agent.unit.getX() - enemy.pos.getX()) > dist || Math.abs(this.agent.unit.getY() - enemy.pos.getY()) > dist || this.agent.distanceSquared(enemy.pos) > dist * dist) continue;
            inrange = this.agent.distanceSquared(enemy.pos) <= smallDist * smallDist;
            ++waitingAtCannon;
            break;
        }
        if (inrange && !this.agent.unit.isHoldingPosition() && !proceed) {
            this.agent.unit.holdPosition();
        } else if (proceed || !inrange) {
            this.attack();
        } else {
            Tyr.drawCircle(this.agent.unit.getPosition(), Color.Blue, 6);
        }
    }

    private void attack() {
        if (!Agent.isRanged(this.agent.unit)) {
            this.agent.orderAttack(this.target);
            return;
        }
        if (this.agent.unit.getType() == UnitType.Terran_Siege_Tank_Tank_Mode) {
            if (!Tyr.self.hasResearched(TechType.Tank_Siege_Mode)) {
                if (!this.agent.unit.isHoldingPosition()) {
                    this.agent.unit.holdPosition();
                }
                this.agent.drawCircle(Color.Green, 12);
                return;
            }
            int radius = UnitType.Terran_Siege_Tank_Siege_Mode.groundWeapon().maxRange();
            int minRadius = UnitType.Terran_Siege_Tank_Siege_Mode.groundWeapon().minRange();
            if (Tyr.self.hasResearched(TechType.Tank_Siege_Mode)) {
                for (Unit unit : EnemyManager.getEnemyUnits()) {
                    if (unit.getType().isFlyer() || unit.isLifted() || unit.isCloaked() || this.agent.distanceSquared(unit) >= minRadius * minRadius || unit.getType() == UnitType.Protoss_Scarab || Agent.isRanged(unit) && this.agent.unit.getType() != UnitType.Zerg_Lurker) continue;
                    this.agent.stutterstep(this.target, this.moveCloser);
                    return;
                }
            }
            for (Unit unit : EnemyManager.getEnemyUnits()) {
                if (unit.getType().isFlyer() || unit.isLifted() || unit.isCloaked() || this.agent.distanceSquared(unit) <= minRadius * minRadius || unit.getType() == UnitType.Protoss_Scarab || !Agent.isRanged(unit) || this.agent.unit.getType() == UnitType.Zerg_Lurker || this.agent.distanceSquared(unit) > radius * radius) continue;
                Tyr.game.drawLineMap(this.agent.unit.getX(), this.agent.unit.getY(), unit.getX(), unit.getY(), Color.Red);
                this.siegeFrame = Tyr.game.getFrameCount();
                if (Tyr.self.hasResearched(TechType.Tank_Siege_Mode)) {
                    this.agent.unit.siege();
                } else if (this.agent.unit.isMoving() || this.agent.unit.isAttacking()) {
                    this.agent.unit.stop();
                }
                this.agent.drawCircle(Color.Red, 6);
                return;
            }
            if (Tyr.self.hasResearched(TechType.Tank_Siege_Mode)) {
                this.agent.stutterstep(this.target, this.moveCloser);
            }
            return;
        }
        if (this.agent.unit.getType() == UnitType.Terran_Siege_Tank_Siege_Mode) {
            int radius = UnitType.Terran_Siege_Tank_Siege_Mode.groundWeapon().maxRange();
            int minRadius = UnitType.Terran_Siege_Tank_Siege_Mode.groundWeapon().minRange();
            for (Unit unit : EnemyManager.getEnemyUnits()) {
                if (unit.getType().isFlyer() || unit.isLifted() || unit.isCloaked() || this.agent.distanceSquared(unit) >= (minRadius - 96) * (minRadius - 96) || unit.getType() == UnitType.Protoss_Scarab || Agent.isRanged(unit) && this.agent.unit.getType() != UnitType.Zerg_Lurker) continue;
                this.agent.drawCircle(Color.White, 6);
                this.agent.unit.unsiege();
                return;
            }
            for (Unit unit : EnemyManager.getEnemyUnits()) {
                if (unit.getType().isFlyer() || unit.isLifted() || unit.isCloaked() || this.agent.distanceSquared(unit) <= minRadius * minRadius || unit.getType() == UnitType.Protoss_Scarab || !Agent.isRanged(unit) || this.agent.unit.getType() == UnitType.Zerg_Lurker || this.agent.distanceSquared(unit) > radius * radius) continue;
                Tyr.game.drawLineMap(this.agent.unit.getX(), this.agent.unit.getY(), unit.getX(), unit.getY(), Color.Red);
                this.agent.drawCircle(Color.Red, 6);
                Unit currentTarget = this.agent.unit.getTarget();
                this.siegeFrame = Tyr.game.getFrameCount();
                if (this.agent.unit.isIdle() || !this.agent.unit.isAttackFrame() && !this.agent.unit.isAttacking() || currentTarget != null && !Agent.isRanged(currentTarget)) {
                    this.agent.unit.attack(unit);
                }
                return;
            }
            if (Tyr.game.getFrameCount() - this.siegeFrame >= 250) {
                this.agent.drawCircle(Color.White, 6);
                this.agent.unit.unsiege();
            } else {
                this.agent.drawCircle(Color.Green, 6);
            }
            return;
        }
        this.agent.stutterstep(this.target, this.moveCloser);
    }

    @Override
    public boolean replace(Command command) {
        if (!command.getClass().equals(Attack.class)) {
            return true;
        }
        Attack atkCom = (Attack)command;
        if (atkCom.target == null) {
            return true;
        }
        if (this.target == null) {
            return false;
        }
        atkCom.moveCloser = this.moveCloser;
        if (this.target.getX() == atkCom.target.getX() && this.target.getY() == atkCom.target.getY()) {
            return false;
        }
        atkCom.target = this.target;
        this.attack();
        return false;
    }
}

