/*
 * Decompiled with CFR 0.152.
 */
package com.tyr;

import bwapi.Color;
import bwapi.Player;
import bwapi.Position;
import bwapi.Race;
import bwapi.Unit;
import bwapi.UnitType;
import bwapi.WeaponType;
import bwta.BaseLocation;
import com.tyr.BWTAProxy;
import com.tyr.DebugMessages;
import com.tyr.EnemyPosition;
import com.tyr.PositionUtil;
import com.tyr.Settings;
import com.tyr.Tyr;
import com.tyr.buildingplacement.BuildCommand;
import com.tyr.buildingplacement.DefensiveStructures;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class EnemyManager {
    private static EnemyManager manager;
    private ArrayList<Position> orderedExpands;
    private int selfPos = -1;
    private Unit invader;
    private Unit flyingInvader;
    private Unit invadingWorker;
    private int invaderCount;
    private int flyingInvaderCount;
    private int invadingWorkerCount;
    private int invaderUpdatedFrame;
    public HashSet<EnemyPosition> enemyBuildingMemory = new HashSet();
    public HashSet<EnemyPosition> neutralBuildingMemory = new HashSet();
    public ArrayList<EnemyPosition> enemyDefensiveStructures;
    private static int enemyUnitsUpdatedFrame;
    private static ArrayList<Unit> enemyUnits;
    private boolean isInvaderWorker;
    private HashMap<Integer, Integer> lastAttackFrame = new HashMap();
    private HashMap<Integer, Position> lastKnownPosition = new HashMap();
    private HashMap<Integer, UnitType> enemyTypeMap = new HashMap();
    private HashMap<UnitType, Integer> allEnemyCount = new HashMap();

    static {
        enemyUnitsUpdatedFrame = -1;
        enemyUnits = new ArrayList();
    }

    public static EnemyManager getManager() {
        if (manager == null) {
            manager = new EnemyManager();
        }
        return manager;
    }

    public ArrayList<Position> getOrderedExpands() {
        if (this.orderedExpands == null) {
            this.initializeOrderedExpands();
        }
        return this.orderedExpands;
    }

    public int getSelfPos() {
        if (this.orderedExpands == null) {
            this.initializeOrderedExpands();
        }
        return this.selfPos;
    }

    private void initializeOrderedExpands() {
        if (!BWTAProxy.initialized) {
            return;
        }
        Tyr bot = Tyr.bot;
        if (bot.suspectedEnemy.size() != 1) {
            return;
        }
        this.orderedExpands = new ArrayList();
        ArrayList<Position> positions = new ArrayList<Position>();
        HashMap<Position, Double> projection = new HashMap<Position, Double>();
        for (BaseLocation b : bot.expands) {
            if (b.getPosition().getDistance(Tyr.tileToPosition(Tyr.self.getStartLocation())) <= 100.0) continue;
            positions.add(b.getPosition());
            projection.put(b.getPosition(), this.projectToBorder(b.getPosition()));
        }
        double selfProjection = this.projectToBorder(Tyr.tileToPosition(Tyr.self.getStartLocation()));
        double enemyProjection = this.projectToBorder(bot.suspectedEnemy.get(0).getPosition());
        positions.add(bot.suspectedEnemy.get(0).getPosition());
        projection.put(bot.suspectedEnemy.get(0).getPosition(), enemyProjection);
        positions.add(Tyr.tileToPosition(Tyr.self.getStartLocation()));
        projection.put(Tyr.tileToPosition(Tyr.self.getStartLocation()), selfProjection);
        boolean changes = true;
        while (changes) {
            changes = false;
            int i = 0;
            while (i < positions.size() - 1) {
                double p1 = (Double)projection.get(positions.get(i));
                double p2 = (Double)projection.get(positions.get(i + 1));
                if ((!(p1 > selfProjection) || !(p2 < selfProjection)) && (p2 > selfProjection && p1 < selfProjection || (Double)projection.get(positions.get(i)) > (Double)projection.get(positions.get(i + 1)))) {
                    Position temp = (Position)positions.get(i);
                    positions.set(i, (Position)positions.get(i + 1));
                    positions.set(i + 1, temp);
                    changes = true;
                }
                ++i;
            }
        }
        int pos = 0;
        while (pos < positions.size() && (Double)projection.get(positions.get(pos)) != enemyProjection) {
            ++pos;
        }
        int enemyPos = pos++;
        while (pos < positions.size()) {
            this.orderedExpands.add((Position)positions.get(pos));
            ++pos;
        }
        pos = 0;
        while (pos < enemyPos) {
            this.orderedExpands.add((Position)positions.get(pos));
            ++pos;
        }
        pos = 0;
        while (pos < this.orderedExpands.size()) {
            if (this.orderedExpands.get(pos).getDistance(Tyr.tileToPosition(Tyr.self.getStartLocation())) <= 100.0) {
                this.selfPos = pos;
                break;
            }
            ++pos;
        }
    }

    public boolean orderBases(List<BaseLocation> bases) {
        if (bases.size() <= 1) {
            return true;
        }
        if (!BWTAProxy.initialized) {
            return false;
        }
        HashMap<Position, Double> projection = new HashMap<Position, Double>();
        for (BaseLocation b : bases) {
            projection.put(b.getPosition(), this.projectToBorder(b.getPosition()));
        }
        double selfProjection = this.projectToBorder(Tyr.getStartLocation());
        projection.put(Tyr.getStartLocation(), selfProjection);
        boolean changes = true;
        while (changes) {
            changes = false;
            int i = 0;
            while (i < bases.size() - 1) {
                double p1 = (Double)projection.get(bases.get(i).getPosition());
                double p2 = (Double)projection.get(bases.get(i + 1).getPosition());
                if ((!(p1 > selfProjection) || !(p2 < selfProjection)) && (p2 > selfProjection && p1 < selfProjection || (Double)projection.get(bases.get(i).getPosition()) > (Double)projection.get(bases.get(i + 1).getPosition()))) {
                    BaseLocation temp = bases.get(i);
                    bases.set(i, bases.get(i + 1));
                    bases.set(i + 1, temp);
                    changes = true;
                }
                ++i;
            }
        }
        for (BaseLocation loc : bases) {
            DebugMessages.log("(" + loc.getPosition().getX() + ", " + loc.getPosition().getY() + "): " + projection.get(loc.getPosition()));
        }
        DebugMessages.log("(" + Tyr.getStartLocation().getX() + ", " + Tyr.getStartLocation().getY() + "): " + selfProjection);
        return true;
    }

    private double projectToBorder(Position p) {
        int width = Tyr.game.mapWidth() * 32;
        int height = Tyr.game.mapHeight() * 32;
        int xd1 = p.getX();
        int xd2 = width - p.getX();
        int yd1 = p.getY();
        int yd2 = height - p.getY();
        if (Math.min(xd1, xd2) < Math.min(yd1, yd2)) {
            if (xd1 < xd2) {
                return 0.5 + (double)yd1 / 4.0 / (double)height;
            }
            return (double)yd2 / 4.0 / (double)height;
        }
        if (yd1 < yd2) {
            return 0.25 + (double)xd2 / 4.0 / (double)width;
        }
        return 0.75 + (double)xd1 / 4.0 / (double)width;
    }

    public Unit getInvader() {
        this.updateInvader();
        return this.invader;
    }

    public Unit getInvadingWorker() {
        this.updateInvader();
        return this.invadingWorker;
    }

    public Unit getFlyingInvader() {
        this.updateInvader();
        return this.flyingInvader;
    }

    public int getInvaderCount() {
        this.updateInvader();
        return this.invaderCount;
    }

    public int getFlyingInvaderCount() {
        this.updateInvader();
        return this.flyingInvaderCount;
    }

    public int getInvadingWorkerCount() {
        this.updateInvader();
        return this.invadingWorkerCount;
    }

    public boolean isInvaderWorker() {
        this.updateInvader();
        return this.isInvaderWorker;
    }

    public int getLastAttackFrame(Unit unit) {
        if (!this.lastAttackFrame.containsKey(unit.getID())) {
            return -1000000;
        }
        return this.lastAttackFrame.get(unit.getID());
    }

    public Position getLastPosition(Unit unit) {
        if (!this.lastKnownPosition.containsKey(unit.getID())) {
            return null;
        }
        return this.lastKnownPosition.get(unit.getID());
    }

    public int getAllCount(UnitType type) {
        if (this.allEnemyCount.containsKey(type)) {
            return this.allEnemyCount.get(type);
        }
        return 0;
    }

    private void updateInvader() {
        int frame = Tyr.game.getFrameCount();
        if (this.invaderUpdatedFrame == frame) {
            return;
        }
        this.invaderUpdatedFrame = frame;
        this.isInvaderWorker = true;
        this.invaderCount = 0;
        this.flyingInvaderCount = 0;
        this.invadingWorkerCount = 0;
        this.invader = null;
        this.invadingWorker = null;
        this.flyingInvader = null;
        Position start = Tyr.tileToPosition(Tyr.self.getStartLocation());
        Tyr.drawCircle(start, Color.Cyan, Settings.getLargeInvasionDist());
        Tyr.drawCircle(start, Color.Cyan, Settings.getDefendExpandDist());
        HashSet<Unit> invadingEnemies = new HashSet<Unit>();
        for (Unit u : EnemyManager.getEnemyUnits()) {
            if (u.getType() == UnitType.Protoss_Observer || u.isCloaked() && !u.isDetected() || Tyr.self.getRace() == Race.Protoss && !u.isDetected() && (u.getType() == UnitType.Protoss_Dark_Templar || u.isBurrowed())) continue;
            double uDist = u.getDistance(start.getX(), start.getY());
            if (!Settings.getDefendStart() || !(uDist <= (double)Settings.getLargeInvasionDist())) continue;
            if (!u.getType().isWorker() && u.getType() != UnitType.Zerg_Overlord && u.getType() != UnitType.Protoss_Observer) {
                this.isInvaderWorker = false;
            }
            if (u.getType().isFlyer() || u.isLifted()) {
                if (this.flyingInvader == null || uDist < this.flyingInvader.getDistance(start.getX(), start.getY())) {
                    this.flyingInvader = u;
                }
                ++this.flyingInvaderCount;
            }
            if (u.getType() == UnitType.Protoss_Shuttle || u.getType() == UnitType.Terran_Dropship || !u.getType().isFlyer() && !u.isLifted()) {
                if (this.invader == null) {
                    this.invader = u;
                } else if (this.invader.getType().isWorker() && !u.getType().isWorker()) {
                    this.invader = u;
                } else if ((!u.getType().isWorker() || this.invader.getType().isWorker()) && uDist < this.invader.getDistance(start.getX(), start.getY())) {
                    this.invader = u;
                }
            }
            if (u.getType().isWorker()) {
                ++this.invadingWorkerCount;
            }
            if (this.invadingWorker == null || uDist < this.invadingWorker.getDistance(start.getX(), start.getY())) {
                this.invadingWorker = u;
            }
            ++this.invaderCount;
            invadingEnemies.add(u);
        }
        ArrayList<Position> needsDefending = new ArrayList<Position>();
        for (DefensiveStructures structures : Tyr.bot.defensiveStructures) {
            double distance;
            if (structures.disabled || !Settings.getDefendStart() && structures.defendedPosition.getDistance(Tyr.tileToPosition(Tyr.self.getStartLocation())) <= 100.0 || !((distance = structures.defendedPosition.getDistance(start)) < (double)Settings.getDefendExpandDist()) || !(distance > (double)(Settings.getLargeInvasionDist() - Settings.getSmallInvasionDist()))) continue;
            needsDefending.add(structures.defendedPosition);
            Tyr.drawCircle(structures.defendedPosition, Color.Cyan, Settings.getSmallInvasionDist());
        }
        for (BuildCommand command : Tyr.bot.buildCommands) {
            if (!command.building.isResourceDepot()) continue;
            Position pos = command.getCenter();
            double distance = PositionUtil.distanceSq(pos, start);
            if (!Settings.getDefendStart() && distance <= 10000.0 || !(distance < (double)(Settings.getDefendExpandDist() * Settings.getDefendExpandDist())) || !(distance > (double)((Settings.getLargeInvasionDist() - Settings.getSmallInvasionDist()) * (Settings.getLargeInvasionDist() - Settings.getSmallInvasionDist())))) continue;
            needsDefending.add(pos);
            Tyr.drawCircle(pos, Color.Cyan, Settings.getSmallInvasionDist());
        }
        for (Unit u : EnemyManager.getEnemyUnits()) {
            if (invadingEnemies.contains(u) || u.getType() == UnitType.Protoss_Observer || u.isCloaked() && !u.isDetected() || Tyr.self.getRace() == Race.Protoss && !u.isDetected() && (u.getType() == UnitType.Protoss_Dark_Templar || u.isBurrowed())) continue;
            for (Position defendedPos : needsDefending) {
                double uDist = u.getDistance(defendedPos.getX(), defendedPos.getY());
                if (!(uDist <= (double)Settings.getSmallInvasionDist())) continue;
                double mainDist = u.getDistance(start);
                if (u.getType().isFlyer()) {
                    if (this.flyingInvader == null || mainDist < (double)this.flyingInvader.getDistance(start)) {
                        this.flyingInvader = u;
                    }
                    ++this.flyingInvaderCount;
                } else if (this.invader == null || mainDist < (double)this.invader.getDistance(start)) {
                    this.invader = u;
                }
                ++this.invaderCount;
            }
        }
        if (this.invader != null) {
            Tyr.drawCircle(this.invader.getPosition(), Color.Red);
        }
        if (this.flyingInvader != null) {
            Tyr.drawCircle(this.flyingInvader.getPosition(), Color.Blue);
        }
    }

    public void update() {
        this.updateBuildings();
        this.updateEnemyInfo();
    }

    private void updateBuildings() {
        Object[] enemyBuildings = this.enemyBuildingMemory.toArray();
        int i = enemyBuildings.length - 1;
        while (i >= 0) {
            Position lastKnown;
            EnemyPosition enemyPosition = (EnemyPosition)enemyBuildings[i];
            Unit unit = Tyr.game.getUnit(enemyPosition.id);
            Position position = lastKnown = unit == null ? null : this.getLastPosition(unit);
            if (lastKnown != null) {
                enemyPosition.pos = lastKnown;
            }
            if (Tyr.game.isVisible(enemyPosition.pos.getX() / 32, enemyPosition.pos.getY() / 32)) {
                Tyr.drawCircle(enemyPosition.pos, Color.Blue, 4);
                this.enemyBuildingMemory.remove(enemyPosition);
            } else {
                Tyr.drawCircle(enemyPosition.pos, Color.Orange);
            }
            --i;
        }
        this.enemyDefensiveStructures = new ArrayList();
        for (Unit u : EnemyManager.getEnemyUnits()) {
            EnemyPosition enemyPos;
            if (!u.getType().isBuilding() || u.isLifted() || this.enemyBuildingMemory.contains(enemyPos = new EnemyPosition(u.getID(), u.getType(), u.getPosition(), u.isCompleted()))) continue;
            Tyr.drawCircle(enemyPos.pos, Color.White, 6);
            this.enemyBuildingMemory.add(enemyPos);
        }
        for (EnemyPosition pos : this.enemyBuildingMemory) {
            if (pos.type != UnitType.Protoss_Photon_Cannon && pos.type != UnitType.Zerg_Sunken_Colony && pos.type != UnitType.Terran_Bunker) continue;
            this.enemyDefensiveStructures.add(pos);
            Tyr.drawCircle(pos.pos, Color.Red, WeaponType.Phase_Disruptor_Cannon.maxRange());
        }
        for (EnemyPosition enemyPos : this.enemyBuildingMemory) {
            Tyr.drawCircle(enemyPos.pos, Color.Red);
        }
        ArrayList<EnemyPosition> removePositions = new ArrayList<EnemyPosition>();
        for (EnemyPosition enemyPosition : this.neutralBuildingMemory) {
            if (Tyr.game.isVisible(enemyPosition.pos.getX() / 32, enemyPosition.pos.getY() / 32)) {
                removePositions.add(enemyPosition);
                continue;
            }
            Tyr.drawCircle(enemyPosition.pos, Color.Teal);
        }
        for (EnemyPosition enemyPosition : removePositions) {
            this.neutralBuildingMemory.remove(enemyPosition);
        }
        for (Unit unit : Tyr.game.getNeutralUnits()) {
            EnemyPosition enemyPos;
            if (unit.getType().canMove() || this.neutralBuildingMemory.contains(enemyPos = new EnemyPosition(unit.getID(), unit.getType(), unit.getPosition(), unit.isCompleted()))) continue;
            this.neutralBuildingMemory.add(enemyPos);
        }
        for (EnemyPosition enemyPosition : this.neutralBuildingMemory) {
            Tyr.drawCircle(enemyPosition.pos, Color.Teal);
        }
    }

    private void updateEnemyInfo() {
        Iterator<Object> iterator = this.lastKnownPosition.keySet().iterator();
        while (iterator.hasNext()) {
            int unitID = iterator.next();
            if (this.lastKnownPosition.get(unitID) == null || !Tyr.game.isVisible(Tyr.positionToTile(this.lastKnownPosition.get(unitID)))) continue;
            this.lastKnownPosition.put(unitID, null);
        }
        for (Unit unit : EnemyManager.getEnemyUnits()) {
            if (unit.isAttacking() || unit.isAttackFrame()) {
                this.lastAttackFrame.put(unit.getID(), Tyr.game.getFrameCount());
            }
            this.lastKnownPosition.put(unit.getID(), unit.getPosition());
            this.enemyTypeMap.put(unit.getID(), unit.getType());
        }
        this.allEnemyCount = new HashMap();
        for (UnitType type : this.enemyTypeMap.values()) {
            if (!this.allEnemyCount.containsKey(type)) {
                this.allEnemyCount.put(type, 1);
                continue;
            }
            this.allEnemyCount.put(type, this.allEnemyCount.get(type) + 1);
        }
    }

    public static ArrayList<Unit> getEnemyUnits() {
        int frame = Tyr.game.getFrameCount();
        if (frame > enemyUnitsUpdatedFrame) {
            enemyUnitsUpdatedFrame = frame;
            enemyUnits = new ArrayList();
            for (Player enemy : Tyr.game.enemies()) {
                for (Unit unit : enemy.getUnits()) {
                    if (unit.getType() == UnitType.Unknown) continue;
                    enemyUnits.add(unit);
                }
            }
        }
        return enemyUnits;
    }

    public void reset() {
        this.orderedExpands = null;
        this.selfPos = -1;
        this.enemyBuildingMemory = new HashSet();
        this.enemyDefensiveStructures = new ArrayList();
        this.invaderUpdatedFrame = 0;
    }

    public void died(Unit unit) {
        if (this.enemyTypeMap.containsKey(unit.getID())) {
            UnitType type = this.enemyTypeMap.get(unit.getID());
            if (this.allEnemyCount.containsKey(type)) {
                this.allEnemyCount.put(type, this.allEnemyCount.get(type) - 1);
            }
            this.enemyTypeMap.remove(unit.getID());
        }
    }

    public Set<UnitType> getEnemyTypes() {
        return this.allEnemyCount.keySet();
    }
}

