/*
 * Decompiled with CFR 0.152.
 */
package com.tyr;

import bwapi.Position;
import bwapi.TilePosition;
import bwta.BWTA;
import bwta.BaseLocation;
import bwta.Chokepoint;
import bwta.Region;
import com.tyr.DebugMessages;
import com.tyr.EnemyManager;
import com.tyr.Tyr;
import java.util.ArrayList;
import java.util.List;

public class BWTAProxy
implements Runnable {
    public static boolean initialized = false;

    @Override
    public void run() {
        try {
            Tyr.bot.expands = new ArrayList();
            Tyr.bot.suspectedEnemy = new ArrayList();
            System.out.println("Analyzing map...");
            BWTA.analyze();
            System.out.println("Map data ready");
            for (BaseLocation bloc : BWTA.getBaseLocations()) {
                if (!bloc.isStartLocation() || Tyr.self.getStartLocation().getDistance(bloc.getTilePosition()) < 4.0) {
                    Tyr.bot.expands.add(bloc);
                    continue;
                }
                Tyr.bot.suspectedEnemy.add(bloc);
            }
            initialized = true;
            EnemyManager.getManager().orderBases(Tyr.bot.suspectedEnemy);
            DebugMessages.log("Map analyzed: " + Tyr.game.mapFileName());
        }
        catch (Exception e) {
            System.out.println("Error intializing BWTA: " + e.getMessage());
            Tyr.game.printf("Error intializing BWTA: " + e.getMessage());
        }
    }

    public static void readMap() {
        System.out.println("Reading map...");
        BWTA.readMap();
        System.out.println("Map is read...");
    }

    public static Region getRegion(Position position) {
        if (initialized) {
            return BWTA.getRegion(position);
        }
        return null;
    }

    public static Region getRegion(TilePosition position) {
        if (initialized) {
            return BWTA.getRegion(position);
        }
        return null;
    }

    public static List<BaseLocation> getStartLocations() {
        if (initialized) {
            return BWTA.getStartLocations();
        }
        return null;
    }

    public static double getGroundDistance(TilePosition p1, TilePosition p2) {
        if (p1 == null) {
            throw new NullPointerException("TilePosition p1 was null.");
        }
        if (p2 == null) {
            throw new NullPointerException("TilePosition p2 was null.");
        }
        if (initialized) {
            return BWTA.getGroundDistance(p1, p2);
        }
        return -1.0;
    }

    public static List<Chokepoint> getChokepoints() {
        if (!initialized) {
            return null;
        }
        return BWTA.getChokepoints();
    }
}

