#include "Common.h"

int GetIntFromString(const std::string & s)
{
	std::stringstream ss(s);
	int a = 0;
	ss >> a;
	return a;
}

// For example, "Zerg_Zergling" -> "Zergling"
std::string TrimRaceName(const std::string & s)
{
	if (s.substr(0, 5) == "Zerg_")
	{
		return s.substr(5, std::string::npos);
	}
	if (s.substr(0, 8) == "Protoss_")
	{
		return s.substr(8, std::string::npos);
	}
	if (s.substr(0, 7) == "Terran_")
	{
		return s.substr(7, std::string::npos);
	}

	// There is no race prefix. Return it unchanged.
	return s;
}

// Predict a visible unit's movement a given number of frames into the future,
// on the assumption that it keeps moving in a straight line.
// If it is predicted to go off the map, clip the prediction to a valid position on the map.
BWAPI::Position PredictMovement(BWAPI::Unit unit, int frames)
{
	UAB_ASSERT(unit && unit->getPosition().isValid(), "bad unit");

	BWAPI::Position pos(
		unit->getPosition().x + int(frames * unit->getVelocityX()),
		unit->getPosition().y + int(frames * unit->getVelocityY())
		);
	ClipToMap(pos);
	return pos;
}

// Clip (x,y) to the bounds of the map.
void ClipToMap(BWAPI::Position & pos)
{
	if (pos.x < 0)
	{
		pos.x = 0;
	}
	else if (pos.x >= 32 * BWAPI::Broodwar->mapWidth())
	{
		pos.x = 32 * BWAPI::Broodwar->mapWidth() - 1;
	}

	if (pos.y < 0)
	{
		pos.y = 0;
	}
	else if (pos.y >= 32 * BWAPI::Broodwar->mapHeight())
	{
		pos.y = 32 * BWAPI::Broodwar->mapHeight() - 1;
	}
}
