#pragma once

#include "Ximp.h"

using namespace BWAPI;
using namespace std;

#define SHOW_DEBUG_INFO 0
#define WRITE_MATCH_RESULT 0

class XimpHandler: public AIModule {

  private:
 
    int frames;
    int fps;
    int lastTicks;

    int frameDuration;

    Ximp ximp;

    const string authorName;
    const string botName;

    bool showPaths;
    bool showOrders;
    bool showEnemyPositions;
    bool showCustom;
    bool showBullets;
    bool showVisibility;
    bool showBuildability;
    bool showTerrainData;
    bool showStats;
    bool showThreatMap;
    bool showHP;

    bool analyzed;

    void countFps();

    void drawUnitsList(int line, map<UnitType, set<Unit*>> &units);
    void drawEnemyBases(int line);
    void drawMyBases(int line);
    void drawGroups(int line);

    void drawStats(); 
    void drawBullets();
    void drawVisibilityData();
    void drawBuildabilityData();
    void drawTerrainData();
    void drawPaths();
    void drawThreatMap();
    void drawOrders();
    void drawEnemyPositions();
    void drawCustom();
    void drawHP();
    void showPlayers();
    void showForces();

  public:

    XimpHandler(): authorName("Tomas Vajda"), 
                   botName("Ximp") {};

    virtual void onSendText(string text);
    virtual void onReceiveText(Player* player, string text);
    virtual void onPlayerLeft(Player* player);
    virtual void onSaveGame(string gameName);
    virtual void onEnd(bool isWinner);

    virtual void onStart();
    virtual void onUnitDiscover(Unit* unit);
    virtual void onFrame();
    virtual void onNukeDetect(Position target);
    virtual void onUnitCreate(Unit* unit);
    virtual void onUnitComplete(Unit *unit);
    virtual void onUnitDestroy(Unit* unit);
    virtual void onUnitMorph(Unit* unit);
    virtual void onUnitRenegade(Unit* unit);
    virtual void onUnitEvade(Unit* unit);
    virtual void onUnitShow(Unit* unit);
    virtual void onUnitHide(Unit* unit);

    void processAnalysis();

};