#include "Dll.h"


DWORD WINAPI AnalyzeThread(XimpHandler *XimpHandler) {
  BWTA::analyze();

  XimpHandler->processAnalysis();

  return 0;
}

void XimpHandler::countFps() {
  int currentTicks = GetTickCount();

  if (currentTicks - lastTicks >= 1000) {
    fps = frames;
    frames = 0;
    lastTicks = currentTicks;
  }

  frames++;
}

void XimpHandler::drawUnitsList(int line, map<UnitType, set<Unit*>> &units) {
  if (units.size() > 0) {
	  string sel = "";
    ostringstream ss;

	  for (map<UnitType, set<Unit*>>::const_iterator it = units.begin(); it != units.end(); ) {
      if (!it->second.empty()) {
        string strUnitType = it->first.getName();
        int first = strUnitType.find(' ');
        if (first != -1) {
          strUnitType = strUnitType.substr(first+1);
        }

        sel.append(strUnitType);
        sel.append(" ");
        ss.str("");
        ss << it->second.size();
        sel.append(ss.str());
        sel.append("x");
          
        if (++it != units.end()) {
          sel.append(", ");
        }
      }
      else {
        it++;
      }
	  }
	  Broodwar->drawTextScreen(5, 16*line, "%s", sel.c_str());
  }
}

void XimpHandler::drawEnemyBases(int line) {
  map<BWTA::BaseLocation*, EnemyBase*> occupiedEnemyBases = ximp.getOccupiedEnemyBases();

  int i = 0;
  for (map<BWTA::BaseLocation*, EnemyBase*>::iterator enemyBasesIterator = occupiedEnemyBases.begin(); enemyBasesIterator != occupiedEnemyBases.end(); enemyBasesIterator++) {
    i++;

    string sel = "";
    ostringstream ss;

    sel.append("hqs ");
    ss << enemyBasesIterator->second->hqs.size();
    sel.append(ss.str());
    ss.str("");
    sel.append("x, ");

    for (map<UnitType, set<Unit*>>::const_iterator it = enemyBasesIterator->second->buildings.begin(); it != enemyBasesIterator->second->buildings.end(); ) {
      if (!it->second.empty()) {
        string strUnitType = it->first.getName();
        int first = strUnitType.find(' ');
        if (first != -1) {
          strUnitType = strUnitType.substr(first+1);
        }

        sel.append(strUnitType);
        sel.append(" ");
        ss.str("");
        ss << it->second.size();
        sel.append(ss.str());
        sel.append("x");
          
        if (++it != enemyBasesIterator->second->buildings.end()) {
          sel.append(", ");
        }
      }
      else {
        it++;
      }
	  }
    Broodwar->drawTextScreen(5, 16*(line+i), "%d. enemy: %d, prob: %d, cap: %d, pos: %d %d, %s", i, enemyBasesIterator->second->isEnemyBase(), enemyBasesIterator->second->probablyEnemyBase, enemyBasesIterator->second->isCapital, enemyBasesIterator->first->getPosition().x(), enemyBasesIterator->first->getPosition().y(), sel.c_str());
  }
}

void XimpHandler::drawMyBases(int line) {
  map<BWTA::BaseLocation*, MyBase*> occupiedMyBases = ximp.colony.getOccupiedMyBases(false);

  int i = 0;
  for (map<BWTA::BaseLocation*, MyBase*>::iterator myBasesIterator = occupiedMyBases.begin(); myBasesIterator != occupiedMyBases.end(); myBasesIterator++) {
    i++;

    string sel = "";
    ostringstream ss;

    sel.append("hqs ");
    ss << myBasesIterator->second->hqs.size();
    sel.append(ss.str());
    ss.str("");
    sel.append("x, ");

    sel.append("workm ");
    ss << myBasesIterator->second->mineralWorkers.size();
    sel.append(ss.str());
    ss.str("");
    sel.append("x, ");

    sel.append("workg ");
    ss << myBasesIterator->second->gasWorkers.size();
    sel.append(ss.str());
    ss.str("");
    sel.append("x, ");

    for (map<UnitType, set<Unit*>>::const_iterator it = myBasesIterator->second->buildingsCompleted.begin(); it != myBasesIterator->second->buildingsCompleted.end(); ) {
      if (!it->second.empty()) {
        string strUnitType = it->first.getName();
        int first = strUnitType.find(' ');
        if (first != -1) {
          strUnitType = strUnitType.substr(first+1);
        }

        sel.append(strUnitType);
        sel.append(" ");
        ss.str("");
        ss << it->second.size();
        sel.append(ss.str());
        sel.append("x");
          
        if (++it != myBasesIterator->second->buildingsCompleted.end()) {
          sel.append(", ");
        }
      }
      else {
        it++;
      }
	  }
    
    Broodwar->drawTextScreen(5, 16*(line+i), "%d. my: %d, full: %d, cap: %d, workr: %f, gas: %d, att: %d, def: %d %s", i, myBasesIterator->second->isMyBase(), myBasesIterator->second->isFull, myBasesIterator->second->isCapital, myBasesIterator->second->getWorkersRatio(), myBasesIterator->second->getNeededAssimilators(), myBasesIterator->second->isUnderAttack, myBasesIterator->second->defendingGroup != NULL, sel.c_str());
  }
}

void XimpHandler::drawGroups(int line) {
  int i = 0;
  
  for (vector<CorsairGroup>::iterator groupIt = ximp.army.corsairGroups.begin(); groupIt != ximp.army.corsairGroups.end(); groupIt++) {
    Broodwar->drawTextScreen(5, 16*(line+i), "\x0F%d. Corsair size: %d instruct: %d", i+1, groupIt->units.size(), groupIt->instruction);
    i++;
  }

  int j = i;

  for (vector<CarrierGroup>::iterator groupIt = ximp.army.carrierGroups.begin(); groupIt != ximp.army.carrierGroups.end(); groupIt++) {
    Broodwar->drawTextScreen(5, 16 * (line + i), "\x1B%d. Carrier size: %d instruct: %d att priority: %d inter: %d maxInter: %d desInter: %d done: %d resup: %d def: %d obs: %d arb: %d", i + 1 - j, groupIt->units.size(), groupIt->instruction, groupIt->attackedUnitPriority, groupIt->countInterceptors(), groupIt->maxCountInterceptors(), groupIt->desiredCountInterceptors(), groupIt->hasAtLeastDone, groupIt->waitForResupply, groupIt->defendedMyBase != NULL, groupIt->observer != NULL, groupIt->arbiter != NULL);
    i++;
  }
}

void XimpHandler::drawStats() {
  set<Unit*> myUnits = Broodwar->self()->getUnits();
  Broodwar->drawTextScreen(5, 0, "\x04Starts: %d Bases: %d Enemy: %s Frames: %d (%d:%s%d) Fps: %d Map: %s", BWTA::getStartLocations().size(), BWTA::getBaseLocations().size(), Broodwar->enemy()->getRace().getName().c_str(), Broodwar->getFrameCount(), Broodwar->elapsedTime() / 60, (Broodwar->elapsedTime() % 60 < 10) ? "0" : "", Broodwar->elapsedTime() % 60, fps, Broodwar->mapName().c_str());

  /*int line = 1;
  if (Broodwar->getSelectedUnits().size() > 0) {
	  string sel = "";
	  for (set<Unit*>::iterator i = Broodwar->getSelectedUnits().begin(); i != Broodwar->getSelectedUnits().end(); i++) {
		  sel.append((*i)->getType().getName());
		  sel.append(" (");
      sel.append((*i)->getOrder().getName());
      if ((*i)->getOrderTarget() != NULL) {
        sel.append(", ");
        sel.append((*i)->getOrderTarget()->getType().getName());
      }
		  sel.append(") ");
	  }
	  Broodwar->drawTextScreen(5, 16*line, "Selected: %s", sel.c_str());
  }*/
  
  #if SHOW_DEBUG_INFO
    Broodwar->drawTextScreen(5, 16*1, "\x17Prediction100 - min: %d gas: %d  Reserved - min: %d gas: %d", ximp.minerals100, ximp.gas100, ximp.colony.buildingsBeignBuiltMinerals(), ximp.colony.buildingsBeignBuiltGas());
    Broodwar->drawTextScreen(5, 16*2, "\x1FWorkers: %d Unassigned: %d Scout died: %d", ximp.getMyUnits(UnitTypes::Protoss_Probe).size(), ximp.colony.unassignedWorkers.size(), ximp.observation.earlyScoutDestroyedFrame);
    //Broodwar->drawTextScreen(5, 286, "Frame: %d (Other: %d Colony: %d Army: %d Observation: %d)", frameDuration, ximp.otherDuration, ximp.colonyDuration, ximp.armyDuration, ximp.observationDuration);

    Broodwar->drawTextScreen(Broodwar->getMousePosition().x()+20, Broodwar->getMousePosition().y()+20, "%d %d", (Broodwar->getScreenPosition().x() + Broodwar->getMousePosition().x()) / TILE_SIZE, (Broodwar->getScreenPosition().y() + Broodwar->getMousePosition().y()) / TILE_SIZE);
    
    /*drawUnitsList(2, ximp.myUnits);
    drawUnitsList(3, ximp.myUnitsCompleted);
    drawUnitsList(4, ximp.enemyUnits);
    drawUnitsList(5, ximp.enemyUnitsVisible);*/

    //drawEnemyBases(2);
    //drawMyBases(2);
    drawGroups(3);
  #endif
}

void XimpHandler::drawBullets() {
  set<Bullet*> bullets = Broodwar->getBullets();
  
  for (set<Bullet*>::iterator it = bullets.begin(); it != bullets.end(); it++) {
    Position p = (*it)->getPosition();
    double velocityX = (*it)->getVelocityX();
    double velocityY = (*it)->getVelocityY();

    if ((*it)->getPlayer() == Broodwar->self()) {
      Broodwar->drawLineMap(p.x(), p.y(), p.x() + (int)velocityX, p.y() + (int)velocityY, Colors::Green);
      Broodwar->drawTextMap(p.x(), p.y(), "\x07%s", (*it)->getType().getName().c_str());
    }
    else {
      Broodwar->drawLineMap(p.x(), p.y(), p.x() + (int)velocityX, p.y() + (int)velocityY, Colors::Red);
      Broodwar->drawTextMap(p.x(), p.y(), "\x06%s", (*it)->getType().getName().c_str());
    }
  }
}

void XimpHandler::drawVisibilityData() {
  for (int x = 0; x < Broodwar->mapWidth(); x++) {
    for (int y = 0; y < Broodwar->mapHeight(); y++) {
      if (Broodwar->isExplored(x, y)) {
        if (Broodwar->isVisible(x, y)) {
          Broodwar->drawDotMap(x*32+16, y*32+16, Colors::Green);
        }
        else {
          Broodwar->drawDotMap(x*32+16, y*32+16, Colors::Blue);
        }
      }
      else {
        Broodwar->drawDotMap(x*32+16, y*32+16, Colors::Red);
      }
    }
  }
}

void XimpHandler::drawTerrainData() {
  //we will iterate through all the horde locations, and draw their outlines.
  for (set<BWTA::BaseLocation*>::const_iterator it = BWTA::getBaseLocations().begin(); it != BWTA::getBaseLocations().end(); it++) {
    TilePosition p = (*it)->getTilePosition();
    Position c = (*it)->getPosition();

    //draw outline of center location
    /*ostringstream osstream;
    osstream << (*it)->getPosition().x() << " " << (*it)->getPosition().y();
    Broodwar->drawText(CoordinateType::Map, (*it)->getPosition().x(), (*it)->getPosition().y(), "%s", osstream.str().c_str());*/
    BWAPI::Color col = Colors::Blue;

    if (ximp.colony.getCapitalMyBase() != NULL && (*it) == ximp.colony.getCapitalMyBase()->baseLocation) {
      col = Colors::Yellow;
    }
    else if (ximp.colony.getNaturalMyBase() != NULL && (*it) == ximp.colony.getNaturalMyBase()->baseLocation) {
      col = Colors::Purple;
    }
    
    Broodwar->drawBox(CoordinateType::Map, p.x()*32, p.y()*32, p.x()*32+4*32, p.y()*32+3*32, col, false);

    //draw a circle at each mineral patch
    for (set<BWAPI::Unit*>::const_iterator jt = (*it)->getStaticMinerals().begin(); jt != (*it)->getStaticMinerals().end(); jt++) {
      Position q = (*jt)->getInitialPosition();
      Broodwar->drawCircle(CoordinateType::Map, q.x(), q.y(), TILE_SIZE, Colors::Cyan, false);
    }

    //draw the outlines of vespene geysers
    for (set<BWAPI::Unit*>::const_iterator jt = (*it)->getGeysers().begin(); jt != (*it)->getGeysers().end(); jt++) {
      TilePosition q = (*jt)->getInitialTilePosition();
      Broodwar->drawBox(CoordinateType::Map, q.x()*32, q.y()*32, q.x()*32+4*32, q.y()*32+2*32, Colors::Orange, false);
    }

    //if this is an island expansion, draw a yellow circle around the horde location
    if ((*it)->isIsland()) {
      Broodwar->drawCircle(CoordinateType::Map, c.x(), c.y(), 80, Colors::Yellow, false);
    }
  }

  //we will iterate through all the regions and draw the polygon outline of it in green.
  for(set<BWTA::Region*>::const_iterator it = BWTA::getRegions().begin(); it != BWTA::getRegions().end(); it++) {
    BWTA::Polygon p = (*it)->getPolygon();
    
    /*ostringstream ostream;
    ostream << (*it)->getCenter().x() << " " << (*it)->getCenter().y();
    Broodwar->drawText(CoordinateType::Map, (*it)->getCenter().x(), (*it)->getCenter().y(), "%s", ostream.str().c_str());*/

    Color col = Colors::Green;
    for (map<BWTA::BaseLocation*, MyBase>::iterator jt = ximp.colony.myBases.begin(); jt != ximp.colony.myBases.end(); jt++) {
      if (jt->first->isStartLocation()) {
        for (set<BWTA::Region*>::const_iterator rt = jt->second.regions.begin(); rt != jt->second.regions.end(); rt++) {
          if (*rt == *it) {
            col = Colors::Purple;
            break;
          }
        }
      }
    }

    if (ximp.isInRegionWithEnemyUnits((*it)->getCenter())) {
      col = Colors::Orange;
    }

    if (ximp.isInRegionWithEnemyBase((*it)->getCenter())) {
      col = Colors::Red;
    }
    
    for (int j = 0; j < (int)p.size(); j++) {
      Position point1 = p[j];
      Position point2 = p[(j+1) % p.size()];      
      Broodwar->drawLine(CoordinateType::Map, point1.x(), point1.y(), point2.x(), point2.y(), col);
      //Broodwar->drawCircle(CoordinateType::Map, point1.x(), point1.y(), 3, col, true);

      /*ostringstream ostream;
      ostream << j;
      Broodwar->drawText(CoordinateType::Map, point1.x(), point1.y(), "%s", ostream.str().c_str())*/
    }
  }

  //we will visualize the chokepoints with red lines
  for (set<BWTA::Region*>::const_iterator it = BWTA::getRegions().begin(); it != BWTA::getRegions().end(); it++) {
    for (set<BWTA::Chokepoint*>::const_iterator jt = (*it)->getChokepoints().begin(); jt != (*it)->getChokepoints().end(); jt++) {
      Position point1 = (*jt)->getSides().first;
      Position point2 = (*jt)->getSides().second;

      /*ostringstream osstream;
      osstream << (*jt)->getCenter().x() << " " << (*jt)->getCenter().y();
      Broodwar->drawText(CoordinateType::Map, (*jt)->getCenter().x()-20, (*jt)->getCenter().y(), "%s", osstream.str().c_str());*/
      Color col = Colors::Red;

      for (map<BWTA::BaseLocation*, MyBase>::iterator kt = ximp.colony.myBases.begin(); kt != ximp.colony.myBases.end(); kt++) {
        if (kt->first->isStartLocation()) {
          if (kt->second.chokepoints.find(*jt) != kt->second.chokepoints.end()) {
            col = Colors::Orange;
            Broodwar->drawLine(CoordinateType::Map, point1.x(), point1.y(), point2.x(), point2.y(), col);
          }
        }
      }      
    }
  }
}

void XimpHandler::drawBuildabilityData() {
  if (analyzed) {
    MyBase* myCapitalBase = ximp.colony.getCapitalMyBase();

    // we will iterate through all TilePositions and draw the buildability info
    for (int x = 0; x < Broodwar->mapWidth(); x++) {
      for (int y = 0; y < Broodwar->mapHeight(); y++) {
		    // Yellow dots - typical 2x2 buildings
		    if (Broodwar->self()->getRace() == Races::Zerg) {
          if (Broodwar->canBuildHere(NULL, TilePosition(x, y), UnitTypes::Zerg_Creep_Colony, true)) {
				    Broodwar->drawCircleMap(x*32+16, y*32+16, 7, Colors::Green, true);
          }
          else if (Broodwar->canBuildHere(NULL, TilePosition(x, y), UnitTypes::Zerg_Creep_Colony, false)) {
            Broodwar->drawCircleMap(x*32+16, y*32+16, 7, Colors::Yellow, true);
          }
		    } 
        else if (Broodwar->self()->getRace() == Races::Protoss) {
          Position pos(x*TILE_SIZE+TILE_SIZE/2, y*TILE_SIZE+TILE_SIZE/2);
          Color col = Colors::Black;
          Unit* nearestMineral = ximp.getNearestMineralField(pos, false, true);
          Unit* nearestGeyser = ximp.getNearestGeyser(pos);
          Unit* nearestAssimilator = ximp.getNearestUnitType(pos, UnitTypes::Protoss_Assimilator);
          BWTA::BaseLocation* nearestBaseLocation = BWTA::getNearestBaseLocation(pos);

          bool distOk = true;
          if ((nearestMineral != NULL && pos.getDistance(nearestMineral->getInitialPosition()) <= 5*TILE_SIZE && nearestBaseLocation != NULL && pos.getDistance(nearestBaseLocation->getPosition()) <= 7*TILE_SIZE) 
            || (nearestGeyser != NULL && pos.getDistance(nearestGeyser->getInitialPosition()) <= 4*TILE_SIZE && nearestBaseLocation != NULL && pos.getDistance(nearestBaseLocation->getPosition()) <= 5*TILE_SIZE)
            || (nearestAssimilator != NULL && pos.getDistance(nearestAssimilator->getPosition()) <= 4*TILE_SIZE && nearestBaseLocation != NULL && pos.getDistance(nearestBaseLocation->getPosition()) <= 5*TILE_SIZE)) {
            col = Colors::Red;
          }
          else if (Broodwar->canBuildHere(NULL, TilePosition(x, y), UnitTypes::Protoss_Pylon, true)) {
            col = Colors::Green;
          }
          else if (Broodwar->canBuildHere(NULL, TilePosition(x, y), UnitTypes::Protoss_Pylon, false)) {
            col = Colors::Yellow;
          }
          else if (Broodwar->isBuildable(TilePosition(x, y), true)) {
            col = Colors::Green;
          }

          if (col != Colors::Black) {
            Broodwar->drawCircleMap(pos.x(), pos.y(), 7, col, true);
          }
		    } 
        else {
          if (Broodwar->canBuildHere(NULL, TilePosition(x, y), UnitTypes::Terran_Supply_Depot, true)) {
				    Broodwar->drawCircleMap(x*32+16, y*32+16, 7, Colors::Green, true);
          }
          else if (Broodwar->canBuildHere(NULL, TilePosition(x, y), UnitTypes::Terran_Supply_Depot, false)) {
            Broodwar->drawCircleMap(x*32+16, y*32+16, 7, Colors::Yellow, true);
          }
		    }
      }
    }
  }
}

void XimpHandler::drawPaths() {
  for (set<Unit*>::const_iterator it = Broodwar->self()->getUnits().begin(); it != Broodwar->self()->getUnits().end(); it++) {
    if ((*it)->getType() != UnitTypes::Protoss_Interceptor) {
      Position point1 = (*it)->getPosition();
      Position point2 = (*it)->getTargetPosition();

      Color color = Colors::Cyan;
      if ((*it)->getOrder() == Orders::AttackUnit) {
        color = Colors::Red;
      }

      Broodwar->drawLine(CoordinateType::Map, point1.x(), point1.y(), point2.x(), point2.y(), color);

      if ((*it)->getType().isWorker() && (*it)->getOrder() == Orders::PlaceBuilding) {
        int x = (*it)->getTargetPosition().x()-((*it)->getBuildType().tileWidth()*TILE_SIZE)/2;
        int y = (*it)->getTargetPosition().y()-((*it)->getBuildType().tileHeight()*TILE_SIZE)/2;

        Broodwar->drawBoxMap(x, y, x+(*it)->getBuildType().tileWidth()*TILE_SIZE, y+(*it)->getBuildType().tileHeight()*TILE_SIZE, Colors::Green);
      }
    }
  }
}

void XimpHandler::drawThreatMap() {
  int x = 0;

  for (vector<vector<vector<WeaponType>>>::iterator row = ximp.threatMap.begin(); row != ximp.threatMap.end(); row++) {
    int y = 0;

    for (vector<vector<WeaponType>>::iterator square = row->begin(); square != row->end(); square++) {
      for (vector<WeaponType>::iterator it = square->begin(); it != square->end(); it++) {
        if (it->targetsGround()) {
          Broodwar->drawCircle(CoordinateType::Map, x*TILE_SIZE, y*TILE_SIZE, 8, Colors::Orange, true);
        }
      }
      
      for (vector<WeaponType>::iterator it = square->begin(); it != square->end(); it++) {
        if (it->targetsAir()) {
          Broodwar->drawCircle(CoordinateType::Map, x*TILE_SIZE, y*TILE_SIZE, 4, Colors::Blue, true);
        }
      }

      y++;
    }

    x++;
  }
}

void XimpHandler::drawHP() {
  set<Unit*> allUnits = Broodwar->getAllUnits();

  for (set<Unit*>::iterator jt = allUnits.begin(); jt != allUnits.end(); jt++) {
    if (!(*jt)->getPlayer()->isNeutral() && (*jt)->isVisible() && (*jt)->isDetected() && ((*jt)->isCompleted() || (*jt)->getType().isBuilding())) {
      if ((*jt)->getType() == UnitTypes::Protoss_Interceptor) {
        if ((*jt)->getCarrier() != NULL && (*jt)->getPosition().getDistance((*jt)->getCarrier()->getPosition()) <= TILE_SIZE*3) {
          continue;
        }
      }
      
      Position maxHP = Position((double)TILE_SIZE*0.7, TILE_SIZE/10);
      int currentHP = ((double)(*jt)->getHitPoints() / (double)(*jt)->getType().maxHitPoints()) * maxHP.x();

      Position pos = Position((*jt)->getPosition().x()-maxHP.x()/2, (*jt)->getPosition().y()-maxHP.y()/2);

      Broodwar->drawBoxMap(pos.x(), pos.y(), pos.x()+maxHP.x(), pos.y()+maxHP.y(), Colors::Red, true);
      Broodwar->drawBoxMap(pos.x(), pos.y(), pos.x()+currentHP, pos.y()+maxHP.y(), Colors::Green, true);

      if ((*jt)->getType().getRace() == Races::Protoss) {
        Position maxShields = Position((double)TILE_SIZE*0.7, TILE_SIZE/10);
        int currentShields = ((double)(*jt)->getShields() / (double)(*jt)->getType().maxShields()) * maxShields.x();

        Broodwar->drawBoxMap(pos.x(), pos.y()-maxShields.y(), pos.x()+maxShields.x(), pos.y(), Colors::Red, true);
        Broodwar->drawBoxMap(pos.x(), pos.y()-maxShields.y(), pos.x()+currentShields, pos.y(), Colors::Blue, true);
      }
    }
  }
}

void XimpHandler::drawOrders() {
  for (map<UnitType, set<Unit*>>::iterator it = ximp.myUnitsCompleted.begin(); it != ximp.myUnitsCompleted.end(); it++) {
    for (set<Unit*>::iterator jt = it->second.begin(); jt != it->second.end(); jt++) {
      if (!(*jt)->getType().isBuilding() && (*jt)->getType() != UnitTypes::Protoss_Interceptor) {
        Broodwar->drawTextMap((*jt)->getPosition().x() - (*jt)->getType().dimensionLeft(), (*jt)->getPosition().y() + (*jt)->getType().dimensionDown() + 8, (*jt)->getOrder().getName().c_str());
      }
    }
  }
}

void XimpHandler::drawEnemyPositions() {
  for (map<Unit*, Position>::iterator it = ximp.enemyUnitsPositions.begin(); it != ximp.enemyUnitsPositions.end(); it++) {
    string strUnitType = ximp.getEnemyUnitType(it->first).getName();
    int first = strUnitType.find(' ');
    if (first != -1) {
      strUnitType = strUnitType.substr(first+1);
    }

    ostringstream ostream;
    ostream << "\x06" << it->second.x() << " " << it->second.y() << ", " <<  strUnitType;
    Broodwar->drawTextMap(it->second.x(), it->second.y(), ostream.str().c_str());
  }
}

void XimpHandler::drawCustom() {
  // Workers assignment
  if (ximp.analyzed) {
    for (map<BWTA::BaseLocation*, MyBase>::iterator it = ximp.colony.myBases.begin(); it != ximp.colony.myBases.end(); it++) {
      for (map<Unit*, set<Unit*>>::iterator jt = it->second.mineralFields.begin(); jt != it->second.mineralFields.end(); jt++) {
        //if (jt->first->exists()) {
          Broodwar->drawText(CoordinateType::Map, jt->first->getInitialPosition().x(), jt->first->getInitialPosition().y(), "\x04%d", jt->second.size());
        //}

        for (set<Unit*>::iterator kt = jt->second.begin(); kt != jt->second.end(); kt++) {
          Broodwar->drawLine(CoordinateType::Map, jt->first->getInitialPosition().x(), jt->first->getInitialPosition().y(), (*kt)->getPosition().x(), (*kt)->getPosition().y(), Colors::White);
        }
      }
      
      set<Unit*> baseWorkers = it->second.getBaseWorkers();

      for (set<Unit*>::iterator jt = baseWorkers.begin(); jt != baseWorkers.end(); jt++) {
        Broodwar->drawLineMap((*jt)->getPosition().x(), (*jt)->getPosition().y(), it->first->getPosition().x(), it->first->getPosition().y(), Colors::Orange);
      }
    }
  }

  /*set<Unit*> mineralFields = Broodwar->getMinerals();

	for (set<Unit*>::iterator it = mineralFields.begin(); it != mineralFields.end(); it++) {
    if (ximp.isBeignGathered(*it)) {
       Broodwar->drawCircle(CoordinateType::Map, (*it)->getInitialPosition().x(), (*it)->getInitialPosition().y(), 8, Colors::Orange);
    }
  }*/


  // Show visible enemy units
  /*int i = 3;
  for (map<UnitType, set<Unit*>>::iterator it = ximp.enemyUnitsVisible.begin(); it != ximp.enemyUnitsVisible.end(); it++) {
    if (!it->second.empty()) {
      string sel = "";
      ostringstream ss;
      for (set<Unit*>::iterator jt = it->second.begin(); jt != it->second.end(); jt++) {
        ss.str("");
        ss << (*jt)->getPosition().x() << "," << (*jt)->getPosition().y() << "  ";
        sel.append(ss.str());
      }
      
      Broodwar->drawTextScreen(5, 16*i, "%s count: %d %s", it->first.getName().c_str(), it->second.size(), sel.c_str());
      i++;
    }
  }*/

  // Defense and Pylons centroid
  if (analyzed) {
    for (map<BWTA::BaseLocation*, MyBase>::iterator it = ximp.colony.myBases.begin(); it != ximp.colony.myBases.end(); it++) {
      MyBase* myBase = &it->second;
    
      Broodwar->drawCircle(CoordinateType::Map, myBase->defenseCentroid.x(), myBase->defenseCentroid.y(), 5, Colors::Red, true);
      Broodwar->drawCircle(CoordinateType::Map, myBase->pylonsCentroid.x(), myBase->pylonsCentroid.y(), 5, Colors::Cyan, true);

      for (map<UnitType, TilePosition>::iterator jt = myBase->buildingPositions.begin(); jt != myBase->buildingPositions.end(); jt++) {
        if (myBase->isInBaseRegions(Position(jt->second))) {
          UnitType buildingType = jt->first;
          Position pos = Position(jt->second);
              
          Position first(pos.x(), pos.y());
          Position last(first.x() + buildingType.tileWidth()*TILE_SIZE, first.y() + buildingType.tileHeight()*TILE_SIZE);

          Broodwar->drawBoxMap(first.x(), first.y(), last.x(), last.y(), Colors::Red);
        }
      }

      for (map<UnitType, Unit*>::iterator jt = myBase->buildingWorkers.begin(); jt != myBase->buildingWorkers.end(); jt++) {
        UnitType buildingType = jt->first;
        Position pos = Position(0,0);

        for (map<UnitType, TilePosition>::iterator kt = myBase->buildingPositions.begin(); kt != myBase->buildingPositions.end(); kt++) {
          if (buildingType == kt->first) {
            pos = Position(kt->second);
            break;
          }
        }
              
        Position first(pos.x(), pos.y());
        Position last(first.x() + buildingType.tileWidth()*TILE_SIZE, first.y() + buildingType.tileHeight()*TILE_SIZE);

        Broodwar->drawBoxMap(first.x(), first.y(), last.x(), last.y(), Colors::Orange);
      }
    }
  }

  // New Nexus workers
  for (map<BWTA::BaseLocation*, Unit*>::iterator it = ximp.colony.newNexusWorkers.begin(); it != ximp.colony.newNexusWorkers.end(); it++) {
    Broodwar->drawCircle(CoordinateType::Map, it->second->getPosition().x(), it->second->getPosition().y(), TILE_SIZE, Colors::Cyan);
    Broodwar->drawCircle(CoordinateType::Map, it->first->getPosition().x(), it->first->getPosition().y(), TILE_SIZE*3, Colors::Red);
  }

  // Count minerals and gas near base
  map<BWTA::BaseLocation*, MyBase> myBases = ximp.colony.myBases;
  for (map<BWTA::BaseLocation*, MyBase>::iterator it = myBases.begin(); it != myBases.end(); it++) {
    Broodwar->drawText(CoordinateType::Map, it->first->getPosition().x()-TILE_SIZE*2, it->first->getPosition().y()-TILE_SIZE*2, "Minerals: %d  is out: %d", it->second.lastSeenMineralCount, it->second.isMinedOut);
  
    /*set<Unit*> geysers = it->first->getGeysers();

    for (set<Unit*>::iterator jt = geysers.begin(); jt != geysers.end(); jt++) {
      map<Position, int>::iterator destroyedRefineriesIt = ximp.destroyedRefineries.find((*jt)->getInitialPosition());
      if (destroyedRefineriesIt != ximp.destroyedRefineries.end() && 
      Broodwar->drawText(CoordinateType::Map, (*jt)->getInitialPosition().x(), (*jt)->getInitialPosition().y(), "Resources: %d", (*jt)->getResources());
    }*/
  }

  // Draw amount of Resources in refineries/Vespene geysers
  set<Unit*> allUnits = Broodwar->getAllUnits();

  for (set<Unit*>::iterator it = allUnits.begin(); it != allUnits.end(); it++) {
    if ((*it)->getType().isRefinery() || (*it)->getType() == UnitTypes::Resource_Vespene_Geyser) {
      Broodwar->drawText(CoordinateType::Map, (*it)->getPosition().x()-2*TILE_SIZE, (*it)->getPosition().y()-1.5*TILE_SIZE, "Gas: %d, %s", (*it)->getResources(), (*it)->getType().getName().c_str());
    }
  }

  // Path for Carriers
  Broodwar->drawCircleMap(ximp.army.nearestEnemyBasePosition.x(), ximp.army.nearestEnemyBasePosition.y(), 10, Colors::Red, true);
  Broodwar->drawCircleMap(ximp.army.nearestEdgePosition.x(), ximp.army.nearestEdgePosition.y(), 10, Colors::Cyan, true);
  Broodwar->drawLineMap(ximp.army.nearestEnemyBasePosition.x(), ximp.army.nearestEnemyBasePosition.y(), ximp.army.nearestEdgePosition.x(), ximp.army.nearestEdgePosition.y(), Colors::Red);

  if (ximp.army.baseLocation != NULL) { 
    Broodwar->drawCircleMap(ximp.army.baseLocation->getPosition().x(), ximp.army.baseLocation->getPosition().y(), 10, Colors::Red, true);
    Broodwar->drawCircleMap(ximp.army.nearestEdgeBasePosition.x(), ximp.army.nearestEdgeBasePosition.y(), 10, Colors::Cyan, true);
    Broodwar->drawLineMap(ximp.army.baseLocation->getPosition().x(), ximp.army.baseLocation->getPosition().y(), ximp.army.nearestEdgeBasePosition.x(), ximp.army.nearestEdgeBasePosition.y(), Colors::Red);
  }

  if (!ximp.army.carrierPath.empty()) {
    for (int i = 0; i < ximp.army.carrierPath.size()-1; i++) {
      Broodwar->drawCircleMap(ximp.army.carrierPath[i].x(), ximp.army.carrierPath[i].y(), 10, Colors::Cyan, true);
      Broodwar->drawLineMap(ximp.army.carrierPath[i].x(), ximp.army.carrierPath[i].y(), ximp.army.carrierPath[(i+1)%ximp.army.carrierPath.size()].x(), ximp.army.carrierPath[(i+1)%ximp.army.carrierPath.size()].y(), Colors::Cyan);
    }
  }

  // Carrier groups
  for (int i = 0; i < ximp.army.carrierGroups.size(); i++) {
    Position posCentroid = ximp.army.carrierGroups[i].centroid;
    Broodwar->drawCircle(CoordinateType::Map, posCentroid.x(), posCentroid.y(), 5*TILE_SIZE, Colors::Cyan);

    if (ximp.army.carrierGroups[i].observer != NULL) {
      Position observerPosition = ximp.army.carrierGroups[i].observer->getPosition();
      Broodwar->drawCircle(CoordinateType::Map, observerPosition.x(), observerPosition.y(), 1*TILE_SIZE, Colors::White);
    }
    
    for (int j = 0; j < ximp.army.carrierGroups[i].attackPositions.size(); j++) {
      Broodwar->drawCircle(CoordinateType::Map, ximp.army.carrierGroups[i].attackPositions[j].x(), ximp.army.carrierGroups[i].attackPositions[j].y(), 10, Colors::Green, true);
    }

    if (ximp.army.carrierGroups[i].defendedMyBase != NULL) {
      Broodwar->drawLineMap(posCentroid.x(), posCentroid.y(), ximp.army.carrierGroups[i].defendedMyBase->baseLocation->getPosition().x(), ximp.army.carrierGroups[i].defendedMyBase->baseLocation->getPosition().y(), Colors::Green);
    }
  }

  // Corsair groups
  for (int i = 0; i < ximp.army.corsairGroups.size(); i++) {
    Position posCentroid = ximp.army.corsairGroups[i].centroid;
    Broodwar->drawCircle(CoordinateType::Map, posCentroid.x(), posCentroid.y(), 5*TILE_SIZE, Colors::Cyan);

    if (ximp.army.corsairGroups[i].observer != NULL) {
      Position observerPosition = ximp.army.corsairGroups[i].observer->getPosition();
      Broodwar->drawCircle(CoordinateType::Map, observerPosition.x(), observerPosition.y(), 1*TILE_SIZE, Colors::White);
    }

    if (ximp.army.corsairGroups[i].defendedMyBase != NULL) {
      Broodwar->drawLineMap(posCentroid.x(), posCentroid.y(), ximp.army.corsairGroups[i].defendedMyBase->baseLocation->getPosition().x(), ximp.army.corsairGroups[i].defendedMyBase->baseLocation->getPosition().y(), Colors::Green);
    }

    if (ximp.army.corsairGroups[i].defendedCarrierGroup != NULL) {
      Broodwar->drawLineMap(posCentroid.x(), posCentroid.y(), ximp.army.corsairGroups[i].defendedCarrierGroup->centroid.x(), ximp.army.corsairGroups[i].defendedCarrierGroup->centroid.y(), Colors::Green);
    }
  }

  // Dark Archons range
  for (set<Unit*>::iterator it = allUnits.begin(); it != allUnits.end(); it++) {
    if (!(*it)->getPlayer()->isNeutral() && (*it)->getPlayer()->isEnemy(Broodwar->self())/* && (*it)->getType().airWeapon() != WeaponTypes::None && (*it)->getType().airWeapon() != WeaponTypes::Unknown*/) {
      //Broodwar->drawCircleMap((*it)->getPosition().x(), (*it)->getPosition().y(), (*it)->getType().airWeapon().maxRange()/*+4*TILE_SIZE*//*, Colors::Red);
      if ((*it)->getType() == UnitTypes::Protoss_Dark_Archon) {
        int range = WeaponTypes::Mind_Control.maxRange();
        Broodwar->drawCircleMap((*it)->getPosition().x(), (*it)->getPosition().y(), range, Colors::Red);
      }
    }
  }

  // Capital base defense probes against enemy probes
  for (map<Unit*, Unit*>::iterator it = ximp.army.capitalMyBaseDefenseProbes.begin(); it != ximp.army.capitalMyBaseDefenseProbes.end(); it++) {
    Broodwar->drawCircleMap((*it).first->getPosition().x(), (*it).first->getPosition().y(), 1*TILE_SIZE, Colors::Green);
    Broodwar->drawLineMap((*it).first->getPosition().x(), (*it).first->getPosition().y(), (*it).second->getPosition().x(), (*it).second->getPosition().y(), Colors::Red);
    Broodwar->drawCircleMap((*it).second->getPosition().x(), (*it).second->getPosition().y(), 1*TILE_SIZE, Colors::Red);
  }
}

void XimpHandler::onSendText(string text) {
  if (text == "/show bullets") {
    showBullets = !showBullets;
    Broodwar->printf("show bullets = %s", showBullets ? "true" : "false");
  } 
  else if (text == "/show visibility") {
    showVisibility = !showVisibility;
    Broodwar->printf("show visibility = %s", showVisibility ? "true" : "false");
  } 
  else if (text == "/show buildability") {
    showBuildability = !showBuildability;
    Broodwar->printf("show buildability = %s", showBuildability ? "true" : "false");
  } 
  else if (text == "/show terrain") {
    showTerrainData = !showTerrainData;
    Broodwar->printf("show terrain = %s", showTerrainData ? "true" : "false");
  } 
  else if (text == "/show stats") {
    showStats = !showStats;
    Broodwar->printf("show stats = %s", showStats ? "true" : "false");
  } 
  else if (text == "/show paths") {
    showPaths = !showPaths;
    Broodwar->printf("show paths = %s", showPaths ? "true" : "false");
  } 
  else if (text == "/show orders") {
    showOrders = !showOrders;
    Broodwar->printf("show orders = %s", showOrders ? "true" : "false");
  } 
  else if (text == "/show positions") {
    showEnemyPositions = !showEnemyPositions;
    Broodwar->printf("show positions = %s", showEnemyPositions ? "true" : "false");
  } 
  else if (text == "/show custom") {
    showCustom = !showCustom;
    Broodwar->printf("show custom = %s", showCustom ? "true" : "false");
  } 
  else if (text == "/show threats") {
    showThreatMap = !showThreatMap;
    Broodwar->printf("show threats = %s", showThreatMap ? "true" : "false");
  }
  else if (text == "/show hp") {
    showHP = !showHP;
    Broodwar->printf("show hp = %s", showHP ? "true" : "false");
  }
  else if (text == "/analyze") {
    if (!analyzed) {
      Broodwar->printf("Analyzing map...");
      CreateThread(NULL, 0, (LPTHREAD_START_ROUTINE)AnalyzeThread, this, 0, NULL);
    }
  }
}

void XimpHandler::onReceiveText(Player* player, string text) {
  //Broodwar->printf("%s said '%s'", player->getName().c_str(), text.c_str());
}

void XimpHandler::onPlayerLeft(Player* player) {
  Broodwar->printf("%s left the game.", player->getName().c_str());
}

void XimpHandler::onSaveGame(string gameName) {
  Broodwar->printf("Game has been saved %s.", gameName.c_str());
}

void XimpHandler::onEnd(bool isWinner) {
  if (isWinner) {
    #if WRITE_MATCH_RESULT 
      ofstream file;
      file.open("results.txt", ios::app);
      file << "I won the game " << endl;
      file.close();
    #endif

    #if WRITE_LOG 
      ostringstream ss;
      ss << "I won the game";
      ximp.log.writeToLog(ss.str());
    #endif

    Broodwar->printf("I won the game");
  }
  else {
    #if WRITE_MATCH_RESULT 
      ofstream file;
      file.open("results.txt", ios::app);
      file << "I lost the game " << endl;
      file.close();
    #endif

    #if WRITE_LOG 
      ostringstream ss;
      ss << "I lost the game";
      ximp.log.writeToLog(ss.str());
    #endif

    Broodwar->sendText("gg");
    Broodwar->printf("I lost the game");
  }
}

void XimpHandler::onStart() {
  #if WRITE_LOG 
    ostringstream ss;
    ss << "XimpHandler::onStart - start";
    ximp.log.writeToLog(ss.str());
  #endif

	srand((unsigned int)time(0));

  #if SHOW_DEBUG_INFO
    Broodwar->enableFlag(Flag::UserInput);

    showPaths = true;
    showThreatMap = false;
    showOrders = true;
    showEnemyPositions = true;
    showCustom = true;
    showBullets = false;
    showVisibility = false;
	  showBuildability = false;
    showTerrainData = true;
    showHP = true;
    showStats = true;
  #else
    showPaths = false;
    showThreatMap = false;
    showOrders = false;
    showEnemyPositions = false;
    showCustom = false;
    showBullets = false;
    showVisibility = false;
	  showBuildability = false;
    showTerrainData = false;
    showHP = false;
    showStats = true;
  #endif

  BWTA::readMap();
  analyzed = false;

  frames = 0;
  fps = 0;
  lastTicks = 0;
	
	Broodwar->printf("Analyzing map...");
  CreateThread(NULL, 0, (LPTHREAD_START_ROUTINE)AnalyzeThread, this, 0, NULL);
    
  ximp.onStart();

  #if WRITE_LOG 
    ss.str("");
    ss << "XimpHandler::onStart - end";
    ximp.log.writeToLog(ss.str());
  #endif
}

void XimpHandler::onUnitDiscover(Unit* unit) {
  if (!Broodwar->isReplay() && Broodwar->getFrameCount() <= 1) {
    #if WRITE_LOG 
      ostringstream ss;
      ss << "XimpHandler::onUnitDiscover - start";
      ximp.log.writeToLog(ss.str());
    #endif

    ximp.onUnitDiscover(unit);

    #if WRITE_LOG 
      ss.str("");
      ss << "XimpHandler::onUnitDiscover - end";
      ximp.log.writeToLog(ss.str());
    #endif
	}
}

void XimpHandler::onFrame() {
  if (!Broodwar->isReplay()) {
    #if WRITE_LOG 
      ostringstream ss;
      ss << "XimpHandler::onFrame - start";
      ximp.log.writeToLog(ss.str());
    #endif

    frameDuration = GetTickCount();
    countFps();

    if (showBullets) {
      drawBullets();
    }

    if (showVisibility) {
      drawVisibilityData();
    }

    if (showBuildability) {
      drawBuildabilityData();
    }

    if (showTerrainData && analyzed) {
      drawTerrainData();
    }

    if (showOrders) {
      drawOrders();
    }

    if (showEnemyPositions) {
      drawEnemyPositions();
    }

    if (showCustom) {
      drawCustom();
    }

    if (showPaths) {
      drawPaths();
    }

    if (showThreatMap) {
      drawThreatMap();
    }

    if (showHP) {
      drawHP();
    }

    ximp.onFrame();

    frameDuration = GetTickCount() - frameDuration;

    if (showStats) {
      drawStats();
    }

    #if WRITE_LOG 
      ss.str("");
      ss << "XimpHandler::onFrame - end";
      ximp.log.writeToLog(ss.str());
    #endif
  }
}

void XimpHandler::onNukeDetect(Position target) {
  if (!Broodwar->isReplay()) {
    #if WRITE_LOG 
      ostringstream ss;
      ss << "XimpHandler::onNukeDetect - start";
      ximp.log.writeToLog(ss.str());
    #endif

    if (target != Positions::Unknown) {
      Broodwar->printf("Nuclear Launch Detected at (%d,%d)",target.x(),target.y());
      ximp.onNukeDetect(target);
    }
    else {
      Broodwar->printf("Nuclear Launch Detected");
    }

    #if WRITE_LOG 
      ss.str("");
      ss << "XimpHandler::onNukeDetect - end";
      ximp.log.writeToLog(ss.str());
    #endif
  }
}

void XimpHandler::onUnitCreate(Unit* unit) {
  if (!Broodwar->isReplay() && Broodwar->getFrameCount() > 1) {
    #if WRITE_LOG 
      ostringstream ss;
      ss << "XimpHandler::onUnitCreate - start";
      ximp.log.writeToLog(ss.str());
    #endif

    ximp.onUnitCreate(unit);

    #if WRITE_LOG 
      ss.str("");
      ss << "XimpHandler::onUnitCreate - end";
      ximp.log.writeToLog(ss.str());
    #endif
  }
}

void XimpHandler::onUnitComplete(Unit *unit) {
  if (!Broodwar->isReplay() && Broodwar->getFrameCount() > 1) {
    #if WRITE_LOG 
      ostringstream ss;
      ss << "XimpHandler::onUnitComplete - start";
      ximp.log.writeToLog(ss.str());
    #endif

    ximp.onUnitComplete(unit);

    #if WRITE_LOG 
      ss.str("");
      ss << "XimpHandler::onUnitComplete - end";
      ximp.log.writeToLog(ss.str());
    #endif
  }
}

void XimpHandler::onUnitDestroy(Unit* unit) {
  if (!Broodwar->isReplay() && Broodwar->getFrameCount() > 1) {
    #if WRITE_LOG 
      ostringstream ss;
      ss << "XimpHandler::onUnitDestroy - start";
      ximp.log.writeToLog(ss.str());
    #endif

    ximp.onUnitDestroy(unit);

    #if WRITE_LOG 
      ss.str("");
      ss << "XimpHandler::onUnitDestroy - end";
      ximp.log.writeToLog(ss.str());
    #endif
  }
}

void XimpHandler::onUnitMorph(Unit* unit) {
  if (!Broodwar->isReplay() && Broodwar->getFrameCount() > 1) {
    #if WRITE_LOG 
      ostringstream ss;
      ss << "XimpHandler::onUnitMorph - start";
      ximp.log.writeToLog(ss.str());
    #endif

    ximp.onUnitMorph(unit);

    #if WRITE_LOG 
      ss.str("");
      ss << "XimpHandler::onUnitMorph - end";
      ximp.log.writeToLog(ss.str());
    #endif
  }
}

void XimpHandler::onUnitRenegade(Unit* unit) {
  if (!Broodwar->isReplay() && Broodwar->getFrameCount() > 1) {
    #if WRITE_LOG 
      ostringstream ss;
      ss << "XimpHandler::onUnitRenegade - start";
      ximp.log.writeToLog(ss.str());
    #endif

    ximp.onUnitRenegade(unit);

    #if WRITE_LOG 
      ss.str("");
      ss << "XimpHandler::onUnitRenegade - end";
      ximp.log.writeToLog(ss.str());
    #endif
  }
}

void XimpHandler::onUnitEvade(Unit* unit) {
  if (!Broodwar->isReplay() && Broodwar->getFrameCount() > 1) {
    #if WRITE_LOG 
      ostringstream ss;
      ss << "XimpHandler::onUnitEvade - start";
      ximp.log.writeToLog(ss.str());
    #endif

    ximp.onUnitEvade(unit);

    #if WRITE_LOG 
      ss.str("");
      ss << "XimpHandler::onUnitEvade - end";
      ximp.log.writeToLog(ss.str());
    #endif
  }
}

void XimpHandler::onUnitShow(Unit* unit) {
  if (!Broodwar->isReplay() && Broodwar->getFrameCount() > 1) {
    #if WRITE_LOG 
      ostringstream ss;
      ss << "XimpHandler::onUnitShow - start";
      ximp.log.writeToLog(ss.str());
    #endif

    ximp.onUnitShow(unit);

    #if WRITE_LOG 
      ss.str("");
      ss << "XimpHandler::onUnitShow - end";
      ximp.log.writeToLog(ss.str());
    #endif
  }
}

void XimpHandler::onUnitHide(Unit* unit) {
  if (!Broodwar->isReplay() && Broodwar->getFrameCount() > 1) {
    #if WRITE_LOG 
      ostringstream ss;
      ss << "XimpHandler::onUnitHide - start";
      ximp.log.writeToLog(ss.str());
    #endif

    ximp.onUnitHide(unit);

    #if WRITE_LOG 
      ss.str("");
      ss << "XimpHandler::onUnitHide - end";
      ximp.log.writeToLog(ss.str());
    #endif
  }
}

void XimpHandler::processAnalysis() {
  Broodwar->printf("Finished analyzing map.");

  analyzed = true;
  
  ximp.processAnalysis();
}
