#pragma once

using namespace BWAPI;
using namespace std;

#define WRITE_LOG 0


enum UnitOwner { MY, ENEMY, NEUTRAL, CARELESS };

class Ximp {

  private:

    set<Unit*> incompleteAssimilators;
    set<Unit*> incompleteArchons;

    void addUnit(Unit* unit, map<UnitType, set<Unit*>> &units);
    void deleteUnit(Unit* unit, map<UnitType, set<Unit*>> &units);

    void updateEnemyUnitPosition(Unit *unit);
    void deleteEnemyUnitPosition(Unit *unit);
    void updateEnemyUnitsPositions();
    void fixVisibleEnemyUnitsTypes();

    void createThreatMap();
    void updateThreatMap();

    void checkZerglingRush();
    void checkZealotRush();
    void checkMarineRush();
    void checkProbablyCanonRush();
    void checkCanonRush();
    void checkEnemyFlyers();
    void checkEarlyMutalisks();
    void checkMassMarines();
    void checkMassGoliaths();
    void checkMassHydras();
    void checkMassDragoons();

    void patchCompletion();
    void resolveIncompleteUnits();

  public:

    Colony colony;
    Army army;
    Observation observation;

    Log log;

    int otherDuration;
    int colonyDuration;
    int armyDuration;
    int observationDuration;

    bool earlyRush;
    bool earlyZealotDrop;
    int state;
    int lastGatheredMinerals;
    int lastGatheredGas;
    int minerals100;
    int gas100;
    int currentSupply;
    int maxSupply;

    bool isZerglingRush;
    bool isZealotRush;
    bool isProbablyCanonRush;
    bool isCanonRush;
    bool isMarineRush;
    bool isEarlyMutalisks;
    bool enemyHasFlyers;
    bool isMassMarines;
    bool isMassGoliaths;
    bool isMassHydras;
    bool isMassDragoons;

    int lastFlyersCheckTrue;

    bool analyzed;
    map<UnitType, set<Unit*>> myUnits;
    map<UnitType, set<Unit*>> myUnitsCompleted;
    map<UnitType, set<Unit*>> enemyUnits;
    map<UnitType, set<Unit*>> enemyUnitsVisible;
    map<Unit*, Position> enemyUnitsPositions;
    set<Unit*> burrowedUnits;

    vector<vector<vector<WeaponType>>> threatMap;

    map<BWTA::BaseLocation*, EnemyBase> enemyBases;


    Ximp(): colony(Colony(this)),
            army(Army(this)),
            observation(Observation(this)) {};

    void onStart();
    void onUnitDiscover(Unit* unit);
    void onFrame();
    void onNukeDetect(Position target);
    void onUnitCreate(Unit* unit);
    void onUnitComplete(Unit *unit);
    void onUnitDestroy(Unit* unit);
    void onUnitMorph(Unit* unit);
    void onUnitRenegade(Unit* unit);
    void onUnitEvade(Unit* unit);
    void onUnitShow(Unit* unit);
    void onUnitHide(Unit* unit);

    void processAnalysis();
    int getFreeSupply(); 

    Position computeCentroid(set<Unit*> &units, bool initialPos = false);
    Position computeCentroid(set<Position> &positions);

    pair<Position, Position> getDistantPositions(set<Unit*> units);

    map<BWTA::BaseLocation*, EnemyBase*> getOccupiedEnemyBases();
    EnemyBase* getCapitalEnemyBase();
    bool isInRegionWithEnemyBase(Position pos);
    bool isInRegionWithEnemyUnits(Position pos);

    bool hasEnemyWithRace(Race race);

    Unit* getNearestEnemyUnit(Position pos, bool detected = true);
    Unit* getNearestUnitType(Position pos, UnitType unitType, UnitOwner unitOwner = CARELESS, bool smallestHP = false, bool detected = true);
    Unit* getNearestMineralField(Position pos, bool mustBeFree, bool staticMinerals = false);
    Unit* getNearestGeyser(Position pos);

    Position getNearestPosition(vector<TilePosition> tiles, Position pos);
    Position getNearestEnemyUnitPosition(Position pos, bool mustBeBuilding = false, bool detected = true);
    vector<Position> getEnemyUnitPositionsInRadius(Position pos, int radius, bool mustBeBuilding = false, bool detected = true);
    UnitType getEnemyUnitType(Unit* unit);

    BWTA::BaseLocation* getNearestBaseLocationFromSet(Position pos, set<BWTA::BaseLocation*> baseLocations);

    vector<TilePosition> rasterizeBasePolygon(BWTA::Polygon poly, BWTA::BaseLocation* baseLocation);

    bool isEnoughResources(UnitType unitType, bool exceptThis);
    bool isEnoughResources(UpgradeType upgradeType);
    bool isEnoughResources(TechType techType);
    bool isBeignGathered(Unit* unit);

    bool haveUnit(UnitType unit, bool completed = true);

    bool buildRequirementsMet(UnitType unitType);
    bool upgradeRequirementsMet(UpgradeType upgradeType);
    bool techRequirementsMet(TechType techType);

    vector<UnitType> getBuildOrderRev(UnitType unitType, vector<UnitType> &stack = vector<UnitType>());
    vector<UnitType> getBuildOrder(UnitType unitType, vector<UnitType> &stack = vector<UnitType>());

    set<Unit*> getMyUnits(UnitType unitType, bool mustBeCompleted = true);

    set<Unit*> getEnemyUnits(set<Unit*> &units, bool detected = true);
    set<Unit*> getUnitsOfType(UnitType unitType, set<Unit*> &units);
    set<Unit*> getUnitsWithAirWeapons(set<Unit*> &units);
    set<Unit*> getUnitsWithWeapon(set<Unit*> &units);
    set<Unit*> getResourceDepots(set<Unit*> &units);
    set<Unit*> getImportantBuildings(set<Unit*> &units);
    set<Unit*> getProductionBuildings(set<Unit*> &units);
    set<Unit*> getWorkers(set<Unit*> &units);
    set<Unit*> getFlyers(set<Unit*> &units);
    set<Unit*> getGroundUnits(set<Unit*> &units);
    set<Unit*> getUnitsThatCanAttack(set<Unit*> &units);

    Unit* getNearestUnit(Position pos, set<Unit*> &units, bool smallestHP = false, bool detected = true);

	  int getAirAttackPower(set<Unit*> &units);

    bool willHaveEnoughResources(UnitType unitType, double distance, double speed, UnitType except = UnitTypes::None);
   
};