#include "Dll.h"


void Ximp::addUnit(Unit* unit, map<UnitType, set<Unit*>> &units) {
  if (unit->getType() != UnitTypes::Unknown) {
    if (unit->getType().getRace() == Races::Zerg) {
      deleteUnit(unit, units);
    }

    map<UnitType, set<Unit*>>::iterator unitsIterator = units.find(unit->getType());

    if (unitsIterator != units.end()) {
      unitsIterator->second.insert(unit);
    }
    else {
      set<Unit*> newUnitType;
      newUnitType.insert(unit);
      units.insert(pair<UnitType, set<Unit*>>(unit->getType(), newUnitType));
    }
  }
}
    
void Ximp::deleteUnit(Unit* unit, map<UnitType, set<Unit*>> &units) {
  if (unit->getType().getRace() != Races::Zerg) {
    map<UnitType, set<Unit*>>::iterator unitsIterator = units.find(unit->getType());

    if (unit->getType() == UnitTypes::Resource_Vespene_Geyser) {
      unitsIterator = units.find(UnitTypes::Protoss_Assimilator);
    }

    if (unitsIterator != units.end()) {
      for (set<Unit*>::iterator it = unitsIterator->second.begin(); it != unitsIterator->second.end(); it++) {
        if ((*it) == unit) {
          unitsIterator->second.erase(it);
          return;
        }
      }
    }
  }
  else {
    for (map<UnitType, set<Unit*>>::iterator it = units.begin(); it != units.end(); it++) {
      for (set<Unit*>::iterator jt = it->second.begin(); jt != it->second.end(); jt++) {
        if (*jt == unit) {
          it->second.erase(jt);
          break;
        }
      }
    }
  }
}

void Ximp::updateEnemyUnitPosition(Unit *unit) {
  map<Unit*, Position>::iterator enemyUnitsPositionsIt = enemyUnitsPositions.find(unit);

  if (enemyUnitsPositionsIt != enemyUnitsPositions.end()) {
    enemyUnitsPositionsIt->second = unit->getPosition();
  }
  else {
    enemyUnitsPositions.insert(pair<Unit*, Position>(unit, unit->getPosition()));
  }
}

void Ximp::deleteEnemyUnitPosition(Unit *unit) {
  map<Unit*, Position>::iterator enemyUnitsPositionsIt = enemyUnitsPositions.find(unit);

  if (enemyUnitsPositionsIt != enemyUnitsPositions.end()) {
    enemyUnitsPositions.erase(enemyUnitsPositionsIt);
  }
}

void Ximp::updateEnemyUnitsPositions() {
  for (map<UnitType, set<Unit*>>::iterator it = enemyUnitsVisible.begin(); it != enemyUnitsVisible.end(); it++) {
    for (set<Unit*>::iterator jt = it->second.begin(); jt != it->second.end(); jt++) {
      map<Unit*, Position>::iterator enemyUnitsPositionsIt = enemyUnitsPositions.find(*jt);

      if (enemyUnitsPositionsIt != enemyUnitsPositions.end() && (*jt)->isVisible() && (*jt)->getPosition().isValid()) {
        enemyUnitsPositionsIt->second = (*jt)->getPosition();
      }

      if ((*jt)->isBurrowed()) {
        burrowedUnits.insert(*jt);
      }
      else {
        burrowedUnits.erase(*jt);
      }
    }
  }

  for (int i = 0; i < Broodwar->mapWidth(); i++) {
    for (int j = 0; j < Broodwar->mapHeight(); j++) {
      TilePosition tilePos(i, j);
      Position pos(i*TILE_SIZE + TILE_SIZE / 2, j*TILE_SIZE + TILE_SIZE / 2);

      if (Broodwar->isVisible(tilePos)) {
        for (map<Unit*, Position>::iterator it = enemyUnitsPositions.begin(); it != enemyUnitsPositions.end(); ) {
          if (it->second.getDistance(pos) <= TILE_SIZE) {
            UnitType unitType = getEnemyUnitType(it->first);
            set<Unit*> unitsOnTile = Broodwar->getUnitsInRadius(pos, TILE_SIZE);

            bool isThere = false;
            for (set<Unit*>::iterator jt = unitsOnTile.begin(); jt != unitsOnTile.end(); jt++) {
              if (*jt == it->first) {
                isThere = true;
                break;
              }
            }

            if (!it->first->exists() || unitType == UnitTypes::Resource_Vespene_Geyser) {
              isThere = false;
            }

            bool canBeDetected = false;
            if (unitType == UnitTypes::Terran_Vulture_Spider_Mine || unitType.isBurrowable()) {
              set<Unit*> observers = getMyUnits(UnitTypes::Protoss_Observer);
              set<Unit*> photonCanons = getMyUnits(UnitTypes::Protoss_Photon_Cannon);

              for (set<Unit*>::iterator observersIt = observers.begin(); observersIt != observers.end(); observersIt++) {
                if ((*observersIt)->getTilePosition().getDistance(tilePos) < 8) {
                  canBeDetected = true;
                }
              }

              if (!canBeDetected) {
                for (set<Unit*>::iterator photonCanonsIt = photonCanons.begin(); photonCanonsIt != photonCanons.end(); photonCanonsIt++) {
                  if ((*photonCanonsIt)->getTilePosition().getDistance(tilePos) < 8) {
                    canBeDetected = true;
                  }
                }
              }
            }

            if (!isThere && 
                (unitType != UnitTypes::Terran_Vulture_Spider_Mine || canBeDetected) &&
                (unitType.getRace() != Races::Zerg || !unitType.isBurrowable() || canBeDetected || burrowedUnits.find(it->first) == burrowedUnits.end())) {
              it = enemyUnitsPositions.erase(it);
            }
            else {
              it++;
            }
          }
          else {
            it++;
          }
        }
      }
    }
  }
}

void Ximp::fixVisibleEnemyUnitsTypes() {
  for (map<UnitType, set<Unit*>>::iterator it = enemyUnits.begin(); it != enemyUnits.end(); it++) {
    for (set<Unit*>::iterator jt = it->second.begin(); jt != it->second.end(); jt++) {
      if ((*jt)->isVisible() && (*jt)->getType() != it->first) {
        for (map<UnitType, set<Unit*>>::iterator et = enemyUnitsVisible.begin(); et != enemyUnitsVisible.end(); et++) {
          set<Unit*>::iterator tt = et->second.find(*jt);
          if (tt != et->second.end()) {
            et->second.erase(tt);
          }
        }

        for (map<UnitType, set<Unit*>>::iterator et = enemyUnits.begin(); et != enemyUnits.end(); et++) {
          set<Unit*>::iterator tt = et->second.find(*jt);
          if (tt != et->second.end()) {
            et->second.erase(tt);
          }
        }

        addUnit(*jt, enemyUnits);
        addUnit(*jt, enemyUnitsVisible);
        updateEnemyUnitPosition(*jt);

        break;
      }
    }
  }
}

void Ximp::createThreatMap() {
  for (int i = 0; i < Broodwar->mapWidth(); i++) {
    vector<vector<WeaponType>> row;

    for (int j = 0; j < Broodwar->mapHeight(); j++) {
      vector<WeaponType> weapons;

      row.push_back(weapons);
    }

    threatMap.push_back(row);
  }
}

void Ximp::updateThreatMap() {
  for (int i = 0; i < Broodwar->mapWidth(); i++) {
    for (int j = 0; j < Broodwar->mapHeight(); j++) {
      threatMap[i][j].clear();
    }
  }

  for (map<Unit*, Position>::iterator it = enemyUnitsPositions.begin(); it != enemyUnitsPositions.end(); it++) {
    UnitType unitType = getEnemyUnitType(it->first);

    if (unitType != UnitTypes::Unknown && unitType.canAttack()) {
      TilePosition tilePosition(it->second.x() / TILE_SIZE, it->second.y() / TILE_SIZE);

      WeaponType airWeapon = unitType.airWeapon();
      WeaponType groundWeapon = unitType.groundWeapon();

      if (airWeapon != WeaponTypes::None && airWeapon != WeaponTypes::Unknown) {
        int range = airWeapon.maxRange() / TILE_SIZE;
        if (range == 0) { range = 1; }
        TilePosition center(it->second);

        for (int i = tilePosition.x() - range; i <= tilePosition.x() + range; i++) {
          for (int j = tilePosition.y() - range; j <= tilePosition.y() + range; j++) {
            if (i >= 0 && j >= 0 && i < Broodwar->mapWidth() && j < Broodwar->mapHeight()) {
              TilePosition current(i, j);

              if (current.getDistance(center) <= range) {
                threatMap[i][j].push_back(airWeapon);
              }
            }
          }
        }
      }

      if (groundWeapon != WeaponTypes::None && groundWeapon != WeaponTypes::Unknown) {
        int range = groundWeapon.maxRange() / TILE_SIZE;
        if (range == 0) { range = 1; }
        TilePosition center(it->second);

        for (int i = tilePosition.x() - range; i <= tilePosition.x() + range; i++) {
          for (int j = tilePosition.y() - range; j <= tilePosition.y() + range; j++) {
            if (i >= 0 && j >= 0 && i < Broodwar->mapWidth() && j < Broodwar->mapHeight()) {
              TilePosition current(i, j);

              if (current.getDistance(center) <= range) {
                threatMap[i][j].push_back(groundWeapon);
              }
            }
          }
        }
      }
    }
  }
}

void Ximp::checkZerglingRush() {
  set<Unit*> units = Broodwar->getAllUnits();
  set<Unit*> enemyUnits = getEnemyUnits(units);

  set<Unit*> zerglings = getUnitsOfType(UnitTypes::Zerg_Zergling, enemyUnits);

  MyBase* capitalMyBase = colony.getCapitalMyBase();
  MyBase* naturalMyBase = colony.getNaturalMyBase();

  if (capitalMyBase != NULL && naturalMyBase != NULL) {
    for (set<Unit*>::iterator it = zerglings.begin(); it != zerglings.end(); it++) {
      if (capitalMyBase->isInBaseRegions((*it)->getPosition()) || naturalMyBase->isInBaseRegions((*it)->getPosition())) {
        Broodwar->printf("Zergling rush!");
        isZerglingRush = true;
        break;
      }
    }
  }
}

void Ximp::checkZealotRush() {
  map<UnitType, set<Unit*>>::iterator unitsIterator = enemyUnits.find(UnitTypes::Protoss_Gateway);

  if (unitsIterator != enemyUnits.end()) {
    if (unitsIterator->second.size() >= 2) {
      colony.changeStartBuildOrderZealotRush();
      Broodwar->printf("Zealot rush!");
      isZealotRush = true;
    }
  }
}

void Ximp::checkMarineRush() {
  map<UnitType, set<Unit*>>::iterator unitsIterator = enemyUnits.find(UnitTypes::Terran_Barracks);

  MyBase* capitalMyBase = colony.getCapitalMyBase();

  if (unitsIterator != enemyUnits.end() && capitalMyBase != NULL) {
    for (set<Unit*>::iterator it = unitsIterator->second.begin(); it != unitsIterator->second.end(); it++) {
      if (capitalMyBase->baseLocation->getPosition().getDistance((*it)->getPosition()) < 50 * TILE_SIZE) {
        colony.changeStartBuildOrderMarineRush();
        Broodwar->printf("Marine rush!");
        isMarineRush = true;
      }
    }
  }
}

void Ximp::checkProbablyCanonRush() {
  map<UnitType, set<Unit*>>::iterator enemyForges = enemyUnits.find(UnitTypes::Protoss_Forge);

  if (enemyForges != enemyUnits.end() && !enemyForges->second.empty()) {
    isProbablyCanonRush = true;
  }
}

void Ximp::checkCanonRush() {
  set<Unit*> units = Broodwar->getAllUnits();
  set<Unit*> enemyUnits = getEnemyUnits(units);

  set<Unit*> pylons = getUnitsOfType(UnitTypes::Protoss_Pylon, enemyUnits);

  MyBase* capitalMyBase = colony.getCapitalMyBase();

  if (capitalMyBase != NULL) {
    for (set<Unit*>::iterator it = pylons.begin(); it != pylons.end(); it++) {
      if (capitalMyBase->isInBaseRegions((*it)->getPosition())) {
        Broodwar->printf("Canon rush!");
        isCanonRush = true;
        break;
      }
    }
  }
}

void Ximp::checkEnemyFlyers() {
  int flyersCount = 0;

  for (map<UnitType, set<Unit*>>::iterator it = enemyUnits.begin(); it != enemyUnits.end(); it++) {
    if (it->first.isFlyer()) {
      if (it->first != UnitTypes::Zerg_Overlord && it->first != UnitTypes::Zerg_Queen && it->first != UnitTypes::Zerg_Devourer &&
        it->first != UnitTypes::Protoss_Shuttle && it->first != UnitTypes::Protoss_Arbiter && it->first != UnitTypes::Protoss_Observer && it->first != UnitTypes::Protoss_Interceptor &&
        it->first != UnitTypes::Terran_Dropship && it->first != UnitTypes::Terran_Science_Facility) {
        flyersCount += it->second.size();
      }
    }
  }

  if (flyersCount >= 5) {
    enemyHasFlyers = true;
    lastFlyersCheckTrue = Broodwar->getFrameCount();
  }
}

void Ximp::checkEarlyMutalisks() {
  set<Unit*> units = Broodwar->getAllUnits();
  set<Unit*> enemyUnits = getEnemyUnits(units);

  for (set<Unit*>::iterator it = enemyUnits.begin(); it != enemyUnits.end(); it++) {
    if ((*it)->getType() == UnitTypes::Zerg_Spire || (*it)->getBuildType() == UnitTypes::Zerg_Spire || (*it)->getType() == UnitTypes::Zerg_Mutalisk) {
      Broodwar->printf("Enemy early mutalisks!");
      isEarlyMutalisks = true;
      colony.changeNormalBuildOrderEarlyMutalisks();
      break;
    }
  }
}

void Ximp::checkMassMarines() {
  map<UnitType, set<Unit*>>::iterator enemyMarines = enemyUnits.find(UnitTypes::Terran_Marine);

  if (enemyMarines != enemyUnits.end() && enemyMarines->second.size() > 40) {
    isMassMarines = true;
    Broodwar->printf("is mass Marines");
  }
}

void Ximp::checkMassGoliaths() {
  map<UnitType, set<Unit*>>::iterator enemyMarines = enemyUnits.find(UnitTypes::Terran_Goliath);

  if (enemyMarines != enemyUnits.end() && enemyMarines->second.size() > 15) {
    isMassGoliaths = true;
    Broodwar->printf("is mass Goliaths");
  }
}

void Ximp::checkMassHydras() {
  map<UnitType, set<Unit*>>::iterator enemyHydras = enemyUnits.find(UnitTypes::Zerg_Hydralisk);

  if (enemyHydras != enemyUnits.end() && enemyHydras->second.size() > 40) {
    isMassHydras = true;
    Broodwar->printf("is mass Hydras");
  }
}

void Ximp::checkMassDragoons() {
  map<UnitType, set<Unit*>>::iterator enemyDragoons = enemyUnits.find(UnitTypes::Protoss_Dragoon);

  if (enemyDragoons != enemyUnits.end() && enemyDragoons->second.size() > 15) {
    isMassDragoons = true;
    Broodwar->printf("is mass Dragoons");
  }
}

void Ximp::patchCompletion() {
	for (set<Unit*>::const_iterator it = Broodwar->self()->getUnits().begin(); it != Broodwar->self()->getUnits().end(); it++) {
    if ((*it)->isCompleted()) {
      map<UnitType, set<Unit*>>::iterator myUnitsCompetedIt = myUnitsCompleted.find((*it)->getType());

      if (myUnitsCompetedIt != myUnitsCompleted.end()) {
        bool newCompletedUnit = true;

        for (set<Unit*>::iterator jt = myUnitsCompetedIt->second.begin(); jt != myUnitsCompetedIt->second.end(); jt++) {
          if (*it == *jt){
            newCompletedUnit = false;
          }
        }

        if (newCompletedUnit) {
          onUnitComplete(*it);
        }
      }
      else {
        onUnitComplete(*it);
      }
    }
  }
}

void Ximp::resolveIncompleteUnits() {
  if (!incompleteAssimilators.empty()) {
    for (set<Unit*>::iterator it = incompleteAssimilators.begin(); it != incompleteAssimilators.end(); it++) {
      if (!(*it)->isBeingConstructed()) {
        addUnit(*it, myUnitsCompleted);
        incompleteAssimilators.erase(it);
        break;
      }
    }
  }

  if (!incompleteArchons.empty()) {
    for (set<Unit*>::iterator it = incompleteArchons.begin(); it != incompleteArchons.end(); it++) {
      if ((*it)->getOrder() != Orders::ArchonWarp && (*it)->getOrder() != Orders::ResetCollision && (*it)->getOrder() != Orders::CompletingArchonsummon) {
        addUnit(*it, myUnitsCompleted);
        incompleteArchons.erase(it);
        break;
      }
    }
  }
}

void Ximp::onStart() {
  #if WRITE_LOG
    log.createLog("ximp_log");
  #endif

  Broodwar->setLocalSpeed(0);

  incompleteAssimilators.clear();
  incompleteArchons.clear();

  myUnits.clear();
  myUnitsCompleted.clear();
  enemyUnits.clear();
  enemyUnitsVisible.clear();
  enemyUnitsPositions.clear();
  burrowedUnits.clear();

  enemyBases.clear();

  threatMap.clear();
  createThreatMap();

  analyzed = false;

  set<Unit*> reservedMinerals;

  for (set<Unit*>::const_iterator it = Broodwar->self()->getUnits().begin(); it != Broodwar->self()->getUnits().end(); it++) {
    addUnit(*it, myUnits);
    addUnit(*it, myUnitsCompleted);

    if ((*it)->getType() == UnitTypes::Protoss_Nexus) {
      (*it)->train(UnitTypes::Protoss_Probe);
    }

    if ((*it)->getType() == UnitTypes::Protoss_Probe) {
      set<Unit*> minerals = Broodwar->getMinerals();
      Unit* nearestMineral = NULL;

      Position startPosition = Position(Broodwar->self()->getStartLocation().x()*TILE_SIZE + 2*TILE_SIZE, Broodwar->self()->getStartLocation().y()*TILE_SIZE + 1.5*TILE_SIZE);

	    for (set<Unit*>::iterator jt = minerals.begin(); jt != minerals.end(); jt++) {
        if (nearestMineral == NULL || startPosition.getDistance((*jt)->getPosition()) < startPosition.getDistance(nearestMineral->getPosition())) {
          if (reservedMinerals.find(*jt) == reservedMinerals.end()) {
            nearestMineral = *jt;
          }
        }
      }

      if (nearestMineral != NULL) {
        (*it)->gather(nearestMineral);
        reservedMinerals.insert(nearestMineral);
      }
    }
	}

  colony.onStart();
  army.onStart();
  observation.onStart();

  state = 0;
  earlyRush = false;
  earlyZealotDrop = false;

  lastGatheredMinerals = 0;
  lastGatheredGas = 0;

  minerals100 = 0;
  gas100 = 0;

  maxSupply = 0;
  currentSupply = 4;

  isZerglingRush = false;
  isZealotRush = false;
  isProbablyCanonRush = false;
  isCanonRush = false;
  isMarineRush = false;
  isEarlyMutalisks = false;
  enemyHasFlyers = false;
  isMassMarines = false;
  isMassGoliaths = false;
  isMassHydras = false;
  isMassDragoons = false;

  lastFlyersCheckTrue = 0;
}

void Ximp::onUnitDiscover(Unit* unit) {

  colony.onUnitDiscover(unit);
  army.onUnitDiscover(unit);
  observation.onUnitDiscover(unit);
}

void Ximp::onFrame() {
  #if WRITE_LOG 
    ostringstream ss;
    ss << "Ximp::onFrame - start";
    log.writeToLog(ss.str());
  #endif

  otherDuration = GetTickCount();
  fixVisibleEnemyUnitsTypes();

  if (Broodwar->getFrameCount() == 90) {
    Broodwar->sendText("gl hf");
  }

  if (Broodwar->getFrameCount() % 100 == 0 && Broodwar->getFrameCount() > 0) {
    minerals100 = Broodwar->self()->gatheredMinerals() - lastGatheredMinerals;
    gas100 = Broodwar->self()->gatheredGas() - lastGatheredGas;
    
    lastGatheredMinerals = Broodwar->self()->gatheredMinerals();
    lastGatheredGas = Broodwar->self()->gatheredGas();

    updateThreatMap();
  }

  if (Broodwar->getFrameCount() % 15 == 0 && Broodwar->getFrameCount() > 0) {
    updateEnemyUnitsPositions();
  }

  patchCompletion();

  resolveIncompleteUnits();

  if (!isZerglingRush && Broodwar->getFrameCount() < 5000) {
    checkZerglingRush();
  }

  if (!isZealotRush && Broodwar->getFrameCount() < 7000) {
    checkZealotRush();
  }

  if (!isMarineRush && Broodwar->getFrameCount() < 5000) {
    checkMarineRush();
  }

  if (!isProbablyCanonRush && Broodwar->getFrameCount() < 5000) {
    checkProbablyCanonRush();
  }

  if (!isCanonRush && Broodwar->getFrameCount() < 5000) {
    checkCanonRush();
  }

  if (!isEarlyMutalisks && Broodwar->getFrameCount() < 13000) {
    checkEarlyMutalisks();
  }

  if (Broodwar->getFrameCount() - lastFlyersCheckTrue >= 100) {
    //enemyHasFlyers = true;
    if (!enemyHasFlyers) {
      checkEnemyFlyers();
    }
    else if (Broodwar->getFrameCount() - lastFlyersCheckTrue >= 3000) {
      enemyHasFlyers = false;
    }
  }

  if (!isMassMarines) {
    checkMassMarines();
  }

  if (!isMassGoliaths) {
    checkMassGoliaths();
  }

  if (!isMassHydras) {
    checkMassHydras();
  }

  if (!isMassDragoons) {
    checkMassDragoons();
  }
  otherDuration = GetTickCount() - otherDuration;
  
  colonyDuration = GetTickCount();
  colony.onFrame();
  colonyDuration = GetTickCount() - colonyDuration;

  armyDuration = GetTickCount();
  army.onFrame();
  armyDuration = GetTickCount() - armyDuration;

  observationDuration = GetTickCount();
  observation.onFrame();
  observationDuration = GetTickCount() - observationDuration;

  #if WRITE_LOG 
    ss.str("");
    ss << "Ximp::onFrame - end";
    log.writeToLog(ss.str());
  #endif
}

void Ximp::onNukeDetect(Position target) {

  colony.onNukeDetect(target);
  army.onNukeDetect(target);
  observation.onNukeDetect(target);
}

void Ximp::onUnitCreate(Unit* unit) {
  if (!Broodwar->self()->isEnemy(unit->getPlayer()) && !unit->getPlayer()->isNeutral()) {
    addUnit(unit, myUnits);

    currentSupply += unit->getType().supplyRequired()/2;
    if (currentSupply > maxSupply) {
      maxSupply = currentSupply;
    }
  }

  colony.onUnitCreate(unit);
  army.onUnitCreate(unit);
  observation.onUnitCreate(unit);
}

void Ximp::onUnitComplete(Unit *unit) {
  if (!unit->isCompleted()) {
    return;
  }

  if (!Broodwar->self()->isEnemy(unit->getPlayer()) && !unit->getPlayer()->isNeutral()) {
    addUnit(unit, myUnitsCompleted);
  }

  colony.onUnitComplete(unit);
  army.onUnitComplete(unit);
  observation.onUnitComplete(unit);
}

void Ximp::onUnitDestroy(Unit* unit) {
  if (!Broodwar->self()->isEnemy(unit->getPlayer()) && !unit->getPlayer()->isNeutral()) {
    deleteUnit(unit, myUnits);
    deleteUnit(unit, myUnitsCompleted);

    currentSupply -= unit->getType().supplyRequired()/2;

    if (unit->getType() == UnitTypes::Protoss_Assimilator) {
      if (!incompleteAssimilators.empty()) {
        for (set<Unit*>::iterator it = incompleteAssimilators.begin(); it != incompleteAssimilators.end(); it++) {
          if ((*it) == unit) {
            incompleteAssimilators.erase(it);
            break;
          }
        }
      }
    }

    if (unit->getType() == UnitTypes::Protoss_Archon) {
      if (!incompleteArchons.empty()) {
        for (set<Unit*>::iterator it = incompleteArchons.begin(); it != incompleteArchons.end(); it++) {
          if ((*it) == unit) {
            incompleteArchons.erase(it);
            break;
          }
        }
      }
    }
  }

  if (Broodwar->self()->isEnemy(unit->getPlayer())) {
    deleteUnit(unit, enemyUnits);
    deleteUnit(unit, enemyUnitsVisible);
    deleteEnemyUnitPosition(unit);

    if (unit->getType().isBuilding() || unit->getType().getRace() == Races::Zerg) {
      bool deleted = false;

      for (map<BWTA::BaseLocation*, EnemyBase>::iterator it = enemyBases.begin(); it != enemyBases.end(); it++) {
        if (it->second.isInBaseRegions(unit->getPosition())) {
          it->second.deleteBuilding(unit);
          deleted = true;
          break;
        }
      }

      if (!deleted) {
        BWTA::BaseLocation* baseLocation = BWTA::getNearestBaseLocation(unit->getPosition());

        map<BWTA::BaseLocation*, EnemyBase>::iterator enemyBasesIterator = enemyBases.find(baseLocation);

        if (enemyBasesIterator != enemyBases.end()) {
          enemyBasesIterator->second.deleteBuilding(unit);
        }
      }
    }
  }

  colony.onUnitDestroy(unit);
  army.onUnitDestroy(unit);
  observation.onUnitDestroy(unit);
}

void Ximp::onUnitMorph(Unit* unit) {
  if (!Broodwar->self()->isEnemy(unit->getPlayer()) && !unit->getPlayer()->isNeutral()) {
    if (unit->getType() == UnitTypes::Protoss_Archon) {
      map<UnitType, set<Unit*>>::iterator unitsIterator = myUnits.find(UnitTypes::Protoss_High_Templar);
      for (set<Unit*>::iterator it = unitsIterator->second.begin(); it != unitsIterator->second.end(); it++) {
        if ((*it) == unit) {
          unitsIterator->second.erase(it);
          break;
        }
      }

      unitsIterator = myUnitsCompleted.find(UnitTypes::Protoss_High_Templar);
      for (set<Unit*>::iterator it = unitsIterator->second.begin(); it != unitsIterator->second.end(); it++) {
        if ((*it) == unit) {
          unitsIterator->second.erase(it);
          break;
        }
      }

      addUnit(unit, myUnits);
      incompleteArchons.insert(unit);
    }
    else if (unit->getType() == UnitTypes::Protoss_Assimilator) {
      addUnit(unit, myUnits);
      incompleteAssimilators.insert(unit);
    }
  }

  if (unit->getType() == UnitTypes::Resource_Vespene_Geyser) {
    deleteUnit(unit, myUnits);
    deleteUnit(unit, myUnitsCompleted);
    deleteUnit(unit, enemyUnits);
    deleteUnit(unit, enemyUnitsVisible);
    deleteEnemyUnitPosition(unit);
  }

  colony.onUnitMorph(unit);
  army.onUnitMorph(unit);
  observation.onUnitMorph(unit);
}

void Ximp::onUnitRenegade(Unit* unit) {
  colony.onUnitRenegade(unit);
  army.onUnitRenegade(unit);
  observation.onUnitRenegade(unit);
}

void Ximp::onUnitEvade(Unit* unit) {
  colony.onUnitEvade(unit);
  army.onUnitEvade(unit);
  observation.onUnitEvade(unit);
}

void Ximp::onUnitShow(Unit* unit) {
  if (Broodwar->self()->isEnemy(unit->getPlayer())) {
    addUnit(unit, enemyUnits);
    addUnit(unit, enemyUnitsVisible);
    updateEnemyUnitPosition(unit);

    if (unit->getType().isBuilding() && !unit->isLifted()) {
      bool added = false;

      for (map<BWTA::BaseLocation*, EnemyBase>::iterator it = enemyBases.begin(); it != enemyBases.end(); it++) {
        if (it->second.isInBaseRegions(unit->getPosition())) {
          it->second.addBuilding(unit);
          added = true;
          break;
        }
      }

      if (!added) {
        BWTA::BaseLocation* baseLocation = BWTA::getNearestBaseLocation(unit->getPosition());

        map<BWTA::BaseLocation*, EnemyBase>::iterator enemyBasesIterator = enemyBases.find(baseLocation);

        if (enemyBasesIterator != enemyBases.end()) {
          enemyBasesIterator->second.addBuilding(unit);
        }
      }
    }
  }

  colony.onUnitShow(unit);
  army.onUnitShow(unit);
  observation.onUnitShow(unit);
}

void Ximp::onUnitHide(Unit* unit) {
  if (Broodwar->self()->isEnemy(unit->getPlayer()) || unit->getType().isAddon()) {
    deleteUnit(unit, enemyUnitsVisible);
    updateEnemyUnitPosition(unit);
  }

  colony.onUnitHide(unit);
  army.onUnitHide(unit);
  observation.onUnitHide(unit);
}


void Ximp::processAnalysis() {
  set<BWTA::BaseLocation*> baseLocations = BWTA::getBaseLocations();

  for (set<BWTA::BaseLocation*>::iterator it = baseLocations.begin(); it != baseLocations.end(); it++) {
    bool nearOtherBaseLocation = false;

    for (set<BWTA::BaseLocation*>::iterator jt = baseLocations.begin(); jt != baseLocations.end(); jt++) {
      if (*it != *jt && (*it)->getAirDistance(*jt) < 4*TILE_SIZE && enemyBases.find(*jt) != enemyBases.end()) {
        nearOtherBaseLocation = true;
      }
    }

    if (!nearOtherBaseLocation && !(*it)->isIsland()) {
      enemyBases.insert(pair<BWTA::BaseLocation*, EnemyBase>(*it, EnemyBase(this, *it)));
    }
  }

  analyzed = true;

  colony.processAnalysis();
  army.processAnalysis();
  observation.processAnalysis();
}

int Ximp::getFreeSupply() {
  int freeSupply = Broodwar->self()->supplyTotal()/2 - Broodwar->self()->supplyUsed()/2;
  return freeSupply >= 0 ? freeSupply : 0;
}

Position Ximp::computeCentroid(set<Unit*> &units, bool initialPos) {
  if (units.empty()) {
    return Position(0,0);
  }

  int x = 0, y = 0;

  for (set<Unit*>::iterator it = units.begin(); it != units.end(); it++) {
    if (!initialPos) {
      x += (*it)->getPosition().x();
      y += (*it)->getPosition().y();
    }
    else {
      x += (*it)->getInitialPosition().x();
      y += (*it)->getInitialPosition().y();
    }
  }

  return Position(x/units.size(), y/units.size());
}

Position Ximp::computeCentroid(set<Position> &positions) {
  if (positions.empty()) {
    return Position(0,0);
  }

  int x = 0, y = 0;

  for (set<Position>::iterator it = positions.begin(); it != positions.end(); it++) {
    x += it->x();
    y += it->y();
  }

  return Position(x/positions.size(), y/positions.size());
}

pair<Position, Position> Ximp::getDistantPositions(set<Unit*> units) {
  if (units.empty()) {
    return pair<Position, Position>(Position(-1,-1), Position(-1,-1));
  }

  Position centroid = computeCentroid(units, true);
  Unit* cornerMineral1 = NULL;

  for (set<Unit*>::iterator it = units.begin(); it != units.end(); it++) {
    if (cornerMineral1 == NULL || (*it)->getInitialPosition().getDistance(centroid) > cornerMineral1->getInitialPosition().getDistance(centroid)) {
      cornerMineral1 = *it;
    }
  }

  Unit* cornerMineral2 = NULL;

  for (set<Unit*>::iterator it = units.begin(); it != units.end(); it++) {
    if ((cornerMineral2 == NULL || (*it)->getInitialPosition().getDistance(centroid) > cornerMineral2->getInitialPosition().getDistance(centroid)) && *it != cornerMineral1) {
      cornerMineral2 = *it;
    }
  } 

  if (cornerMineral1 != NULL && cornerMineral2 != NULL) {
    return pair<Position, Position>(cornerMineral1->getInitialPosition(), cornerMineral2->getInitialPosition());
  }
  else {
    return pair<Position, Position>(Position(-1,-1), Position(-1,-1));
  }
}

map<BWTA::BaseLocation*, EnemyBase*> Ximp::getOccupiedEnemyBases() {
  map<BWTA::BaseLocation*, EnemyBase*> enemyOccupiedBases;

  for (map<BWTA::BaseLocation*, EnemyBase>::iterator enemyBasesIterator = enemyBases.begin(); enemyBasesIterator != enemyBases.end(); enemyBasesIterator++) {
    if (enemyBasesIterator->second.isEnemyBase()) {
      enemyOccupiedBases.insert(pair<BWTA::BaseLocation*, EnemyBase*>(enemyBasesIterator->first, &enemyBasesIterator->second));
    }
  }

  return enemyOccupiedBases;
}

EnemyBase* Ximp::getCapitalEnemyBase() {
  for (map<BWTA::BaseLocation*, EnemyBase>::iterator enemyBasesIterator = enemyBases.begin(); enemyBasesIterator != enemyBases.end(); enemyBasesIterator++) {
    if (enemyBasesIterator->second.isCapital) {
      return &enemyBasesIterator->second;
    }
  }

  return NULL;
}

bool Ximp::isInRegionWithEnemyBase(Position pos) {
  map<BWTA::BaseLocation*, EnemyBase*> occupiedEnemyBases = getOccupiedEnemyBases();

  for (map<BWTA::BaseLocation*, EnemyBase*>::iterator it = occupiedEnemyBases.begin(); it != occupiedEnemyBases.end(); it++) {
    if (it->second->isInBaseRegions(pos)) {
      return true;
    }
  }

  return false;
}

bool Ximp::isInRegionWithEnemyUnits(Position pos) {
  set<BWTA::Region*> enemyRegions;

  for (map<Unit*, Position>::iterator it = enemyUnitsPositions.begin(); it != enemyUnitsPositions.end(); it++) {
    UnitType unitType = getEnemyUnitType(it->first);

    if (!unitType.isWorker() && !unitType.isAddon() && unitType != UnitTypes::Zerg_Larva && unitType != UnitTypes::Terran_Vulture_Spider_Mine && unitType != UnitTypes::Protoss_Observer) {
      BWTA::Region* region = BWTA::getRegion(it->second);
      enemyRegions.insert(region);
    }
  }

  BWTA::Region* posRegion = BWTA::getRegion(pos);

  for (set<BWTA::Region*>::iterator it = enemyRegions.begin(); it != enemyRegions.end(); it++) {
    if (*it == posRegion) {
      return true;
    }
  }

  return false;
}

bool Ximp::hasEnemyWithRace(Race race) {
  bool result = false;

  std::set<Player*> players = Broodwar->getPlayers();
  for (std::set<Player*>::iterator it = players.begin(); it != players.end(); it++) {
    if ((*it)->getRace() == race) {
      result = true;
    }
  }

  return result;
}

Unit* Ximp::getNearestEnemyUnit(Position pos, bool detected) {
  Unit* nearest = NULL;

  for (map<UnitType, set<Unit*>>::iterator it = enemyUnits.begin(); it != enemyUnits.end(); it++) {
    if (it->first != UnitTypes::Terran_Vulture_Spider_Mine) {
      for (set<Unit*>::iterator jt = it->second.begin(); jt != it->second.end(); jt++) {
        if (nearest == NULL || pos.getDistance((*jt)->getPosition()) < pos.getDistance(nearest->getPosition())) {
          if (!detected || (detected && (*jt)->isDetected())) {
            nearest = *jt;
          }
        }
      }
    }
  }

  return nearest;
}

Unit* Ximp::getNearestUnitType(Position pos, UnitType unitType, UnitOwner unitOwner, bool smallestHP, bool detected) {
  Unit* closest = NULL;

  set<Unit*> searchedUnits = Broodwar->getAllUnits();

	for (set<Unit*>::iterator it = searchedUnits.begin(); it != searchedUnits.end(); it++) {
    //if ((*it)->isCompleted()) {
      if ((*it)->getType() == unitType && 
          (unitOwner == CARELESS ||
          (unitOwner == MY && !Broodwar->self()->isEnemy((*it)->getPlayer()) && !(*it)->getType().isNeutral()) || 
          (unitOwner == ENEMY && Broodwar->self()->isEnemy((*it)->getPlayer()) && !(*it)->getType().isNeutral()) || 
          (unitOwner == NEUTRAL && !Broodwar->self()->isEnemy((*it)->getPlayer()) && (*it)->getType().isNeutral()))) {
        if (!smallestHP || (smallestHP && (closest == NULL || (*it)->getHitPoints() + (*it)->getShields() <= closest->getHitPoints() + closest->getShields()))) {
          if ((closest == NULL 
              || /*((ximp->analyzed && BWTA::getGroundDistance(TilePosition(pos), (*it)->getTilePosition()) < BWTA::getGroundDistance(TilePosition(pos), closest->getTilePosition())) 
              ||*/ pos.getDistance((*it)->getPosition()) < pos.getDistance(closest->getPosition())/*)*/)) {
            if (!detected || (detected && (*it)->isDetected())) {
			        closest = *it;
            }
          }
        }
      //}
    }
	}

  return closest;
}

Unit* Ximp::getNearestMineralField(Position pos, bool mustBeFree, bool staticMinerals) {
  set<Unit*> mineralFields = Broodwar->getMinerals();
  Unit* closest = NULL;

  BWTA::BaseLocation* nearestBaseLocation = BWTA::getNearestBaseLocation(pos);

  if (nearestBaseLocation != NULL) {
    mineralFields = nearestBaseLocation->getMinerals(); 
    if (staticMinerals) {
      mineralFields = nearestBaseLocation->getStaticMinerals(); 
    }
  }

	for (set<Unit*>::iterator it = mineralFields.begin(); it != mineralFields.end(); it++) {
    if ((mustBeFree && !isBeignGathered(*it)) || !mustBeFree) {
      BWTA::BaseLocation* mineralNearestBaseLocation = BWTA::getNearestBaseLocation((*it)->getInitialPosition());

      if ((closest == NULL || pos.getDistance((*it)->getInitialPosition()) < pos.getDistance(closest->getInitialPosition())) 
           && ((analyzed && mineralNearestBaseLocation != NULL && !mineralNearestBaseLocation->isIsland()) || !analyzed)) {
			  closest = *it;
      }
    }
	}

  return closest;
}

Unit* Ximp::getNearestGeyser(Position pos) {
  set<Unit*> geysers = Broodwar->getGeysers();
  Unit* closest = NULL;

  BWTA::BaseLocation* nearestBaseLocation = BWTA::getNearestBaseLocation(pos);

  if (nearestBaseLocation != NULL) {
    geysers = nearestBaseLocation->getGeysers(); 
  }

	for (set<Unit*>::iterator it = geysers.begin(); it != geysers.end(); it++) {
    BWTA::BaseLocation* geyserNearestBaseLocation = BWTA::getNearestBaseLocation((*it)->getInitialPosition());

    if ((closest == NULL || pos.getDistance((*it)->getInitialPosition()) < pos.getDistance(closest->getInitialPosition())) 
         && ((analyzed && geyserNearestBaseLocation != NULL && !geyserNearestBaseLocation->isIsland()) || !analyzed)) {
	    closest = *it;
    }
 }

  return closest;
}

Position Ximp::getNearestPosition(vector<TilePosition> tiles, Position pos) {
  int nearest = 0;
  for (int i = 1; i < tiles.size(); i++) {
    if (pos.getDistance(Position(tiles[i])) < pos.getDistance(Position(tiles[nearest]))) {
      nearest = i;
    }
  }
  return Position(tiles[nearest]);
}

Position Ximp::getNearestEnemyUnitPosition(Position pos, bool mustBeBuilding, bool detected) {
  Position nearest(-1,-1);

  for (map<Unit*, Position>::iterator it = enemyUnitsPositions.begin(); it != enemyUnitsPositions.end(); it++) {
    if (it->second.isValid() && getEnemyUnitType(it->first) != UnitTypes::Terran_Vulture_Spider_Mine/* && !getEnemyUnitType(it->first).isAddon()*/) {
      if (nearest == Position(-1,-1)  || pos.getDistance(it->second) < pos.getDistance(nearest)) {
        if (!detected || !Broodwar->isVisible(TilePosition(it->second)) || (detected && it->first->isDetected())) {
          UnitType unitType = getEnemyUnitType(it->first);
        
          if (!mustBeBuilding || unitType.isBuilding()) {
            nearest = it->second;
          }
        }
      }
    }
  }

  return nearest;
}

vector<Position> Ximp::getEnemyUnitPositionsInRadius(Position pos, int radius, bool mustBeBuilding, bool detected) {
  vector<Position> result;

  for (map<Unit*, Position>::iterator it = enemyUnitsPositions.begin(); it != enemyUnitsPositions.end(); it++) {
    if (it->second.isValid() && getEnemyUnitType(it->first) != UnitTypes::Terran_Vulture_Spider_Mine) {
      if (pos.getDistance(it->second) <= radius) {
        if (!detected || (detected && it->first->isDetected())) {
          UnitType unitType = getEnemyUnitType(it->first);

          if (!mustBeBuilding || unitType.isBuilding()) {
            result.push_back(it->second);
          }
        }
      }
    }
  }

  return result;
}

UnitType Ximp::getEnemyUnitType(Unit* unit) {
  UnitType result = UnitTypes::Unknown;

  for (map<UnitType, set<Unit*>>::iterator it = enemyUnits.begin(); it != enemyUnits.end(); it++) {
    for (set<Unit*>::iterator jt = it->second.begin(); jt != it->second.end(); jt++) {
      if (*jt == unit) {
        return it->first;
      }
    }
  }

  return result;
}

BWTA::BaseLocation* Ximp::getNearestBaseLocationFromSet(Position pos, set<BWTA::BaseLocation*> baseLocations) {
  BWTA::BaseLocation* nearest = NULL;

  for (set<BWTA::BaseLocation*>::iterator it = baseLocations.begin(); it != baseLocations.end(); it++) {
    if (nearest == NULL || ((*it)->getPosition().getDistance(pos) < nearest->getPosition().getDistance(pos))) {
      nearest = *it;
    }
  }

  return nearest;
}

vector<TilePosition> Ximp::rasterizeBasePolygon(BWTA::Polygon poly, BWTA::BaseLocation* baseLocation) {
  MyBase* myBase = NULL;
  map<BWTA::BaseLocation*, MyBase>::iterator myBaseIterator = colony.myBases.find(baseLocation);
  if (myBaseIterator != colony.myBases.end()) {
    myBase = &myBaseIterator->second;
  }

  vector<TilePosition> result;

  if (myBase == NULL) {
    return result;
  }

  Position pos = baseLocation->getPosition();

  for (int i = 0; i < poly.size(); i++) {
    TilePosition currentTile(poly[i]);
    TilePosition nextTile(poly[(i + 1) % poly.size()]);

    if (currentTile != nextTile) {
      double vector[2] = { nextTile.x() - currentTile.x(), nextTile.y() - currentTile.y() };
      int longer = abs(vector[0]) >= abs(vector[1]) ? 0 : 1;
      int shorter = abs(vector[0]) < abs(vector[1]) ? 0 : 1;

      double dshorter = vector[shorter] == 0 ? 0 : vector[shorter] / abs(vector[longer]);
      double dlonger = vector[longer] / abs(vector[longer]);
    
      int count = abs(vector[longer]);
      for (int j = 0; j < count; j++) {
        vector[shorter] = j*dshorter;
        vector[longer] = j*dlonger;
            
        for (int j = -1; j < 2; j++) {
          bool added = false;
          for (int k = -1; k < 2; k++) {
            TilePosition surroundTile = TilePosition(currentTile.x()+vector[0]+j, currentTile.y()+vector[1]+k);
            Position surroundPosition(surroundTile);
            surroundPosition.x() += TILE_SIZE/2; surroundPosition.y() += TILE_SIZE/2;

            if (std::find(result.begin(), result.end(), surroundTile) == result.end() && surroundTile.isValid() && surroundTile.hasPath(TilePosition(pos)) && myBase->isInBaseRegions(surroundPosition)) {
              result.push_back(surroundTile);
              added = true;
              break;
            }
          }
          if (added) {
            break;
          }
        }
      }
    }
  }

  return result;
}

bool Ximp::isEnoughResources(UnitType unitType, bool exceptThis) {
  return unitType.supplyRequired() / 2 <= getFreeSupply() && 
         unitType.mineralPrice() <= Broodwar->self()->minerals() - (exceptThis ? colony.buildingsBeignBuiltMinerals(unitType) : colony.buildingsBeignBuiltMinerals()) && 
         unitType.gasPrice() <= Broodwar->self()->gas() - (exceptThis ? colony.buildingsBeignBuiltGas(unitType) : colony.buildingsBeignBuiltGas());
}

bool Ximp::isEnoughResources(UpgradeType upgradeType) {
  if (Broodwar->self()->getMaxUpgradeLevel(upgradeType) == Broodwar->self()->getUpgradeLevel(upgradeType)) {
    return false;
  }

  return upgradeType.mineralPrice(Broodwar->self()->getUpgradeLevel(upgradeType)+1) <= Broodwar->self()->minerals() - colony.buildingsBeignBuiltMinerals() && 
         upgradeType.gasPrice(Broodwar->self()->getUpgradeLevel(upgradeType)+1) <= Broodwar->self()->gas() - colony.buildingsBeignBuiltGas();
}

bool Ximp::isEnoughResources(TechType techType) {
  return techType.mineralPrice() <= Broodwar->self()->minerals() - colony.buildingsBeignBuiltMinerals() && 
         techType.gasPrice() <= Broodwar->self()->gas() - colony.buildingsBeignBuiltGas();
}

bool Ximp::isBeignGathered(Unit* unit) {
  map<UnitType, set<Unit*>>::iterator workers = myUnits.find(UnitTypes::Protoss_Probe);

  if (workers != myUnits.end()) {
    for (set<Unit*>::iterator it = workers->second.begin(); it != workers->second.end(); it++) {
      if ((*it)->isGatheringMinerals() && (*it)->getOrderTarget() == unit) {
        return true;
      }
    }
  }

  return false;
}

bool Ximp::haveUnit(UnitType unitType, bool completed) {
  map<UnitType, set<Unit*>> *myUnitsP = &myUnits;

  if (completed) {
    myUnitsP = &myUnitsCompleted;
  }

  map<UnitType, set<Unit*>>::iterator myUnitsIt = myUnitsP->find(unitType);

  if (myUnitsIt != myUnitsP->end() && !myUnitsIt->second.empty()) {
    return true;
  }

	return false;
}

bool Ximp::buildRequirementsMet(UnitType unitType) {
	for (map<UnitType, int>::const_iterator it = unitType.requiredUnits().begin(); it != unitType.requiredUnits().end(); it++) {
    if (((*it).first != UnitTypes::Zerg_Larva) && (!haveUnit((*it).first))) {
      return false;
    }
	}

	return true;
}

bool Ximp::upgradeRequirementsMet(UpgradeType upgradeType) {
  if (Broodwar->self()->getMaxUpgradeLevel(upgradeType) == Broodwar->self()->getUpgradeLevel(upgradeType) || Broodwar->self()->isUpgrading(upgradeType)) {
    return false;
  }

  UnitType whatUpgrades = upgradeType.whatUpgrades();

  if (whatUpgrades == UnitTypes::None) {
    return false;
  }
  else {
    map<UnitType, set<Unit*>>::iterator myUnitsIt = myUnitsCompleted.find(whatUpgrades);

    if (myUnitsIt != myUnitsCompleted.end() && !myUnitsIt->second.empty()) {
      for (set<Unit*>::iterator it = myUnitsIt->second.begin(); it != myUnitsIt->second.end(); it++) {
        if ((*it)->getUpgrade() == upgradeType) {
		      return false;
		    }
      }
      
      UnitType whatsRequired = upgradeType.whatsRequired(Broodwar->self()->getUpgradeLevel(upgradeType)+1);
      myUnitsIt = myUnitsCompleted.find(whatsRequired);

      if (whatsRequired == UnitTypes::None || (myUnitsIt != myUnitsCompleted.end() && !myUnitsIt->second.empty())) {
        return true;
      }
    }
  }

  return false;
}

bool Ximp::techRequirementsMet(TechType techType) {
  if (!Broodwar->self()->isResearchAvailable(techType) || Broodwar->self()->hasResearched(techType) || Broodwar->self()->isResearching(techType)) {
    return false;
  }

  UnitType whatResearches = techType.whatResearches();

  if (whatResearches == UnitTypes::None) {
    return false;
  }
  else {
    map<UnitType, set<Unit*>>::iterator myUnitsIt = myUnitsCompleted.find(whatResearches);

    if (myUnitsIt != myUnitsCompleted.end() && !myUnitsIt->second.empty()) {
      for (set<Unit*>::iterator it = myUnitsIt->second.begin(); it != myUnitsIt->second.end(); it++) {
        if ((*it)->getTech() == techType) {
		      return false;
		    }
      }

      return true;
    }
  }

  return false;
}

vector<UnitType> Ximp::getBuildOrderRev(UnitType unitType, vector<UnitType> &stack) {
  vector<UnitType> result;

  map<UnitType, int> required = unitType.requiredUnits();

  UnitType last = UnitTypes::None;

  for (map<UnitType, int>::iterator it = required.begin(); it != required.end(); it++) {
    if (std::find(stack.begin(), stack.end(), it->first) == stack.end() && it->first.isBuilding()) {
      result.insert(std::find(result.begin(), result.end(), last), it->first);
      stack.push_back(it->first);

      vector<UnitType> other = getBuildOrderRev(it->first, stack);

      for (vector<UnitType>::iterator jt = other.begin(); jt != other.end(); jt++) {
        result.insert(std::find(result.begin(), result.end(), last), *jt);
      }
    }
    last = it->first;
  }

  return result;
}

vector<UnitType> Ximp::getBuildOrder(UnitType unitType, vector<UnitType> &stack) {
  vector<UnitType> result = getBuildOrderRev(unitType, stack);
  std::reverse(result.begin(), result.end());
  return result;
}

set<Unit*> Ximp::getMyUnits(UnitType unitType, bool mustBeCompleted) {
  set<Unit*> result;

  map<UnitType, set<Unit*>> *myUnitsP = &myUnits;

  if (mustBeCompleted) {
    myUnitsP = &myUnitsCompleted;
  }

  map<UnitType, set<Unit*>>::iterator myUnitsIt = myUnitsP->find(unitType);

  if (myUnitsIt != myUnitsP->end()) {
    result = myUnitsIt->second;
  }

  return result;
}

set<Unit*> Ximp::getEnemyUnits(set<Unit*> &units, bool detected) {
  set<Unit*> result;

  for (set<Unit*>::iterator it = units.begin(); it != units.end(); it++) {
    if ((Broodwar->self()->isEnemy((*it)->getPlayer()) || ((*it)->getPlayer()->isNeutral() && (*it)->getType().isAddon())) && (*it)->getType() != UnitTypes::Terran_Vulture_Spider_Mine/* && !(*it)->isLifted()*/) {
      if (!detected || (detected && (*it)->isDetected())) {
        result.insert(*it);
      }
    }
  }

  return result;
}

set<Unit*> Ximp::getUnitsOfType(UnitType unitType, set<Unit*> &units) {
  set<Unit*> result;

  for (set<Unit*>::iterator it = units.begin(); it != units.end(); it++) {
    if ((*it)->getType() == unitType) {
      result.insert(*it);
    }
  }

  return result;
}

set<Unit*> Ximp::getUnitsWithAirWeapons(set<Unit*> &units) {
  set<Unit*> result;

  for (set<Unit*>::iterator it = units.begin(); it != units.end(); it++) {
    if ((*it)->isCompleted()) {
      if (((*it)->getType().airWeapon() != WeaponTypes::None || (*it)->getType() == UnitTypes::Protoss_Carrier) && (*it)->getType() != UnitTypes::Protoss_Interceptor) {
        result.insert(*it);
      }
      else if ((*it)->getType() == UnitTypes::Terran_Bunker) {
        result.insert(*it);
      }
    }
  }

  return result;
}

set<Unit*> Ximp::getUnitsWithWeapon(set<Unit*> &units) {
  set<Unit*> result;

  for (set<Unit*>::iterator it = units.begin(); it != units.end(); it++) {
    if ((*it)->isCompleted()) {
      if (((*it)->getType().airWeapon() != WeaponTypes::None || (*it)->getType().groundWeapon() != WeaponTypes::None || (*it)->getType() == UnitTypes::Protoss_Carrier) && (*it)->getType() != UnitTypes::Protoss_Interceptor) {
        result.insert(*it);
      }
      else if ((*it)->getType() == UnitTypes::Terran_Bunker) {
        result.insert(*it);
      }
    }
  }

  return result;
}

set<Unit*> Ximp::getResourceDepots(set<Unit*> &units) {
  set<Unit*> result;

  for (set<Unit*>::iterator it = units.begin(); it != units.end(); it++) {
    if ((*it)->getType().isBuilding() && (*it)->getType().isResourceDepot()) {
      result.insert(*it);
    }
  }

  return result;
}

set<Unit*> Ximp::getImportantBuildings(set<Unit*> &units) {
  set<Unit*> result;

  for (set<Unit*>::iterator it = units.begin(); it != units.end(); it++) {
    if ((*it)->getType().isBuilding() && ((*it)->getType() == UnitTypes::Zerg_Hydralisk_Den || (*it)->getType() == UnitTypes::Zerg_Spire || (*it)->getType() == UnitTypes::Terran_Armory || (*it)->getType() == UnitTypes::Terran_Science_Facility || (*it)->getType() == UnitTypes::Protoss_Cybernetics_Core || (*it)->getType() == UnitTypes::Protoss_Templar_Archives || (*it)->getType() == UnitTypes::Protoss_Fleet_Beacon)) {
      result.insert(*it);
    }
  }

  return result;
}

set<Unit*> Ximp::getProductionBuildings(set<Unit*> &units) {
  set<Unit*> result;

  for (set<Unit*>::iterator it = units.begin(); it != units.end(); it++) {
    if ((*it)->getType().isBuilding() && (*it)->getType().canProduce() && (*it)->isCompleted()) {
      result.insert(*it);
    }
  }

  return result;
}

set<Unit*> Ximp::getWorkers(set<Unit*> &units) {
  set<Unit*> result;

  for (set<Unit*>::iterator it = units.begin(); it != units.end(); it++) {
    if ((*it)->getType().isWorker()) {
      result.insert(*it);
    }
  }

  return result;
}

set<Unit*> Ximp::getFlyers(set<Unit*> &units) {
  set<Unit*> result;

  for (set<Unit*>::iterator it = units.begin(); it != units.end(); it++) {
    if ((*it)->getType().isFlyer()) {
      result.insert(*it);
    }
  }

  return result;
}

set<Unit*> Ximp::getGroundUnits(set<Unit*> &units) {
  set<Unit*> result;

  for (set<Unit*>::iterator it = units.begin(); it != units.end(); it++) {
    if (!(*it)->getType().isFlyer()) {
      result.insert(*it);
    }
  }

  return result;
}

set<Unit*> Ximp::getUnitsThatCanAttack(set<Unit*> &units) {
  set<Unit*> result;

  for (set<Unit*>::iterator it = units.begin(); it != units.end(); it++) {
    if ((*it)->getType().canAttack()) {
      result.insert(*it);
    }
  }

  return result;
}

Unit* Ximp::getNearestUnit(Position pos, set<Unit*> &units, bool smallestHP, bool detected) {
  Unit* nearest = NULL;

  for (set<Unit*>::iterator it = units.begin(); it != units.end(); it++) {
    if (nearest == NULL || pos.getDistance((*it)->getPosition()) < pos.getDistance(nearest->getPosition())) {
      if (!smallestHP || (smallestHP && (nearest == NULL || (*it)->getHitPoints() + (*it)->getShields() <= nearest->getHitPoints() + nearest->getShields()))) {
        if (!detected || (detected && (*it)->isDetected())) {
          nearest = *it;
        }
      }
    }
  }

  return nearest;
}

int Ximp::getAirAttackPower(set<Unit*> &units) {
  int result = 0;

  for (set<Unit*>::iterator it = units.begin(); it != units.end(); it++) {
    WeaponType airWeaponType = (*it)->getType().airWeapon();
	
	  if (airWeaponType != WeaponTypes::None && airWeaponType != WeaponTypes::Unknown) {
      result += airWeaponType.damageAmount();
	  }
  }

  return result;
}

bool Ximp::willHaveEnoughResources(UnitType unitType, double distance, double speed, UnitType except) {
  int numFramesNeeded = distance / speed;

  int willHaveMinerals = ((double)minerals100 / 100.0) * numFramesNeeded;
  int willHaveGas = ((double)gas100 / 100.0) * numFramesNeeded;

  return unitType.mineralPrice() <= willHaveMinerals + Broodwar->self()->minerals() - colony.buildingsBeignBuiltMinerals(except) && 
         unitType.gasPrice() <= willHaveGas + Broodwar->self()->gas() - colony.buildingsBeignBuiltGas(except);
}