#pragma once

using namespace BWAPI;
using namespace std;

enum EarlyScoutBase { UNKNOWN, CHECKED };
enum EarlyScoutHarash { ATTACK, RUN_CORNER_MINERAL, RUN_NEAREST_POSITION, RUN_POLYGON };

class Army;
class Base;
class Ximp;

class Observation {

  private: 

    Ximp *ximp;

    void performEarlyScouting();
    void performHarash();
    void selectMyBaseScoutWorker();
    void performMyBaseScouting();

    bool isEnemyProbeInMyBases();

  public:

    const int scoutPointDist;
    const int earlyScoutWorkerNumToStart;
    const int myBaseScoutWorkerNumToStart;
    const int unitsInRadiusExpansionScout;

    bool earlyScoutingPerformed;
    bool myBaseScoutingPerformedAtLeastOnce;
    bool earlyScoutWorkerHarash;
    EarlyScoutHarash harashPhase;

    BWTA::Polygon earlyScoutPolygon;
    vector<TilePosition> earlyScoutPolygonTiles;
    int earlyScoutTileLastPosition;
    
    Unit* earlyScoutWorker;
    bool earlyScoutWorkerDamaged;
    int earlyScoutWorkerLastLife;
    map<BWTA::BaseLocation*, EarlyScoutBase> earlyScoutingStartLocations;
    
    bool earlyScoutMovedToMinerals;
    int earlyScoutDestroyedFrame;
    int earlyScoutDeaths;

    Unit* myBaseScoutWorker;
    bool myBaseScoutingPerformed;
    vector<TilePosition> myBaseScoutPolygonTiles;
    int myBaseTileStartPosition;
    int myBaseTileLastPosition;
    EarlyScoutHarash myBaseScoutPhase;


    set<Unit*> scoutWorkers;

    BWTA::BaseLocation* myBase;
    BWTA::BaseLocation* enemyBase;

    Observation(Ximp *x): ximp(x), 
                          scoutPointDist(4), 
                          earlyScoutWorkerNumToStart(8), 
                          myBaseScoutWorkerNumToStart(11), 
                          unitsInRadiusExpansionScout(8*TILE_SIZE),
                          earlyScoutMovedToMinerals(false),
                          earlyScoutDestroyedFrame(-1),
                          earlyScoutDeaths(0) {};

    void onStart();
    void onUnitDiscover(Unit* unit);
    void onFrame();
    void onNukeDetect(Position target);
    void onUnitCreate(Unit* unit);
    void onUnitComplete(Unit *unit);
    void onUnitDestroy(Unit* unit);
    void onUnitMorph(Unit* unit);
    void onUnitRenegade(Unit* unit);
    void onUnitEvade(Unit* unit);
    void onUnitShow(Unit* unit);
    void onUnitHide(Unit* unit);

    void processAnalysis();

};