#include "Dll.h"


void Observation::performEarlyScouting() {
  if (earlyScoutWorker == NULL) {
    map<UnitType, set<Unit*>>::iterator workers = ximp->myUnits.find(UnitTypes::Protoss_Probe);

    MyBase* capitalMyBase = ximp->colony.getCapitalMyBase();

    if (workers != ximp->myUnits.end() && capitalMyBase != NULL && workers->second.size() >= earlyScoutWorkerNumToStart) {
      Unit* nearest = NULL;
      MyBase* naturalMyBase = ximp->colony.getNaturalMyBase();

      if (naturalMyBase == NULL) {
        naturalMyBase = capitalMyBase;
      }

      for (set<Unit*>::iterator it = capitalMyBase->mineralWorkers.begin(); it != capitalMyBase->mineralWorkers.end(); it++) {
        if ((*it)->isCompleted() && !(*it)->isCarryingMinerals()) {
          if (nearest == NULL || (*it)->getPosition().getDistance(naturalMyBase->baseLocation->getPosition()) < nearest->getPosition().getDistance(naturalMyBase->baseLocation->getPosition())) {
            nearest = *it;
          }            
        }
      }

      if (nearest != NULL) {
        earlyScoutWorker = nearest;

        earlyScoutWorkerDamaged = false;
        earlyScoutWorkerLastLife = earlyScoutWorker->getShields() + earlyScoutWorker->getHitPoints();
        capitalMyBase->deleteWorker(earlyScoutWorker);
        earlyScoutWorker->stop();
      }
    }

    if (earlyScoutingStartLocations.size() == 0) {
      set<BWTA::BaseLocation*> startLocations = BWTA::getStartLocations();

      for (set<BWTA::BaseLocation*>::iterator it = startLocations.begin(); it != startLocations.end(); it++) {
        if (ximp->colony.getCapitalMyBase() != NULL && *it != ximp->colony.getCapitalMyBase()->baseLocation) {
          earlyScoutingStartLocations.insert(pair<BWTA::BaseLocation*, EarlyScoutBase>(*it, UNKNOWN));  
        }
      }
    }
  }
  else if (earlyScoutWorker->isCompleted()) {
    if (enemyBase == NULL) {
      map<BWTA::BaseLocation*, EnemyBase*> occupiedEnemyBases = ximp->getOccupiedEnemyBases();

      for (map<BWTA::BaseLocation*, EnemyBase*>::iterator enemyBasesIterator = occupiedEnemyBases.begin(); enemyBasesIterator != occupiedEnemyBases.end(); enemyBasesIterator++) {
        if (enemyBasesIterator->second->baseLocation->isStartLocation() && (ximp->colony.getCapitalMyBase() == NULL || ximp->colony.getCapitalMyBase()->baseLocation != enemyBasesIterator->second->baseLocation)) {
          enemyBase = enemyBasesIterator->first;
          earlyScoutPolygon = enemyBase->getRegion()->getPolygon();

          // Benzene
          if (Broodwar->mapHash() == "af618ea3ed8a8926ca7b17619eebcb9126f0d8b1" && enemyBase->getPosition() == Position(288, 3120)) {
            earlyScoutPolygon[43].y() = earlyScoutPolygon[100].y();
            earlyScoutPolygon.erase(earlyScoutPolygon.begin()+44, earlyScoutPolygon.begin()+100);
          }

          break;
        }
      }

      if (earlyScoutWorker->getDistance(earlyScoutWorker->getTargetPosition()) <= earlyScoutWorker->getType().sightRange()) {
        BWTA::BaseLocation* nearest = BWTA::getNearestBaseLocation(earlyScoutWorker->getPosition());
        
        if (nearest != NULL && earlyScoutWorker->getOrder() != Orders::PlaceBuilding) {
          map<BWTA::BaseLocation*, EarlyScoutBase>::iterator earlyScoutStarts = earlyScoutingStartLocations.find(nearest);

          if (earlyScoutStarts != earlyScoutingStartLocations.end()) {
            earlyScoutStarts->second = CHECKED;
          }      
          
          nearest = NULL;
    
          for (map<BWTA::BaseLocation*, EarlyScoutBase>::iterator it = earlyScoutingStartLocations.begin(); it != earlyScoutingStartLocations.end(); it++) {
            if (it->second == UNKNOWN && (nearest == NULL || BWTA::getGroundDistance(TilePosition(earlyScoutWorker->getPosition()), TilePosition(it->first->getPosition())) < BWTA::getGroundDistance(TilePosition(earlyScoutWorker->getPosition()), TilePosition(nearest->getPosition())))) {
              nearest = it->first;
            }
          }

          MyBase* myBase = ximp->colony.getCapitalMyBase();

          // Electric Circuit
          if (myBase != NULL && Broodwar->mapHash() == "9505d618c63a0959f0c0bfe21c253a2ea6e58d26" && myBase->baseLocation->getPosition() == Position(3808, 3856)) {
            for (map<BWTA::BaseLocation*, EarlyScoutBase>::iterator it = earlyScoutingStartLocations.begin(); it != earlyScoutingStartLocations.end(); it++) {
              if (it->first->getPosition() == Position(288, 3856) && it->second == UNKNOWN) {
                nearest = it->first;
                break;
              }
            }
          }

          if (nearest != NULL) {
            bool shiftCommandQueue = false;

            // Electric Circuit
            if (Broodwar->mapHash() == "9505d618c63a0959f0c0bfe21c253a2ea6e58d26" && nearest->getPosition() == Position(3808, 272)) {
              shiftCommandQueue = true;

              set<BWTA::Chokepoint*> chokepoints = BWTA::getRegion(earlyScoutWorker->getTargetPosition())->getChokepoints();
              BWTA::Chokepoint* chokepoint = NULL;

              for (set<BWTA::Chokepoint*>::iterator it = chokepoints.begin(); it != chokepoints.end(); it++) {
                if ((*it)->getCenter() == Position(3153, 3676)) {
                  chokepoint = *it;
                  break;
                }
              }

              if (chokepoint != NULL) {
                earlyScoutWorker->move(chokepoint->getCenter(), shiftCommandQueue);
              }
            }

            if (earlyScoutWorker->getOrder() != Orders::PlaceBuilding) {
              earlyScoutWorker->move(nearest->getPosition(), shiftCommandQueue);
            }
          }
        }
      }
    }
    else {
      earlyScoutPolygonTiles = ximp->rasterizeBasePolygon(earlyScoutPolygon, enemyBase);
      
      map<BWTA::BaseLocation*, EnemyBase>::iterator enemyBasesIt = ximp->enemyBases.find(enemyBase);
      if (enemyBasesIt != ximp->enemyBases.end()) {
        enemyBasesIt->second.isCapital = true;
      }

      earlyScoutingPerformed = true;
      earlyScoutWorkerHarash = true;
      harashPhase = ATTACK;

      ximp->army.calculateCarrierPath();
    }
  }
}

void Observation::performHarash() {
  if (!earlyScoutWorkerDamaged && earlyScoutWorkerLastLife > earlyScoutWorker->getShields() + earlyScoutWorker->getHitPoints()) {
    earlyScoutWorkerDamaged = true;
  }
  else if (!earlyScoutWorkerDamaged) {
    earlyScoutWorkerLastLife = earlyScoutWorker->getShields() + earlyScoutWorker->getHitPoints();
  }

  if (earlyScoutWorker->isStuck()) {
    harashPhase = RUN_NEAREST_POSITION; 
  }

  bool isAttacked = false;

  set<Unit*> unitsInRadius = Broodwar->getUnitsInRadius(earlyScoutWorker->getPosition(), earlyScoutWorker->getType().sightRange());
  for (set<Unit*>::iterator it = unitsInRadius.begin(); it != unitsInRadius.end(); it++) {
    if (Broodwar->self()->isEnemy((*it)->getPlayer()) && (*it)->getOrder() == Orders::AttackUnit) {
      isAttacked = true;
    }
  }

  if (!isAttacked) {
    harashPhase = ATTACK;
  }

  if (harashPhase == ATTACK) {
    set<Unit*> unitsInRadius = Broodwar->getUnitsInRadius(earlyScoutWorker->getPosition(), earlyScoutWorker->getType().sightRange()+unitsInRadiusExpansionScout);

    for (set<Unit*>::iterator it = unitsInRadius.begin(); it != unitsInRadius.end(); it++) {
      if (Broodwar->self()->isEnemy((*it)->getPlayer()) && (*it)->getOrder() == Orders::AttackUnit && (*it)->getOrderTarget() == earlyScoutWorker) {
        if (!earlyScoutMovedToMinerals) {
          harashPhase = RUN_CORNER_MINERAL;
          earlyScoutMovedToMinerals = true;
        }
        else {
          harashPhase = RUN_NEAREST_POSITION;
        }

        Position nearestPoint = earlyScoutPolygon.getNearestPoint(earlyScoutWorker->getPosition());
        earlyScoutWorker->move(nearestPoint);
        return;
      }
    }

    Unit *nearestWorker = ximp->getNearestUnitType(earlyScoutWorker->getPosition(), UnitTypes::Protoss_Probe, ENEMY, !earlyScoutWorkerDamaged);

    if (nearestWorker == NULL) {
      nearestWorker = ximp->getNearestUnitType(earlyScoutWorker->getPosition(), UnitTypes::Terran_SCV, ENEMY, !earlyScoutWorkerDamaged);
    }

    if (nearestWorker == NULL) {
      nearestWorker = ximp->getNearestUnitType(earlyScoutWorker->getPosition(), UnitTypes::Zerg_Drone, ENEMY, !earlyScoutWorkerDamaged);
    }

    map<BWTA::BaseLocation*, EnemyBase*> occupiedEnemyBases = ximp->getOccupiedEnemyBases();
    Position enemyStartPosition = Position(-1,-1);
    
    for (map<BWTA::BaseLocation*, EnemyBase*>::iterator enemyBasesIterator = occupiedEnemyBases.begin(); enemyBasesIterator != occupiedEnemyBases.end(); enemyBasesIterator++) {
      if (enemyBasesIterator->second->baseLocation->isStartLocation() && ((ximp->colony.getCapitalMyBase() != NULL && enemyBasesIterator->second->baseLocation != ximp->colony.getCapitalMyBase()->baseLocation) || ximp->colony.getCapitalMyBase() == NULL)) {
        enemyStartPosition = enemyBasesIterator->second->baseLocation->getPosition();
        break;
      }
    }

    if (nearestWorker != NULL && BWTA::getRegion(nearestWorker->getPosition()) == BWTA::getRegion(enemyStartPosition)) {
      earlyScoutWorker->attack(nearestWorker);
    }
    else if (enemyStartPosition != Position(-1,-1)) {
      if (earlyScoutWorker->getPosition().getDistance(enemyStartPosition) <= 3 * TILE_SIZE) {
        set<Unit*> unitsInRadius = Broodwar->getUnitsInRadius(enemyStartPosition, 3 * TILE_SIZE);
        set<Unit*> enemyUnits = ximp->getEnemyUnits(unitsInRadius);
        set<Unit*> enemyGroundUnits = ximp->getGroundUnits(enemyUnits);

        for (set<Unit*>::iterator it = enemyGroundUnits.begin(); it != enemyGroundUnits.end(); it++) {
          if ((*it)->getType().isResourceDepot()) {
            earlyScoutWorker->attack(*it);
            break;
          }
        }
      }
      else {
        earlyScoutWorker->move(enemyStartPosition);
      }
    }
  }
  else if (harashPhase == RUN_CORNER_MINERAL) {
    EnemyBase* enemyBase = ximp->getCapitalEnemyBase();

    if (enemyBase == NULL) {
      harashPhase = RUN_NEAREST_POSITION;
    }
    else {
      set<Unit*> minerals = enemyBase->baseLocation->getMinerals();

      if (minerals.empty()) {
        harashPhase = RUN_NEAREST_POSITION;
      }
      else {
        Position centroid = ximp->computeCentroid(minerals);
        Unit* cornerMineral1 = NULL;

        for (set<Unit*>::iterator it = minerals.begin(); it != minerals.end(); it++) {
          if (cornerMineral1 == NULL || (*it)->getPosition().getDistance(centroid) > cornerMineral1->getPosition().getDistance(centroid)) {
            cornerMineral1 = *it;
          }
        }

        Unit* cornerMineral2 = NULL;

        for (set<Unit*>::iterator it = minerals.begin(); it != minerals.end(); it++) {
          if ((cornerMineral2 == NULL || (*it)->getPosition().getDistance(centroid) > cornerMineral2->getPosition().getDistance(centroid)) && *it != cornerMineral1) {
            cornerMineral2 = *it;
          }
        }  

        Unit* cornerMineral = NULL;
        if (cornerMineral1 != NULL) {
          Position nearestPointCornerMineral1 = ximp->getNearestPosition(earlyScoutPolygonTiles, cornerMineral1->getPosition());

          if (cornerMineral2 != NULL) {
            Position nearestPointCornerMineral2 = ximp->getNearestPosition(earlyScoutPolygonTiles, cornerMineral2->getPosition());

            cornerMineral = earlyScoutWorker->getPosition().getDistance(nearestPointCornerMineral1) <= earlyScoutWorker->getPosition().getDistance(nearestPointCornerMineral2) ? cornerMineral1 : cornerMineral2;
          }
          else {
            cornerMineral = cornerMineral1;
          }
        }

        if (cornerMineral == NULL) {
          harashPhase = RUN_NEAREST_POSITION;
        }
        else {
          if (earlyScoutWorker->getPosition().getDistance(cornerMineral->getPosition()) <= 12*TILE_SIZE) {
            earlyScoutWorker->rightClick(cornerMineral);
            
            if (earlyScoutWorker->isInWeaponRange(cornerMineral)) {
              harashPhase = RUN_NEAREST_POSITION;
            }
          }
          else {
            harashPhase = RUN_NEAREST_POSITION;
          }
        }
      }
    }
  }
  else if (harashPhase == RUN_NEAREST_POSITION) {
    Position nearestPoint = ximp->getNearestPosition(earlyScoutPolygonTiles, earlyScoutWorker->getPosition());
    nearestPoint.x() += TILE_SIZE/2; nearestPoint.y() += TILE_SIZE/2;      
    earlyScoutWorker->move(nearestPoint);

    if (earlyScoutWorker->getDistance(nearestPoint) <= TILE_SIZE) {        
      harashPhase = RUN_POLYGON;

      nearestPoint.x() -= TILE_SIZE/2; nearestPoint.y() -= TILE_SIZE/2;
      for (int i = 0; i < earlyScoutPolygonTiles.size(); i++) {
        if (Position(earlyScoutPolygonTiles[i]) == nearestPoint) {
          earlyScoutTileLastPosition = i;
          break;
        }
      }
    }
  }
  else if (harashPhase == RUN_POLYGON) {
    Position currentPosition(earlyScoutPolygonTiles[earlyScoutTileLastPosition]);
    currentPosition.x() += TILE_SIZE/2; currentPosition.y() += TILE_SIZE/2;
    earlyScoutWorker->move(currentPosition);

    if (earlyScoutWorker->getDistance(Position(earlyScoutPolygonTiles[earlyScoutTileLastPosition])) < TILE_SIZE*scoutPointDist) {
      earlyScoutTileLastPosition = (earlyScoutTileLastPosition + 1) % earlyScoutPolygonTiles.size();
    }
  }
}

void Observation::selectMyBaseScoutWorker() {
  map<UnitType, set<Unit*>>::iterator workers = ximp->myUnits.find(UnitTypes::Protoss_Probe);
  MyBase* capitalMyBase = ximp->colony.getCapitalMyBase();

  if (workers != ximp->myUnits.end() && capitalMyBase != NULL) {
    for (set<Unit*>::iterator it = capitalMyBase->mineralWorkers.begin(); it != capitalMyBase->mineralWorkers.end(); it++) {
      bool isInMyBaseDefenseProbes = false;

      for (map<Unit*, Unit*>::iterator jt = ximp->army.capitalMyBaseDefenseProbes.begin(); jt != ximp->army.capitalMyBaseDefenseProbes.end(); jt++) {
        if (jt->first == *it) {
          isInMyBaseDefenseProbes = true;
          break;
        }
      }

      if (*it != ximp->observation.earlyScoutWorker && (*it)->isCompleted() && (*it)->getOrder() != Orders::PlaceBuilding && !ximp->colony.isInBuildingWorkers(*it) && !isInMyBaseDefenseProbes) {
        myBaseScoutWorker = *it;
        myBaseScoutWorker->stop();
        capitalMyBase->deleteWorker(myBaseScoutWorker);

        BWTA::Polygon tempPolygon = (*capitalMyBase->regions.begin())->getPolygon();

        // Benzene
        if (Broodwar->mapHash() == "af618ea3ed8a8926ca7b17619eebcb9126f0d8b1" && (*it)->getPosition() == Position(288, 3120)) {
          tempPolygon[43].y() = tempPolygon[100].y();
          tempPolygon.erase(tempPolygon.begin()+44, tempPolygon.begin()+100);
        }

        // Electric Circuit
        if (Broodwar->mapHash() == "9505d618c63a0959f0c0bfe21c253a2ea6e58d26" && capitalMyBase->baseLocation->getPosition() == Position(288, 272)) {
          BWTA::Polygon tempPolygon2 = (*++capitalMyBase->regions.begin())->getPolygon();
          for (vector<Position>::iterator jt = tempPolygon2.begin(); jt != tempPolygon2.end(); jt++) {
            tempPolygon.push_back(*jt);
          }
        }

        myBaseScoutPolygonTiles = ximp->rasterizeBasePolygon(tempPolygon, capitalMyBase->baseLocation);
        myBaseScoutPhase = RUN_NEAREST_POSITION;

        break;
      }
    }
  }
}

void Observation::performMyBaseScouting() {
  if (myBaseScoutPhase == RUN_NEAREST_POSITION) {
    Position nearestPoint;

    MyBase* capitalMyBase = ximp->colony.getCapitalMyBase();
    if (capitalMyBase != NULL && !capitalMyBase->chokepoints.empty()) {
      nearestPoint = ximp->getNearestPosition(myBaseScoutPolygonTiles, (*capitalMyBase->chokepoints.begin())->getCenter());
    }
    else {
      nearestPoint = ximp->getNearestPosition(myBaseScoutPolygonTiles, myBaseScoutWorker->getPosition());
    }

    nearestPoint.x() += TILE_SIZE/2; nearestPoint.y() += TILE_SIZE/2;      
    myBaseScoutWorker->move(nearestPoint);

    if (myBaseScoutWorker->getDistance(nearestPoint) <= TILE_SIZE) {        
      myBaseScoutPhase = RUN_POLYGON;

      nearestPoint.x() -= TILE_SIZE/2; nearestPoint.y() -= TILE_SIZE/2;
      for (int i = 0; i < myBaseScoutPolygonTiles.size(); i++) {
        if (Position(myBaseScoutPolygonTiles[i]) == nearestPoint) {
          myBaseTileLastPosition = i;
          myBaseTileStartPosition = i;
          break;
        }
      }
    }
  }
  else if (myBaseScoutPhase == RUN_POLYGON) {
    Position currentPosition(myBaseScoutPolygonTiles[myBaseTileLastPosition]);
    currentPosition.x() += TILE_SIZE/2; currentPosition.y() += TILE_SIZE/2;
    if (myBaseScoutWorker->getOrderTarget() == NULL || myBaseScoutWorker->getOrderTarget()->getType() != UnitTypes::Resource_Mineral_Field || myBaseScoutWorker->getOrderTarget()->getResources() != 0) {
      myBaseScoutWorker->move(currentPosition);
    }

    if (myBaseScoutWorker->getDistance(Position(myBaseScoutPolygonTiles[myBaseTileLastPosition])) < TILE_SIZE*scoutPointDist) {
      myBaseTileLastPosition = (myBaseTileLastPosition + 1) % myBaseScoutPolygonTiles.size();
    }

    if (myBaseTileLastPosition == myBaseTileStartPosition){
      MyBase* capitalMyBase = ximp->colony.getCapitalMyBase();
      if (capitalMyBase != NULL) {
        if (!capitalMyBase->addWorker(myBaseScoutWorker)) {
          ximp->colony.unassignedWorkers.insert(myBaseScoutWorker);
        }
      }
      else {
        ximp->colony.unassignedWorkers.insert(myBaseScoutWorker);
      }

      myBaseScoutWorker = NULL;
      myBaseScoutingPerformed = true;
      myBaseScoutingPerformedAtLeastOnce = true;
    }
  }
}

bool Observation::isEnemyProbeInMyBases() {
  set<Unit*> units = Broodwar->getAllUnits();
  set<Unit*> enemyUnits = ximp->getEnemyUnits(units);

  set<Unit*> enemyProbes = ximp->getUnitsOfType(UnitTypes::Protoss_Probe, enemyUnits);

  map<BWTA::BaseLocation*, MyBase*> myBases = ximp->colony.getOccupiedMyBases(false);

  for (set<Unit*>::iterator it = enemyProbes.begin(); it != enemyProbes.end(); ) { 
    bool isInMyBase = false;

    for (map<BWTA::BaseLocation*, MyBase*>::iterator jt = myBases.begin(); jt != myBases.end(); jt++) {
      if (jt->second->isInBaseRegions((*it)->getPosition())) {
        isInMyBase = true;
        break;
      }
    }

    if (isInMyBase) {
      it++;
    }
    else {
      it = enemyProbes.erase(it);
    }
  }

  return !enemyProbes.empty();
}

void Observation::onStart() {
  earlyScoutPolygonTiles.clear();
  earlyScoutingStartLocations.clear();
  scoutWorkers.clear();
  earlyScoutPolygon.clear();
  myBaseScoutPolygonTiles.clear();

  myBase = NULL;
  enemyBase = NULL;

  earlyScoutingPerformed = false;
  earlyScoutWorkerHarash = false;
  earlyScoutWorker = NULL;
  earlyScoutDestroyedFrame = -1;
  earlyScoutDeaths = 0;

  earlyScoutTileLastPosition = 0;
  
  myBaseScoutingPerformed = true;
  myBaseScoutingPerformedAtLeastOnce = false;
  myBaseScoutWorker = NULL;
  myBaseTileLastPosition = 0;
}

void Observation::onUnitDiscover(Unit* unit) {
	
}

void Observation::onFrame() {
  #if WRITE_LOG 
    ostringstream ss;
    ss << "Observation::onFrame - start";
    ximp->log.writeToLog(ss.str());
  #endif
    
  if ((Broodwar->getFrameCount() % 5 == 0) && (Broodwar->getFrameCount() > 0)) {
    if (!earlyScoutingPerformed && ximp->analyzed) {
      performEarlyScouting();
    } 
  }

  if (earlyScoutWorker != NULL && earlyScoutWorkerHarash && ximp->analyzed) {
    performHarash();
  }

  bool scoutingPerformed = false;

  /*if ((Broodwar->getFrameCount() % 5 == 0) && (Broodwar->getFrameCount() > 0 && Broodwar->getFrameCount() < 8000)) {
    if (isEnemyProbeInMyBases()) {
      myBaseScoutingPerformed = false;
    }

    if (!myBaseScoutingPerformed && ximp->analyzed) {
      if (myBaseScoutWorker == NULL) {
        selectMyBaseScoutWorker();
      }
      else {
        performMyBaseScouting();
        scoutingPerformed = true;
      }
    } 
  }
  if ((Broodwar->getFrameCount() % 5 == 0) && (Broodwar->getFrameCount() > 0 && Broodwar->getFrameCount() >= 8000 && myBaseScoutWorker != NULL)) {
    if (!myBaseScoutingPerformed && ximp->analyzed) {
      performMyBaseScouting();
      scoutingPerformed = true;
    }
  }*/

  if ((Broodwar->getFrameCount() % 5 == 0) && ximp->isProbablyCanonRush) {
    if (!scoutingPerformed && !myBaseScoutingPerformedAtLeastOnce && ximp->analyzed && Broodwar->enemy()->getRace() == Races::Protoss) {
      map<UnitType, set<Unit*>>::iterator workers = ximp->myUnits.find(UnitTypes::Protoss_Probe);

      if (workers != ximp->myUnits.end()/* && workers->second.size() >= myBaseScoutWorkerNumToStart*/) {
        if (myBaseScoutWorker == NULL) {
          selectMyBaseScoutWorker();
        }
        else {
          performMyBaseScouting();
        }
      }
    }
  }

  #if WRITE_LOG 
    ss.str("");
    ss << "Observation::onFrame - end";
    ximp->log.writeToLog(ss.str());
  #endif
}

void Observation::onNukeDetect(Position target) {

}

void Observation::onUnitCreate(Unit* unit) {

}

void Observation::onUnitComplete(Unit *unit) {

}

void Observation::onUnitDestroy(Unit* unit) {
  if (unit == earlyScoutWorker) {
    earlyScoutWorker = NULL;
    earlyScoutWorkerHarash = false;
    earlyScoutDeaths++;

    if (earlyScoutDeaths > 5) {
      earlyScoutingPerformed = true;
    }

    if (ximp->getOccupiedEnemyBases().size() == 0) {
      if (ximp->analyzed) {
        BWTA::BaseLocation* nearestBaseLocation = BWTA::getNearestBaseLocation(unit->getPosition());
        map<BWTA::BaseLocation*, EnemyBase>::iterator nearestEnemyBase = ximp->enemyBases.find(nearestBaseLocation);

        if (nearestEnemyBase != ximp->enemyBases.end()) {
          nearestEnemyBase->second.probablyEnemyBase = true;
        }
      }
    }

    earlyScoutDestroyedFrame = Broodwar->getFrameCount();
  }

  if (unit == myBaseScoutWorker) {
    myBaseScoutWorker = NULL;
  }
}

void Observation::onUnitMorph(Unit* unit) {

}

void Observation::onUnitRenegade(Unit* unit) {

}

void Observation::onUnitEvade(Unit* unit) {

}

void Observation::onUnitShow(Unit* unit) {
 
}

void Observation::onUnitHide(Unit* unit) {

}

void Observation::processAnalysis() {
  if (BWTA::getStartLocation(Broodwar->self()) != NULL) {
    myBase = BWTA::getStartLocation(Broodwar->self());
  }
}